

<?php $__env->startSection('title', 'Tambah Booking Tiket'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Tambah Booking Tiket</h1>
        <a href="<?php echo e(route('admin.tiket-wisata.index')); ?>" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="<?php echo e(route('admin.tiket-wisata.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        
        <div class="row">
            <!-- Main Form -->
            <div class="col-lg-8">
                <!-- Booking Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Pemesan</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_pemesan">Nama Pemesan <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['nama_pemesan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="nama_pemesan" name="nama_pemesan" value="<?php echo e(old('nama_pemesan')); ?>" required>
                                    <?php $__errorArgs = ['nama_pemesan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="email" name="email" value="<?php echo e(old('email')); ?>" required>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="telepon">Nomor Telepon <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control <?php $__errorArgs = ['telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="telepon" name="telepon" value="<?php echo e(old('telepon')); ?>" required>
                                    <?php $__errorArgs = ['telepon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tanggal_kunjungan">Tanggal Kunjungan <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control <?php $__errorArgs = ['tanggal_kunjungan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="tanggal_kunjungan" name="tanggal_kunjungan" 
                                           value="<?php echo e(old('tanggal_kunjungan')); ?>" 
                                           min="<?php echo e(date('Y-m-d')); ?>" required>
                                    <?php $__errorArgs = ['tanggal_kunjungan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Ticket Details -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Detail Tiket</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jumlah_dewasa">Jumlah Tiket Dewasa <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['jumlah_dewasa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="jumlah_dewasa" name="jumlah_dewasa" 
                                           value="<?php echo e(old('jumlah_dewasa', 1)); ?>" min="0" required>
                                    <?php $__errorArgs = ['jumlah_dewasa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jumlah_anak">Jumlah Tiket Anak</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['jumlah_anak'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="jumlah_anak" name="jumlah_anak" 
                                           value="<?php echo e(old('jumlah_anak', 0)); ?>" min="0">
                                    <?php $__errorArgs = ['jumlah_anak'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_dewasa">Harga Tiket Dewasa (Rp)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['harga_dewasa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="harga_dewasa" name="harga_dewasa" 
                                           value="<?php echo e(old('harga_dewasa')); ?>" readonly>
                                    <?php $__errorArgs = ['harga_dewasa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_anak">Harga Tiket Anak (Rp)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['harga_anak'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="harga_anak" name="harga_anak" 
                                           value="<?php echo e(old('harga_anak')); ?>" readonly>
                                    <?php $__errorArgs = ['harga_anak'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_harga">Total Harga (Rp)</label>
                                    <input type="number" class="form-control <?php $__errorArgs = ['total_harga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                           id="total_harga" name="total_harga" 
                                           value="<?php echo e(old('total_harga')); ?>" readonly>
                                    <?php $__errorArgs = ['total_harga'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_pengunjung">Total Pengunjung</label>
                                    <input type="number" class="form-control" 
                                           id="total_pengunjung" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Pembayaran</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status_tiket">Status Pembayaran</label>
                                    <select class="form-control <?php $__errorArgs = ['status_tiket'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="status_tiket" name="status_tiket">
                                        <option value="pending_payment" <?php echo e(old('status_tiket') == 'pending_payment' ? 'selected' : ''); ?>>Pending Payment</option>
                                        <option value="paid" <?php echo e(old('status_tiket') == 'paid' ? 'selected' : ''); ?>>Paid</option>
                                        <option value="confirmed" <?php echo e(old('status_tiket') == 'confirmed' ? 'selected' : ''); ?>>Confirmed</option>
                                        <option value="used" <?php echo e(old('status_tiket') == 'used' ? 'selected' : ''); ?>>Used</option>
                                        <option value="expired" <?php echo e(old('status_tiket') == 'expired' ? 'selected' : ''); ?>>Expired</option>
                                        <option value="cancelled" <?php echo e(old('status_tiket') == 'cancelled' ? 'selected' : ''); ?>>Cancelled</option>
                                        <option value="refunded" <?php echo e(old('status_tiket') == 'refunded' ? 'selected' : ''); ?>>Refunded</option>
                                    </select>
                                    <?php $__errorArgs = ['status_tiket'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="metode_pembayaran">Metode Pembayaran</label>
                                    <select class="form-control <?php $__errorArgs = ['metode_pembayaran'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                            id="metode_pembayaran" name="metode_pembayaran">
                                        <option value="">Pilih Metode</option>
                                        <option value="cash" <?php echo e(old('metode_pembayaran') == 'cash' ? 'selected' : ''); ?>>Bayar di Tempat</option>
                                        <option value="bank_transfer" <?php echo e(old('metode_pembayaran') == 'bank_transfer' ? 'selected' : ''); ?>>Transfer Bank</option>
                                        <option value="BRIVA" <?php echo e(old('metode_pembayaran') == 'BRIVA' ? 'selected' : ''); ?>>BRI Virtual Account</option>
                                        <option value="BCAVA" <?php echo e(old('metode_pembayaran') == 'BCAVA' ? 'selected' : ''); ?>>BCA Virtual Account</option>
                                        <option value="BNIVA" <?php echo e(old('metode_pembayaran') == 'BNIVA' ? 'selected' : ''); ?>>BNI Virtual Account</option>
                                        <option value="OVO" <?php echo e(old('metode_pembayaran') == 'OVO' ? 'selected' : ''); ?>>OVO</option>
                                        <option value="DANA" <?php echo e(old('metode_pembayaran') == 'DANA' ? 'selected' : ''); ?>>DANA</option>
                                        <option value="SHOPEEPAY" <?php echo e(old('metode_pembayaran') == 'SHOPEEPAY' ? 'selected' : ''); ?>>ShopeePay</option>
                                        <option value="QRIS" <?php echo e(old('metode_pembayaran') == 'QRIS' ? 'selected' : ''); ?>>QRIS</option>
                                        <option value="OTTOPAY_VA" <?php echo e(old('metode_pembayaran') == 'OTTOPAY_VA' ? 'selected' : ''); ?>>Virtual Account (OttoPay)</option>
                                        <option value="OTTOPAY_QRIS" <?php echo e(old('metode_pembayaran') == 'OTTOPAY_QRIS' ? 'selected' : ''); ?>>QRIS (OttoPay)</option>
                                        <option value="OTTOPAY_EWALLET" <?php echo e(old('metode_pembayaran') == 'OTTOPAY_EWALLET' ? 'selected' : ''); ?>>E-Wallet (OttoPay)</option>
                                        <option value="OTTOPAY_CREDIT_CARD" <?php echo e(old('metode_pembayaran') == 'OTTOPAY_CREDIT_CARD' ? 'selected' : ''); ?>>Kartu Kredit</option>
                                    </select>
                                    <?php $__errorArgs = ['metode_pembayaran'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="catatan">Catatan</label>
                                    <textarea class="form-control <?php $__errorArgs = ['catatan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              id="catatan" name="catatan" rows="3"><?php echo e(old('catatan')); ?></textarea>
                                    <?php $__errorArgs = ['catatan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Tourism Object Selection -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Objek Wisata</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="objek_wisata_id">Pilih Objek Wisata <span class="text-danger">*</span></label>
                            <select class="form-control <?php $__errorArgs = ['objek_wisata_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="objek_wisata_id" name="objek_wisata_id" required>
                                <option value="">Pilih Objek Wisata</option>
                                <?php $__currentLoopData = $objekWisataList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $objek): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($objek->id); ?>" 
                                            data-harga-dewasa="<?php echo e($objek->harga_tiket_dewasa); ?>"
                                            data-harga-anak="<?php echo e($objek->harga_tiket_anak); ?>"
                                            <?php echo e(old('objek_wisata_id') == $objek->id ? 'selected' : ''); ?>>
                                        <?php echo e($objek->nama); ?> - <?php echo e($objek->desa); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['objek_wisata_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Tourism Object Info -->
                        <div id="objek-info" style="display: none;">
                            <div class="mt-3 p-3 border rounded">
                                <h6 id="objek-nama"></h6>
                                <p id="objek-alamat" class="text-muted small"></p>
                                <div class="row">
                                    <div class="col-6">
                                        <small class="text-muted">Tiket Dewasa</small>
                                        <div id="objek-harga-dewasa" class="font-weight-bold"></div>
                                    </div>
                                    <div class="col-6">
                                        <small class="text-muted">Tiket Anak</small>
                                        <div id="objek-harga-anak" class="font-weight-bold"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Booking Status -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Status Booking</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    id="status" name="status">
                                <option value="pending_payment" <?php echo e(old('status') == 'pending' ? 'selected' : ''); ?>>Pending</option>
                                <option value="aktif" <?php echo e(old('status') == 'aktif' ? 'selected' : ''); ?>>Aktif</option>
                            </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Booking
                            </button>
                            <a href="<?php echo e(route('admin.tiket-wisata.index')); ?>" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Update price when tourism object changes
    $('#objek_wisata_id').change(function() {
        var selected = $(this).find(':selected');
        var hargaDewasa = selected.data('harga-dewasa') || 0;
        var hargaAnak = selected.data('harga-anak') || 0;
        
        $('#harga_dewasa').val(hargaDewasa);
        $('#harga_anak').val(hargaAnak);
        
        // Show object info
        if (selected.val()) {
            $('#objek-nama').text(selected.text().split(' - ')[0]);
            $('#objek-alamat').text(selected.text().split(' - ')[1] || '');
            $('#objek-harga-dewasa').text('Rp ' + number_format(hargaDewasa));
            $('#objek-harga-anak').text('Rp ' + number_format(hargaAnak));
            $('#objek-info').show();
        } else {
            $('#objek-info').hide();
        }
        
        calculateTotal();
    });

    // Calculate total when quantity changes
    $('#jumlah_dewasa, #jumlah_anak').on('input', function() {
        calculateTotal();
    });

    function calculateTotal() {
        var jumlahDewasa = parseInt($('#jumlah_dewasa').val()) || 0;
        var jumlahAnak = parseInt($('#jumlah_anak').val()) || 0;
        var hargaDewasa = parseInt($('#harga_dewasa').val()) || 0;
        var hargaAnak = parseInt($('#harga_anak').val()) || 0;
        
        var totalHarga = (jumlahDewasa * hargaDewasa) + (jumlahAnak * hargaAnak);
        var totalPengunjung = jumlahDewasa + jumlahAnak;
        
        $('#total_harga').val(totalHarga);
        $('#total_pengunjung').val(totalPengunjung);
    }

    function number_format(number) {
        return new Intl.NumberFormat('id-ID').format(number);
    }

    // Set minimum date to today
    $('#tanggal_kunjungan').attr('min', new Date().toISOString().split('T')[0]);
});
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/tiket-wisata/create.blade.php ENDPATH**/ ?>