

<?php $__env->startSection('title', 'Tambah Data PBB'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Tambah Data PBB (Pajak Bumi dan Bangunan)</h3>
                    <div class="card-tools">
                        <a href="<?php echo e(route('admin.pbb.index')); ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form action="<?php echo e(route('admin.pbb.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        
                        <div class="row">
                            <!-- Data Objek Pajak -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">Data Objek Pajak</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="nop">NOP (Nomor Objek Pajak) <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control <?php $__errorArgs = ['nop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="nop" name="nop" value="<?php echo e(old('nop')); ?>" 
                                                   placeholder="18 digit nomor objek pajak" maxlength="18" required>
                                            <small class="form-text text-muted">Format: 18 digit angka tanpa titik atau strip</small>
                                            <?php $__errorArgs = ['nop'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="nik">NIK Pemilik <span class="text-danger">*</span></label>
                                            <select class="form-control select2 <?php $__errorArgs = ['nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                    id="nik" name="nik" required>
                                                <option value="">Pilih Pemilik</option>
                                                <?php $__currentLoopData = $penduduk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($p->nik); ?>" <?php echo e(old('nik') == $p->nik ? 'selected' : ''); ?>>
                                                        <?php echo e($p->nik); ?> - <?php echo e($p->nama); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <?php $__errorArgs = ['nik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="nama_pemilik">Nama Pemilik <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control <?php $__errorArgs = ['nama_pemilik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="nama_pemilik" name="nama_pemilik" value="<?php echo e(old('nama_pemilik')); ?>" 
                                                   placeholder="Nama pemilik objek pajak" required>
                                            <?php $__errorArgs = ['nama_pemilik'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="form-group">
                                            <label for="alamat_objek">Alamat Objek <span class="text-danger">*</span></label>
                                            <textarea class="form-control <?php $__errorArgs = ['alamat_objek'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                      id="alamat_objek" name="alamat_objek" rows="3" 
                                                      placeholder="Alamat lengkap objek pajak" required><?php echo e(old('alamat_objek')); ?></textarea>
                                            <?php $__errorArgs = ['alamat_objek'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="dusun">Dusun</label>
                                                    <input type="text" class="form-control <?php $__errorArgs = ['dusun'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="dusun" name="dusun" value="<?php echo e(old('dusun')); ?>" 
                                                           placeholder="Nama dusun">
                                                    <?php $__errorArgs = ['dusun'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="rt">RT</label>
                                                    <input type="text" class="form-control <?php $__errorArgs = ['rt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="rt" name="rt" value="<?php echo e(old('rt')); ?>" 
                                                           placeholder="RT" maxlength="5">
                                                    <?php $__errorArgs = ['rt'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="rw">RW</label>
                                                    <input type="text" class="form-control <?php $__errorArgs = ['rw'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="rw" name="rw" value="<?php echo e(old('rw')); ?>" 
                                                           placeholder="RW" maxlength="5">
                                                    <?php $__errorArgs = ['rw'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Data Tanah dan Bangunan -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">Data Tanah dan Bangunan</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="luas_tanah">Luas Tanah (m²) <span class="text-danger">*</span></label>
                                                    <input type="number" class="form-control <?php $__errorArgs = ['luas_tanah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="luas_tanah" name="luas_tanah" value="<?php echo e(old('luas_tanah')); ?>" 
                                                           placeholder="0" min="0" step="0.01" required>
                                                    <?php $__errorArgs = ['luas_tanah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="luas_bangunan">Luas Bangunan (m²)</label>
                                                    <input type="number" class="form-control <?php $__errorArgs = ['luas_bangunan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="luas_bangunan" name="luas_bangunan" value="<?php echo e(old('luas_bangunan')); ?>" 
                                                           placeholder="0" min="0" step="0.01">
                                                    <?php $__errorArgs = ['luas_bangunan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="jenis_tanah">Jenis Tanah <span class="text-danger">*</span></label>
                                                    <select class="form-control <?php $__errorArgs = ['jenis_tanah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                            id="jenis_tanah" name="jenis_tanah" required>
                                                        <option value="">Pilih Jenis Tanah</option>
                                                        <option value="Sawah" <?php echo e(old('jenis_tanah') == 'Sawah' ? 'selected' : ''); ?>>Sawah</option>
                                                        <option value="Tegalan" <?php echo e(old('jenis_tanah') == 'Tegalan' ? 'selected' : ''); ?>>Tegalan</option>
                                                        <option value="Pekarangan" <?php echo e(old('jenis_tanah') == 'Pekarangan' ? 'selected' : ''); ?>>Pekarangan</option>
                                                        <option value="Perkebunan" <?php echo e(old('jenis_tanah') == 'Perkebunan' ? 'selected' : ''); ?>>Perkebunan</option>
                                                        <option value="Hutan" <?php echo e(old('jenis_tanah') == 'Hutan' ? 'selected' : ''); ?>>Hutan</option>
                                                        <option value="Rawa" <?php echo e(old('jenis_tanah') == 'Rawa' ? 'selected' : ''); ?>>Rawa</option>
                                                        <option value="Lainnya" <?php echo e(old('jenis_tanah') == 'Lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                                                    </select>
                                                    <?php $__errorArgs = ['jenis_tanah'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="jenis_bangunan">Jenis Bangunan <span class="text-danger">*</span></label>
                                                    <select class="form-control <?php $__errorArgs = ['jenis_bangunan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                            id="jenis_bangunan" name="jenis_bangunan" required>
                                                        <option value="">Pilih Jenis Bangunan</option>
                                                        <option value="Rumah Tinggal" <?php echo e(old('jenis_bangunan') == 'Rumah Tinggal' ? 'selected' : ''); ?>>Rumah Tinggal</option>
                                                        <option value="Ruko" <?php echo e(old('jenis_bangunan') == 'Ruko' ? 'selected' : ''); ?>>Ruko</option>
                                                        <option value="Pabrik" <?php echo e(old('jenis_bangunan') == 'Pabrik' ? 'selected' : ''); ?>>Pabrik</option>
                                                        <option value="Gudang" <?php echo e(old('jenis_bangunan') == 'Gudang' ? 'selected' : ''); ?>>Gudang</option>
                                                        <option value="Pertanian" <?php echo e(old('jenis_bangunan') == 'Pertanian' ? 'selected' : ''); ?>>Pertanian</option>
                                                        <option value="Lainnya" <?php echo e(old('jenis_bangunan') == 'Lainnya' ? 'selected' : ''); ?>>Lainnya</option>
                                                        <option value="Tidak Ada" <?php echo e(old('jenis_bangunan') == 'Tidak Ada' ? 'selected' : ''); ?>>Tidak Ada</option>
                                                    </select>
                                                    <?php $__errorArgs = ['jenis_bangunan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="njop_tanah_per_m2">NJOP Tanah per m² (Rp) <span class="text-danger">*</span></label>
                                                    <input type="number" class="form-control <?php $__errorArgs = ['njop_tanah_per_m2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="njop_tanah_per_m2" name="njop_tanah_per_m2" value="<?php echo e(old('njop_tanah_per_m2')); ?>" 
                                                           placeholder="0" min="0" step="1" required>
                                                    <?php $__errorArgs = ['njop_tanah_per_m2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="njop_bangunan_per_m2">NJOP Bangunan per m² (Rp)</label>
                                                    <input type="number" class="form-control <?php $__errorArgs = ['njop_bangunan_per_m2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                           id="njop_bangunan_per_m2" name="njop_bangunan_per_m2" value="<?php echo e(old('njop_bangunan_per_m2')); ?>" 
                                                           placeholder="0" min="0" step="1">
                                                    <?php $__errorArgs = ['njop_bangunan_per_m2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                        <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="keterangan">Keterangan</label>
                                            <textarea class="form-control <?php $__errorArgs = ['keterangan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                      id="keterangan" name="keterangan" rows="3" 
                                                      placeholder="Keterangan tambahan (opsional)"><?php echo e(old('keterangan')); ?></textarea>
                                            <?php $__errorArgs = ['keterangan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Koordinat (Opsional) -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">Koordinat Lokasi (Opsional)</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="latitude">Latitude</label>
                                            <input type="number" class="form-control <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="latitude" name="latitude" value="<?php echo e(old('latitude')); ?>" 
                                                   placeholder="-6.123456" step="0.00000001">
                                            <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="longitude">Longitude</label>
                                            <input type="number" class="form-control <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   id="longitude" name="longitude" value="<?php echo e(old('longitude')); ?>" 
                                                   placeholder="106.123456" step="0.00000001">
                                            <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Ringkasan Perhitungan -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">Ringkasan Perhitungan PBB</h5>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-info">
                                    <strong>Rumus Perhitungan:</strong><br>
                                    1. NJOP Tanah = Luas Tanah × NJOP Tanah per m²<br>
                                    2. NJOP Bangunan = Luas Bangunan × NJOP Bangunan per m²<br>
                                    3. NJOP Total = NJOP Tanah + NJOP Bangunan<br>
                                    4. NJKP = NJOP Total × 20% (untuk rumah tinggal)<br>
                                    5. PBB Terhutang = NJKP × 0.5%
                                </div>
                                <div id="perhitungan-preview" class="d-none">
                                    <table class="table table-sm">
                                        <tr>
                                            <td>NJOP Tanah</td>
                                            <td>:</td>
                                            <td class="text-right"><span id="njop-tanah-preview">Rp 0</span></td>
                                        </tr>
                                        <tr>
                                            <td>NJOP Bangunan</td>
                                            <td>:</td>
                                            <td class="text-right"><span id="njop-bangunan-preview">Rp 0</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NJOP Total</strong></td>
                                            <td>:</td>
                                            <td class="text-right"><strong><span id="njop-total-preview">Rp 0</span></strong></td>
                                        </tr>
                                        <tr>
                                            <td>NJKP (20%)</td>
                                            <td>:</td>
                                            <td class="text-right"><span id="njkp-preview">Rp 0</span></td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>PBB Terhutang (0.5%)</strong></td>
                                            <td>:</td>
                                            <td class="text-right"><strong><span id="pbb-preview">Rp 0</span></strong></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Data PBB
                            </button>
                            <a href="<?php echo e(route('admin.pbb.index')); ?>" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap4',
        placeholder: 'Pilih...'
    });

    // Auto-fill nama pemilik when NIK is selected
    $('#nik').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var namaPemilik = selectedOption.text().split(' - ')[1];
        if (namaPemilik) {
            $('#nama_pemilik').val(namaPemilik);
        }
    });

    // Calculate PBB preview
    function calculatePbbPreview() {
        var luasTanah = parseFloat($('#luas_tanah').val()) || 0;
        var luasBangunan = parseFloat($('#luas_bangunan').val()) || 0;
        var njopTanahPerM2 = parseFloat($('#njop_tanah_per_m2').val()) || 0;
        var njopBangunanPerM2 = parseFloat($('#njop_bangunan_per_m2').val()) || 0;

        if (luasTanah > 0 && njopTanahPerM2 > 0) {
            var njopTanah = luasTanah * njopTanahPerM2;
            var njopBangunan = luasBangunan * njopBangunanPerM2;
            var njopTotal = njopTanah + njopBangunan;
            var njkp = njopTotal * 0.20;
            var pbbTerhutang = njkp * 0.005;

            $('#njop-tanah-preview').text('Rp ' + njopTanah.toLocaleString('id-ID'));
            $('#njop-bangunan-preview').text('Rp ' + njopBangunan.toLocaleString('id-ID'));
            $('#njop-total-preview').text('Rp ' + njopTotal.toLocaleString('id-ID'));
            $('#njkp-preview').text('Rp ' + njkp.toLocaleString('id-ID'));
            $('#pbb-preview').text('Rp ' + pbbTerhutang.toLocaleString('id-ID'));

            $('#perhitungan-preview').removeClass('d-none');
        } else {
            $('#perhitungan-preview').addClass('d-none');
        }
    }

    // Trigger calculation on input change
    $('#luas_tanah, #luas_bangunan, #njop_tanah_per_m2, #njop_bangunan_per_m2').on('input', calculatePbbPreview);

    // Format NOP input
    $('#nop').on('input', function() {
        var value = $(this).val().replace(/\D/g, '');
        if (value.length > 18) {
            value = value.substring(0, 18);
        }
        $(this).val(value);
    });
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pbb/create.blade.php ENDPATH**/ ?>