

<?php $__env->startSection('title', 'Perangkat Desa'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item active">Perangkat Desa</li>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    /* Custom Tab Styling - Enhanced Visibility */
    .nav-tabs {
        border-bottom: 2px solid #dee2e6;
        margin-bottom: 1.5rem;
    }
    
    .nav-tabs .nav-link {
        color: #2c3e50 !important;
        font-weight: 600;
        font-size: 0.95rem;
        border: 2px solid transparent;
        border-top-left-radius: 0.75rem;
        border-top-right-radius: 0.75rem;
        padding: 15px 25px;
        margin-right: 8px;
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
        transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        position: relative;
        text-shadow: 0 1px 2px rgba(255, 255, 255, 0.8);
    }
    
    .nav-tabs .nav-link:hover {
        color: #1a73e8 !important;
        background: linear-gradient(135deg, #e3f2fd 0%, #bbdefb 100%);
        border-color: #1a73e8 #1a73e8 transparent;
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(26, 115, 232, 0.2);
        text-shadow: 0 1px 2px rgba(255, 255, 255, 0.9);
    }
    
    .nav-tabs .nav-link.active {
        color: #ffffff !important;
        background: linear-gradient(135deg, #1a73e8 0%, #1557b0 100%) !important;
        border-color: #1a73e8 #1a73e8 transparent !important;
        box-shadow: 0 8px 25px rgba(26, 115, 232, 0.4);
        transform: translateY(-3px);
        z-index: 10;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    .nav-tabs .nav-link.active i {
        color: #ffffff !important;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    .tab-count {
        background: rgba(52, 73, 94, 0.15);
        color: #2c3e50 !important;
        padding: 4px 10px;
        border-radius: 15px;
        font-size: 0.75rem;
        font-weight: 700;
        margin-left: 8px;
        display: inline-block;
        min-width: 25px;
        text-align: center;
        border: 1px solid rgba(52, 73, 94, 0.2);
        text-shadow: none;
    }
    
    .nav-tabs .nav-link.active .tab-count {
        background: rgba(255, 255, 255, 0.3) !important;
        color: #ffffff !important;
        border-color: rgba(255, 255, 255, 0.4);
        text-shadow: 0 1px 2px rgba(0, 0, 0, 0.2);
    }
    
    .nav-tabs .nav-link:hover .tab-count {
        background: rgba(26, 115, 232, 0.2);
        color: #1a73e8 !important;
        border-color: rgba(26, 115, 232, 0.3);
    }
    
    /* Tab content animation */
    .tab-content {
        animation: fadeIn 0.4s ease-in-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(10px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-users-cog me-2"></i>
                        Perangkat Desa
                    </h3>
                    <div>
                        <a href="<?php echo e(route('admin.perangkat-desa.create')); ?>" class="btn btn-primary">
                            <i class="fas fa-plus me-1"></i>
                            Tambah Perangkat
                        </a>
                        <a href="<?php echo e(route('admin.perangkat-desa.struktur')); ?>" class="btn btn-info">
                            <i class="fas fa-sitemap me-1"></i>
                            Struktur Organisasi
                        </a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <!-- Tab Navigation -->
                <ul class="nav nav-tabs perangkat-tabs mb-4" id="perangkatTab" role="tablist" style="border-bottom: 3px solid #dee2e6;">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link active" id="aktif-tab" data-bs-toggle="tab" 
                                data-bs-target="#aktif" type="button" role="tab" aria-selected="true"
                                style="color: #ffffff !important; font-weight: 700 !important; font-size: 1rem !important; 
                                       background: linear-gradient(135deg, #28a745 0%, #20c997 100%) !important; 
                                       border: 2px solid #28a745 !important; padding: 16px 28px !important;
                                       box-shadow: 0 8px 25px rgba(40, 167, 69, 0.4) !important;
                                       text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3) !important;">
                            <i class="fas fa-check-circle me-2" style="color: #ffffff !important;"></i>
                            <strong>Perangkat Aktif</strong>
                            <span class="tab-count ms-2" style="background: rgba(255, 255, 255, 0.3) !important; 
                                                               color: #ffffff !important; padding: 4px 10px !important;
                                                               border-radius: 15px !important; font-weight: 700 !important;
                                                               border: 1px solid rgba(255, 255, 255, 0.4) !important;">
                                <?php echo e($perangkat->where('status', 'Aktif')->count()); ?>

                            </span>
                        </button>
                    </li>
                    <li class="nav-item" role="presentation">
                        <button class="nav-link" id="nonaktif-tab" data-bs-toggle="tab" 
                                data-bs-target="#nonaktif" type="button" role="tab" aria-selected="false"
                                style="color: #495057 !important; font-weight: 700 !important; font-size: 1rem !important;
                                       background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%) !important;
                                       border: 2px solid transparent !important; padding: 16px 28px !important;
                                       text-shadow: 0 1px 2px rgba(255, 255, 255, 0.8) !important;">
                            <i class="fas fa-times-circle me-2" style="color: #6c757d !important;"></i>
                            <strong>Non-Aktif</strong>
                            <span class="tab-count ms-2" style="background: rgba(108, 117, 125, 0.2) !important;
                                                               color: #495057 !important; padding: 4px 10px !important;
                                                               border-radius: 15px !important; font-weight: 700 !important;
                                                               border: 1px solid rgba(108, 117, 125, 0.3) !important;">
                                <?php echo e($perangkat->where('status', '!=', 'Aktif')->count()); ?>

                            </span>
                        </button>
                    </li>
                </ul>

                <!-- Tab Content -->
                <div class="tab-content perangkat-tab-content" id="perangkatTabContent">
                    <!-- Perangkat Aktif -->
                    <div class="tab-pane fade show active" id="aktif" role="tabpanel">
                        <?php $__currentLoopData = $struktur; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level => $levelPerangkat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($levelPerangkat->where('status', 'Aktif')->count() > 0): ?>
                            <div class="mb-4">
                                <h5 class="border-bottom pb-2 mb-3">
                                    <?php echo e($level == 0 ? 'Kepala Desa' : ($level == 1 ? 'Sekretaris Desa' : ($level == 2 ? 'Perangkat Inti' : 'RT/RW'))); ?>

                                </h5>
                                <div class="row">
                                    <?php $__currentLoopData = $levelPerangkat->where('status', 'Aktif'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-md-6 col-lg-4 mb-3">
                                        <div class="card border">
                                            <div class="card-body text-center">
                                                <?php if($person->foto): ?>
                                                    <img src="<?php echo e(asset('storage/' . $person->foto)); ?>" 
                                                         class="rounded-circle mb-2" 
                                                         style="width: 80px; height: 80px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="bg-primary rounded-circle d-inline-flex align-items-center justify-content-center mb-2" 
                                                         style="width: 80px; height: 80px;">
                                                        <i class="fas fa-user fa-2x text-white"></i>
                                                    </div>
                                                <?php endif; ?>
                                                <h6 class="mb-1"><?php echo e($person->nama); ?></h6>
                                                <p class="text-muted small mb-2"><?php echo e($person->jabatan); ?></p>
                                                <?php if($person->nip): ?>
                                                    <p class="small text-info mb-2">NIP: <?php echo e($person->nip); ?></p>
                                                <?php endif; ?>
                                                <?php if($person->no_hp): ?>
                                                    <p class="small mb-2">
                                                        <i class="fas fa-phone"></i> <?php echo e($person->no_hp); ?>

                                                    </p>
                                                <?php endif; ?>
                                                <div class="btn-group btn-group-sm" role="group">
                                                    <a href="<?php echo e(route('admin.perangkat-desa.show', $person)); ?>" 
                                                       class="btn btn-outline-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="<?php echo e(route('admin.perangkat-desa.edit', $person)); ?>" 
                                                       class="btn btn-outline-warning">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <form action="<?php echo e(route('admin.perangkat-desa.destroy', $person)); ?>" 
                                                          method="POST" class="d-inline"
                                                          onsubmit="return confirm('Yakin ingin menghapus data perangkat ini?')">
                                                        <?php echo csrf_field(); ?>
                                                        <?php echo method_field('DELETE'); ?>
                                                        <button type="submit" class="btn btn-outline-danger">
                                                            <i class="fas fa-trash"></i>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Perangkat Non-Aktif -->
                    <div class="tab-pane fade" id="nonaktif" role="tabpanel">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead class="table-dark">
                                    <tr>
                                        <th>Nama</th>
                                        <th>Jabatan</th>
                                        <th>Status</th>
                                        <th>Periode</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $perangkat->where('status', '!=', 'Aktif'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if($person->foto): ?>
                                                    <img src="<?php echo e(asset('storage/' . $person->foto)); ?>" 
                                                         class="rounded-circle me-2" 
                                                         style="width: 40px; height: 40px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="bg-secondary rounded-circle d-inline-flex align-items-center justify-content-center me-2" 
                                                         style="width: 40px; height: 40px;">
                                                        <i class="fas fa-user text-white"></i>
                                                    </div>
                                                <?php endif; ?>
                                                <div>
                                                    <div><?php echo e($person->nama); ?></div>
                                                    <?php if($person->nip): ?>
                                                        <small class="text-muted">NIP: <?php echo e($person->nip); ?></small>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td><?php echo e($person->jabatan); ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo e($person->status == 'Pensiun' ? 'warning' : 'secondary'); ?>">
                                                <?php echo e($person->status); ?>

                                            </span>
                                        </td>
                                        <td>
                                            <?php echo e($person->mulai_tugas->format('d/m/Y')); ?> - 
                                            <?php echo e($person->selesai_tugas ? $person->selesai_tugas->format('d/m/Y') : 'Sekarang'); ?>

                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="<?php echo e(route('admin.perangkat-desa.show', $person)); ?>" 
                                                   class="btn btn-outline-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="<?php echo e(route('admin.perangkat-desa.edit', $person)); ?>" 
                                                   class="btn btn-outline-warning">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/perangkat-desa/index.blade.php ENDPATH**/ ?>