

<?php $__env->startSection('title', 'Edit Relasi Keluarga'); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.pohon-keluarga.index')); ?>">Pohon Keluarga</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.pohon-keluarga.show', $penduduk->nik)); ?>"><?php echo e($penduduk->nama); ?></a></li>
    <li class="breadcrumb-item active">Edit Relasi</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-xl-8">
        <div class="card">
            <div class="card-header bg-gradient-primary text-white">
                <h5 class="card-title mb-0">
                    <i class="fas fa-edit me-2"></i>
                    Edit Relasi Keluarga
                </h5>
            </div>
            <div class="card-body">
                <!-- Current Person Info -->
                <div class="row mb-4">
                    <div class="col-12">
                        <div class="alert alert-info">
                            <div class="d-flex align-items-center">
                                <div class="avatar-circle me-3 <?php echo e($penduduk->jenis_kelamin == 'L' ? 'bg-primary' : 'bg-pink'); ?>">
                                    <i class="fas fa-<?php echo e($penduduk->jenis_kelamin == 'L' ? 'male' : 'female'); ?> text-white"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1"><?php echo e($penduduk->nama); ?></h6>
                                    <small class="text-muted">
                                        NIK: <?php echo e($penduduk->nik); ?> | 
                                        <?php echo e($penduduk->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'); ?> | 
                                        <?php echo e($penduduk->umur); ?> tahun |
                                        KK: <?php echo e($penduduk->no_kk); ?>

                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <h6><i class="fas fa-exclamation-triangle me-2"></i>Terjadi Kesalahan:</h6>
                        <ul class="mb-0">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('admin.pohon-keluarga.update', $penduduk->nik)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="row">
                        <!-- Father Selection -->
                        <div class="col-md-6 mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-male text-primary me-2"></i>Ayah
                            </label>
                            <select name="ayah_nik" class="form-select select2" id="ayah_nik">
                                <option value="">Pilih Ayah...</option>
                                <?php $__currentLoopData = $potentialAyah; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ayah): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ayah->nik); ?>" 
                                            <?php echo e($penduduk->ayah_nik == $ayah->nik ? 'selected' : ''); ?>>
                                        <?php echo e($ayah->nama); ?> (<?php echo e($ayah->nik); ?>) - Umur: <?php echo e($ayah->umur); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small class="form-text text-muted">
                                Pilih ayah dari daftar penduduk laki-laki yang lebih tua
                            </small>
                        </div>

                        <!-- Mother Selection -->
                        <div class="col-md-6 mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-female text-pink me-2"></i>Ibu
                            </label>
                            <select name="ibu_nik" class="form-select select2" id="ibu_nik">
                                <option value="">Pilih Ibu...</option>
                                <?php $__currentLoopData = $potentialIbu; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ibu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ibu->nik); ?>" 
                                            <?php echo e($penduduk->ibu_nik == $ibu->nik ? 'selected' : ''); ?>>
                                        <?php echo e($ibu->nama); ?> (<?php echo e($ibu->nik); ?>) - Umur: <?php echo e($ibu->umur); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <small class="form-text text-muted">
                                Pilih ibu dari daftar penduduk perempuan yang lebih tua
                            </small>
                        </div>
                    </div>

                    <!-- Status in Family -->
                    <div class="row">
                        <div class="col-12 mb-4">
                            <label class="form-label fw-bold">
                                <i class="fas fa-users me-2 text-info"></i>Status dalam Keluarga
                            </label>
                            <select name="status_keluarga" class="form-select">
                                <option value="">Pilih Status...</option>
                                <option value="Kepala Keluarga" <?php echo e($penduduk->status_keluarga == 'Kepala Keluarga' ? 'selected' : ''); ?>>
                                    Kepala Keluarga
                                </option>
                                <option value="Istri" <?php echo e($penduduk->status_keluarga == 'Istri' ? 'selected' : ''); ?>>
                                    Istri
                                </option>
                                <option value="Anak" <?php echo e($penduduk->status_keluarga == 'Anak' ? 'selected' : ''); ?>>
                                    Anak
                                </option>
                                <option value="Cucu" <?php echo e($penduduk->status_keluarga == 'Cucu' ? 'selected' : ''); ?>>
                                    Cucu
                                </option>
                                <option value="Orang Tua" <?php echo e($penduduk->status_keluarga == 'Orang Tua' ? 'selected' : ''); ?>>
                                    Orang Tua
                                </option>
                                <option value="Mertua" <?php echo e($penduduk->status_keluarga == 'Mertua' ? 'selected' : ''); ?>>
                                    Mertua
                                </option>
                                <option value="Menantu" <?php echo e($penduduk->status_keluarga == 'Menantu' ? 'selected' : ''); ?>>
                                    Menantu
                                </option>
                                <option value="Saudara" <?php echo e($penduduk->status_keluarga == 'Saudara' ? 'selected' : ''); ?>>
                                    Saudara
                                </option>
                                <option value="Lainnya" <?php echo e($penduduk->status_keluarga == 'Lainnya' ? 'selected' : ''); ?>>
                                    Lainnya
                                </option>
                            </select>
                            <small class="form-text text-muted">
                                Status dalam keluarga untuk keperluan statistik dan administrasi
                            </small>
                        </div>
                    </div>

                    <!-- Current Family Relations Display -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card bg-light">
                                <div class="card-header">
                                    <h6 class="mb-0">
                                        <i class="fas fa-info-circle me-2 text-info"></i>
                                        Relasi Keluarga Saat Ini
                                    </h6>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <strong>Ayah:</strong>
                                            <?php if($penduduk->ayah): ?>
                                                <div class="mt-1">
                                                    <span class="badge bg-primary"><?php echo e($penduduk->ayah->nama); ?></span>
                                                    <small class="text-muted d-block">NIK: <?php echo e($penduduk->ayah->nik); ?></small>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-muted">Belum ditetapkan</span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-md-6">
                                            <strong>Ibu:</strong>
                                            <?php if($penduduk->ibu): ?>
                                                <div class="mt-1">
                                                    <span class="badge bg-pink"><?php echo e($penduduk->ibu->nama); ?></span>
                                                    <small class="text-muted d-block">NIK: <?php echo e($penduduk->ibu->nik); ?></small>
                                                </div>
                                            <?php else: ?>
                                                <span class="text-muted">Belum ditetapkan</span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Submit Buttons -->
                    <div class="row">
                        <div class="col-12">
                            <div class="d-flex justify-content-between">
                                <a href="<?php echo e(route('admin.pohon-keluarga.show', $penduduk->nik)); ?>" 
                                   class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-2"></i>Kembali
                                </a>
                                <div>
                                    <button type="button" class="btn btn-warning me-2" onclick="resetForm()">
                                        <i class="fas fa-undo me-2"></i>Reset
                                    </button>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-2"></i>Simpan Relasi
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />

<style>
.avatar-circle {
    width: 50px;
    height: 50px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 20px;
}

.bg-pink {
    background-color: #e91e63 !important;
}

.text-pink {
    color: #e91e63 !important;
}

.card-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.select2-container--bootstrap-5 .select2-selection {
    min-height: 38px;
}

.select2-container--bootstrap-5 .select2-selection--single .select2-selection__rendered {
    line-height: 36px;
}
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap-5',
        placeholder: 'Ketik untuk mencari...',
        allowClear: true,
        width: '100%'
    });

    // Form validation
    $('form').on('submit', function(e) {
        const ayah = $('#ayah_nik').val();
        const ibu = $('#ibu_nik').val();
        
        if (!ayah && !ibu) {
            e.preventDefault();
            alert('Silakan pilih minimal salah satu orang tua (ayah atau ibu).');
            return false;
        }

        // Confirm submission
        if (!confirm('Apakah Anda yakin ingin menyimpan relasi keluarga ini?')) {
            e.preventDefault();
            return false;
        }
    });
});

function resetForm() {
    if (confirm('Apakah Anda yakin ingin mereset form?')) {
        $('#ayah_nik').val('').trigger('change');
        $('#ibu_nik').val('').trigger('change');
        $('select[name="status_keluarga"]').val('');
    }
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/pohon-keluarga/edit.blade.php ENDPATH**/ ?>