

<?php $__env->startSection('title', 'Realisasi APBDes'); ?>

<?php $__env->startSection('breadcrumb'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
<li class="breadcrumb-item active">Realisasi APBDes</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-receipt text-primary me-2"></i>
                        Realisasi APBDes
                    </h4>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">
                        <i class="fas fa-plus me-1"></i>
                        Tambah Realisasi
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped" id="realisasiTable">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Rencana</th>
                                    <th>Transaksi</th>
                                    <th>Nominal</th>
                                    <th>Tanggal</th>
                                    <th>Status</th>
                                    <th>Bukti</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $realisasi; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td>
                                        <div>
                                            <strong><?php echo e($item->apbdesRencana->kode_rekening); ?></strong><br>
                                            <small class="text-muted"><?php echo e(Str::limit($item->apbdesRencana->uraian, 50)); ?></small>
                                        </div>
                                    </td>
                                    <td><?php echo e($item->keterangan_transaksi); ?></td>
                                    <td>Rp <?php echo e(number_format($item->nominal, 0, ',', '.')); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($item->tanggal_transaksi)->format('d/m/Y')); ?></td>
                                    <td>
                                        <?php if($item->status_verifikasi == 'pending'): ?>
                                            <span class="badge bg-warning">Pending</span>
                                        <?php elseif($item->status_verifikasi == 'verified'): ?>
                                            <span class="badge bg-success">Terverifikasi</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Ditolak</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($item->bukti_transaksi): ?>
                                            <a href="<?php echo e(Storage::url($item->bukti_transaksi)); ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-file-alt"></i>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">-</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <?php if($item->status_verifikasi == 'pending'): ?>
                                                <button class="btn btn-sm btn-success" onclick="verifyRealisasi(<?php echo e($item->id); ?>, 'verified')">
                                                    <i class="fas fa-check"></i>
                                                </button>
                                                <button class="btn btn-sm btn-danger" onclick="verifyRealisasi(<?php echo e($item->id); ?>, 'rejected')">
                                                    <i class="fas fa-times"></i>
                                                </button>
                                            <?php endif; ?>
                                            <button class="btn btn-sm btn-warning" onclick="editRealisasi(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteRealisasi(<?php echo e($item->id); ?>)">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="8" class="text-center py-4">
                                        <i class="fas fa-inbox fa-3x text-muted mb-3"></i>
                                        <p class="text-muted">Belum ada data realisasi APBDes</p>
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Modal -->
<div class="modal fade" id="addModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Realisasi APBDes</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addForm" action="<?php echo e(route('admin.apbdes.realisasi.store')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Rencana APBDes</label>
                        <select class="form-select" name="apbdes_rencana_id" required>
                            <option value="">Pilih Rencana</option>
                            <?php $__currentLoopData = $rencanaList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rencana): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($rencana->id); ?>">
                                    <?php echo e($rencana->kode_rekening); ?> - <?php echo e($rencana->uraian); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Keterangan Transaksi</label>
                        <textarea class="form-control" name="keterangan_transaksi" rows="3" required></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nominal</label>
                                <input type="number" class="form-control" name="nominal" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Transaksi</label>
                                <input type="date" class="form-control" name="tanggal_transaksi" required>
                            </div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Bukti Transaksi</label>
                        <input type="file" class="form-control" name="bukti_transaksi" accept=".pdf,.jpg,.jpeg,.png">
                        <small class="text-muted">Format: PDF, JPG, PNG (Max: 2MB)</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Simpan</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function verifyRealisasi(id, status) {
    let statusText = status === 'verified' ? 'menyetujui' : 'menolak';
    
    if (confirm(`Apakah Anda yakin ingin ${statusText} realisasi ini?`)) {
        fetch(`<?php echo e(route('admin.apbdes.realisasi.index')); ?>/${id}/verify`, {
            method: 'PUT',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            },
            body: JSON.stringify({ status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}

function deleteRealisasi(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data ini?')) {
        fetch(`<?php echo e(route('admin.apbdes.realisasi.index')); ?>/${id}`, {
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>',
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Error: ' + data.message);
            }
        });
    }
}
</script>
<?php $__env->stopPush(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/waangu-angu.copilotproduction.com/resources/views/admin/apbdes/realisasi/index.blade.php ENDPATH**/ ?>