<?php
/**
 * Test script untuk memverifikasi akses gambar
 * Akses via: https://susukannet.id/test-image-access.php
 */

// Include Laravel bootstrap
require_once __DIR__ . '/../vendor/autoload.php';
$app = require_once __DIR__ . '/../bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

use App\Helpers\SharedHostingHelper;

echo "<h1>Test Image Access</h1>";

// Test files
$testFiles = [
    'umkm/logo/sample-logo.png',
    'umkm/galeri/sample-gallery1.png',
    'wisata/sample-tourism-1.png',
    'wisata/sample-tourism-2.png'
];

echo "<h2>Testing SharedHostingHelper URLs</h2>";

foreach ($testFiles as $file) {
    echo "<h3>Testing: {$file}</h3>";
    
    // Test getFileUrl
    $url = SharedHostingHelper::getFileUrl($file);
    echo "<div class='info'>Helper URL: <a href='{$url}' target='_blank'>{$url}</a></div>";
    
    // Test specific methods
    if (strpos($file, 'umkm/logo/') === 0) {
        $filename = basename($file);
        $logoUrl = SharedHostingHelper::getUmkmLogoUrl($filename);
        echo "<div class='info'>Logo URL: <a href='{$logoUrl}' target='_blank'>{$logoUrl}</a></div>";
    }
    
    if (strpos($file, 'umkm/galeri/') === 0) {
        $filename = basename($file);
        $galleryUrl = SharedHostingHelper::getUmkmGalleryUrl($filename);
        echo "<div class='info'>Gallery URL: <a href='{$galleryUrl}' target='_blank'>{$galleryUrl}</a></div>";
    }
    
    // Test direct URL
    $directUrl = 'https://susukannet.id/storage/' . $file;
    echo "<div class='info'>Direct URL: <a href='{$directUrl}' target='_blank'>{$directUrl}</a></div>";
    
    echo "<hr>";
}

// Test default images
echo "<h2>Testing Default Images</h2>";

$defaultImages = [
    'https://susukannet.id/images/default-umkm-logo.png',
    'https://susukannet.id/images/default-tourism.png'
];

foreach ($defaultImages as $url) {
    echo "<div class='info'>Default Image: <a href='{$url}' target='_blank'>{$url}</a></div>";
}

// Test with null/empty values
echo "<h2>Testing with Null/Empty Values</h2>";

$nullTests = [
    'null' => null,
    'empty' => '',
    'whitespace' => '   '
];

foreach ($nullTests as $testName => $value) {
    $url = SharedHostingHelper::getFileUrl($value);
    echo "<div class='info'>Test {$testName}: <a href='{$url}' target='_blank'>{$url}</a></div>";
}

// Test file existence
echo "<h2>File Existence Check</h2>";

foreach ($testFiles as $file) {
    $storagePath = storage_path('app/public/' . $file);
    $publicPath = public_path('storage/' . $file);
    
    $storageExists = file_exists($storagePath);
    $publicExists = file_exists($publicPath);
    
    echo "<div class='info'>File: {$file}</div>";
    echo "<div class='" . ($storageExists ? 'success' : 'error') . "'>Storage: " . ($storageExists ? 'EXISTS' : 'NOT FOUND') . "</div>";
    echo "<div class='" . ($publicExists ? 'success' : 'error') . "'>Public: " . ($publicExists ? 'EXISTS' : 'NOT FOUND') . "</div>";
    
    if ($storageExists) {
        echo "<div class='info'>Storage Size: " . filesize($storagePath) . " bytes</div>";
    }
    
    if ($publicExists) {
        echo "<div class='info'>Public Size: " . filesize($publicPath) . " bytes</div>";
    }
    
    echo "<hr>";
}

echo "<h2>Test Completed</h2>";
echo "<p><a href='/admin/umkm'>Kembali ke Admin UMKM</a></p>";

?>
<style>
.success { color: green; font-weight: bold; }
.error { color: red; font-weight: bold; }
.info { color: blue; }
</style>
