<?php
/**
 * Test script untuk memverifikasi foto UMKM
 */

echo "<h1>Test Foto UMKM</h1>";

// Test 1: Cek direktori
echo "<h2>1. Cek Direktori</h2>";
$dirs = [
    'storage/app/public/umkm' => '../storage/app/public/umkm',
    'storage/app/public/umkm/logo' => '../storage/app/public/umkm/logo',
    'storage/app/public/umkm/galeri' => '../storage/app/public/umkm/galeri',
    'public/storage/umkm' => 'storage/umkm',
    'public/storage/umkm/logo' => 'storage/umkm/logo',
    'public/storage/umkm/galeri' => 'storage/umkm/galeri'
];

foreach ($dirs as $name => $path) {
    if (is_dir($path)) {
        echo "✓ $name: EXISTS<br>";
    } else {
        echo "✗ $name: NOT FOUND<br>";
    }
}

// Test 2: Cek file sample
echo "<h2>2. Cek File Sample</h2>";
$files = [
    'Logo Sample' => 'storage/umkm/logo/sample-logo.png',
    'Galeri Sample' => 'storage/umkm/galeri/sample-gallery1.png'
];

foreach ($files as $name => $file) {
    if (file_exists($file)) {
        echo "✓ $name: EXISTS<br>";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;Size: " . filesize($file) . " bytes<br>";
        echo "&nbsp;&nbsp;&nbsp;&nbsp;URL: <a href='$file' target='_blank'>$file</a><br>";
    } else {
        echo "✗ $name: NOT FOUND<br>";
    }
}

// Test 3: Test URL access
echo "<h2>3. Test URL Access</h2>";
$testUrls = [
    'Logo URL' => '/storage/umkm/logo/sample-logo.png',
    'Galeri URL' => '/storage/umkm/galeri/sample-gallery1.png',
    'Default Logo' => '/images/default-umkm-logo.png'
];

foreach ($testUrls as $name => $url) {
    echo "<strong>$name:</strong> <a href='$url' target='_blank'>$url</a><br>";
}

// Test 4: Helper Test
echo "<h2>4. Test SharedHostingHelper</h2>";
try {
    require_once '../app/Helpers/SharedHostingHelper.php';
    use App\Helpers\SharedHostingHelper;
    
    $logoUrl = SharedHostingHelper::getUmkmLogoUrl('sample-logo.png');
    echo "✓ Logo URL Helper: <a href='$logoUrl' target='_blank'>$logoUrl</a><br>";
    
    $galleryUrl = SharedHostingHelper::getUmkmGalleryUrl('sample-gallery1.png');
    echo "✓ Gallery URL Helper: <a href='$galleryUrl' target='_blank'>$galleryUrl</a><br>";
    
    $defaultUrl = SharedHostingHelper::getUmkmLogoUrl(null);
    echo "✓ Default URL Helper: <a href='$defaultUrl' target='_blank'>$defaultUrl</a><br>";
    
} catch (Exception $e) {
    echo "✗ Helper Error: " . $e->getMessage() . "<br>";
}

// Test 5: Laravel Route Test
echo "<h2>5. Test Laravel Integration</h2>";
echo "<p>Test URL: <a href='/produk-umkm' target='_blank'>/produk-umkm</a></p>";
echo "<p>Admin UMKM: <a href='/admin/umkm' target='_blank'>/admin/umkm</a></p>";

echo "<h2>✅ Test Complete</h2>";
echo "<p>Jika semua test berhasil, foto UMKM sudah siap untuk shared hosting!</p>";
?>
