<?php
/**
 * Script untuk menguji route UMKM yang sudah diperbaiki
 * Akses: https://yourdomain.com/test-umkm-routes-fixed.php
 */

echo "<h2>=== Test UMKM Routes (Fixed) ===</h2>";

$baseUrl = 'https://' . $_SERVER['HTTP_HOST'];

// Test sample files
$testFiles = [
    'logo' => 'sample-logo.png',
    'gallery' => 'sample-gallery1.png'
];

echo "<h3>Testing Fixed Routes:</h3>";
echo "<table border='1' cellpadding='10' cellspacing='0'>";
echo "<tr><th>Type</th><th>Route URL</th><th>Status</th><th>Preview</th></tr>";

foreach ($testFiles as $type => $filename) {
    $routeUrl = $baseUrl . '/admin/umkm/' . $type . '/' . $filename;
    
    echo "<tr>";
    echo "<td><strong>" . ucfirst($type) . "</strong></td>";
    echo "<td><a href='$routeUrl' target='_blank'>$routeUrl</a></td>";
    
    // Test if URL is accessible
    $headers = @get_headers($routeUrl);
    $status = $headers && strpos($headers[0], '200') ? 'OK' : 'Error';
    $statusColor = $status === 'OK' ? 'green' : 'red';
    
    echo "<td style='color: $statusColor; font-weight: bold;'>$status</td>";
    echo "<td>";
    if ($status === 'OK') {
        echo "<img src='$routeUrl' style='width: 50px; height: 50px; object-fit: cover; border: 1px solid #ccc;'>";
    } else {
        echo "Image not accessible";
    }
    echo "</td>";
    echo "</tr>";
}

echo "</table>";

echo "<h3>Testing Helper Functions:</h3>";

// Test helper functions
try {
    // Test logo URL
    $logoUrl = \App\Helpers\SharedHostingHelper::getUmkmLogoUrl('sample-logo.png');
    echo "<p><strong>Logo URL:</strong> <a href='$logoUrl' target='_blank'>$logoUrl</a></p>";
    
    // Test gallery URL
    $galleryUrl = \App\Helpers\SharedHostingHelper::getUmkmGalleryUrl('sample-gallery1.png');
    echo "<p><strong>Gallery URL:</strong> <a href='$galleryUrl' target='_blank'>$galleryUrl</a></p>";
    
    echo "<p style='color: green;'><strong>✓ Helper functions working correctly!</strong></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'><strong>✗ Error in helper functions:</strong> " . $e->getMessage() . "</p>";
}

echo "<h3>Route Information:</h3>";
echo "<ul>";
echo "<li><strong>Logo Route:</strong> admin.umkm.logo</li>";
echo "<li><strong>Gallery Route:</strong> admin.umkm.gallery</li>";
echo "<li><strong>Route Path:</strong> /admin/umkm/{type}/{filename}</li>";
echo "</ul>";

echo "<p><em>Test completed at: " . date('Y-m-d H:i:s') . "</em></p>";
?>
