<?php
/**
 * Script untuk menguji route UMKM yang baru
 * Akses: https://yourdomain.com/test-umkm-routes.php
 */

echo "<h2>=== Test UMKM Routes ===</h2>";

$baseUrl = 'https://' . $_SERVER['HTTP_HOST'];

// Test sample files
$testFiles = [
    'logo' => 'sample-logo.png',
    'gallery' => 'sample-gallery1.png'
];

echo "<h3>Testing New Routes:</h3>";
echo "<table border='1' cellpadding='10' cellspacing='0'>";
echo "<tr><th>Type</th><th>Route URL</th><th>Status</th><th>Preview</th></tr>";

foreach ($testFiles as $type => $filename) {
    $routeUrl = $baseUrl . '/admin/umkm/' . $type . '/' . $filename;
    
    echo "<tr>";
    echo "<td><strong>" . ucfirst($type) . "</strong></td>";
    echo "<td><a href='$routeUrl' target='_blank'>$routeUrl</a></td>";
    
    // Test if URL is accessible
    $headers = @get_headers($routeUrl);
    $status = $headers && strpos($headers[0], '200') ? 'OK' : 'ERROR';
    $statusColor = $status === 'OK' ? 'green' : 'red';
    
    echo "<td style='color: $statusColor;'><strong>$status</strong></td>";
    
    if ($status === 'OK') {
        echo "<td><img src='$routeUrl' style='max-width: 100px; max-height: 100px; border: 1px solid #ccc;' onerror='this.style.display=\"none\";'></td>";
    } else {
        echo "<td style='color: red;'>Route not accessible</td>";
    }
    
    echo "</tr>";
}

echo "</table>";

// Test file existence
echo "<h3>File System Check:</h3>";
echo "<table border='1' cellpadding='10' cellspacing='0'>";
echo "<tr><th>File</th><th>Storage Path</th><th>Exists</th><th>Size</th></tr>";

foreach ($testFiles as $type => $filename) {
    $storagePath = __DIR__ . '/../storage/app/public/umkm/' . $type . '/' . $filename;
    
    echo "<tr>";
    echo "<td><strong>$filename</strong></td>";
    echo "<td>$storagePath</td>";
    echo "<td>" . (file_exists($storagePath) ? '<span style="color: green;">YES</span>' : '<span style="color: red;">NO</span>') . "</td>";
    echo "<td>" . (file_exists($storagePath) ? filesize($storagePath) . ' bytes' : 'N/A') . "</td>";
    echo "</tr>";
}

echo "</table>";

// Test Laravel routes
echo "<h3>Laravel Route Test:</h3>";
try {
    // Simulate Laravel route generation
    $logoRoute = $baseUrl . '/admin/umkm/logo/sample-logo.png';
    $galleryRoute = $baseUrl . '/admin/umkm/galeri/sample-gallery1.png';
    
    echo "<p><strong>Logo Route:</strong> <a href='$logoRoute' target='_blank'>$logoRoute</a></p>";
    echo "<p><strong>Gallery Route:</strong> <a href='$galleryRoute' target='_blank'>$galleryRoute</a></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Route test error: " . htmlspecialchars($e->getMessage()) . "</p>";
}

echo "<h3>Recommendations:</h3>";
echo "<ul>";
echo "<li>If routes show 'OK', the new route system is working</li>";
echo "<li>If routes show 'ERROR', check Laravel route configuration</li>";
echo "<li>Make sure the route is defined in routes/web.php</li>";
echo "<li>Check that the route is within the admin middleware group</li>";
echo "</ul>";

echo "<p><strong>Route test completed!</strong> Check the results above.</p>";
?>
