@extends('layouts.app')

@section('title', 'Report Bug')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.bugs.index') }}">Bug Detection</a></li>
    <li class="breadcrumb-item active">Report Bug</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header bg-gradient-danger text-white">
                    <h4 class="card-title mb-0">
                        <i class="fas fa-bug me-2"></i>
                        Report New Bug
                    </h4>
                    <small>Laporkan bug atau masalah yang ditemukan dalam sistem</small>
                </div>
                
                <form action="{{ route('admin.bugs.store') }}" method="POST" id="bugReportForm">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="mb-3">
                                    <label for="title" class="form-label">
                                        <i class="fas fa-heading me-1"></i>
                                        Bug Title <span class="text-danger">*</span>
                                    </label>
                                    <input type="text" class="form-control @error('title') is-invalid @enderror" 
                                           id="title" name="title" value="{{ old('title') }}" 
                                           placeholder="Berikan judul singkat untuk bug ini..." required>
                                    @error('title')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="severity" class="form-label">
                                        <i class="fas fa-exclamation-triangle me-1"></i>
                                        Severity <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select @error('severity') is-invalid @enderror" 
                                            id="severity" name="severity" required>
                                        <option value="">Pilih Severity</option>
                                        <option value="low" {{ old('severity') == 'low' ? 'selected' : '' }}>Low</option>
                                        <option value="medium" {{ old('severity') == 'medium' ? 'selected' : '' }}>Medium</option>
                                        <option value="high" {{ old('severity') == 'high' ? 'selected' : '' }}>High</option>
                                        <option value="critical" {{ old('severity') == 'critical' ? 'selected' : '' }}>Critical</option>
                                    </select>
                                    @error('severity')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="type" class="form-label">
                                        <i class="fas fa-tag me-1"></i>
                                        Type <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select @error('type') is-invalid @enderror" 
                                            id="type" name="type" required>
                                        <option value="">Pilih Tipe</option>
                                        <option value="bug" {{ old('type') == 'bug' ? 'selected' : '' }}>Bug</option>
                                        <option value="error" {{ old('type') == 'error' ? 'selected' : '' }}>Error</option>
                                        <option value="warning" {{ old('type') == 'warning' ? 'selected' : '' }}>Warning</option>
                                        <option value="info" {{ old('type') == 'info' ? 'selected' : '' }}>Info</option>
                                    </select>
                                    @error('type')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="module" class="form-label">
                                        <i class="fas fa-cube me-1"></i>
                                        Module/Controller
                                    </label>
                                    <input type="text" class="form-control @error('module') is-invalid @enderror" 
                                           id="module" name="module" value="{{ old('module') }}" 
                                           placeholder="Nama controller atau modul (contoh: PendudukController)">
                                    @error('module')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="url" class="form-label">
                                <i class="fas fa-link me-1"></i>
                                URL (Opsional)
                            </label>
                            <input type="url" class="form-control @error('url') is-invalid @enderror" 
                                   id="url" name="url" value="{{ old('url') }}" 
                                   placeholder="https://example.com/page-where-bug-occurred">
                            @error('url')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="mb-3">
                            <label for="description" class="form-label">
                                <i class="fas fa-align-left me-1"></i>
                                Description <span class="text-danger">*</span>
                            </label>
                            <textarea class="form-control @error('description') is-invalid @enderror" 
                                      id="description" name="description" rows="4" required
                                      placeholder="Jelaskan bug ini secara detail...">{{ old('description') }}</textarea>
                            @error('description')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <div class="form-text">
                                <i class="fas fa-info-circle me-1"></i>
                                Sertakan informasi seperti: langkah untuk reproduce, pesan error, dan kondisi saat bug terjadi.
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="reproduction_steps" class="form-label">
                                <i class="fas fa-list-ol me-1"></i>
                                Steps to Reproduce (Opsional)
                            </label>
                            <textarea class="form-control @error('reproduction_steps') is-invalid @enderror" 
                                      id="reproduction_steps" name="reproduction_steps" rows="3"
                                      placeholder="1. Buka halaman...&#10;2. Klik tombol...&#10;3. Error muncul...">{{ old('reproduction_steps') }}</textarea>
                            @error('reproduction_steps')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Severity Guide -->
                        <div class="alert alert-info">
                            <h6><i class="fas fa-info-circle me-2"></i>Panduan Severity:</h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <small>
                                        <strong class="text-dark">Critical:</strong> Sistem down, data hilang<br>
                                        <strong class="text-danger">High:</strong> Fitur utama tidak berfungsi
                                    </small>
                                </div>
                                <div class="col-md-6">
                                    <small>
                                        <strong class="text-warning">Medium:</strong> Fitur minor bermasalah<br>
                                        <strong class="text-success">Low:</strong> UI/UX improvement
                                    </small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer bg-light">
                        <div class="d-flex justify-content-between">
                            <a href="{{ route('admin.bugs.index') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-2"></i>Kembali
                            </a>
                            <div>
                                <button type="reset" class="btn btn-outline-secondary me-2">
                                    <i class="fas fa-undo me-2"></i>Reset
                                </button>
                                <button type="submit" class="btn btn-gradient-danger">
                                    <i class="fas fa-paper-plane me-2"></i>Report Bug
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

            <!-- Quick Bug Report Card -->
            <div class="card mt-4">
                <div class="card-header bg-light">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-bolt me-2"></i>
                        Quick Report Templates
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="quick-template" data-severity="critical" data-type="error" 
                                 data-title="System Error" 
                                 data-description="Sistem mengalami error dan tidak dapat diakses.">
                                <div class="d-flex align-items-center p-3 border rounded mb-2 cursor-pointer">
                                    <i class="fas fa-exclamation-circle text-danger fa-2x me-3"></i>
                                    <div>
                                        <h6 class="mb-1">System Error</h6>
                                        <small class="text-muted">Critical system malfunction</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="quick-template" data-severity="high" data-type="bug" 
                                 data-title="Feature Not Working" 
                                 data-description="Fitur tidak berfungsi dengan baik atau memberikan hasil yang salah.">
                                <div class="d-flex align-items-center p-3 border rounded mb-2 cursor-pointer">
                                    <i class="fas fa-bug text-warning fa-2x me-3"></i>
                                    <div>
                                        <h6 class="mb-1">Feature Bug</h6>
                                        <small class="text-muted">Feature malfunction</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="quick-template" data-severity="medium" data-type="warning" 
                                 data-title="UI/UX Issue" 
                                 data-description="Masalah tampilan atau pengalaman pengguna yang perlu diperbaiki.">
                                <div class="d-flex align-items-center p-3 border rounded mb-2 cursor-pointer">
                                    <i class="fas fa-palette text-info fa-2x me-3"></i>
                                    <div>
                                        <h6 class="mb-1">UI/UX Issue</h6>
                                        <small class="text-muted">Interface problems</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="quick-template" data-severity="low" data-type="info" 
                                 data-title="Performance Issue" 
                                 data-description="Sistem berjalan lambat atau menggunakan resource berlebihan.">
                                <div class="d-flex align-items-center p-3 border rounded mb-2 cursor-pointer">
                                    <i class="fas fa-tachometer-alt text-success fa-2x me-3"></i>
                                    <div>
                                        <h6 class="mb-1">Performance</h6>
                                        <small class="text-muted">Speed optimization</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.bg-gradient-danger {
    background: linear-gradient(135deg, #ff416c 0%, #ff4757 100%);
}

.cursor-pointer {
    cursor: pointer;
}

.quick-template:hover .border {
    border-color: #007bff !important;
    box-shadow: 0 2px 10px rgba(0,123,255,0.1);
    transition: all 0.3s ease;
}

.btn-gradient-danger {
    background: linear-gradient(135deg, #ff416c 0%, #ff4757 100%);
    border: none;
    color: white;
    transition: all 0.3s ease;
}

.btn-gradient-danger:hover {
    background: linear-gradient(135deg, #ff4757 0%, #ff416c 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(255,65,108,0.3);
}
</style>
@endpush

@push('scripts')
<script>
// Quick template functionality
document.querySelectorAll('.quick-template').forEach(template => {
    template.addEventListener('click', function() {
        const severity = this.dataset.severity;
        const type = this.dataset.type;
        const title = this.dataset.title;
        const description = this.dataset.description;
        
        // Fill form fields
        document.getElementById('severity').value = severity;
        document.getElementById('type').value = type;
        document.getElementById('title').value = title;
        document.getElementById('description').value = description;
        
        // Scroll to form
        document.getElementById('bugReportForm').scrollIntoView({ 
            behavior: 'smooth',
            block: 'start'
        });
        
        // Focus on title field
        setTimeout(() => {
            document.getElementById('title').focus();
        }, 500);
    });
});

// Form validation
document.getElementById('bugReportForm').addEventListener('submit', function(e) {
    const requiredFields = ['title', 'description', 'severity', 'type'];
    let isValid = true;
    
    requiredFields.forEach(fieldName => {
        const field = document.getElementById(fieldName);
        if (!field.value.trim()) {
            field.classList.add('is-invalid');
            isValid = false;
        } else {
            field.classList.remove('is-invalid');
        }
    });
    
    if (!isValid) {
        e.preventDefault();
        showToast('Mohon lengkapi semua field yang wajib diisi', 'error');
        return false;
    }
    
    // Show loading state
    const submitBtn = this.querySelector('button[type="submit"]');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Submitting...';
    submitBtn.disabled = true;
});

// Toast notification function
function showToast(message, type = 'success') {
    const toast = document.createElement('div');
    toast.className = `alert alert-${type === 'error' ? 'danger' : type} alert-dismissible fade show position-fixed`;
    toast.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    toast.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        if (toast.parentNode) {
            toast.parentNode.removeChild(toast);
        }
    }, 5000);
}

// Auto-detect current URL
if (!document.getElementById('url').value) {
    document.getElementById('url').value = window.location.href;
}
</script>
@endpush 