@extends('layouts.app')

@section('title', 'Bug Detail - ' . $bug->title)

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.bugs.index') }}">Bug Detection</a></li>
    <li class="breadcrumb-item active">Bug Detail</li>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-8">
            <!-- Bug Details Card -->
            <div class="card shadow-sm">
                <div class="card-header bg-gradient-primary text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-bug me-2"></i>
                        {{ $bug->title }}
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Status and Severity Badges -->
                    <div class="mb-3">
                        <span class="badge bg-{{ $bug->status_badge_color }} me-2">
                            {{ ucfirst($bug->status) }}
                        </span>
                        <span class="badge bg-{{ $bug->severity_badge_color }} me-2">
                            {{ ucfirst($bug->severity) }}
                        </span>
                        <span class="badge bg-info">
                            {{ ucfirst($bug->type) }}
                        </span>
                    </div>

                    <!-- Description -->
                    <div class="mb-4">
                        <h6 class="text-muted">Description</h6>
                        <p class="text-dark">{{ $bug->description }}</p>
                    </div>

                    <!-- Error Details -->
                    @if($bug->error_data)
                    <div class="mb-4">
                        <h6 class="text-muted">Error Details</h6>
                        <div class="bg-light p-3 rounded">
                            <pre class="mb-0 text-sm">{{ json_encode($bug->error_data, JSON_PRETTY_PRINT) }}</pre>
                        </div>
                    </div>
                    @endif

                    <!-- Stack Trace -->
                    @if($bug->stack_trace)
                    <div class="mb-4">
                        <h6 class="text-muted">Stack Trace</h6>
                        <div class="bg-dark text-light p-3 rounded" style="max-height: 300px; overflow-y: auto;">
                            <pre class="mb-0 text-sm text-light">{{ $bug->stack_trace }}</pre>
                        </div>
                    </div>
                    @endif

                    <!-- Environment Data -->
                    @if($bug->environment_data)
                    <div class="mb-4">
                        <h6 class="text-muted">Environment Information</h6>
                        <div class="row">
                            @foreach($bug->environment_data as $key => $value)
                            <div class="col-md-6 mb-2">
                                <strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong>
                                <span class="text-muted">{{ is_array($value) ? json_encode($value) : $value }}</span>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    <!-- Resolution Notes -->
                    @if($bug->resolution_notes)
                    <div class="mb-4">
                        <h6 class="text-muted">Resolution Notes</h6>
                        <div class="bg-success bg-opacity-10 p-3 rounded border-start border-success border-4">
                            <p class="mb-0">{{ $bug->resolution_notes }}</p>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <!-- Bug Information Card -->
            <div class="card shadow-sm mb-4">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Bug Information</h6>
                </div>
                <div class="card-body">
                    <div class="row mb-2">
                        <div class="col-5"><strong>ID:</strong></div>
                        <div class="col-7">#{{ $bug->id }}</div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-5"><strong>Module:</strong></div>
                        <div class="col-7">
                            @if($bug->module)
                                <span class="badge bg-secondary">{{ $bug->module }}</span>
                            @else
                                <span class="text-muted">N/A</span>
                            @endif
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-5"><strong>URL:</strong></div>
                        <div class="col-7">
                            @if($bug->url)
                                <a href="{{ $bug->url }}" target="_blank" class="text-primary text-decoration-none">
                                    {{ Str::limit($bug->url, 30) }}
                                </a>
                            @else
                                <span class="text-muted">N/A</span>
                            @endif
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-5"><strong>Occurrences:</strong></div>
                        <div class="col-7">
                            <span class="badge bg-warning text-dark">{{ $bug->occurrence_count }}x</span>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-5"><strong>Reported By:</strong></div>
                        <div class="col-7">
                            @if($bug->user)
                                <div>{{ $bug->user->name }}</div>
                                <small class="text-muted">{{ $bug->user->email }}</small>
                            @else
                                <span class="text-muted">System</span>
                            @endif
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-5"><strong>Created:</strong></div>
                        <div class="col-7">
                            <div>{{ $bug->created_at->format('M d, Y') }}</div>
                            <small class="text-muted">{{ $bug->created_at->format('H:i:s') }}</small>
                        </div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-5"><strong>Last Occurred:</strong></div>
                        <div class="col-7">
                            <div>{{ $bug->last_occurred_at->format('M d, Y') }}</div>
                            <small class="text-muted">{{ $bug->last_occurred_at->format('H:i:s') }}</small>
                        </div>
                    </div>
                    @if($bug->resolved_at)
                    <div class="row mb-2">
                        <div class="col-5"><strong>Resolved:</strong></div>
                        <div class="col-7">
                            <div>{{ $bug->resolved_at->format('M d, Y') }}</div>
                            <small class="text-muted">{{ $bug->resolved_at->format('H:i:s') }}</small>
                        </div>
                    </div>
                    @endif
                    @if($bug->resolver)
                    <div class="row mb-2">
                        <div class="col-5"><strong>Resolved By:</strong></div>
                        <div class="col-7">
                            <div>{{ $bug->resolver->name }}</div>
                            <small class="text-muted">{{ $bug->resolver->email }}</small>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- Update Status Card -->
            <div class="card shadow-sm">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Update Status</h6>
                </div>
                <div class="card-body">
                    <form action="{{ route('admin.bugs.update', $bug) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="mb-3">
                            <label for="status" class="form-label">Status</label>
                            <select name="status" id="status" class="form-select" required>
                                <option value="open" {{ $bug->status === 'open' ? 'selected' : '' }}>Open</option>
                                <option value="in_progress" {{ $bug->status === 'in_progress' ? 'selected' : '' }}>In Progress</option>
                                <option value="resolved" {{ $bug->status === 'resolved' ? 'selected' : '' }}>Resolved</option>
                                <option value="closed" {{ $bug->status === 'closed' ? 'selected' : '' }}>Closed</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="resolution_notes" class="form-label">Resolution Notes</label>
                            <textarea name="resolution_notes" id="resolution_notes" class="form-control" rows="4" placeholder="Add notes about the resolution...">{{ $bug->resolution_notes }}</textarea>
                        </div>

                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i>Update Status
                            </button>
                            <a href="{{ route('admin.bugs.index') }}" class="btn btn-outline-secondary">
                                <i class="fas fa-arrow-left me-2"></i>Back to List
                            </a>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Actions Card -->
            <div class="card shadow-sm mt-4">
                <div class="card-header bg-light">
                    <h6 class="mb-0">Actions</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        @if($bug->status !== 'resolved')
                        <form action="{{ route('admin.bugs.update', $bug) }}" method="POST" class="d-inline">
                            @csrf
                            @method('PUT')
                            <input type="hidden" name="status" value="resolved">
                            <button type="submit" class="btn btn-success btn-sm w-100" onclick="return confirm('Mark this bug as resolved?')">
                                <i class="fas fa-check me-2"></i>Mark as Resolved
                            </button>
                        </form>
                        @endif
                        
                        <form action="{{ route('admin.bugs.destroy', $bug) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm w-100" onclick="return confirm('Are you sure you want to delete this bug report?')">
                                <i class="fas fa-trash me-2"></i>Delete Bug
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
pre {
    white-space: pre-wrap;
    word-wrap: break-word;
}

.text-sm {
    font-size: 0.875rem;
}
</style>
@endsection
