@extends('layouts.app')

@section('title', 'Tambah Inventaris Desa')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.inventaris-desa.index') }}">Inventaris Desa</a></li>
    <li class="breadcrumb-item active">Tambah Inventaris</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-plus me-2"></i>
                    Tambah Inventaris Desa
                </h5>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.inventaris-desa.store') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    
                    <!-- Informasi Dasar -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-info-circle me-2"></i>
                                Informasi Dasar
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nama Barang <span class="text-danger">*</span></label>
                                <input type="text" name="nama_barang" class="form-control @error('nama_barang') is-invalid @enderror" 
                                       value="{{ old('nama_barang') }}" required>
                                @error('nama_barang')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Kategori <span class="text-danger">*</span></label>
                                <select name="kategori" class="form-select @error('kategori') is-invalid @enderror" required>
                                    <option value="">Pilih Kategori</option>
                                    @foreach($kategori as $kat)
                                        <option value="{{ $kat }}" {{ old('kategori') == $kat ? 'selected' : '' }}>{{ $kat }}</option>
                                    @endforeach
                                </select>
                                @error('kategori')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Merk/Tipe</label>
                                <input type="text" name="merk_tipe" class="form-control @error('merk_tipe') is-invalid @enderror" 
                                       value="{{ old('merk_tipe') }}">
                                @error('merk_tipe')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tahun Perolehan</label>
                                <input type="number" name="tahun_perolehan" class="form-control @error('tahun_perolehan') is-invalid @enderror" 
                                       value="{{ old('tahun_perolehan') }}" min="1900" max="{{ date('Y') }}">
                                @error('tahun_perolehan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Deskripsi</label>
                                <textarea name="deskripsi" class="form-control @error('deskripsi') is-invalid @enderror" rows="3">{{ old('deskripsi') }}</textarea>
                                @error('deskripsi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Informasi Finansial -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-money-bill-wave me-2"></i>
                                Informasi Finansial
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Harga Perolehan <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" name="harga_perolehan" class="form-control @error('harga_perolehan') is-invalid @enderror" 
                                           value="{{ old('harga_perolehan') }}" min="0" step="0.01" required>
                                </div>
                                @error('harga_perolehan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Nilai Sekarang</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" name="nilai_sekarang" class="form-control @error('nilai_sekarang') is-invalid @enderror" 
                                           value="{{ old('nilai_sekarang') }}" min="0" step="0.01">
                                </div>
                                @error('nilai_sekarang')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Sumber Dana</label>
                                <select name="sumber_dana" class="form-select @error('sumber_dana') is-invalid @enderror">
                                    <option value="">Pilih Sumber Dana</option>
                                    <option value="APBDes" {{ old('sumber_dana') == 'APBDes' ? 'selected' : '' }}>APBDes</option>
                                    <option value="Bantuan Pemerintah" {{ old('sumber_dana') == 'Bantuan Pemerintah' ? 'selected' : '' }}>Bantuan Pemerintah</option>
                                    <option value="Swadaya" {{ old('sumber_dana') == 'Swadaya' ? 'selected' : '' }}>Swadaya</option>
                                    <option value="Hibah" {{ old('sumber_dana') == 'Hibah' ? 'selected' : '' }}>Hibah</option>
                                    <option value="Lainnya" {{ old('sumber_dana') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                </select>
                                @error('sumber_dana')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Kondisi dan Status -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-clipboard-check me-2"></i>
                                Kondisi dan Status
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Kondisi <span class="text-danger">*</span></label>
                                <select name="kondisi" class="form-select @error('kondisi') is-invalid @enderror" required>
                                    <option value="">Pilih Kondisi</option>
                                    <option value="Baik" {{ old('kondisi') == 'Baik' ? 'selected' : '' }}>Baik</option>
                                    <option value="Rusak Ringan" {{ old('kondisi') == 'Rusak Ringan' ? 'selected' : '' }}>Rusak Ringan</option>
                                    <option value="Rusak Berat" {{ old('kondisi') == 'Rusak Berat' ? 'selected' : '' }}>Rusak Berat</option>
                                    <option value="Tidak Dapat Digunakan" {{ old('kondisi') == 'Tidak Dapat Digunakan' ? 'selected' : '' }}>Tidak Dapat Digunakan</option>
                                </select>
                                @error('kondisi')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Status Pemakaian</label>
                                <select name="status_pemakaian" class="form-select @error('status_pemakaian') is-invalid @enderror">
                                    <option value="Digunakan" {{ old('status_pemakaian') == 'Digunakan' ? 'selected' : '' }}>Digunakan</option>
                                    <option value="Tidak Digunakan" {{ old('status_pemakaian') == 'Tidak Digunakan' ? 'selected' : '' }}>Tidak Digunakan</option>
                                    <option value="Dipinjamkan" {{ old('status_pemakaian') == 'Dipinjamkan' ? 'selected' : '' }}>Dipinjamkan</option>
                                    <option value="Dalam Perbaikan" {{ old('status_pemakaian') == 'Dalam Perbaikan' ? 'selected' : '' }}>Dalam Perbaikan</option>
                                    <option value="Hilang" {{ old('status_pemakaian') == 'Hilang' ? 'selected' : '' }}>Hilang</option>
                                </select>
                                @error('status_pemakaian')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Lokasi dan Penanggung Jawab -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-map-marker-alt me-2"></i>
                                Lokasi dan Penanggung Jawab
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Lokasi Penyimpanan <span class="text-danger">*</span></label>
                                <input type="text" name="lokasi_penyimpanan" class="form-control @error('lokasi_penyimpanan') is-invalid @enderror" 
                                       value="{{ old('lokasi_penyimpanan') }}" required>
                                @error('lokasi_penyimpanan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Penanggung Jawab <span class="text-danger">*</span></label>
                                <input type="text" name="penanggung_jawab" class="form-control @error('penanggung_jawab') is-invalid @enderror" 
                                       value="{{ old('penanggung_jawab') }}" required>
                                @error('penanggung_jawab')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jabatan Penanggung Jawab</label>
                                <input type="text" name="jabatan_pj" class="form-control @error('jabatan_pj') is-invalid @enderror" 
                                       value="{{ old('jabatan_pj') }}">
                                @error('jabatan_pj')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Alamat Detail</label>
                                <textarea name="alamat_detail" class="form-control @error('alamat_detail') is-invalid @enderror" rows="2">{{ old('alamat_detail') }}</textarea>
                                @error('alamat_detail')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Maintenance -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-tools me-2"></i>
                                Informasi Maintenance
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Terakhir Maintenance</label>
                                <input type="date" name="terakhir_maintenance" class="form-control @error('terakhir_maintenance') is-invalid @enderror" 
                                       value="{{ old('terakhir_maintenance') }}">
                                @error('terakhir_maintenance')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Jadwal Maintenance Berikutnya</label>
                                <input type="date" name="jadwal_maintenance_berikutnya" class="form-control @error('jadwal_maintenance_berikutnya') is-invalid @enderror" 
                                       value="{{ old('jadwal_maintenance_berikutnya') }}">
                                @error('jadwal_maintenance_berikutnya')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Biaya Maintenance per Tahun</label>
                                <div class="input-group">
                                    <span class="input-group-text">Rp</span>
                                    <input type="number" name="biaya_maintenance_per_tahun" class="form-control @error('biaya_maintenance_per_tahun') is-invalid @enderror" 
                                           value="{{ old('biaya_maintenance_per_tahun') }}" min="0" step="0.01">
                                </div>
                                @error('biaya_maintenance_per_tahun')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <!-- Dokumentasi -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <h6 class="text-primary mb-3">
                                <i class="fas fa-images me-2"></i>
                                Dokumentasi
                            </h6>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Foto Barang</label>
                                <input type="file" name="foto_barang" class="form-control @error('foto_barang') is-invalid @enderror" 
                                       accept="image/*">
                                @error('foto_barang')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Dokumen Pendukung</label>
                                <input type="file" name="dokumen_pendukung" class="form-control @error('dokumen_pendukung') is-invalid @enderror" 
                                       accept=".pdf,.doc,.docx">
                                @error('dokumen_pendukung')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="mb-3">
                                <label class="form-label">Keterangan</label>
                                <textarea name="keterangan" class="form-control @error('keterangan') is-invalid @enderror" rows="3">{{ old('keterangan') }}</textarea>
                                @error('keterangan')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="{{ route('admin.inventaris-desa.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-2"></i>
                            Kembali
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>
                            Simpan Inventaris
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informasi
                </h6>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <h6 class="alert-heading">Tips:</h6>
                    <ul class="mb-0">
                        <li>Kode inventaris akan dibuat otomatis berdasarkan kategori</li>
                        <li>Nilai sekarang akan diset sama dengan harga perolehan jika tidak diisi</li>
                        <li>Foto dan dokumen pendukung dapat diupload setelah data tersimpan</li>
                        <li>Pastikan informasi penanggung jawab diisi dengan benar</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
