@extends('layouts.app')

@section('title', 'Detail Objek Wisata')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Detail Objek Wisata</h1>
                <div>
                    <a href="{{ route('admin.objek-wisata.edit', $objekWisata->id) }}" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="{{ route('admin.objek-wisata.index') }}" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Dasar</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Nama:</strong> {{ $objekWisata->nama_wisata }}</p>
                            <p><strong>Kategori:</strong> <span class="badge badge-info">{{ ucfirst(str_replace('_', ' ', $objekWisata->kategori_wisata)) }}</span></p>
                            <p><strong>Status:</strong> 
                                @if($objekWisata->status === 'aktif')
                                    <span class="badge badge-success">Aktif</span>
                                @else
                                    <span class="badge badge-secondary">Non-aktif</span>
                                @endif
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Harga Tiket Dewasa:</strong> Rp {{ number_format($objekWisata->harga_tiket_dewasa ?? 0) }}</p>
                            <p><strong>Harga Tiket Anak:</strong> Rp {{ number_format($objekWisata->harga_tiket_anak ?? 0) }}</p>
                            <p><strong>Total Pengunjung:</strong> {{ number_format($objekWisata->total_pengunjung ?? 0) }}</p>
                            <p><strong>Rating:</strong> 
                                @if($objekWisata->rating_rata_rata ?? 0 > 0)
                                    {{ number_format($objekWisata->rating_rata_rata, 1) }}/5 ({{ $objekWisata->jumlah_review ?? 0 }} review)
                                @else
                                    Belum ada rating
                                @endif
                            </p>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-12">
                            <p><strong>Deskripsi:</strong></p>
                            <p>{{ $objekWisata->deskripsi ?? 'Tidak ada deskripsi' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Lokasi</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Alamat:</strong> {{ $objekWisata->alamat ?? '-' }}</p>
                            <p><strong>Desa:</strong> {{ $objekWisata->desa ?? '-' }}</p>
                            <p><strong>Kecamatan:</strong> {{ $objekWisata->kecamatan ?? '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Latitude:</strong> {{ $objekWisata->latitude ?? '-' }}</p>
                            <p><strong>Longitude:</strong> {{ $objekWisata->longitude ?? '-' }}</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informasi Kontak & Operasional -->
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Kontak & Operasional</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Jam Operasional:</strong> 
                                @if($objekWisata->jam_operasional)
                                    @if(is_array($objekWisata->jam_operasional))
                                        {{ implode(', ', $objekWisata->jam_operasional) }}
                                    @else
                                        {{ $objekWisata->jam_operasional }}
                                    @endif
                                @else
                                    24 Jam
                                @endif
                            </p>
                            <p><strong>Nama Pengelola:</strong> {{ $objekWisata->nama_pengelola ?? '-' }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Telepon:</strong> {{ $objekWisata->telepon ?? '-' }}</p>
                            <p><strong>Email:</strong> {{ $objekWisata->email ?? '-' }}</p>
                            <p><strong>Website:</strong> 
                                @if($objekWisata->website)
                                    <a href="{{ $objekWisata->website }}" target="_blank">{{ $objekWisata->website }}</a>
                                @else
                                    -
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            @if($objekWisata->foto_utama && is_string($objekWisata->foto_utama))
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Foto Utama</h6>
                </div>
                <div class="card-body">
                    <img src="{{ $objekWisata->foto_utama_url }}" 
                         alt="{{ $objekWisata->nama_wisata }}" 
                         class="img-fluid rounded"
                         onerror="this.style.display='none';">
                </div>
            </div>
            @endif

            <!-- Galeri Foto -->
            @if($objekWisata->galeri_foto && count($objekWisata->galeri_foto) > 0)
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Galeri Foto</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        @php
                            $galeri = is_array($objekWisata->galeri_foto) ? $objekWisata->galeri_foto : json_decode($objekWisata->galeri_foto, true);
                        @endphp
                        @if($galeri && count($galeri) > 0)
                            @foreach($galeri as $foto)
                                @if($foto && is_string($foto))
                                <div class="col-6 mb-3">
                                    <img src="{{ \App\Helpers\SharedHostingHelper::getFileUrl('wisata/galeri/' . $foto, 'images/default-tourism.png') }}" 
                                         alt="Gallery" 
                                         class="img-fluid rounded"
                                         style="width: 100%; height: 120px; object-fit: cover;"
                                         onerror="this.style.display='none';">
                                </div>
                                @endif
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
            @endif

            <div class="card shadow">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="{{ route('admin.objek-wisata.edit', $objekWisata->id) }}" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="{{ route('admin.tiket-wisata.index') }}?objek_wisata_id={{ $objekWisata->id }}" 
                           class="btn btn-info btn-sm">
                            <i class="fas fa-ticket-alt"></i> Lihat Booking
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 
