@extends('layouts.app')

@section('title', 'Tambah Data PBB')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Tambah Data PBB (Pajak Bumi dan Bangunan)</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.pbb.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('admin.pbb.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <!-- Data Objek Pajak -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">Data Objek Pajak</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <label for="nop">NOP (Nomor Objek Pajak) <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nop') is-invalid @enderror" 
                                                   id="nop" name="nop" value="{{ old('nop') }}" 
                                                   placeholder="18 digit nomor objek pajak" maxlength="18" required>
                                            <small class="form-text text-muted">Format: 18 digit angka tanpa titik atau strip</small>
                                            @error('nop')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="nik">NIK Pemilik <span class="text-danger">*</span></label>
                                            <select class="form-control select2 @error('nik') is-invalid @enderror" 
                                                    id="nik" name="nik" required>
                                                <option value="">Pilih Pemilik</option>
                                                @foreach($penduduk as $p)
                                                    <option value="{{ $p->nik }}" {{ old('nik') == $p->nik ? 'selected' : '' }}>
                                                        {{ $p->nik }} - {{ $p->nama }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            @error('nik')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="nama_pemilik">Nama Pemilik <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('nama_pemilik') is-invalid @enderror" 
                                                   id="nama_pemilik" name="nama_pemilik" value="{{ old('nama_pemilik') }}" 
                                                   placeholder="Nama pemilik objek pajak" required>
                                            @error('nama_pemilik')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="form-group">
                                            <label for="alamat_objek">Alamat Objek <span class="text-danger">*</span></label>
                                            <textarea class="form-control @error('alamat_objek') is-invalid @enderror" 
                                                      id="alamat_objek" name="alamat_objek" rows="3" 
                                                      placeholder="Alamat lengkap objek pajak" required>{{ old('alamat_objek') }}</textarea>
                                            @error('alamat_objek')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="dusun">Dusun</label>
                                                    <input type="text" class="form-control @error('dusun') is-invalid @enderror" 
                                                           id="dusun" name="dusun" value="{{ old('dusun') }}" 
                                                           placeholder="Nama dusun">
                                                    @error('dusun')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="rt">RT</label>
                                                    <input type="text" class="form-control @error('rt') is-invalid @enderror" 
                                                           id="rt" name="rt" value="{{ old('rt') }}" 
                                                           placeholder="RT" maxlength="5">
                                                    @error('rt')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="rw">RW</label>
                                                    <input type="text" class="form-control @error('rw') is-invalid @enderror" 
                                                           id="rw" name="rw" value="{{ old('rw') }}" 
                                                           placeholder="RW" maxlength="5">
                                                    @error('rw')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Data Tanah dan Bangunan -->
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="card-title">Data Tanah dan Bangunan</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="luas_tanah">Luas Tanah (m²) <span class="text-danger">*</span></label>
                                                    <input type="number" class="form-control @error('luas_tanah') is-invalid @enderror" 
                                                           id="luas_tanah" name="luas_tanah" value="{{ old('luas_tanah') }}" 
                                                           placeholder="0" min="0" step="0.01" required>
                                                    @error('luas_tanah')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="luas_bangunan">Luas Bangunan (m²)</label>
                                                    <input type="number" class="form-control @error('luas_bangunan') is-invalid @enderror" 
                                                           id="luas_bangunan" name="luas_bangunan" value="{{ old('luas_bangunan') }}" 
                                                           placeholder="0" min="0" step="0.01">
                                                    @error('luas_bangunan')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="jenis_tanah">Jenis Tanah <span class="text-danger">*</span></label>
                                                    <select class="form-control @error('jenis_tanah') is-invalid @enderror" 
                                                            id="jenis_tanah" name="jenis_tanah" required>
                                                        <option value="">Pilih Jenis Tanah</option>
                                                        <option value="Sawah" {{ old('jenis_tanah') == 'Sawah' ? 'selected' : '' }}>Sawah</option>
                                                        <option value="Tegalan" {{ old('jenis_tanah') == 'Tegalan' ? 'selected' : '' }}>Tegalan</option>
                                                        <option value="Pekarangan" {{ old('jenis_tanah') == 'Pekarangan' ? 'selected' : '' }}>Pekarangan</option>
                                                        <option value="Perkebunan" {{ old('jenis_tanah') == 'Perkebunan' ? 'selected' : '' }}>Perkebunan</option>
                                                        <option value="Hutan" {{ old('jenis_tanah') == 'Hutan' ? 'selected' : '' }}>Hutan</option>
                                                        <option value="Rawa" {{ old('jenis_tanah') == 'Rawa' ? 'selected' : '' }}>Rawa</option>
                                                        <option value="Lainnya" {{ old('jenis_tanah') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                                    </select>
                                                    @error('jenis_tanah')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="jenis_bangunan">Jenis Bangunan <span class="text-danger">*</span></label>
                                                    <select class="form-control @error('jenis_bangunan') is-invalid @enderror" 
                                                            id="jenis_bangunan" name="jenis_bangunan" required>
                                                        <option value="">Pilih Jenis Bangunan</option>
                                                        <option value="Rumah Tinggal" {{ old('jenis_bangunan') == 'Rumah Tinggal' ? 'selected' : '' }}>Rumah Tinggal</option>
                                                        <option value="Ruko" {{ old('jenis_bangunan') == 'Ruko' ? 'selected' : '' }}>Ruko</option>
                                                        <option value="Pabrik" {{ old('jenis_bangunan') == 'Pabrik' ? 'selected' : '' }}>Pabrik</option>
                                                        <option value="Gudang" {{ old('jenis_bangunan') == 'Gudang' ? 'selected' : '' }}>Gudang</option>
                                                        <option value="Pertanian" {{ old('jenis_bangunan') == 'Pertanian' ? 'selected' : '' }}>Pertanian</option>
                                                        <option value="Lainnya" {{ old('jenis_bangunan') == 'Lainnya' ? 'selected' : '' }}>Lainnya</option>
                                                        <option value="Tidak Ada" {{ old('jenis_bangunan') == 'Tidak Ada' ? 'selected' : '' }}>Tidak Ada</option>
                                                    </select>
                                                    @error('jenis_bangunan')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="njop_tanah_per_m2">NJOP Tanah per m² (Rp) <span class="text-danger">*</span></label>
                                                    <input type="number" class="form-control @error('njop_tanah_per_m2') is-invalid @enderror" 
                                                           id="njop_tanah_per_m2" name="njop_tanah_per_m2" value="{{ old('njop_tanah_per_m2') }}" 
                                                           placeholder="0" min="0" step="1" required>
                                                    @error('njop_tanah_per_m2')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="njop_bangunan_per_m2">NJOP Bangunan per m² (Rp)</label>
                                                    <input type="number" class="form-control @error('njop_bangunan_per_m2') is-invalid @enderror" 
                                                           id="njop_bangunan_per_m2" name="njop_bangunan_per_m2" value="{{ old('njop_bangunan_per_m2') }}" 
                                                           placeholder="0" min="0" step="1">
                                                    @error('njop_bangunan_per_m2')
                                                        <div class="invalid-feedback">{{ $message }}</div>
                                                    @enderror
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group">
                                            <label for="keterangan">Keterangan</label>
                                            <textarea class="form-control @error('keterangan') is-invalid @enderror" 
                                                      id="keterangan" name="keterangan" rows="3" 
                                                      placeholder="Keterangan tambahan (opsional)">{{ old('keterangan') }}</textarea>
                                            @error('keterangan')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Koordinat (Opsional) -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">Koordinat Lokasi (Opsional)</h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="latitude">Latitude</label>
                                            <input type="number" class="form-control @error('latitude') is-invalid @enderror" 
                                                   id="latitude" name="latitude" value="{{ old('latitude') }}" 
                                                   placeholder="-6.123456" step="0.00000001">
                                            @error('latitude')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="longitude">Longitude</label>
                                            <input type="number" class="form-control @error('longitude') is-invalid @enderror" 
                                                   id="longitude" name="longitude" value="{{ old('longitude') }}" 
                                                   placeholder="106.123456" step="0.00000001">
                                            @error('longitude')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Ringkasan Perhitungan -->
                        <div class="card mt-3">
                            <div class="card-header">
                                <h5 class="card-title">Ringkasan Perhitungan PBB</h5>
                            </div>
                            <div class="card-body">
                                <div class="alert alert-info">
                                    <strong>Rumus Perhitungan:</strong><br>
                                    1. NJOP Tanah = Luas Tanah × NJOP Tanah per m²<br>
                                    2. NJOP Bangunan = Luas Bangunan × NJOP Bangunan per m²<br>
                                    3. NJOP Total = NJOP Tanah + NJOP Bangunan<br>
                                    4. NJKP = NJOP Total × 20% (untuk rumah tinggal)<br>
                                    5. PBB Terhutang = NJKP × 0.5%
                                </div>
                                <div id="perhitungan-preview" class="d-none">
                                    <table class="table table-sm">
                                        <tr>
                                            <td>NJOP Tanah</td>
                                            <td>:</td>
                                            <td class="text-right"><span id="njop-tanah-preview">Rp 0</span></td>
                                        </tr>
                                        <tr>
                                            <td>NJOP Bangunan</td>
                                            <td>:</td>
                                            <td class="text-right"><span id="njop-bangunan-preview">Rp 0</span></td>
                                        </tr>
                                        <tr>
                                            <td><strong>NJOP Total</strong></td>
                                            <td>:</td>
                                            <td class="text-right"><strong><span id="njop-total-preview">Rp 0</span></strong></td>
                                        </tr>
                                        <tr>
                                            <td>NJKP (20%)</td>
                                            <td>:</td>
                                            <td class="text-right"><span id="njkp-preview">Rp 0</span></td>
                                        </tr>
                                        <tr class="table-success">
                                            <td><strong>PBB Terhutang (0.5%)</strong></td>
                                            <td>:</td>
                                            <td class="text-right"><strong><span id="pbb-preview">Rp 0</span></strong></td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>

                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Data PBB
                            </button>
                            <a href="{{ route('admin.pbb.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap4',
        placeholder: 'Pilih...'
    });

    // Auto-fill nama pemilik when NIK is selected
    $('#nik').on('change', function() {
        var selectedOption = $(this).find('option:selected');
        var namaPemilik = selectedOption.text().split(' - ')[1];
        if (namaPemilik) {
            $('#nama_pemilik').val(namaPemilik);
        }
    });

    // Calculate PBB preview
    function calculatePbbPreview() {
        var luasTanah = parseFloat($('#luas_tanah').val()) || 0;
        var luasBangunan = parseFloat($('#luas_bangunan').val()) || 0;
        var njopTanahPerM2 = parseFloat($('#njop_tanah_per_m2').val()) || 0;
        var njopBangunanPerM2 = parseFloat($('#njop_bangunan_per_m2').val()) || 0;

        if (luasTanah > 0 && njopTanahPerM2 > 0) {
            var njopTanah = luasTanah * njopTanahPerM2;
            var njopBangunan = luasBangunan * njopBangunanPerM2;
            var njopTotal = njopTanah + njopBangunan;
            var njkp = njopTotal * 0.20;
            var pbbTerhutang = njkp * 0.005;

            $('#njop-tanah-preview').text('Rp ' + njopTanah.toLocaleString('id-ID'));
            $('#njop-bangunan-preview').text('Rp ' + njopBangunan.toLocaleString('id-ID'));
            $('#njop-total-preview').text('Rp ' + njopTotal.toLocaleString('id-ID'));
            $('#njkp-preview').text('Rp ' + njkp.toLocaleString('id-ID'));
            $('#pbb-preview').text('Rp ' + pbbTerhutang.toLocaleString('id-ID'));

            $('#perhitungan-preview').removeClass('d-none');
        } else {
            $('#perhitungan-preview').addClass('d-none');
        }
    }

    // Trigger calculation on input change
    $('#luas_tanah, #luas_bangunan, #njop_tanah_per_m2, #njop_bangunan_per_m2').on('input', calculatePbbPreview);

    // Format NOP input
    $('#nop').on('input', function() {
        var value = $(this).val().replace(/\D/g, '');
        if (value.length > 18) {
            value = value.substring(0, 18);
        }
        $(this).val(value);
    });
});
</script>
@endpush 