@extends('layouts.app')

@section('title', 'Manajemen PBB')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Data PBB (Pajak Bumi dan Bangunan)</h3>
                    <div class="card-tools">
                        <a href="{{ route('admin.pbb.create') }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Tambah Data PBB
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Statistik -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="fas fa-home"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Objek PBB</span>
                                    <span class="info-box-number">{{ number_format($statistik['total_pbb']) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Lunas</span>
                                    <span class="info-box-number">{{ number_format($statistik['lunas']) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="fas fa-exclamation-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Belum Lunas</span>
                                    <span class="info-box-number">{{ number_format($statistik['belum_lunas']) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-danger"><i class="fas fa-money-bill-wave"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Tagihan</span>
                                    <span class="info-box-number">Rp {{ number_format($statistik['total_tagihan'], 0, ',', '.') }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter -->
                    <div class="row mb-3">
                        <div class="col-md-6">
                            <form method="GET" action="{{ route('admin.pbb.index') }}">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Cari NOP, Nama Pemilik, atau Alamat..." value="{{ request('search') }}">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="submit">
                                            <i class="fas fa-search"></i>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="col-md-6">
                            <form method="GET" action="{{ route('admin.pbb.index') }}">
                                <div class="input-group">
                                    <select name="status" class="form-control">
                                        <option value="">Semua Status</option>
                                        <option value="Lunas" {{ request('status') == 'Lunas' ? 'selected' : '' }}>Lunas</option>
                                        <option value="Belum Lunas" {{ request('status') == 'Belum Lunas' ? 'selected' : '' }}>Belum Lunas</option>
                                        <option value="Dicicil" {{ request('status') == 'Dicicil' ? 'selected' : '' }}>Dicicil</option>
                                    </select>
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-secondary" type="submit">Filter</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Tabel Data -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>NOP</th>
                                    <th>Nama Pemilik</th>
                                    <th>Alamat Objek</th>
                                    <th>Luas Tanah</th>
                                    <th>Luas Bangunan</th>
                                    <th>PBB Terhutang</th>
                                    <th>Status Tahun Ini</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($pbbList as $index => $pbb)
                                    <tr>
                                        <td>{{ $pbbList->firstItem() + $index }}</td>
                                        <td>{{ $pbb->formatted_nop }}</td>
                                        <td>{{ $pbb->nama_pemilik }}</td>
                                        <td>{{ $pbb->alamat_objek }}</td>
                                        <td>{{ number_format($pbb->luas_tanah, 0, ',', '.') }} m²</td>
                                        <td>{{ number_format($pbb->luas_bangunan, 0, ',', '.') }} m²</td>
                                        <td>Rp {{ number_format($pbb->pbb_terhutang, 0, ',', '.') }}</td>
                                        <td>
                                            @php
                                                $statusTerkini = $pbb->getStatusPembayaranTerkini();
                                            @endphp
                                            @if($statusTerkini == 'Lunas')
                                                <span class="badge badge-success">{{ $statusTerkini }}</span>
                                            @elseif($statusTerkini == 'Dicicil')
                                                <span class="badge badge-warning">{{ $statusTerkini }}</span>
                                            @elseif($statusTerkini == 'Belum Lunas')
                                                <span class="badge badge-danger">{{ $statusTerkini }}</span>
                                            @else
                                                <span class="badge badge-secondary">{{ $statusTerkini }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('admin.pbb.show', $pbb) }}" class="btn btn-info btn-sm" title="Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('admin.pbb.edit', $pbb) }}" class="btn btn-warning btn-sm" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form method="POST" action="{{ route('admin.pbb.destroy', $pbb) }}" style="display:inline;" onsubmit="return confirm('Yakin ingin menghapus data ini?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger btn-sm" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">Tidak ada data PBB</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center">
                        {{ $pbbList->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 