@extends('layouts.app')

@section('title', 'Pelayanan Surat')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Pelayanan Surat</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-file-alt me-2 text-primary"></i>
            Pelayanan Surat
        </h2>
        <p class="text-muted mb-0">Kelola permohonan surat menyurat warga</p>
    </div>
    <div>
        <button type="button" class="btn btn-gradient-success me-2" data-bs-toggle="modal" data-bs-target="#addSuratModal">
            <i class="fas fa-plus me-2"></i>
            Tambah Permohonan
        </button>
        <button type="button" class="btn btn-gradient-info" onclick="exportSurat()">
            <i class="fas fa-download me-2"></i>
            Export Data
        </button>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-primary me-3">
                    <i class="fas fa-file-alt"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['total'] ?? 0 }}</h4>
                    <small class="text-muted">Total Permohonan</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-warning me-3">
                    <i class="fas fa-clock"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['menunggu'] ?? 0 }}</h4>
                    <small class="text-muted">Menunggu</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-info me-3">
                    <i class="fas fa-cog"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['diproses'] ?? 0 }}</h4>
                    <small class="text-muted">Diproses</small>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stats-card">
            <div class="d-flex align-items-center">
                <div class="stats-icon bg-success me-3">
                    <i class="fas fa-check"></i>
                </div>
                <div>
                    <h4 class="mb-0">{{ $stats['selesai'] ?? 0 }}</h4>
                    <small class="text-muted">Selesai</small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Template Quick Access -->
<div class="card mb-4">
    <div class="card-header bg-light d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="fas fa-file-contract me-2 text-primary"></i>
            Template Quick Access
        </h5>
        <a href="{{ route('admin.template-surat.index') }}" class="btn btn-sm btn-outline-primary">
            <i class="fas fa-cogs me-1"></i>
            Kelola Template
        </a>
    </div>
    <div class="card-body">
        <div class="row" id="templateGrid">
            <!-- Templates will be loaded via JavaScript -->
            <div class="col-12 text-center">
                <div class="spinner-border text-primary" role="status">
                    <span class="visually-hidden">Memuat template...</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div class="row">
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select class="form-select" id="filterStatus">
                            <option value="">Semua Status</option>
                            <option value="menunggu">Menunggu</option>
                            <option value="diproses">Diproses</option>
                            <option value="selesai">Selesai</option>
                            <option value="ditolak">Ditolak</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Jenis Surat</label>
                        <select class="form-select" id="filterJenis">
                            <option value="">Semua Jenis</option>
                            <option value="domisili">Surat Domisili</option>
                            <option value="skck">SKCK</option>
                            <option value="kematian">Surat Kematian</option>
                            <option value="usaha">Surat Usaha</option>
                            <option value="lahir">Surat Kelahiran</option>
                            <option value="pindah">Surat Pindah</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Tanggal</label>
                        <input type="date" class="form-control" id="filterTanggal">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="button" class="btn btn-primary" onclick="applyFilters()">
                                <i class="fas fa-filter me-2"></i>Filter
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 text-end">
                <button type="button" class="btn btn-outline-secondary" onclick="resetFilters()">
                    <i class="fas fa-refresh me-2"></i>Reset
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Main Table -->
<div class="card">
    <div class="card-header bg-light">
        <h5 class="card-title mb-0">
            <i class="fas fa-list me-2"></i>
            Daftar Permohonan Surat
        </h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="suratTable">
                <thead>
                    <tr>
                        <th width="5%">No</th>
                        <th width="20%">Pemohon</th>
                        <th width="15%">Jenis Surat</th>
                        <th width="15%">Tanggal</th>
                        <th width="12%">Status</th>
                        <th width="13%">File PDF</th>
                        <th width="20%">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($pelayananSurat as $index => $s)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>
                            <div>
                                <strong>{{ $s->penduduk->nama }}</strong>
                                <br><small class="text-muted">{{ $s->penduduk->nik }}</small>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-info">{{ ucfirst($s->jenis_surat) }}</span>
                        </td>
                        <td>
                            <div>{{ $s->tanggal_pengajuan->format('d/m/Y') }}</div>
                            <small class="text-muted">{{ $s->tanggal_pengajuan->format('H:i') }}</small>
                        </td>
                        <td>
                            <span class="badge bg-{{ $s->status_color }}">
                                {{ ucfirst($s->status) }}
                            </span>
                        </td>
                        <td>
                            @if($s->file_pdf)
                                <a href="{{ asset('storage/surat/' . $s->file_pdf) }}" target="_blank" class="btn btn-sm btn-outline-danger">
                                    <i class="fas fa-file-pdf me-1"></i>Lihat PDF
                                </a>
                            @else
                                <span class="text-muted">Belum ada</span>
                            @endif
                        </td>
                        <td>
                            <div class="btn-group btn-group-sm">
                                <button type="button" class="btn btn-outline-info" 
                                        onclick="showDetail({{ $s->id }})" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </button>
                                
                                @if($s->status === 'menunggu')
                                <button type="button" class="btn btn-outline-warning" 
                                        onclick="updateStatus({{ $s->id }}, 'diproses')" title="Proses">
                                    <i class="fas fa-cog"></i>
                                </button>
                                @endif
                                
                                @if($s->status === 'diproses')
                                <button type="button" class="btn btn-outline-secondary" 
                                        onclick="selectTemplate({{ $s->id }})" title="Pilih Template">
                                    <i class="fas fa-file-contract"></i>
                                </button>
                                <button type="button" class="btn btn-outline-success" 
                                        onclick="generateSurat({{ $s->id }})" title="Generate Surat">
                                    <i class="fas fa-file-pdf"></i>
                                </button>
                                @endif
                                
                                @if($s->status === 'selesai' && $s->file_pdf)
                                <button type="button" class="btn btn-outline-primary" 
                                        onclick="sendWhatsApp({{ $s->id }})" title="Kirim WA">
                                    <i class="fab fa-whatsapp"></i>
                                </button>
                                @endif
                                
                                <button type="button" class="btn btn-outline-danger" 
                                        onclick="deleteSurat({{ $s->id }})" title="Hapus">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center py-5">
                            <div class="text-muted">
                                <i class="fas fa-file-alt fa-3x mb-3 d-block"></i>
                                <h5>Belum ada permohonan surat</h5>
                                <p>Permohonan dari warga akan muncul di sini</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add Surat Modal -->
<div class="modal fade" id="addSuratModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-plus me-2"></i>
                    Tambah Permohonan Surat
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addSuratForm">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Pemohon</label>
                                <select class="form-select" name="penduduk_id" required>
                                    <option value="">Pilih Penduduk</option>
                                    @foreach($penduduk ?? [] as $p)
                                    <option value="{{ $p->id }}">{{ $p->nama }} - {{ $p->nik }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label required">Jenis Surat</label>
                                <select class="form-select" name="jenis_surat" required>
                                    <option value="">Pilih Jenis Surat</option>
                                    <option value="domisili">Surat Domisili</option>
                                    <option value="skck">SKCK</option>
                                    <option value="kematian">Surat Kematian</option>
                                    <option value="usaha">Surat Usaha</option>
                                    <option value="lahir">Surat Kelahiran</option>
                                    <option value="pindah">Surat Pindah</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Keperluan</label>
                        <textarea class="form-control" name="keperluan" rows="3" 
                                  placeholder="Jelaskan keperluan surat ini..."></textarea>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Tanggal Pengajuan</label>
                                <input type="date" class="form-control" name="tanggal_pengajuan" 
                                       value="{{ date('Y-m-d') }}">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Prioritas</label>
                                <select class="form-select" name="prioritas">
                                    <option value="normal">Normal</option>
                                    <option value="mendesak">Mendesak</option>
                                    <option value="sangat_mendesak">Sangat Mendesak</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-save me-2"></i>Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-file-alt me-2"></i>
                    Detail Permohonan Surat
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detailContent">
                <!-- Content will be loaded here -->
            </div>
        </div>
    </div>
</div>

<!-- Upload PDF Modal -->
<div class="modal fade" id="uploadPDFModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-upload me-2"></i>
                    Upload File PDF
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="uploadPDFForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="surat_id" id="uploadSuratId">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">File PDF Surat</label>
                        <input type="file" class="form-control" name="file_pdf" accept=".pdf" required>
                        <div class="form-text">
                            Upload file PDF yang sudah ditandatangani (Maks. 5MB)
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Catatan</label>
                        <textarea class="form-control" name="catatan" rows="3" 
                                  placeholder="Catatan tambahan untuk pemohon..."></textarea>
                    </div>
                    
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="sendWAAfterUpload" name="send_wa" value="1" checked>
                        <label class="form-check-label" for="sendWAAfterUpload">
                            Kirim notifikasi WhatsApp otomatis
                        </label>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-upload me-2"></i>Upload & Selesaikan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Template Selection Modal -->
<div class="modal fade" id="templateModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-file-contract me-2"></i>
                    Pilih Template Surat
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="templateList">
                    <!-- Template list will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
    .required::after {
        content: ' *';
        color: #dc3545;
    }
    
    .stats-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 24px;
        color: white;
    }
    
    .table th {
        border-top: none;
        font-weight: 600;
        background: #f8f9fa;
    }
    
    .btn-group-sm .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
    }
    
    .badge {
        font-size: 0.75rem;
        font-weight: 500;
    }
</style>
@endpush

@push('scripts')
<script>
// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Bootstrap tooltips
    var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
    var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
        return new bootstrap.Tooltip(tooltipTriggerEl);
    });

    // Load available templates
    loadTemplates();
});

function loadTemplates() {
    fetch('/api/template-surat')
        .then(response => response.json())
        .then(data => {
            const templateGrid = document.getElementById('templateGrid');
            if (templateGrid && data.data && data.data.length > 0) {
                templateGrid.innerHTML = data.data.map(template => `
                    <div class="col-md-4 col-lg-3">
                        <div class="card border h-100">
                            <div class="card-body text-center p-3">
                                <i class="fas fa-file-contract fa-2x text-primary mb-2"></i>
                                <h6 class="card-title">${template.nama_template}</h6>
                                <p class="card-text small text-muted">${template.jenis_surat}</p>
                                <button class="btn btn-sm btn-outline-primary" onclick="useTemplate(${template.id})">
                                    <i class="fas fa-plus me-1"></i> Gunakan
                                </button>
                            </div>
                        </div>
                    </div>
                `).join('');
            } else if (templateGrid) {
                templateGrid.innerHTML = `
                    <div class="col-12 text-center">
                        <div class="text-muted">
                            <i class="fas fa-file-contract fa-3x mb-3"></i>
                            <div>Belum ada template tersedia</div>
                            <a href="/admin/template-surat/create" class="btn btn-sm btn-primary mt-2">
                                <i class="fas fa-plus me-1"></i> Buat Template
                            </a>
                        </div>
                    </div>
                `;
            }
        })
        .catch(error => {
            console.error('Error loading templates:', error);
            const templateGrid = document.getElementById('templateGrid');
            if (templateGrid) {
                templateGrid.innerHTML = `
                    <div class="col-12 text-center text-danger">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        Gagal memuat template
                    </div>
                `;
            }
        });
}

function useTemplate(templateId) {
    // Open add surat modal with pre-selected template
    const addModal = document.getElementById('addSuratModal');
    if (addModal) {
        const modal = new bootstrap.Modal(addModal);
        modal.show();
        // Pre-select template if form exists
        const templateSelect = document.getElementById('template_id');
        if (templateSelect) {
            templateSelect.value = templateId;
        }
    }
}

function selectTemplate(suratId) {
    const templateModal = document.getElementById('templateModal');
    if (templateModal) {
        const modal = new bootstrap.Modal(templateModal);
        modal.show();
        
        // Store surat ID for later use
        templateModal.dataset.suratId = suratId;
        
        // Load templates
        const templateList = document.getElementById('templateList');
        if (templateList) {
            templateList.innerHTML = '<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Memuat template...</div>';
            
            fetch('/api/template-surat')
                .then(response => response.json())
                .then(data => {
                    if (data.data && data.data.length > 0) {
                        templateList.innerHTML = data.data.map(template => `
                            <div class="border rounded p-3 mb-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">${template.nama_template}</h6>
                                        <small class="text-muted">${template.jenis_surat}</small>
                                    </div>
                                    <button class="btn btn-sm btn-primary" onclick="assignTemplate(${template.id})">
                                        <i class="fas fa-check me-1"></i> Pilih
                                    </button>
                                </div>
                            </div>
                        `).join('');
                    } else {
                        templateList.innerHTML = '<div class="text-center text-muted">Tidak ada template tersedia</div>';
                    }
                });
        }
    }
}

function assignTemplate(templateId) {
    const templateModal = document.getElementById('templateModal');
    const suratId = templateModal.dataset.suratId;
    
    fetch(`/admin/pelayanan-surat/${suratId}/assign-template`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({ template_id: templateId })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            bootstrap.Modal.getInstance(templateModal).hide();
            location.reload();
        } else {
            alert('Gagal menugaskan template: ' + (data.message || 'Unknown error'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Terjadi kesalahan saat menugaskan template');
    });
}

function submitSurat() {
    const form = document.getElementById('addSuratForm');
    if (!form) return;
    
    const formData = new FormData(form);
    
    fetch('/admin/pelayanan-surat', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const addModal = document.getElementById('addSuratModal');
            if (addModal) {
                bootstrap.Modal.getInstance(addModal).hide();
            }
            location.reload();
        } else {
            alert('Gagal menyimpan permohonan surat: ' + (data.message || 'Unknown error'));
        }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Terjadi kesalahan saat menyimpan');
    });
}

function showDetail(id) {
    window.location.href = `/admin/pelayanan-surat/${id}`;
}

function updateStatus(id, status) {
    if (confirm(`Ubah status menjadi ${status}?`)) {
        fetch(`/admin/pelayanan-surat/${id}/status`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ status: status })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal mengubah status: ' + (data.message || 'Unknown error'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat mengubah status');
        });
    }
}

function generateSurat(id) {
    if (confirm('Generate surat PDF dari template?')) {
        fetch(`/admin/pelayanan-surat/${id}/generate`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert('Gagal generate surat: ' + (data.message || 'Unknown error'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat generate surat');
        });
    }
}

function applyFilters() {
    const status = document.getElementById('filterStatus')?.value || '';
    const jenis = document.getElementById('filterJenis')?.value || '';
    const tanggal = document.getElementById('filterTanggal')?.value || '';
    const search = document.getElementById('searchInput')?.value || '';
    
    const params = new URLSearchParams();
    if (status) params.set('status', status);
    if (jenis) params.set('jenis_surat', jenis);
    if (tanggal) params.set('tanggal', tanggal);
    if (search) params.set('search', search);
    
    window.location.href = '{{ route("admin.pelayanan-surat.index") }}?' + params.toString();
}

function resetFilters() {
    // Clear all filter inputs
    const filterStatus = document.getElementById('filterStatus');
    const filterJenis = document.getElementById('filterJenis');
    const filterTanggal = document.getElementById('filterTanggal');
    const searchInput = document.getElementById('searchInput');
    
    if (filterStatus) filterStatus.value = '';
    if (filterJenis) filterJenis.value = '';
    if (filterTanggal) filterTanggal.value = '';
    if (searchInput) searchInput.value = '';
    
    // Reload page without parameters
    window.location.href = '{{ route("admin.pelayanan-surat.index") }}';
}

function exportSurat(format = null) {
    if (!format) {
        // Show export options if not specified
        const exportOptions = ['pdf', 'excel', 'csv'];
        const selectedFormat = prompt('Pilih format export:\n1. PDF\n2. Excel\n3. CSV\n\nMasukkan angka (1-3):');
        
        if (selectedFormat && exportOptions[selectedFormat - 1]) {
            format = exportOptions[selectedFormat - 1];
        } else {
            return;
        }
    }
    
    const params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.location.href = '{{ route("admin.pelayanan-surat.index") }}?' + params.toString();
}

function editSurat(id) {
    window.location.href = `/admin/pelayanan-surat/${id}/edit`;
}

function deleteSurat(id) {
    if (confirm('Apakah Anda yakin ingin menghapus permohonan ini?')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/pelayanan-surat/${id}`;
        form.innerHTML = `
            <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').content}">
            <input type="hidden" name="_method" value="DELETE">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

function sendWhatsApp(id) {
    if (confirm('Kirim notifikasi WhatsApp ke pemohon?')) {
        fetch(`/admin/pelayanan-surat/${id}/send-wa`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json'
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('WhatsApp berhasil dikirim');
            } else {
                alert('Gagal mengirim WhatsApp: ' + (data.message || 'Unknown error'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat mengirim WhatsApp');
        });
    }
}
</script>
@endpush 
