@extends('layouts.app')

@section('title', 'Data Penduduk')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item active">Data Penduduk</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-users me-2 text-primary"></i>
            Data Penduduk
        </h2>
        <p class="text-muted mb-0">Kelola data penduduk desa secara lengkap dan akurat</p>
    </div>
    <div>
        <a href="{{ route('admin.penduduk.create') }}" class="btn btn-gradient-primary">
            <i class="fas fa-user-plus me-2"></i>
            Tambah Penduduk
        </a>
    </div>
</div>

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-triangle me-2"></i>
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
@endif

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-users fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">{{ $stats['total'] ?? 0 }}</h4>
                        <small>Total Penduduk</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-male fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">{{ $stats['laki_laki'] ?? 0 }}</h4>
                        <small>Laki-laki</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-pink text-white">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-female fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">{{ $stats['perempuan'] ?? 0 }}</h4>
                        <small>Perempuan</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-white">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div class="me-3">
                        <i class="fas fa-child fa-2x"></i>
                    </div>
                    <div>
                        <h4 class="mb-0">{{ $stats['anak'] ?? 0 }}</h4>
                        <small>Anak-anak</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form method="GET" action="{{ route('admin.penduduk.index') }}">
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">Pencarian</label>
                    <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Nama, NIK, atau No KK">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Dusun</label>
                    <select class="form-select" name="dusun">
                        <option value="">Semua Dusun</option>
                        @foreach($dusunList as $dusun)
                            <option value="{{ $dusun }}" {{ request('dusun') == $dusun ? 'selected' : '' }}>{{ $dusun }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">RT</label>
                    <select class="form-select" name="rt">
                        <option value="">Semua RT</option>
                        @foreach($rtList as $rt)
                            <option value="{{ $rt }}" {{ request('rt') == $rt ? 'selected' : '' }}>{{ $rt }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">RW</label>
                    <select class="form-select" name="rw">
                        <option value="">Semua RW</option>
                        @foreach($rwList as $rw)
                            <option value="{{ $rw }}" {{ request('rw') == $rw ? 'selected' : '' }}>{{ $rw }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">&nbsp;</label>
                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-search me-2"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card">
    <div class="card-header bg-light">
        <h5 class="card-title mb-0">
            <i class="fas fa-table me-2"></i>
            Daftar Penduduk
        </h5>
    </div>
    <div class="card-body">
        @if(count($penduduk) > 0)
            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead class="table-light">
                        <tr>
                            <th width="5%" class="text-center">No</th>
                            <th width="15%">NIK</th>
                            <th width="20%">Nama Lengkap</th>
                            <th width="10%" class="text-center">L/P</th>
                            <th width="15%">Tempat/Tgl Lahir</th>
                            <th width="8%" class="text-center">Umur</th>
                            <th width="15%">Alamat</th>
                            <th width="12%" class="text-center">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($penduduk as $index => $p)
                        <tr>
                            <td class="text-center">{{ $penduduk->firstItem() + $index }}</td>
                            <td>
                                <span class="text-monospace">{{ $p->nik ?? '-' }}</span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($p->foto)
                                        <img src="{{ asset('storage/' . $p->foto) }}" 
                                             class="rounded-circle me-2" 
                                             width="32" height="32"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center me-2" 
                                             style="width: 32px; height: 32px; display: none;">
                                            <i class="fas fa-user text-muted"></i>
                                        </div>
                                    @else
                                        <div class="bg-light rounded-circle d-flex align-items-center justify-content-center me-2" 
                                             style="width: 32px; height: 32px;">
                                            <i class="fas fa-user text-muted"></i>
                                        </div>
                                    @endif
                                    <div>
                                        <strong>{{ $p->nama ?? '-' }}</strong>
                                        @if($p->no_kk)
                                            <br><small class="text-muted">KK: {{ $p->no_kk }}</small>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td class="text-center">
                                @if($p->jenis_kelamin == 'L')
                                    <span class="badge bg-primary">L</span>
                                @elseif($p->jenis_kelamin == 'P')
                                    <span class="badge bg-pink">P</span>
                                @else
                                    <span class="badge bg-secondary">-</span>
                                @endif
                            </td>
                            <td>
                                @if($p->tempat_lahir || $p->tanggal_lahir)
                                    {{ $p->tempat_lahir ?? '-' }}
                                    @if($p->tanggal_lahir)
                                        <br><small class="text-muted">{{ $p->tanggal_lahir->format('d/m/Y') }}</small>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                            <td class="text-center">
                                @if($p->tanggal_lahir)
                                    {{ $p->tanggal_lahir->age }} th
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                <div>
                                    {{ $p->alamat ?? '-' }}
                                    @if($p->rt || $p->rw || $p->dusun)
                                        <br>
                                        <small class="text-muted">
                                            @if($p->rt)RT {{ $p->rt }}@endif
                                            @if($p->rw) RW {{ $p->rw }}@endif
                                            @if($p->dusun) {{ $p->dusun }}@endif
                                        </small>
                                    @endif
                                </div>
                            </td>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm" role="group">
                                    <button type="button" class="btn btn-outline-info" 
                                            onclick="showDetail({{ $p->id }})"
                                            data-bs-toggle="tooltip" title="Lihat Detail">
                                        <i class="fas fa-eye"></i>
                                    </button>
                                    <a href="{{ route('admin.penduduk.edit', $p->id) }}" 
                                       class="btn btn-outline-warning"
                                       data-bs-toggle="tooltip" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-outline-danger" 
                                            onclick="deletePenduduk({{ $p->id }})"
                                            data-bs-toggle="tooltip" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="d-flex justify-content-between align-items-center mt-3">
                <div>
                    <small class="text-muted">
                        Menampilkan {{ $penduduk->firstItem() }} sampai {{ $penduduk->lastItem() }} 
                        dari {{ $penduduk->total() }} data
                    </small>
                </div>
                <div>
                    {{ $penduduk->appends(request()->query())->links() }}
                </div>
            </div>
        @else
            <div class="text-center py-5">
                <i class="fas fa-users fa-3x text-muted mb-3"></i>
                <h5 class="text-muted">Tidak ada data penduduk</h5>
                <p class="text-muted">Belum ada data penduduk yang tersedia atau sesuai dengan filter yang dipilih.</p>
                <a href="{{ route('admin.penduduk.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Tambah Penduduk Pertama
                </a>
            </div>
        @endif
    </div>
</div>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Detail Penduduk</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="detailContent">
                <div class="text-center">
                    <div class="spinner-border" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.bg-pink {
    background-color: #e91e63 !important;
}

.text-monospace {
    font-family: 'Courier New', Courier, monospace;
    font-size: 0.9em;
}

.table th {
    border-top: none;
    font-weight: 600;
    background: #f8f9fa;
}

.table td {
    vertical-align: middle;
}

.btn-group-sm .btn {
    padding: 0.25rem 0.5rem;
    font-size: 0.875rem;
}

.badge {
    font-size: 0.75rem;
    font-weight: 500;
}
</style>
@endpush

@push('scripts')
<script>
$(document).ready(function() {
    console.log('Penduduk index page loaded');
    
    // Force clean modal backdrops on page load
    if (typeof window.forceCleanModalBackdrops === 'function') {
        window.forceCleanModalBackdrops();
    }
    
    // Initialize tooltips
    $('[data-bs-toggle="tooltip"]').tooltip();
});

function showDetail(id) {
    $('#detailModal').modal('show');
    
    fetch(`/admin/penduduk/${id}`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const penduduk = data.data;
            $('#detailContent').html(`
                <div class="row">
                    <div class="col-md-4 text-center">
                        ${penduduk.foto ? 
                            `<img src="${penduduk.foto}" class="img-fluid rounded mb-3" style="max-height: 200px;">` :
                            `<div class="bg-light rounded d-flex align-items-center justify-content-center mb-3" style="height: 200px;">
                                <i class="fas fa-user fa-3x text-muted"></i>
                            </div>`
                        }
                        <h5>${penduduk.nama}</h5>
                        <p class="text-muted">${penduduk.nik}</p>
                    </div>
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr><td><strong>Jenis Kelamin:</strong></td><td>${penduduk.jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'}</td></tr>
                            <tr><td><strong>Tempat/Tgl Lahir:</strong></td><td>${penduduk.tempat_lahir}, ${penduduk.tanggal_lahir}</td></tr>
                            <tr><td><strong>Alamat:</strong></td><td>${penduduk.alamat}</td></tr>
                            <tr><td><strong>RT/RW:</strong></td><td>${penduduk.rt}/${penduduk.rw}</td></tr>
                            <tr><td><strong>Agama:</strong></td><td>${penduduk.agama}</td></tr>
                            <tr><td><strong>Status Kawin:</strong></td><td>${penduduk.status_kawin}</td></tr>
                            <tr><td><strong>Pekerjaan:</strong></td><td>${penduduk.pekerjaan || '-'}</td></tr>
                            <tr><td><strong>Kewarganegaraan:</strong></td><td>${penduduk.kewarganegaraan}</td></tr>
                        </table>
                    </div>
                </div>
            `);
        } else {
            $('#detailContent').html('<div class="alert alert-danger">Gagal memuat detail penduduk</div>');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        $('#detailContent').html('<div class="alert alert-danger">Terjadi kesalahan saat memuat data</div>');
    });
}

function deletePenduduk(id) {
    if (confirm('Apakah Anda yakin ingin menghapus data penduduk ini?')) {
        fetch(`/admin/penduduk/${id}`, {
            method: 'DELETE',
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Data penduduk berhasil dihapus');
                location.reload();
            } else {
                alert('Gagal menghapus data penduduk');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Terjadi kesalahan saat menghapus data');
        });
    }
}

// Enhanced modal cleanup handlers
$(document).on('hidden.bs.modal', '.modal', function () {
    if (typeof window.forceCleanModalBackdrops === 'function') {
        window.forceCleanModalBackdrops();
    }
});
</script>
@endpush 