@extends('layouts.app')

@section('title', 'Tambah Pengaduan')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-plus me-2 text-primary"></i>Tambah Pengaduan
            </h2>
            <p class="text-muted mb-0">Buat pengaduan baru dari masyarakat</p>
        </div>
        <div>
            <a href="{{ route('admin.pengaduan.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i>Informasi Pengaduan</h5>
                </div>
                <div class="card-body">
                    <form id="createPengaduanForm" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label">Kategori Pengaduan</label>
                            <select class="form-select" name="kategori" required>
                                <option value="">Pilih Kategori</option>
                                <option value="infrastruktur">Infrastruktur</option>
                                <option value="kebersihan">Kebersihan</option>
                                <option value="keamanan">Keamanan</option>
                                <option value="pelayanan">Pelayanan</option>
                                <option value="lainnya">Lainnya</option>
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Pelapor</label>
                            <select class="form-select" name="pelapor_id" required>
                                <option value="">Pilih Pelapor</option>
                                <!-- Options loaded via AJAX -->
                            </select>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Judul Pengaduan</label>
                            <input type="text" class="form-control" name="judul" required>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Deskripsi</label>
                            <textarea class="form-control" name="deskripsi" rows="5" required></textarea>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Lokasi Kejadian</label>
                            <input type="text" class="form-control" name="lokasi">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Foto Pendukung</label>
                            <input type="file" class="form-control" name="foto[]" multiple accept="image/*">
                            <div class="form-text">Upload foto jika ada (opsional)</div>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Pengaduan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <div class="col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h6><i class="fas fa-info-circle me-2"></i>Informasi</h6>
                    <p class="text-muted">Form untuk menambah pengaduan baru dari masyarakat.</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
document.getElementById('createPengaduanForm').addEventListener('submit', function(e) {
    e.preventDefault();
    showToast('Pengaduan berhasil disimpan', 'success');
});
</script>
@endpush 
