@extends('layouts.app')

@section('title', 'Tambah Perangkat Desa')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h3 class="card-title">
                            <i class="fas fa-plus me-2"></i>
                            Tambah Perangkat Desa
                        </h3>
                        <a href="{{ route('admin.perangkat-desa.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-left me-1"></i>
                            Kembali
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    <form action="{{ route('admin.perangkat-desa.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nik" class="form-label">NIK <span class="text-danger">*</span></label>
                                    <select class="form-control @error('nik') is-invalid @enderror" 
                                            id="nik" name="nik" required>
                                        <option value="">Pilih Penduduk</option>
                                        @foreach($penduduk as $p)
                                            <option value="{{ $p->nik }}" {{ old('nik') == $p->nik ? 'selected' : '' }}>
                                                {{ $p->nik }} - {{ $p->nama }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('nik')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nama" class="form-label">Nama <span class="text-danger">*</span></label>
                                    <input type="text" 
                                           class="form-control @error('nama') is-invalid @enderror" 
                                           id="nama" 
                                           name="nama" 
                                           value="{{ old('nama') }}" 
                                           required>
                                    @error('nama')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="jabatan" class="form-label">Jabatan <span class="text-danger">*</span></label>
                                    <select class="form-control @error('jabatan') is-invalid @enderror" 
                                            id="jabatan" name="jabatan" required>
                                        <option value="">Pilih Jabatan</option>
                                        @foreach($jabatan as $j)
                                            <option value="{{ $j }}" {{ old('jabatan') == $j ? 'selected' : '' }}>
                                                {{ $j }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('jabatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="nip" class="form-label">NIP</label>
                                    <input type="text" 
                                           class="form-control @error('nip') is-invalid @enderror" 
                                           id="nip" 
                                           name="nip" 
                                           value="{{ old('nip') }}" 
                                           placeholder="Nomor Induk Pegawai (opsional)">
                                    @error('nip')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="mulai_tugas" class="form-label">Mulai Tugas <span class="text-danger">*</span></label>
                                    <input type="date" 
                                           class="form-control @error('mulai_tugas') is-invalid @enderror" 
                                           id="mulai_tugas" 
                                           name="mulai_tugas" 
                                           value="{{ old('mulai_tugas') }}" 
                                           required>
                                    @error('mulai_tugas')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                                    <select class="form-control @error('status') is-invalid @enderror" 
                                            id="status" name="status" required>
                                        <option value="">Pilih Status</option>
                                        <option value="Aktif" {{ old('status') == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                        <option value="Tidak Aktif" {{ old('status') == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                        <option value="Pensiun" {{ old('status') == 'Pensiun' ? 'selected' : '' }}>Pensiun</option>
                                        <option value="Mutasi" {{ old('status') == 'Mutasi' ? 'selected' : '' }}>Mutasi</option>
                                    </select>
                                    @error('status')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="no_hp" class="form-label">No. HP</label>
                                    <input type="text" 
                                           class="form-control @error('no_hp') is-invalid @enderror" 
                                           id="no_hp" 
                                           name="no_hp" 
                                           value="{{ old('no_hp') }}" 
                                           placeholder="Nomor HP/WhatsApp">
                                    @error('no_hp')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="email" class="form-label">Email</label>
                                    <input type="email" 
                                           class="form-control @error('email') is-invalid @enderror" 
                                           id="email" 
                                           name="email" 
                                           value="{{ old('email') }}" 
                                           placeholder="Email perangkat desa">
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="bidang_tugas" class="form-label">Bidang Tugas</label>
                                    <input type="text" 
                                           class="form-control @error('bidang_tugas') is-invalid @enderror" 
                                           id="bidang_tugas" 
                                           name="bidang_tugas" 
                                           value="{{ old('bidang_tugas') }}" 
                                           placeholder="Bidang tugas dan tanggung jawab">
                                    @error('bidang_tugas')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label for="tugas_tanggung_jawab" class="form-label">Tugas & Tanggung Jawab</label>
                                    <textarea class="form-control @error('tugas_tanggung_jawab') is-invalid @enderror" 
                                              id="tugas_tanggung_jawab" 
                                              name="tugas_tanggung_jawab" 
                                              rows="3" 
                                              placeholder="Uraian detail tugas dan tanggung jawab">{{ old('tugas_tanggung_jawab') }}</textarea>
                                    @error('tugas_tanggung_jawab')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="foto" class="form-label">Foto</label>
                                    <input type="file" 
                                           class="form-control @error('foto') is-invalid @enderror" 
                                           id="foto" 
                                           name="foto" 
                                           accept="image/*">
                                    <small class="form-text text-muted">Format: JPG, PNG (Max: 2MB)</small>
                                    @error('foto')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="level_hierarki" class="form-label">Level Hierarki</label>
                                    <select class="form-control @error('level_hierarki') is-invalid @enderror" 
                                            id="level_hierarki" name="level_hierarki">
                                        <option value="">Pilih Level</option>
                                        <option value="0" {{ old('level_hierarki') == '0' ? 'selected' : '' }}>Level 0 - Kepala Desa</option>
                                        <option value="1" {{ old('level_hierarki') == '1' ? 'selected' : '' }}>Level 1 - Perangkat Inti</option>
                                        <option value="2" {{ old('level_hierarki') == '2' ? 'selected' : '' }}>Level 2 - Kepala Dusun</option>
                                        <option value="3" {{ old('level_hierarki') == '3' ? 'selected' : '' }}>Level 3 - RT/RW</option>
                                    </select>
                                    @error('level_hierarki')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3">
                                    <label for="urutan" class="form-label">Urutan</label>
                                    <input type="number" 
                                           class="form-control @error('urutan') is-invalid @enderror" 
                                           id="urutan" 
                                           name="urutan" 
                                           value="{{ old('urutan', 1) }}" 
                                           min="1">
                                    @error('urutan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('admin.perangkat-desa.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i>
                                        Batal
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i>
                                        Simpan
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection 