@extends('layouts.app')

@section('title', 'Kelola Produk UMKM')

@section('content')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Kelola Produk UMKM</h1>
        <a href="{{ route('admin.produk-umkm.create') }}" class="btn btn-primary btn-icon-split">
            <span class="icon text-white-50"><i class="fas fa-plus"></i></span>
            <span class="text">Tambah Produk</span>
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">Total Produk</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['total'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-box fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['aktif'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-check-circle fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">Stok Menipis</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['stok_menipis'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-exclamation-triangle fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">Pending</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $stats['pending'] ?? 0 }}</div>
                        </div>
                        <div class="col-auto"><i class="fas fa-clock fa-2x text-gray-300"></i></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter & Search -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.produk-umkm.index') }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" name="search" value="{{ request('search') }}" placeholder="Nama produk...">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" name="status">
                                <option value="">Semua Status</option>
                                <option value="aktif" {{ request('status') === 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ request('status') === 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending" {{ request('status') === 'pending' ? 'selected' : '' }}>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" name="kategori">
                                <option value="">Semua Kategori</option>
                                <option value="makanan" {{ request('kategori') === 'makanan' ? 'selected' : '' }}>Makanan</option>
                                <option value="minuman" {{ request('kategori') === 'minuman' ? 'selected' : '' }}>Minuman</option>
                                <option value="kerajinan" {{ request('kategori') === 'kerajinan' ? 'selected' : '' }}>Kerajinan</option>
                                <option value="fashion" {{ request('kategori') === 'fashion' ? 'selected' : '' }}>Fashion</option>
                                <option value="elektronik" {{ request('kategori') === 'elektronik' ? 'selected' : '' }}>Elektronik</option>
                                <option value="lainnya" {{ request('kategori') === 'lainnya' ? 'selected' : '' }}>Lainnya</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="umkm">UMKM</label>
                            <select class="form-control" name="umkm_id">
                                <option value="">Semua UMKM</option>
                                @foreach($umkmList as $umkm)
                                    <option value="{{ $umkm->id }}" {{ request('umkm_id') == $umkm->id ? 'selected' : '' }}>
                                        {{ $umkm->nama_umkm }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary btn-sm mr-1"><i class="fas fa-search"></i></button>
                                <a href="{{ route('admin.produk-umkm.index') }}" class="btn btn-secondary btn-sm"><i class="fas fa-undo"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Data Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar Produk UMKM</h6>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered" width="100%" cellspacing="0">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th width="15%">Gambar</th>
                            <th width="20%">Produk</th>
                            <th width="15%">UMKM</th>
                            <th width="10%">Kategori</th>
                            <th width="12%">Harga</th>
                            <th width="8%">Stok</th>
                            <th width="8%">Status</th>
                            <th width="12%">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($produkUmkm as $index => $produk)
                        <tr>
                            <td>{{ $produkUmkm->firstItem() + $index }}</td>
                            <td>
                                @if($produk->gambar_utama)
                                    <img src="{{ Storage::url($produk->gambar_utama) }}" 
                                         alt="{{ $produk->nama }}" 
                                         class="img-thumbnail" 
                                         style="width: 70px; height: 50px; object-fit: cover;">
                                @else
                                    <div class="bg-light d-flex align-items-center justify-content-center" style="width: 70px; height: 50px;">
                                        <i class="fas fa-image text-muted"></i>
                                    </div>
                                @endif
                            </td>
                            <td>
                                <div class="font-weight-bold">{{ $produk->nama }}</div>
                                <small class="text-muted">SKU: {{ $produk->sku }}</small>
                                @if($produk->is_unggulan)
                                    <br><span class="badge badge-warning badge-sm"><i class="fas fa-star"></i> Unggulan</span>
                                @endif
                            </td>
                            <td>
                                <div class="font-weight-bold">{{ $produk->umkm->nama_umkm }}</div>
                                <small class="text-muted">{{ $produk->umkm->pemilik }}</small>
                            </td>
                            <td><span class="badge badge-info">{{ ucfirst($produk->kategori) }}</span></td>
                            <td>
                                <div class="font-weight-bold">Rp {{ number_format($produk->harga) }}</div>
                                @if($produk->harga_diskon > 0)
                                    <small class="text-success">Diskon: Rp {{ number_format($produk->harga_diskon) }}</small>
                                @endif
                            </td>
                            <td>
                                <div class="font-weight-bold @if($produk->stok <= $produk->minimum_stok) text-danger @elseif($produk->stok <= ($produk->minimum_stok * 2)) text-warning @else text-success @endif">
                                    {{ $produk->stok }}
                                </div>
                                <small class="text-muted">Min: {{ $produk->minimum_stok }}</small>
                            </td>
                            <td>
                                @if($produk->status === 'aktif')
                                    <span class="badge badge-success">Aktif</span>
                                @elseif($produk->status === 'pending')
                                    <span class="badge badge-warning">Pending</span>
                                @else
                                    <span class="badge badge-secondary">Non-aktif</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="{{ route('admin.produk-umkm.show', $produk->id) }}" class="btn btn-info btn-sm" title="Detail">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="{{ route('admin.produk-umkm.edit', $produk->id) }}" class="btn btn-warning btn-sm" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    @if($produk->status === 'pending')
                                        <button type="button" class="btn btn-success btn-sm" onclick="approveProduct({{ $produk->id }})" title="Setujui">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    @endif
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteProduct({{ $produk->id }})" title="Hapus">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="9" class="text-center py-4">
                                <i class="fas fa-search fa-3x text-muted mb-3"></i>
                                <h5 class="text-muted">Tidak ada data produk</h5>
                                <p class="text-muted">Silakan tambah produk baru atau ubah filter pencarian</p>
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($produkUmkm->hasPages())
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Menampilkan {{ $produkUmkm->firstItem() }} - {{ $produkUmkm->lastItem() }} 
                        dari {{ $produkUmkm->total() }} data
                    </div>
                    {{ $produkUmkm->appends(request()->query())->links() }}
                </div>
            @endif
        </div>
    </div>
</div>

<!-- Delete Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Konfirmasi Hapus</h5>
                <button type="button" class="close" data-dismiss="modal"><span>&times;</span></button>
            </div>
            <div class="modal-body">
                <p>Apakah Anda yakin ingin menghapus produk ini?</p>
                <p class="text-danger"><small>Tindakan ini tidak dapat dibatalkan.</small></p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Batal</button>
                <form id="deleteForm" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
function deleteProduct(id) {
    $('#deleteForm').attr('action', `/admin/produk-umkm/${id}`);
    $('#deleteModal').modal('show');
}

function approveProduct(id) {
    if (confirm('Setujui produk ini?')) {
        const form = $('<form>', {
            'method': 'POST',
            'action': `/admin/produk-umkm/${id}/approve`
        });
        form.append($('<input>', {'type': 'hidden', 'name': '_token', 'value': $('meta[name="csrf-token"]').attr('content')}));
        form.append($('<input>', {'type': 'hidden', 'name': '_method', 'value': 'PATCH'}));
        $('body').append(form);
        form.submit();
    }
}

// Auto-hide alerts
setTimeout(function() {
    $('.alert').fadeOut('slow');
}, 5000);
</script>
@endpush 
