@extends('layouts.app')

@section('title', 'Detail Template Surat')

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.template-surat.index') }}">Template Surat</a></li>
    <li class="breadcrumb-item active">{{ $templateSurat->nama_template }}</li>
@endsection

@section('content')
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-file-contract me-2 text-primary"></i>
            {{ $templateSurat->nama_template }}
        </h2>
        <p class="text-muted mb-0">Detail informasi template surat</p>
    </div>
    <div>
        <a href="{{ route('admin.template-surat.index') }}" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
        <a href="{{ route('admin.template-surat.edit', $templateSurat) }}" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i>
            Edit Template
        </a>
    </div>
</div>

<div class="row">
    <!-- Template Info -->
    <div class="col-md-4">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informasi Template
                </h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tbody>
                        <tr>
                            <td class="fw-semibold">Nama Template:</td>
                            <td>{{ $templateSurat->nama_template }}</td>
                        </tr>
                        <tr>
                            <td class="fw-semibold">Jenis Surat:</td>
                            <td><span class="badge bg-info">{{ $templateSurat->jenis_surat }}</span></td>
                        </tr>
                        <tr>
                            <td class="fw-semibold">Kategori:</td>
                            <td><span class="badge bg-secondary">{{ $templateSurat->kategori }}</span></td>
                        </tr>
                        <tr>
                            <td class="fw-semibold">Status:</td>
                            <td>
                                @if($templateSurat->status == 'Aktif')
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-danger">Tidak Aktif</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-semibold">Dibuat:</td>
                            <td>
                                {{ $templateSurat->created_at->format('d/m/Y H:i') }}
                                <br><small class="text-muted">{{ $templateSurat->created_at->diffForHumans() }}</small>
                            </td>
                        </tr>
                        <tr>
                            <td class="fw-semibold">Diupdate:</td>
                            <td>
                                {{ $templateSurat->updated_at->format('d/m/Y H:i') }}
                                <br><small class="text-muted">{{ $templateSurat->updated_at->diffForHumans() }}</small>
                            </td>
                        </tr>
                        @if($templateSurat->file_template)
                        <tr>
                            <td class="fw-semibold">File Template:</td>
                            <td>
                                <a href="{{ asset('storage/' . $templateSurat->file_template) }}" 
                                   target="_blank" class="btn btn-sm btn-outline-primary">
                                    <i class="fas fa-download me-1"></i>
                                    Download
                                </a>
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
                
                @if($templateSurat->deskripsi)
                <div class="mt-3">
                    <h6 class="fw-semibold">Deskripsi:</h6>
                    <p class="text-muted">{{ $templateSurat->deskripsi }}</p>
                </div>
                @endif
            </div>
        </div>
        
        <!-- Actions -->
        <div class="card mt-4">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-cog me-2"></i>
                    Aksi Template
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <button type="button" class="btn btn-outline-info" onclick="previewTemplate()">
                        <i class="fas fa-eye me-2"></i>
                        Preview Template
                    </button>
                    
                    <button type="button" class="btn btn-outline-success" onclick="duplicateTemplate()">
                        <i class="fas fa-copy me-2"></i>
                        Duplikasi Template
                    </button>
                    
                    @if($templateSurat->status == 'Aktif')
                    <button type="button" class="btn btn-outline-warning" onclick="toggleStatus('Tidak Aktif')">
                        <i class="fas fa-pause me-2"></i>
                        Non-aktifkan
                    </button>
                    @else
                    <button type="button" class="btn btn-outline-success" onclick="toggleStatus('Aktif')">
                        <i class="fas fa-play me-2"></i>
                        Aktifkan
                    </button>
                    @endif
                    
                    <button type="button" class="btn btn-outline-danger" onclick="deleteTemplate()">
                        <i class="fas fa-trash me-2"></i>
                        Hapus Template
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Template Content -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-file-alt me-2"></i>
                    Konten Template
                </h5>
            </div>
            <div class="card-body">
                <!-- Header/Kop -->
                @if($templateSurat->kop_surat)
                <div class="mb-4">
                    <h6 class="fw-semibold text-primary">Kop Surat:</h6>
                    <div class="border rounded p-3 bg-light">
                        <pre class="mb-0">{{ $templateSurat->kop_surat }}</pre>
                    </div>
                </div>
                @endif
                
                <!-- Main Content -->
                <div class="mb-4">
                    <h6 class="fw-semibold text-primary">Konten Utama:</h6>
                    <div class="border rounded p-3" style="min-height: 400px;">
                        <pre class="mb-0">{{ $templateSurat->konten_template }}</pre>
                    </div>
                </div>
                
                <!-- Footer -->
                @if($templateSurat->footer_surat)
                <div class="mb-4">
                    <h6 class="fw-semibold text-primary">Footer Surat:</h6>
                    <div class="border rounded p-3 bg-light">
                        <pre class="mb-0">{{ $templateSurat->footer_surat }}</pre>
                    </div>
                </div>
                @endif
            </div>
        </div>
        
        <!-- Usage Statistics -->
        <div class="card mt-4">
            <div class="card-header bg-light">
                <h5 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Statistik Penggunaan
                </h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-md-4">
                        <div class="border rounded p-3">
                            <h4 class="text-primary mb-1">{{ $templateSurat->pelayananSurat->count() }}</h4>
                            <small class="text-muted">Total Penggunaan</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="border rounded p-3">
                            <h4 class="text-success mb-1">{{ $templateSurat->pelayananSurat->where('status', 'Selesai')->count() }}</h4>
                            <small class="text-muted">Surat Selesai</small>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="border rounded p-3">
                            <h4 class="text-warning mb-1">{{ $templateSurat->pelayananSurat->whereIn('status', ['Menunggu', 'Diproses'])->count() }}</h4>
                            <small class="text-muted">Dalam Proses</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-eye me-2"></i>
                    Preview Template
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="preview-content">
                    <div class="text-center">
                        <i class="fas fa-spinner fa-spin fa-2x mb-3"></i>
                        <div>Memuat preview...</div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
function previewTemplate() {
    const modal = new bootstrap.Modal(document.getElementById('previewModal'));
    modal.show();
    
    // Load preview
    fetch(`/admin/template-surat/{{ $templateSurat->id }}/preview`, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Content-Type': 'application/json',
        }
    })
    .then(response => response.text())
    .then(html => {
        document.getElementById('preview-content').innerHTML = html;
    })
    .catch(error => {
        document.getElementById('preview-content').innerHTML = `
            <div class="alert alert-danger">
                <i class="fas fa-exclamation-triangle me-2"></i>
                Gagal memuat preview: ${error.message}
            </div>
        `;
    });
}

function duplicateTemplate() {
    if (confirm('Duplikasi template ini?')) {
        fetch(`/admin/template-surat/{{ $templateSurat->id }}/duplicate`, {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                'Content-Type': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                window.location.href = data.redirect;
            } else {
                alert('Gagal menduplikasi template');
            }
        });
    }
}

function toggleStatus(newStatus) {
    const action = newStatus === 'Aktif' ? 'mengaktifkan' : 'menonaktifkan';
    
    if (confirm(`Apakah Anda yakin ingin ${action} template ini?`)) {
        // Create a form to submit the status change
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/template-surat/{{ $templateSurat->id }}`;
        form.innerHTML = `
            <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').content}">
            <input type="hidden" name="_method" value="PUT">
            <input type="hidden" name="status" value="${newStatus}">
            <input type="hidden" name="nama_template" value="{{ $templateSurat->nama_template }}">
            <input type="hidden" name="jenis_surat" value="{{ $templateSurat->jenis_surat }}">
            <input type="hidden" name="kategori" value="{{ $templateSurat->kategori }}">
            <input type="hidden" name="konten_template" value="{{ addslashes($templateSurat->konten_template) }}">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}

function deleteTemplate() {
    if (confirm('Apakah Anda yakin ingin menghapus template ini? Tindakan ini tidak dapat dibatalkan.')) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = `/admin/template-surat/{{ $templateSurat->id }}`;
        form.innerHTML = `
            <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').content}">
            <input type="hidden" name="_method" value="DELETE">
        `;
        document.body.appendChild(form);
        form.submit();
    }
}
</script>
@endpush
@endsection 