@extends('layouts.app')

@section('title', 'Tambah Booking Tiket')

@section('content')
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">Tambah Booking Tiket</h1>
        <a href="{{ route('admin.tiket-wisata.index') }}" class="btn btn-secondary btn-sm">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    <form action="{{ route('admin.tiket-wisata.store') }}" method="POST">
        @csrf
        
        <div class="row">
            <!-- Main Form -->
            <div class="col-lg-8">
                <!-- Booking Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Pemesan</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_pemesan">Nama Pemesan <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('nama_pemesan') is-invalid @enderror" 
                                           id="nama_pemesan" name="nama_pemesan" value="{{ old('nama_pemesan') }}" required>
                                    @error('nama_pemesan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="email">Email <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control @error('email') is-invalid @enderror" 
                                           id="email" name="email" value="{{ old('email') }}" required>
                                    @error('email')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="telepon">Nomor Telepon <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('telepon') is-invalid @enderror" 
                                           id="telepon" name="telepon" value="{{ old('telepon') }}" required>
                                    @error('telepon')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tanggal_kunjungan">Tanggal Kunjungan <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('tanggal_kunjungan') is-invalid @enderror" 
                                           id="tanggal_kunjungan" name="tanggal_kunjungan" 
                                           value="{{ old('tanggal_kunjungan') }}" 
                                           min="{{ date('Y-m-d') }}" required>
                                    @error('tanggal_kunjungan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Ticket Details -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Detail Tiket</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jumlah_dewasa">Jumlah Tiket Dewasa <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control @error('jumlah_dewasa') is-invalid @enderror" 
                                           id="jumlah_dewasa" name="jumlah_dewasa" 
                                           value="{{ old('jumlah_dewasa', 1) }}" min="0" required>
                                    @error('jumlah_dewasa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jumlah_anak">Jumlah Tiket Anak</label>
                                    <input type="number" class="form-control @error('jumlah_anak') is-invalid @enderror" 
                                           id="jumlah_anak" name="jumlah_anak" 
                                           value="{{ old('jumlah_anak', 0) }}" min="0">
                                    @error('jumlah_anak')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_dewasa">Harga Tiket Dewasa (Rp)</label>
                                    <input type="number" class="form-control @error('harga_dewasa') is-invalid @enderror" 
                                           id="harga_dewasa" name="harga_dewasa" 
                                           value="{{ old('harga_dewasa') }}" readonly>
                                    @error('harga_dewasa')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="harga_anak">Harga Tiket Anak (Rp)</label>
                                    <input type="number" class="form-control @error('harga_anak') is-invalid @enderror" 
                                           id="harga_anak" name="harga_anak" 
                                           value="{{ old('harga_anak') }}" readonly>
                                    @error('harga_anak')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_harga">Total Harga (Rp)</label>
                                    <input type="number" class="form-control @error('total_harga') is-invalid @enderror" 
                                           id="total_harga" name="total_harga" 
                                           value="{{ old('total_harga') }}" readonly>
                                    @error('total_harga')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="total_pengunjung">Total Pengunjung</label>
                                    <input type="number" class="form-control" 
                                           id="total_pengunjung" readonly>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Payment Information -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Informasi Pembayaran</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="status_tiket">Status Pembayaran</label>
                                    <select class="form-control @error('status_tiket') is-invalid @enderror" 
                                            id="status_tiket" name="status_tiket">
                                        <option value="pending_payment" {{ old('status_tiket') == 'pending_payment' ? 'selected' : '' }}>Pending Payment</option>
                                        <option value="paid" {{ old('status_tiket') == 'paid' ? 'selected' : '' }}>Paid</option>
                                        <option value="confirmed" {{ old('status_tiket') == 'confirmed' ? 'selected' : '' }}>Confirmed</option>
                                        <option value="used" {{ old('status_tiket') == 'used' ? 'selected' : '' }}>Used</option>
                                        <option value="expired" {{ old('status_tiket') == 'expired' ? 'selected' : '' }}>Expired</option>
                                        <option value="cancelled" {{ old('status_tiket') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                                        <option value="refunded" {{ old('status_tiket') == 'refunded' ? 'selected' : '' }}>Refunded</option>
                                    </select>
                                    @error('status_tiket')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="metode_pembayaran">Metode Pembayaran</label>
                                    <select class="form-control @error('metode_pembayaran') is-invalid @enderror" 
                                            id="metode_pembayaran" name="metode_pembayaran">
                                        <option value="">Pilih Metode</option>
                                        <option value="cash" {{ old('metode_pembayaran') == 'cash' ? 'selected' : '' }}>Bayar di Tempat</option>
                                        <option value="bank_transfer" {{ old('metode_pembayaran') == 'bank_transfer' ? 'selected' : '' }}>Transfer Bank</option>
                                        <option value="BRIVA" {{ old('metode_pembayaran') == 'BRIVA' ? 'selected' : '' }}>BRI Virtual Account</option>
                                        <option value="BCAVA" {{ old('metode_pembayaran') == 'BCAVA' ? 'selected' : '' }}>BCA Virtual Account</option>
                                        <option value="BNIVA" {{ old('metode_pembayaran') == 'BNIVA' ? 'selected' : '' }}>BNI Virtual Account</option>
                                        <option value="OVO" {{ old('metode_pembayaran') == 'OVO' ? 'selected' : '' }}>OVO</option>
                                        <option value="DANA" {{ old('metode_pembayaran') == 'DANA' ? 'selected' : '' }}>DANA</option>
                                        <option value="SHOPEEPAY" {{ old('metode_pembayaran') == 'SHOPEEPAY' ? 'selected' : '' }}>ShopeePay</option>
                                        <option value="QRIS" {{ old('metode_pembayaran') == 'QRIS' ? 'selected' : '' }}>QRIS</option>
                                        <option value="OTTOPAY_VA" {{ old('metode_pembayaran') == 'OTTOPAY_VA' ? 'selected' : '' }}>Virtual Account (OttoPay)</option>
                                        <option value="OTTOPAY_QRIS" {{ old('metode_pembayaran') == 'OTTOPAY_QRIS' ? 'selected' : '' }}>QRIS (OttoPay)</option>
                                        <option value="OTTOPAY_EWALLET" {{ old('metode_pembayaran') == 'OTTOPAY_EWALLET' ? 'selected' : '' }}>E-Wallet (OttoPay)</option>
                                        <option value="OTTOPAY_CREDIT_CARD" {{ old('metode_pembayaran') == 'OTTOPAY_CREDIT_CARD' ? 'selected' : '' }}>Kartu Kredit</option>
                                    </select>
                                    @error('metode_pembayaran')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="catatan">Catatan</label>
                                    <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                              id="catatan" name="catatan" rows="3">{{ old('catatan') }}</textarea>
                                    @error('catatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4">
                <!-- Tourism Object Selection -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Objek Wisata</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="objek_wisata_id">Pilih Objek Wisata <span class="text-danger">*</span></label>
                            <select class="form-control @error('objek_wisata_id') is-invalid @enderror" 
                                    id="objek_wisata_id" name="objek_wisata_id" required>
                                <option value="">Pilih Objek Wisata</option>
                                @foreach($objekWisataList as $objek)
                                    <option value="{{ $objek->id }}" 
                                            data-harga-dewasa="{{ $objek->harga_tiket_dewasa }}"
                                            data-harga-anak="{{ $objek->harga_tiket_anak }}"
                                            {{ old('objek_wisata_id') == $objek->id ? 'selected' : '' }}>
                                        {{ $objek->nama }} - {{ $objek->desa }}
                                    </option>
                                @endforeach
                            </select>
                            @error('objek_wisata_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Tourism Object Info -->
                        <div id="objek-info" style="display: none;">
                            <div class="mt-3 p-3 border rounded">
                                <h6 id="objek-nama"></h6>
                                <p id="objek-alamat" class="text-muted small"></p>
                                <div class="row">
                                    <div class="col-6">
                                        <small class="text-muted">Tiket Dewasa</small>
                                        <div id="objek-harga-dewasa" class="font-weight-bold"></div>
                                    </div>
                                    <div class="col-6">
                                        <small class="text-muted">Tiket Anak</small>
                                        <div id="objek-harga-anak" class="font-weight-bold"></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Booking Status -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Status Booking</h6>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control @error('status') is-invalid @enderror" 
                                    id="status" name="status">
                                <option value="pending_payment" {{ old('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                                <option value="aktif" {{ old('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                            </select>
                            @error('status')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="card shadow">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Simpan Booking
                            </button>
                            <a href="{{ route('admin.tiket-wisata.index') }}" 
                               class="btn btn-secondary">
                                <i class="fas fa-times"></i> Batal
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Update price when tourism object changes
    $('#objek_wisata_id').change(function() {
        var selected = $(this).find(':selected');
        var hargaDewasa = selected.data('harga-dewasa') || 0;
        var hargaAnak = selected.data('harga-anak') || 0;
        
        $('#harga_dewasa').val(hargaDewasa);
        $('#harga_anak').val(hargaAnak);
        
        // Show object info
        if (selected.val()) {
            $('#objek-nama').text(selected.text().split(' - ')[0]);
            $('#objek-alamat').text(selected.text().split(' - ')[1] || '');
            $('#objek-harga-dewasa').text('Rp ' + number_format(hargaDewasa));
            $('#objek-harga-anak').text('Rp ' + number_format(hargaAnak));
            $('#objek-info').show();
        } else {
            $('#objek-info').hide();
        }
        
        calculateTotal();
    });

    // Calculate total when quantity changes
    $('#jumlah_dewasa, #jumlah_anak').on('input', function() {
        calculateTotal();
    });

    function calculateTotal() {
        var jumlahDewasa = parseInt($('#jumlah_dewasa').val()) || 0;
        var jumlahAnak = parseInt($('#jumlah_anak').val()) || 0;
        var hargaDewasa = parseInt($('#harga_dewasa').val()) || 0;
        var hargaAnak = parseInt($('#harga_anak').val()) || 0;
        
        var totalHarga = (jumlahDewasa * hargaDewasa) + (jumlahAnak * hargaAnak);
        var totalPengunjung = jumlahDewasa + jumlahAnak;
        
        $('#total_harga').val(totalHarga);
        $('#total_pengunjung').val(totalPengunjung);
    }

    function number_format(number) {
        return new Intl.NumberFormat('id-ID').format(number);
    }

    // Set minimum date to today
    $('#tanggal_kunjungan').attr('min', new Date().toISOString().split('T')[0]);
});
</script>
@endpush 
