@extends('layouts.app')

@section('title', 'Direktori UMKM')

@section('breadcrumb')
<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
<li class="breadcrumb-item active">Direktori UMKM</li>
@endsection

@section('content')
<div class="container-fluid">
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <i class="fas fa-check-circle me-2"></i>
            {{ session('success') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    @if($errors->any())
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <i class="fas fa-exclamation-circle me-2"></i>
            <ul class="mb-0">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    @endif
    
    <!-- Header Section -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">
                <i class="fas fa-store text-primary me-2"></i>
                Direktori UMKM Desa
            </h1>
            <p class="text-muted mb-0">Kelola data Usaha Mikro Kecil Menengah (UMKM) desa</p>
        </div>
        <a href="{{ route('admin.umkm.create') }}" class="btn btn-primary">
            <i class="fas fa-plus me-2"></i>Create UMKM
        </a>
    </div>

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total UMKM</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $umkm->total() }}</div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-store fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                UMKM Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $umkm->where('status', 'aktif')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Marketplace Aktif</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $umkm->where('aktif_marketplace', true)->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-shopping-cart fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Pending Verifikasi</div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $umkm->where('status', 'pending_verifikasi')->count() }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-clock fa-2x text-gray-300"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter Section -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter & Pencarian</h6>
        </div>
        <div class="card-body">
            <form method="GET" action="{{ route('admin.umkm.index') }}">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="search">Pencarian</label>
                            <input type="text" class="form-control" id="search" name="search" 
                                   value="{{ request('search') }}" placeholder="Nama UMKM, pemilik...">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="kategori">Kategori</label>
                            <select class="form-control" id="kategori" name="kategori">
                                <option value="">Semua Kategori</option>
                                @foreach($kategoris as $key => $label)
                                    <option value="{{ $key }}" {{ request('kategori') == $key ? 'selected' : '' }}>
                                        {{ $label }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status">
                                <option value="">Semua Status</option>
                                <option value="aktif" {{ request('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="nonaktif" {{ request('status') == 'nonaktif' ? 'selected' : '' }}>Non-aktif</option>
                                <option value="pending_verifikasi" {{ request('status') == 'pending_verifikasi' ? 'selected' : '' }}>Pending</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="verified">Verifikasi</label>
                            <select class="form-control" id="verified" name="verified">
                                <option value="">Semua</option>
                                <option value="1" {{ request('verified') == '1' ? 'selected' : '' }}>Terverifikasi</option>
                                <option value="0" {{ request('verified') == '0' ? 'selected' : '' }}>Belum Verifikasi</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div class="d-flex">
                                <button type="submit" class="btn btn-primary me-2">
                                    <i class="fas fa-search"></i> Filter
                                </button>
                                <a href="{{ route('admin.umkm.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-redo"></i> Reset
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- UMKM Table -->
    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Daftar UMKM</h6>
        </div>
        <div class="card-body">
            @if($umkm->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered" id="umkmTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Logo</th>
                                <th>Nama UMKM</th>
                                <th>Kategori</th>
                                <th>Pemilik</th>
                                <th>Kontak</th>
                                <th>Galeri</th>
                                <th>Status</th>
                                <th>Marketplace</th>
                                <th>Rating</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($umkm as $item)
                            <tr>
                                <td class="text-center">
                                    <img src="{{ \App\Helpers\ImageHelper::getImageUrl($item->logo, '/images/default-umkm-logo.png') }}" 
                                         alt="{{ $item->nama_umkm }}" 
                                         class="rounded-circle" 
                                         style="width: 32px; height: 32px; object-fit: cover;"
                                         onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'; this.onerror=null;">
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        <strong>{{ $item->nama_umkm }}</strong>
                                        <small class="text-muted">{{ Str::limit($item->deskripsi, 50) }}</small>
                                        @if($item->is_verified)
                                            <span class="badge bg-success badge-sm mt-1">
                                                <i class="fas fa-check-circle"></i> Terverifikasi
                                            </span>
                                        @endif
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $item->kategori_label }}</span>
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        <strong>{{ $item->pemilik->nama ?? 'N/A' }}</strong>
                                        <small class="text-muted">{{ $item->pemilik->nik ?? 'N/A' }}</small>
                                    </div>
                                </td>
                                <td>
                                    <div class="d-flex flex-column">
                                        @if($item->nomor_telepon)
                                            <small><i class="fas fa-phone"></i> {{ $item->nomor_telepon }}</small>
                                        @endif
                                        @if($item->email)
                                            <small><i class="fas fa-envelope"></i> {{ $item->email }}</small>
                                        @endif
                                        @if($item->whatsapp)
                                            <small><i class="fab fa-whatsapp"></i> {{ $item->whatsapp }}</small>
                                        @endif
                                    </div>
                                </td>
                                <td class="text-center">
                                    @if($item->galeri_foto && count($item->galeri_foto) > 0)
                                        <div class="d-flex justify-content-center align-items-center">
                                            @foreach(array_slice($item->galeri_foto, 0, 3) as $index => $foto)
                                                <img src="{{ \App\Helpers\SharedHostingHelper::getUmkmGalleryUrl($foto) }}" 
                                                     alt="Galeri {{ $index + 1 }}" 
                                                     class="rounded me-1" 
                                                     style="width: 24px; height: 24px; object-fit: cover;"
                                                     data-bs-toggle="tooltip" 
                                                     title="Galeri {{ $index + 1 }}"
                                                     onerror="this.src='{{ asset('images/default-umkm-logo.png') }}'; this.onerror=null;">
                                            @endforeach
                                            @if(count($item->galeri_foto) > 3)
                                                <span class="badge bg-secondary ms-1" 
                                                      data-bs-toggle="tooltip" 
                                                      title="+{{ count($item->galeri_foto) - 3 }} foto lainnya">
                                                    +{{ count($item->galeri_foto) - 3 }}
                                                </span>
                                            @endif
                                        </div>
                                    @else
                                        <span class="text-muted">
                                            <i class="fas fa-image"></i>
                                        </span>
                                    @endif
                                </td>
                                <td>
                                    {!! $item->status_badge !!}
                                </td>
                                <td class="text-center">
                                    <div class="form-check form-switch">
                                        <input class="form-check-input marketplace-toggle" type="checkbox" 
                                               data-id="{{ $item->id }}" {{ $item->aktif_marketplace ? 'checked' : '' }}>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="d-flex flex-column align-items-center">
                                        <div class="rating-stars">
                                            @for($i = 1; $i <= 5; $i++)
                                                <i class="fas fa-star {{ $i <= $item->rating_rata_rata ? 'text-warning' : 'text-muted' }}"></i>
                                            @endfor
                                        </div>
                                        <small class="text-muted">{{ $item->rating_rata_rata }}/5 ({{ $item->jumlah_ulasan }})</small>
                                    </div>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <button type="button" class="btn btn-sm btn-info" 
                                                onclick="viewUmkm({{ $item->id }})" title="Lihat Detail">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                        <button type="button" class="btn btn-sm btn-warning" 
                                                onclick="editUmkm({{ $item->id }})" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        @if($item->status == 'pending_verifikasi')
                                            <button type="button" class="btn btn-sm btn-success" 
                                                    onclick="verifyUmkm({{ $item->id }})" title="Verifikasi">
                                                <i class="fas fa-check"></i>
                                            </button>
                                        @endif
                                        <button type="button" class="btn btn-sm btn-danger" 
                                                onclick="deleteUmkm({{ $item->id }})" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div>
                        Menampilkan {{ $umkm->firstItem() }} sampai {{ $umkm->lastItem() }} 
                        dari {{ $umkm->total() }} data
                    </div>
                    {{ $umkm->links() }}
                </div>
            @else
                <div class="text-center py-4">
                    <i class="fas fa-store fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada data UMKM</h5>
                    <p class="text-muted">Klik tombol "Tambah UMKM" untuk menambahkan data pertama</p>
                </div>
            @endif
        </div>
    </div>
</div>


@endsection

@push('scripts')
<script>
// Enhanced image fallback for shared hosting
function handleImageError(img) {
    const defaultImage = '{{ asset("images/default-umkm-logo.png") }}';
    const currentSrc = img.src;
    
    // If already showing default image, don't change
    if (currentSrc.includes('default-umkm-logo.png')) {
        return;
    }
    
    // Try alternative paths for shared hosting
    const alternativePaths = [
        currentSrc.replace('/storage/umkm/logo/', '/admin/umkm/logo/'),
        currentSrc.replace('/storage/umkm/galeri/', '/admin/umkm/galeri/'),
        currentSrc.replace('/storage/', '/storage/app/public/'),
        currentSrc.replace('/storage/umkm/', '/storage/umkm/'),
        defaultImage
    ];
    
    let pathIndex = 0;
    
    function tryNextPath() {
        if (pathIndex < alternativePaths.length) {
            img.src = alternativePaths[pathIndex];
            pathIndex++;
        } else {
            // All paths failed, use default
            img.src = defaultImage;
            img.onerror = null; // Prevent infinite loop
        }
    }
    
    // Set up error handler for next attempt
    img.onerror = tryNextPath;
    
    // Try first alternative
    tryNextPath();
}

$(document).ready(function() {
    // Initialize DataTable
    $('#umkmTable').DataTable({
        "paging": false,
        "searching": false,
        "ordering": true,
        "info": false,
        "responsive": true,
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
        }
    });
    
    // Enhanced image error handling for all UMKM images
    $('img[src*="storage/umkm"]').each(function() {
        const img = this;
        img.onerror = function() {
            handleImageError(img);
        };
    });


    // Marketplace toggle
    $('.marketplace-toggle').change(function() {
        const umkmId = $(this).data('id');
        const isChecked = $(this).is(':checked');
        
        $.ajax({
            url: `/admin/umkm/${umkmId}/toggle-marketplace`,
            method: 'PUT',
            data: {
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Berhasil!',
                        text: response.message,
                        timer: 2000,
                        showConfirmButton: false
                    });
                }
            },
            error: function() {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Terjadi kesalahan!'
                });
                // Revert checkbox
                $(this).prop('checked', !isChecked);
            }
        });
    });
});

function viewUmkm(id) {
    $('#detailModal').modal('show');
    
    fetch(`/admin/umkm/${id}`, {
        method: 'GET',
        headers: {
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            const umkm = data.data;
            $('#detailContent').html(`
                <div class="row">
                    <div class="col-md-4 text-center">
                        <img src="${umkm.logo}" 
                             class="img-fluid rounded mb-3" 
                             style="max-height: 200px; max-width: 200px; object-fit: cover;"
                             alt="${umkm.nama_umkm}">
                        <h5>${umkm.nama_umkm}</h5>
                        <p class="text-muted">${umkm.kategori_label}</p>
                    </div>
                    <div class="col-md-8">
                        <table class="table table-borderless">
                            <tr><td><strong>Deskripsi:</strong></td><td>${umkm.deskripsi}</td></tr>
                            <tr><td><strong>Alamat:</strong></td><td>${umkm.alamat}</td></tr>
                            <tr><td><strong>Nomor Telepon:</strong></td><td>${umkm.nomor_telepon || '-'}</td></tr>
                            <tr><td><strong>Email:</strong></td><td>${umkm.email || '-'}</td></tr>
                            <tr><td><strong>Website:</strong></td><td>${umkm.website ? '<a href="' + umkm.website + '" target="_blank">' + umkm.website + '</a>' : '-'}</td></tr>
                            <tr><td><strong>Status:</strong></td><td>${umkm.status_badge}</td></tr>
                            <tr><td><strong>Skala Usaha:</strong></td><td>${umkm.skala_usaha}</td></tr>
                            <tr><td><strong>Pemilik:</strong></td><td>${umkm.pemilik ? umkm.pemilik.nama + ' (NIK: ' + umkm.pemilik.nik + ')' : '-'}</td></tr>
                        </table>
                    </div>
                </div>
                ${umkm.galeri_foto && umkm.galeri_foto.length > 0 ? `
                <div class="row mt-4">
                    <div class="col-12">
                        <h6>Galeri Foto:</h6>
                        <div class="row">
                            ${umkm.galeri_foto.map(foto => `
                                <div class="col-md-3 mb-2">
                                    <img src="${foto}" class="img-fluid rounded" style="height: 100px; object-fit: cover; width: 100%;" alt="Galeri">
                                </div>
                            `).join('')}
                        </div>
                    </div>
                </div>
                ` : ''}
            `);
        } else {
            $('#detailContent').html('<div class="alert alert-danger">Gagal memuat detail UMKM</div>');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        $('#detailContent').html('<div class="alert alert-danger">Terjadi kesalahan saat memuat data</div>');
    });
}

function editUmkm(id) {
    window.location.href = `/admin/umkm/${id}/edit`;
}

function verifyUmkm(id) {
    Swal.fire({
        title: 'Verifikasi UMKM',
        html: `
            <div class="mb-3">
                <label for="status" class="form-label">Status</label>
                <select class="form-control" id="verify-status">
                    <option value="aktif">Aktif</option>
                    <option value="nonaktif">Non-aktif</option>
                </select>
            </div>
            <div class="mb-3">
                <label for="catatan" class="form-label">Catatan Verifikasi</label>
                <textarea class="form-control" id="verify-catatan" rows="3"></textarea>
            </div>
        `,
        showCancelButton: true,
        confirmButtonText: 'Verifikasi',
        cancelButtonText: 'Batal',
        preConfirm: () => {
            const status = document.getElementById('verify-status').value;
            const catatan = document.getElementById('verify-catatan').value;
            
            return { status, catatan };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                url: `/admin/umkm/${id}/verify`,
                method: 'PUT',
                data: {
                    _token: '{{ csrf_token() }}',
                    status: result.value.status,
                    catatan_verifikasi: result.value.catatan
                },
                success: function(response) {
                    if (response.success) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Berhasil!',
                            text: response.message
                        }).then(() => {
                            location.reload();
                        });
                    }
                },
                error: function() {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Terjadi kesalahan!'
                    });
                }
            });
        }
    });
}

function deleteUmkm(id) {
    Swal.fire({
        title: 'Apakah Anda yakin?',
        text: "Data UMKM akan dihapus permanen!",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Ya, hapus!',
        cancelButtonText: 'Batal'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = `/admin/umkm/${id}`;
            form.innerHTML = `
                @csrf
                @method('DELETE')
            `;
            document.body.appendChild(form);
            form.submit();
        }
    });
}
</script>

<!-- Detail Modal -->
<div class="modal fade" id="detailModal" tabindex="-1" aria-labelledby="detailModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="detailModalLabel">
                    <i class="fas fa-eye me-2"></i>
                    Detail UMKM
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="detailContent">
                    <div class="text-center">
                        <div class="spinner-border" role="status">
                            <span class="visually-hidden">Loading...</span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
@endpush 
