@extends('layouts.app')

@section('title', 'Edit User')

@section('content')
<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h2 class="mb-2">
                <i class="fas fa-edit me-2 text-primary"></i>Edit User
            </h2>
            <p class="text-muted mb-0">Ubah informasi pengguna sistem</p>
        </div>
        <div>
            <a href="{{ route('admin.users.index') }}" class="btn btn-outline-secondary">
                <i class="fas fa-arrow-left me-2"></i>Kembali
            </a>
        </div>
    </div>

    <form id="editUserForm">
        @csrf
        @method('PUT')
        <div class="row">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0"><i class="fas fa-user me-2"></i>Informasi User</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label required">Nama Lengkap</label>
                            <input type="text" class="form-control" name="name" required
                                   value="{{ old('name', $user->name ?? '') }}"
                                   placeholder="Masukkan nama lengkap">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label required">Email</label>
                            <input type="email" class="form-control" name="email" required
                                   value="{{ old('email', $user->email ?? '') }}"
                                   placeholder="Masukkan alamat email">
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Password Baru</label>
                                    <input type="password" class="form-control" name="password" minlength="8"
                                           placeholder="Kosongkan jika tidak ingin mengubah">
                                    <div class="form-text">Kosongkan jika tidak ingin mengubah password</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Konfirmasi Password</label>
                                    <input type="password" class="form-control" name="password_confirmation" minlength="8"
                                           placeholder="Ulangi password baru">
                                </div>
                            </div>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label required">Role</label>
                            <select class="form-select" name="role_id" required>
                                <option value="">Pilih Role</option>
                                @foreach($roles ?? [] as $role)
                                    <option value="{{ $role->id }}" 
                                            {{ old('role_id', $user->role_id ?? '') == $role->id ? 'selected' : '' }}>
                                        {{ $role->display_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="is_active" id="isActive" 
                                   {{ old('is_active', $user->is_active ?? false) ? 'checked' : '' }}>
                            <label class="form-check-label" for="isActive">
                                User aktif
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-info-circle me-2"></i>Informasi</h6>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label text-muted">User ID</label>
                            <p class="mb-0">{{ $user->id ?? '-' }}</p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label text-muted">Dibuat</label>
                            <p class="mb-0">{{ $user->created_at ? $user->created_at->format('d/m/Y H:i') : '-' }}</p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label text-muted">Terakhir Diubah</label>
                            <p class="mb-0">{{ $user->updated_at ? $user->updated_at->format('d/m/Y H:i') : '-' }}</p>
                        </div>
                        
                        @if($user->last_login_at)
                        <div class="mb-3">
                            <label class="form-label text-muted">Login Terakhir</label>
                            <p class="mb-0">{{ $user->last_login_at->format('d/m/Y H:i') }}</p>
                        </div>
                        @endif
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-header">
                        <h6 class="mb-0"><i class="fas fa-exclamation-triangle me-2"></i>Panduan</h6>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-warning">
                            <ul class="mb-0 small">
                                <li>Kosongkan password jika tidak ingin mengubah</li>
                                <li>Email harus tetap unik dalam sistem</li>
                                <li>Perubahan role akan mempengaruhi akses user</li>
                                <li>User yang dinonaktifkan tidak dapat login</li>
                            </ul>
                        </div>
                    </div>
                </div>
                
                <div class="card mt-4">
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-success">
                                <i class="fas fa-save me-2"></i>Simpan Perubahan
                            </button>
                            
                            @if($user->id !== auth()->id())
                            <button type="button" class="btn btn-outline-warning" onclick="resetPassword()">
                                <i class="fas fa-key me-2"></i>Reset Password
                            </button>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Reset Password Modal -->
<div class="modal fade" id="resetPasswordModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reset Password</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="resetPasswordForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Password Baru</label>
                        <input type="password" class="form-control" name="password" required minlength="8">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Konfirmasi Password</label>
                        <input type="password" class="form-control" name="password_confirmation" required minlength="8">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Reset Password</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.required::after {
    content: ' *';
    color: #dc3545;
}
</style>
@endpush

@push('scripts')
<script>
document.getElementById('editUserForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    
    // Check password confirmation if password is provided
    const password = formData.get('password');
    const confirmation = formData.get('password_confirmation');
    
    if (password && password !== confirmation) {
        showToast('Password dan konfirmasi password tidak cocok', 'error');
        return;
    }
    
    showLoading();
    
    fetch('{{ route("admin.users.update", $user->id ?? 0) }}', {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        hideLoading();
        
        if (data.success) {
            showToast('User berhasil diperbarui', 'success');
            setTimeout(() => {
                window.location.href = '{{ route("admin.users.index") }}';
            }, 1500);
        } else {
            showToast(data.message || 'Gagal memperbarui user', 'error');
        }
    })
    .catch(error => {
        hideLoading();
        console.error('Error:', error);
        showToast('Terjadi kesalahan sistem', 'error');
    });
});

function resetPassword() {
    const modal = new bootstrap.Modal(document.getElementById('resetPasswordModal'));
    modal.show();
}

document.getElementById('resetPasswordForm').addEventListener('submit', function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    const password = formData.get('password');
    const confirmation = formData.get('password_confirmation');
    
    if (password !== confirmation) {
        showToast('Password dan konfirmasi password tidak cocok', 'error');
        return;
    }
    
    showLoading();
    
    fetch('{{ route("admin.users.reset-password", $user->id ?? 0) }}', {
        method: 'PUT',
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: formData
    })
    .then(response => response.json())
    .then(data => {
        hideLoading();
        
        if (data.success) {
            showToast('Password berhasil direset', 'success');
            const modal = bootstrap.Modal.getInstance(document.getElementById('resetPasswordModal'));
            modal.hide();
            document.getElementById('resetPasswordForm').reset();
        } else {
            showToast(data.message || 'Gagal reset password', 'error');
        }
    })
    .catch(error => {
        hideLoading();
        console.error('Error:', error);
        showToast('Terjadi kesalahan sistem', 'error');
    });
});
</script>
@endpush 
