<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajukan Surat - Sistem Informasi Desa</title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#3B82F6">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            border: 1px solid #f3f4f6;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .form-input {
            padding: 0.75rem;
            border: 2px solid #e5e7eb;
            border-radius: 0.5rem;
            transition: all 0.3s;
            font-size: 1rem;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #3b82f6;
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
        }
        
        .form-input.error {
            border-color: #ef4444;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header -->
        <div class="gradient-bg text-white px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 left-0 w-40 h-40 bg-white rounded-full -translate-x-20 -translate-y-20"></div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-white rounded-full translate-x-16 translate-y-16"></div>
            </div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <button onclick="goBack()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md hover:bg-white/30 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                        </svg>
                    </button>
                    
                    <div class="text-center">
                        <h1 class="text-lg font-bold">Ajukan Surat</h1>
                        <p class="text-white/80 text-sm">Buat surat keterangan online</p>
                    </div>
                    
                    <div class="w-10 h-10"></div> <!-- Spacer -->
                </div>
            </div>
        </div>

        <!-- Form Content -->
        <div class="px-6 py-6">
            <!-- Success Message -->
            <div id="success-message" class="mobile-card bg-green-50 border-green-200 text-green-800 mb-6 hidden">
                <div class="flex items-center space-x-3">
                    <svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/>
                    </svg>
                    <div>
                        <p class="font-semibold">Berhasil!</p>
                        <p class="text-sm">Pengajuan surat berhasil dikirim</p>
                    </div>
                </div>
            </div>

            <!-- Error Message -->
            <div id="error-message" class="mobile-card bg-red-50 border-red-200 text-red-800 mb-6 hidden">
                <div class="flex items-center space-x-3">
                    <svg class="w-6 h-6 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"/>
                    </svg>
                    <div>
                        <p class="font-semibold">Terjadi Kesalahan!</p>
                        <p class="text-sm" id="error-text">Silakan periksa kembali data yang diinput</p>
                    </div>
                </div>
            </div>

            <!-- Instructions Card -->
            <div class="mobile-card mb-6">
                <h3 class="font-semibold text-gray-800 mb-3 flex items-center">
                    <div class="w-6 h-6 bg-blue-100 rounded-lg flex items-center justify-center mr-2">
                        <svg class="w-4 h-4 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/>
                        </svg>
                    </div>
                    Petunjuk
                </h3>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li>• Pastikan NIK valid (16 digit)</li>
                    <li>• Isi semua data dengan benar</li>
                    <li>• Proses 1-3 hari kerja</li>
                    <li>• Surat dapat diambil di kantor desa</li>
                </ul>
            </div>

            <!-- Form -->
            <form id="form-surat" class="space-y-4">
                <!-- NIK -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        NIK <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           id="nik" 
                           name="nik" 
                           class="form-input w-full" 
                           placeholder="Masukkan NIK (16 digit)"
                           maxlength="16"
                           pattern="[0-9]{16}"
                           title="NIK harus 16 digit angka"
                           required>
                    <div id="nik-error" class="text-red-500 text-xs mt-1 hidden">NIK harus 16 digit angka dan terdaftar di sistem</div>
                    <div class="text-blue-600 text-xs mt-1 flex items-start">
                        <div class="w-4 h-4 bg-blue-50 rounded flex items-center justify-center mr-1 mt-0.5 flex-shrink-0">
                            <svg class="w-3 h-3 text-blue-600" fill="currentColor" viewBox="0 0 24 24">
                                <path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-2h2v2zm0-4h-2V7h2v6z"/>
                            </svg>
                        </div>
                        <span>Pastikan NIK sudah terdaftar di data penduduk desa. Contoh: 3201234567890001</span>
                    </div>
                </div>

                <!-- Nama -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Nama Lengkap <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           id="nama" 
                           name="nama" 
                           class="form-input w-full" 
                           placeholder="Masukkan nama lengkap"
                           required>
                    <div id="nama-error" class="text-red-500 text-xs mt-1 hidden">Nama wajib diisi</div>
                </div>

                <!-- Jenis Surat -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Jenis Surat <span class="text-red-500">*</span>
                    </label>
                    <select id="jenis_surat" name="jenis_surat" class="form-input w-full" required>
                        <option value="">Pilih Jenis Surat</option>
                        <option value="Surat Domisili">Surat Keterangan Domisili</option>
                        <option value="Surat Keterangan Tidak Mampu">Surat Keterangan Tidak Mampu</option>
                        <option value="Surat Usaha">Surat Keterangan Usaha</option>
                        <option value="SKCK">Surat Keterangan Catatan Kepolisian (SKCK)</option>
                        <option value="Surat Kematian">Surat Keterangan Kematian</option>
                        <option value="Surat Keterangan Belum Menikah">Surat Keterangan Belum Menikah</option>
                        <option value="Surat Pengantar Nikah">Surat Pengantar Nikah</option>
                        <option value="Surat Keterangan Penghasilan">Surat Keterangan Penghasilan</option>
                        <option value="Lainnya">Lainnya</option>
                    </select>
                    <div id="jenis-error" class="text-red-500 text-xs mt-1 hidden">Jenis surat wajib dipilih</div>
                </div>

                <!-- Keperluan -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Keperluan <span class="text-red-500">*</span>
                    </label>
                    <textarea id="keperluan" 
                              name="keperluan" 
                              class="form-input w-full" 
                              rows="3"
                              placeholder="Jelaskan keperluan surat ini..."
                              required></textarea>
                    <div id="keperluan-error" class="text-red-500 text-xs mt-1 hidden">Keperluan wajib diisi</div>
                </div>

                <!-- Upload Berkas (Optional) -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Berkas Pendukung <span class="text-gray-500">(Opsional)</span>
                    </label>
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 text-center">
                        <input type="file" 
                               id="berkas_pendukung" 
                               name="berkas_pendukung" 
                               class="hidden"
                               accept=".pdf,.jpg,.jpeg,.png">
                        <button type="button" 
                                onclick="document.getElementById('berkas_pendukung').click()"
                                class="text-blue-600 font-medium hover:text-blue-700">
                            <svg class="w-6 h-6 mx-auto mb-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM6.293 6.707a1 1 0 010-1.414l3-3a1 1 0 011.414 0l3 3a1 1 0 01-1.414 1.414L11 5.414V13a1 1 0 11-2 0V5.414L7.707 6.707a1 1 0 01-1.414 0z"/>
                            </svg>
                            Pilih file PDF, JPG, atau PNG
                        </button>
                        <p class="text-xs text-gray-500 mt-1">Maksimal 2MB</p>
                    </div>
                    <div id="file-name" class="text-sm text-gray-600 mt-2 hidden"></div>
                </div>

                <!-- Submit Button -->
                <div class="pt-4">
                    <button type="submit" 
                            id="submit-btn"
                            class="w-full bg-blue-600 text-white py-3 px-4 rounded-lg font-semibold hover:bg-blue-700 transition-colors disabled:bg-gray-400 disabled:cursor-not-allowed">
                        <span id="submit-text">Kirim Permohonan</span>
                        <span id="loading-text" class="hidden">Mengirim...</span>
                    </button>
                </div>
            </form>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-200 px-6 py-4 z-50 shadow-lg">
            <div class="flex justify-around">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"/>
                    </svg>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 002 2H4a2 2 0 01-2-2V5zm3 1h6v4H5V6zm6 6H5v2h6v-2z"/>
                        <path d="M15 7h1a2 2 0 012 2v5.5a1.5 1.5 0 01-3 0V7z"/>
                    </svg>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                    </svg>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"/>
                    </svg>
                    <span class="text-xs">Umkm</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"/>
                    </svg>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <!-- JavaScript -->
    <script>
        function goBack() {
            window.history.back();
        }

        // File upload handler
        document.getElementById('berkas_pendukung').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const fileNameDiv = document.getElementById('file-name');
            
            if (file) {
                fileNameDiv.textContent = `File dipilih: ${file.name}`;
                fileNameDiv.classList.remove('hidden');
            } else {
                fileNameDiv.classList.add('hidden');
            }
        });

        // NIK validation and auto-fill
        document.getElementById('nik').addEventListener('blur', function() {
            const nik = this.value;
            const namaField = document.getElementById('nama');
            
            if (nik.length === 16 && /^\d+$/.test(nik)) {
                // Check NIK in database
                fetch(`/api/check-nik/${nik}`)
                    .then(response => response.json())
                    .then(data => {
                        if (data.exists) {
                            namaField.value = data.nama;
                            namaField.readOnly = true;
                            namaField.classList.add('bg-gray-100');
                            document.getElementById('nik-error').classList.add('hidden');
                            this.classList.remove('error');
                        } else {
                            namaField.value = '';
                            namaField.readOnly = false;
                            namaField.classList.remove('bg-gray-100');
                            document.getElementById('nik-error').textContent = 'NIK tidak ditemukan di database';
                            document.getElementById('nik-error').classList.remove('hidden');
                            this.classList.add('error');
                        }
                    })
                    .catch(error => {
                        console.error('Error checking NIK:', error);
                    });
            } else {
                namaField.value = '';
                namaField.readOnly = false;
                namaField.classList.remove('bg-gray-100');
            }
        });

        // Form validation and submission
        document.getElementById('form-surat').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Clear previous errors
            document.querySelectorAll('.text-red-500').forEach(el => el.classList.add('hidden'));
            document.querySelectorAll('.form-input').forEach(el => el.classList.remove('error'));
            
            let isValid = true;
            
            // Validate NIK
            const nik = document.getElementById('nik').value;
            if (nik.length !== 16 || !/^\d+$/.test(nik)) {
                document.getElementById('nik-error').textContent = 'NIK harus 16 digit angka dan terdaftar di sistem';
                document.getElementById('nik-error').classList.remove('hidden');
                document.getElementById('nik').classList.add('error');
                isValid = false;
            }
            
            // Validate other required fields
            const requiredFields = ['nama', 'jenis_surat', 'keperluan'];
            requiredFields.forEach(field => {
                const element = document.getElementById(field);
                if (!element.value.trim()) {
                    document.getElementById(field.replace('_', '-') + '-error').classList.remove('hidden');
                    element.classList.add('error');
                    isValid = false;
                }
            });
            
            if (isValid) {
                // Show loading
                const submitBtn = document.getElementById('submit-btn');
                const submitText = document.getElementById('submit-text');
                const loadingText = document.getElementById('loading-text');
                
                submitBtn.disabled = true;
                submitText.classList.add('hidden');
                loadingText.classList.remove('hidden');
                
                // Prepare form data
                const formData = new FormData();
                formData.append('nik', document.getElementById('nik').value);
                formData.append('nama', document.getElementById('nama').value);
                formData.append('jenis_surat', document.getElementById('jenis_surat').value);
                formData.append('keperluan', document.getElementById('keperluan').value);
                
                const fileInput = document.getElementById('berkas_pendukung');
                if (fileInput.files[0]) {
                    formData.append('berkas_pendukung', fileInput.files[0]);
                }
                
                // Submit to backend
                fetch('/ajukan-surat', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('success-message').classList.remove('hidden');
                        document.getElementById('form-surat').reset();
                        document.getElementById('file-name').classList.add('hidden');
                        
                        // Scroll to top
                        window.scrollTo(0, 0);
                        
                        // Redirect after 3 seconds
                        setTimeout(() => {
                            window.location.href = '/';
                        }, 3000);
                    } else {
                        throw new Error(data.message || 'Terjadi kesalahan');
                    }
                })
                .catch(error => {
                    document.getElementById('error-text').textContent = error.message;
                    document.getElementById('error-message').classList.remove('hidden');
                    window.scrollTo(0, 0);
                })
                .finally(() => {
                    // Hide loading
                    submitBtn.disabled = false;
                    submitText.classList.remove('hidden');
                    loadingText.classList.add('hidden');
                });
            }
        });

        // Auto-format NIK input
        document.getElementById('nik').addEventListener('input', function(e) {
            this.value = this.value.replace(/\D/g, '').substring(0, 16);
        });

        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }
    </script>
</body>
</html> 
