<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Checkout - Produk UMKM</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<body class="bg-gray-50 min-h-screen">
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="bg-white shadow-sm border-b px-4 py-3">
            <div class="flex items-center">
                <button onclick="history.back()" class="mr-3 text-gray-600">
                    <i class="fas fa-arrow-left text-xl"></i>
                </button>
                <h1 class="text-lg font-semibold text-gray-800">Checkout</h1>
            </div>
        </div>

        <form action="{{ route('checkout.process') }}" method="POST">
            @csrf
            
            <!-- Order Summary -->
            <div class="px-4 py-4">
                <div class="bg-white rounded-xl shadow-lg p-4">
                    <h3 class="font-semibold text-gray-800 mb-4">Ringkasan Pesanan</h3>
                    
                    @foreach($items as $item)
                    <div class="flex items-center space-x-3 mb-4">
                        <img src="{{ $item['produk']->gambar_utama ? asset('storage/' . $item['produk']->gambar_utama) : asset('images/no-image.png') }}" 
                             alt="{{ $item['produk']->nama_produk }}" 
                             class="w-16 h-16 rounded-lg object-cover">
                        <div class="flex-1">
                            <h4 class="font-medium text-gray-800 text-sm">{{ $item['produk']->nama_produk }}</h4>
                            <p class="text-gray-600 text-xs">{{ $item['quantity'] }} x Rp {{ number_format($item['produk']->harga_akhir, 0, ',', '.') }}</p>
                        </div>
                        <div class="text-right">
                            <span class="text-sm font-medium text-gray-800">Rp {{ number_format($item['subtotal'], 0, ',', '.') }}</span>
                        </div>
                    </div>
                    @endforeach
                    
                    <!-- Order totals -->
                    <div class="border-t pt-3 space-y-2">
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Subtotal</span>
                            <span class="text-gray-800">Rp {{ number_format($subtotal, 0, ',', '.') }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Ongkir</span>
                            <span class="text-gray-800">Rp {{ number_format($shippingCost, 0, ',', '.') }}</span>
                        </div>
                        <div class="flex justify-between text-sm">
                            <span class="text-gray-600">Biaya Admin</span>
                            <span class="text-gray-800" id="admin-fee">Rp 0</span>
                        </div>
                        <div class="flex justify-between text-base font-semibold border-t pt-2">
                            <span class="text-gray-800">Total</span>
                            <span class="text-green-600" id="total-amount">Rp {{ number_format($total, 0, ',', '.') }}</span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Customer Information -->
            <div class="px-4 mb-4">
                <div class="bg-white rounded-xl shadow-lg p-4">
                    <h3 class="font-semibold text-gray-800 mb-4">Informasi Pembeli</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Nama Lengkap</label>
                            <input type="text" name="customer_name" required 
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                   placeholder="Masukkan nama lengkap" value="{{ old('customer_name') }}">
                            @error('customer_name')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Email</label>
                            <input type="email" name="customer_email" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                   placeholder="contoh@email.com" value="{{ old('customer_email') }}">
                            @error('customer_email')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">No. WhatsApp</label>
                            <input type="tel" name="customer_phone" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                   placeholder="08xxxxxxxxxx" value="{{ old('customer_phone') }}">
                            @error('customer_phone')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Alamat Lengkap</label>
                            <textarea name="customer_address" rows="3" required
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                      placeholder="Masukkan alamat lengkap untuk pengiriman">{{ old('customer_address') }}</textarea>
                            @error('customer_address')
                                <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                            @enderror
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Catatan (Opsional)</label>
                            <textarea name="notes" rows="2"
                                      class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-blue-500"
                                      placeholder="Catatan khusus untuk pesanan">{{ old('notes') }}</textarea>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Payment Method -->
            <div class="px-4 mb-4">
                <div class="bg-white rounded-xl shadow-lg p-4">
                    <h3 class="font-semibold text-gray-800 mb-4">Metode Pembayaran</h3>
                    
                    @php
                        $groupedMethods = [];
                        foreach($paymentMethods as $method) {
                            $groupedMethods[$method['group']][] = $method;
                        }
                    @endphp
                    
                    @foreach($groupedMethods as $groupName => $groupMethods)
                    <div class="mb-4">
                        <h4 class="text-sm font-medium text-gray-700 mb-3">{{ $groupName }}</h4>
                        <div class="space-y-2">
                            @foreach($groupMethods as $method)
                            <label class="flex items-center p-3 border rounded-lg cursor-pointer hover:bg-gray-50">
                                <input type="radio" name="payment_method" value="{{ $method['code'] }}" 
                                       class="payment-option" 
                                       data-fee="{{ $method['fee'] ?? 0 }}"
                                       data-fee-percentage="{{ $method['fee_percentage'] ?? 0 }}"
                                       {{ old('payment_method') == $method['code'] ? 'checked' : '' }}>
                                <div class="ml-3 flex items-center flex-1">
                                    <div class="w-8 h-8 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                        @if(filter_var($method['icon'], FILTER_VALIDATE_URL))
                                            <img src="{{ $method['icon'] }}" alt="{{ $method['name'] }}" class="w-6 h-6 object-contain">
                                        @else
                                            <i class="fas fa-credit-card text-gray-500 text-sm"></i>
                                        @endif
                                    </div>
                                    <div class="flex-1">
                                        <span class="text-sm font-medium text-gray-800">{{ $method['name'] }}</span>
                                        <p class="text-xs text-gray-500">
                                            @if($method['fee'] > 0)
                                                Biaya admin: Rp {{ number_format($method['fee'], 0, ',', '.') }}
                                            @elseif(isset($method['fee_percentage']) && $method['fee_percentage'] > 0)
                                                Biaya admin: {{ $method['fee_percentage'] }}%
                                            @else
                                                Tanpa biaya admin
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </label>
                            @endforeach
                        </div>
                    </div>
                    @endforeach
                    
                    @error('payment_method')
                        <p class="text-red-500 text-xs mt-1">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Payment Button -->
            <div class="p-4">
                <button type="submit" class="w-full bg-green-600 text-white py-3 rounded-xl font-semibold text-lg hover:bg-green-700 transition-colors">
                    Bayar Sekarang
                </button>
            </div>
        </form>

        <!-- Bottom spacing -->
        <div class="h-8"></div>
    </div>

    <script>
        // Calculate total with admin fee
        const paymentOptions = document.querySelectorAll('.payment-option');
        const adminFeeElement = document.getElementById('admin-fee');
        const totalAmountElement = document.getElementById('total-amount');
        
        const baseTotal = {{ $total }}; // Base total without admin fee
        
        paymentOptions.forEach(option => {
            option.addEventListener('change', function() {
                if (this.checked) {
                    const fixedFee = parseInt(this.dataset.fee) || 0;
                    const feePercentage = parseFloat(this.dataset.feePercentage) || 0;
                    
                    let totalFee = 0;
                    if (fixedFee > 0) {
                        totalFee = fixedFee;
                    } else if (feePercentage > 0) {
                        totalFee = Math.round((baseTotal * feePercentage) / 100);
                    }
                    
                    const newTotal = baseTotal + totalFee;
                    
                    adminFeeElement.textContent = 'Rp ' + totalFee.toLocaleString('id-ID');
                    totalAmountElement.textContent = 'Rp ' + newTotal.toLocaleString('id-ID');
                }
            });
        });

        // Form validation
        document.querySelector('form').addEventListener('submit', function(e) {
            const paymentMethod = document.querySelector('input[name="payment_method"]:checked');
            
            if (!paymentMethod) {
                e.preventDefault();
                alert('Silakan pilih metode pembayaran');
                return false;
            }
        });

        // Show errors if any
        @if ($errors->any())
            let errorMessage = 'Terjadi kesalahan:\n';
            @foreach ($errors->all() as $error)
                errorMessage += '- {{ $error }}\n';
            @endforeach
            alert(errorMessage);
        @endif
    </script>
</body>
</html> 