<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Produk - Aplikasi Desa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'sans-serif'],
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <meta name="csrf-token" content="<?php echo csrf_token(); ?>">
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="gradient-bg text-white px-6 py-4 relative overflow-hidden">
           <!-- Background Pattern -->
           <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            
            <div class="relative z-10">
                <div class="flex items-center space-x-3">
                    <button onclick="window.history.back()" class="w-8 h-8 bg-white/20 rounded-full flex items-center justify-center">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
                        </svg>
                    </button>
                    <h1 class="text-lg font-semibold">Detail Produk</h1>
                </div>
            </div>
        </div>

        <!-- Product Gallery -->
        <div class="px-6 py-4">
        <div class="bg-white rounded-xl overflow-hidden shadow-lg">
            <div class="relative h-64">
                <img src="https://via.placeholder.com/400x300/f1f5f9/64748b?text=Keripik+Singkong" alt="Keripik Singkong" class="w-full h-full object-cover">
                <button class="absolute top-3 right-3 w-10 h-10 bg-white/80 rounded-full flex items-center justify-center">
                    <svg class="w-5 h-5 text-gray-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4.318 6.318a4.5 4.5 0 000 6.364L12 20.364l7.682-7.682a4.5 4.5 0 00-6.364-6.364L12 7.636l-1.318-1.318a4.5 4.5 0 00-6.364 0z"/>
                    </svg>
                </button>
                <div class="absolute bottom-3 left-3 bg-red-500 text-white text-xs px-2 py-1 rounded-full">-17%</div>
            </div>
            <div class="p-4">
                <h2 class="text-xl font-bold text-gray-800 mb-2" id="product-name">Keripik Singkong</h2>
                <p class="text-sm text-gray-600 mb-3" id="umkm-name">Warung Makan Sari</p>
                
                <!-- Rating -->
                <div class="flex items-center mb-3">
                    <div class="flex text-yellow-400">
                        <span>★★★★☆</span>
                    </div>
                    <span class="text-sm text-gray-500 ml-2">4.2 (23 ulasan)</span>
                    <span class="text-xs text-gray-400 ml-2">| 156 terjual</span>
                </div>
                
                <!-- Price -->
                <div class="flex items-center mb-4">
                    <span class="text-2xl font-bold text-green-600" id="product-price">Rp 25.000</span>
                    <span class="text-sm text-gray-400 line-through ml-2">Rp 30.000</span>
                </div>
                
                <!-- Quick Info -->
                <div class="grid grid-cols-2 gap-3 text-sm">
                    <div class="bg-gray-50 p-2 rounded-lg">
                        <span class="text-gray-500">Stok:</span>
                        <span class="font-medium text-gray-800" id="product-stock">50 pack</span>
                    </div>
                    <div class="bg-gray-50 p-2 rounded-lg">
                        <span class="text-gray-500">Kategori:</span>
                        <span class="font-medium text-gray-800">Makanan Ringan</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <!-- Product Info Tabs -->
        <div class="px-6">
        <div class="bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="border-b border-gray-200">
                <div class="flex">
                    <button class="flex-1 px-4 py-3 text-sm font-medium text-blue-600 border-b-2 border-blue-600 bg-blue-50 tab-button" data-tab="description">Deskripsi</button>
                    <button class="flex-1 px-4 py-3 text-sm font-medium text-gray-500 tab-button" data-tab="reviews">Ulasan</button>
                    <button class="flex-1 px-4 py-3 text-sm font-medium text-gray-500 tab-button" data-tab="umkm">Info UMKM</button>
                </div>
            </div>
            <div class="p-4">
                <div id="tab-description" class="tab-content">
                    <p class="text-gray-700 text-sm leading-relaxed">
                        Keripik singkong renyah dengan berbagai rasa: original, balado, dan keju. Dibuat dari singkong pilihan berkualitas tinggi dengan proses higienis. Cocok untuk camilan sehari-hari atau oleh-oleh khas daerah.
                    </p>
                    
                    <div class="mt-4 p-3 bg-amber-50 rounded-lg border border-amber-200">
                        <div class="flex items-start space-x-2">
                            <svg class="w-5 h-5 text-amber-600 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z"/>
                            </svg>
                            <div>
                                <p class="text-sm font-medium text-amber-800">Informasi Penting</p>
                                <p class="text-xs text-amber-700">Produk dapat berubah rasa tergantung ketersediaan bumbu. Hubungi UMKM untuk konfirmasi rasa yang tersedia.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div id="tab-reviews" class="tab-content hidden">
                    <div class="space-y-3">
                        <div class="border-b pb-3">
                            <div class="flex items-center mb-2">
                                <span class="text-sm font-medium text-gray-800">Ahmad S.</span>
                                <div class="flex text-yellow-400 ml-2">
                                    <span class="text-xs">★★★★★</span>
                                </div>
                            </div>
                            <p class="text-sm text-gray-600">Rasa original enak banget, renyah dan tidak terlalu asin. Packagingnya juga rapi.</p>
                        </div>
                        <div class="border-b pb-3">
                            <div class="flex items-center mb-2">
                                <span class="text-sm font-medium text-gray-800">Siti M.</span>
                                <div class="flex text-yellow-400 ml-2">
                                    <span class="text-xs">★★★★☆</span>
                                </div>
                            </div>
                            <p class="text-sm text-gray-600">Varian balado mantap, pedas pas. Cocok buat cemilan sore.</p>
                        </div>
                    </div>
                </div>
                
                <div id="tab-umkm" class="tab-content hidden">
                    <div class="space-y-3">
                        <h4 class="font-medium text-gray-800">Warung Makan Sari</h4>
                        <p class="text-sm text-gray-600">Alamat: Dusun 1, RT 01/RW 01</p>
                        <p class="text-sm text-gray-600">Telepon: 081234567890</p>
                        <p class="text-sm text-gray-600">UMKM yang berfokus pada produksi makanan ringan tradisional dengan kualitas terjaga dan higienis.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

        <!-- Related Products -->
        <div class="px-6 mt-4">
        <div class="bg-white rounded-xl shadow-lg p-4">
            <h3 class="font-semibold text-gray-800 mb-3">Produk Serupa</h3>
            <div class="grid grid-cols-2 gap-3">
                <div class="border border-gray-200 rounded-lg p-3">
                    <img src="https://via.placeholder.com/120x80/f1f5f9/64748b?text=Rempeyek" alt="Rempeyek Kacang" class="w-full h-16 object-cover rounded mb-2">
                    <h4 class="text-sm font-medium text-gray-800 mb-1">Rempeyek Kacang</h4>
                    <p class="text-xs text-gray-500 mb-1">Warung Makan Sari</p>
                    <span class="text-sm font-bold text-green-600">Rp 15.000</span>
                </div>
                <div class="border border-gray-200 rounded-lg p-3">
                    <img src="https://via.placeholder.com/120x80/f1f5f9/64748b?text=Emping" alt="Emping Jagung" class="w-full h-16 object-cover rounded mb-2">
                    <h4 class="text-sm font-medium text-gray-800 mb-1">Emping Jagung</h4>
                    <p class="text-xs text-gray-500 mb-1">Ibu Sari Makanan</p>
                    <span class="text-sm font-bold text-green-600">Rp 35.000</span>
                </div>
            </div>
        </div>
    </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-32"></div>
    </div>

    <!-- Quantity & Purchase -->
    <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-200 px-6 py-4">
        <div class="flex items-center space-x-3 mb-3">
            <!-- Quantity -->
            <div class="flex items-center border border-gray-300 rounded-lg">
                <button id="minus-btn" class="w-8 h-8 flex items-center justify-center text-gray-600">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 12H4"/>
                    </svg>
                </button>
                <span id="quantity" class="px-3 py-1 text-sm font-medium">1</span>
                <button id="plus-btn" class="w-8 h-8 flex items-center justify-center text-gray-600">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                    </svg>
                </button>
            </div>
            
            <!-- Actions -->
            <button onclick="addToCart()" class="flex-1 bg-blue-100 text-blue-700 py-2 px-4 rounded-lg font-medium text-sm flex items-center justify-center space-x-1">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-2.5 2.5M7 13l2.5 2.5"/>
                </svg>
                <span>Keranjang</span>
            </button>
            <button onclick="buyNow()" class="flex-1 bg-green-600 text-white py-2 px-4 rounded-lg font-medium text-sm">
                Beli Sekarang
            </button>
        </div>
        
        <!-- Contact Seller -->
        <div class="flex space-x-2">
            <button onclick="contactSeller()" class="flex-1 bg-green-500 text-white py-2 px-4 rounded-lg font-medium text-sm flex items-center justify-center space-x-1">
                <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20">
                    <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l.74 4.435a1 1 0 01-.54 1.06l-1.548.773a11.037 11.037 0 006.105 6.105l.774-1.548a1 1 0 011.059-.54l4.435.74a1 1 0 01.836.986V17a1 1 0 01-1 1h-2C7.82 18 2 12.18 2 5V3z"/>
                </svg>
                <span>Chat WhatsApp</span>
            </button>
            <button class="w-12 h-8 bg-gray-200 text-gray-600 rounded-lg flex items-center justify-center">
                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.367 2.684 3 3 0 00-5.367-2.684z"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- Spacer for fixed bottom -->
    <div class="h-32"></div>

    <!-- Quick Checkout Modal -->
    <div id="checkoutModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-end justify-center min-h-screen">
            <div class="bg-white rounded-t-xl w-full max-w-md max-h-screen overflow-y-auto">
                <!-- Modal Header -->
                <div class="flex items-center justify-between p-4 border-b">
                    <h3 class="text-lg font-semibold text-gray-800">Checkout Cepat</h3>
                    <button onclick="closeCheckoutModal()" class="text-gray-400 hover:text-gray-600">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                        </svg>
                    </button>
                </div>
                
                <!-- Order Summary -->
                <div class="p-4 border-b">
                    <div class="flex items-center space-x-3">
                        <img src="https://via.placeholder.com/60x60/f1f5f9/64748b?text=Produk" alt="Product" class="w-15 h-15 rounded-lg object-cover">
                        <div class="flex-1">
                            <h4 class="font-medium text-gray-800" id="modal-product-name">Keripik Singkong</h4>
                            <p class="text-sm text-gray-600">Qty: <span id="modal-quantity">1</span></p>
                            <p class="text-sm font-semibold text-green-600" id="modal-total">Rp 25.000</p>
                        </div>
                    </div>
                </div>
                
                <!-- Customer Info -->
                <div class="p-4 border-b">
                    <h4 class="font-medium text-gray-800 mb-3">Informasi Pembeli</h4>
                    <div class="space-y-3">
                        <input type="text" id="customer-name" placeholder="Nama lengkap" class="w-full p-2 border border-gray-300 rounded-lg text-sm">
                        <input type="tel" id="customer-phone" placeholder="No. WhatsApp" class="w-full p-2 border border-gray-300 rounded-lg text-sm">
                        <textarea id="customer-address" placeholder="Alamat lengkap" rows="2" class="w-full p-2 border border-gray-300 rounded-lg text-sm"></textarea>
                    </div>
                </div>
                
                <!-- Payment Methods -->
                <div class="p-4">
                    <h4 class="font-medium text-gray-800 mb-3">Metode Pembayaran</h4>
                    <div id="payment-methods-container">
                        <div class="text-center py-4">
                            <div class="animate-spin rounded-full h-6 w-6 border-b-2 border-blue-600 mx-auto"></div>
                            <p class="text-sm text-gray-500 mt-2">Memuat metode pembayaran...</p>
                        </div>
                    </div>
                </div>
                
                <!-- Action Buttons -->
                <div class="p-4 border-t">
                    <div class="flex space-x-3">
                        <button onclick="closeCheckoutModal()" class="flex-1 py-2 px-4 border border-gray-300 rounded-lg text-gray-700 font-medium">
                            Batal
                        </button>
                        <button onclick="processCheckout()" class="flex-1 py-2 px-4 bg-green-600 text-white rounded-lg font-medium">
                            Pesan Sekarang
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Product data (in real app, this would come from backend)
        const productData = {
            id: 1,
            name: 'Keripik Singkong',
            price: 25000,
            stock: 50,
            umkm_phone: '6281234567890'
        };

        let quantity = 1;
        const maxStock = productData.stock;

        // Tab switching
        document.querySelectorAll('.tab-button').forEach(button => {
            button.addEventListener('click', function() {
                const targetTab = this.dataset.tab;
                
                // Remove active styles from all tabs
                document.querySelectorAll('.tab-button').forEach(tab => {
                    tab.className = 'flex-1 px-4 py-3 text-sm font-medium text-gray-500';
                });
                
                // Hide all tab contents
                document.querySelectorAll('.tab-content').forEach(content => {
                    content.classList.add('hidden');
                });
                
                // Add active styles to clicked tab
                this.className = 'flex-1 px-4 py-3 text-sm font-medium text-blue-600 border-b-2 border-blue-600 bg-blue-50';
                
                // Show target tab content
                document.getElementById('tab-' + targetTab).classList.remove('hidden');
            });
        });

        // Quantity controls
        document.getElementById('minus-btn').addEventListener('click', () => {
            if (quantity > 1) {
                quantity--;
                document.getElementById('quantity').textContent = quantity;
            }
        });
        
        document.getElementById('plus-btn').addEventListener('click', () => {
            if (quantity < maxStock) {
                quantity++;
                document.getElementById('quantity').textContent = quantity;
            }
        });

        // Add to cart function
        async function addToCart() {
            try {
                const response = await fetch('/checkout/add-to-cart', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        produk_id: productData.id,
                        quantity: quantity
                    })
                });

                const result = await response.json();
                
                if (result.success) {
                    alert('Produk berhasil ditambahkan ke keranjang!');
                    // Update cart count if you have cart icon
                } else {
                    alert(result.message || 'Gagal menambahkan ke keranjang');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat menambahkan ke keranjang');
            }
        }

        // Buy now function
        function buyNow() {
            openCheckoutModal();
        }
        
        async function addToCartThenCheckout() {
            try {
                const response = await fetch('/checkout/add-to-cart', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                    },
                    body: JSON.stringify({
                        produk_id: productData.id,
                        quantity: quantity
                    })
                });

                const result = await response.json();
                
                if (result.success) {
                    // Redirect to checkout
                    window.location.href = '/checkout';
                } else {
                    alert(result.message || 'Gagal memproses pesanan');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat memproses pesanan');
            }
        }

        // WhatsApp contact
        function contactSeller() {
            const message = encodeURIComponent(`Halo, saya tertarik dengan produk ${productData.name}. Apakah masih tersedia?`);
            window.open(`https://wa.me/${productData.umkm_phone}?text=${message}`, '_blank');
        }

        // Checkout Modal Functions
        function openCheckoutModal() {
            // Update modal content
            document.getElementById('modal-product-name').textContent = productData.name;
            document.getElementById('modal-quantity').textContent = quantity;
            document.getElementById('modal-total').textContent = `Rp ${(productData.price * quantity).toLocaleString('id-ID')}`;
            
            // Show modal
            document.getElementById('checkoutModal').classList.remove('hidden');
            
            // Load payment methods
            loadPaymentMethods();
        }

        function closeCheckoutModal() {
            document.getElementById('checkoutModal').classList.add('hidden');
        }

        async function loadPaymentMethods() {
            try {
                const response = await fetch('/api/payment-methods/umkm');
                const result = await response.json();
                
                if (result.success) {
                    renderPaymentMethods(result.data);
                } else {
                    showPaymentMethodsError('Gagal memuat metode pembayaran');
                }
            } catch (error) {
                console.error('Error loading payment methods:', error);
                showPaymentMethodsError('Terjadi kesalahan saat memuat metode pembayaran');
            }
        }

        function renderPaymentMethods(methods) {
            const container = document.getElementById('payment-methods-container');
            
            // Group methods by group
            const groupedMethods = {};
            methods.forEach(method => {
                if (!groupedMethods[method.group]) {
                    groupedMethods[method.group] = [];
                }
                groupedMethods[method.group].push(method);
            });
            
            let html = '';
            
            Object.keys(groupedMethods).forEach(groupName => {
                html += `<div class="mb-4">`;
                html += `<h5 class="text-sm font-medium text-gray-700 mb-2">${groupName}</h5>`;
                html += `<div class="space-y-2">`;
                
                groupedMethods[groupName].forEach(method => {
                    const feeText = method.fee > 0 ? 
                        `Biaya: Rp ${method.fee.toLocaleString('id-ID')}` :
                        (method.fee_percentage > 0 ? `Biaya: ${method.fee_percentage}%` : 'Tanpa biaya');
                    
                    html += `
                        <label class="flex items-center p-3 border border-gray-200 rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="payment_method" value="${method.code}" class="mr-3">
                            <div class="flex items-center flex-1">
                                <div class="w-8 h-8 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-credit-card text-gray-500 text-sm"></i>
                                </div>
                                <div class="flex-1">
                                    <span class="text-sm font-medium text-gray-800">${method.name}</span>
                                    <p class="text-xs text-gray-500">${feeText}</p>
                                </div>
                            </div>
                        </label>
                    `;
                });
                
                html += `</div></div>`;
            });
            
            container.innerHTML = html;
        }

        function showPaymentMethodsError(message) {
            const container = document.getElementById('payment-methods-container');
            container.innerHTML = `
                <div class="text-center py-4">
                    <p class="text-sm text-red-500">${message}</p>
                    <button onclick="loadPaymentMethods()" class="text-blue-600 text-sm mt-2">Coba Lagi</button>
                </div>
            `;
        }

        async function processCheckout() {
            // Validate form
            const customerName = document.getElementById('customer-name').value.trim();
            const customerPhone = document.getElementById('customer-phone').value.trim();
            const customerAddress = document.getElementById('customer-address').value.trim();
            const paymentMethod = document.querySelector('input[name="payment_method"]:checked');
            
            if (!customerName || !customerPhone || !customerAddress) {
                alert('Mohon lengkapi informasi pembeli');
                return;
            }
            
            if (!paymentMethod) {
                alert('Mohon pilih metode pembayaran');
                return;
            }
            
            try {
                // First add to cart
                const cartResponse = await fetch('/checkout/add-to-cart', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        produk_id: productData.id,
                        quantity: quantity
                    })
                });
                
                const cartResult = await cartResponse.json();
                
                if (!cartResult.success) {
                    alert(cartResult.message || 'Gagal menambahkan ke keranjang');
                    return;
                }
                
                // Then process checkout
                const checkoutResponse = await fetch('/checkout/process', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        customer_name: customerName,
                        customer_phone: customerPhone,
                        customer_address: customerAddress,
                        payment_method: paymentMethod.value
                    })
                });
                
                const checkoutResult = await checkoutResponse.json();
                
                if (checkoutResult.success) {
                    alert('Pesanan berhasil dibuat!');
                    closeCheckoutModal();
                    // Redirect to payment page or success page
                    if (checkoutResult.redirect_url) {
                        window.location.href = checkoutResult.redirect_url;
                    }
                } else {
                    alert(checkoutResult.message || 'Gagal memproses pesanan');
                }
                
            } catch (error) {
                console.error('Error processing checkout:', error);
                alert('Terjadi kesalahan saat memproses pesanan');
            }
        }
    </script>
</body>
</html> 