<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="csrf-token-placeholder">
    <title>{{nama_destinasi}} - Wisata Desa</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            margin-bottom: 16px;
            border: 1px solid #f0f0f0;
        }
        
        .image-gallery {
            position: relative;
            border-radius: 20px;
            overflow: hidden;
            margin-bottom: 20px;
        }
        
        .gallery-nav {
            position: absolute;
            bottom: 15px;
            left: 50%;
            transform: translateX(-50%);
            display: flex;
            gap: 8px;
        }
        
        .gallery-dot {
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: rgba(255,255,255,0.5);
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .gallery-dot.active {
            background: white;
        }
        
        .rating-stars {
            color: #fbbf24;
        }
        
        .info-item {
            display: flex;
            align-items: center;
            padding: 12px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .info-item:last-child {
            border-bottom: none;
        }
        
        .amenity-tag {
            background: #f0f9ff;
            color: #0369a1;
            padding: 4px 12px;
            border-radius: 12px;
            font-size: 12px;
            font-weight: 500;
            margin: 2px;
        }
        
        .review-card {
            background: #f8fafc;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 12px;
        }
        
        .sticky-bottom {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: white;
            border-top: 1px solid #e5e7eb;
            padding: 16px;
            z-index: 50;
        }
        
        /* FontAwesome fallback with emoji */
        .fab.fa-whatsapp:before, .fa.fa-whatsapp:before { content: "💬" !important; font-family: system-ui !important; }
        .fas.fa-arrow-left:before, .fa.fa-arrow-left:before { content: "⬅️" !important; font-family: system-ui !important; }
        .fas.fa-share-alt:before, .fa.fa-share-alt:before { content: "📤" !important; font-family: system-ui !important; }
        .far.fa-heart:before, .fa.fa-heart:before { content: "🤍" !important; font-family: system-ui !important; }
        .fas.fa-star:before, .fa.fa-star:before { content: "⭐" !important; font-family: system-ui !important; }
        .fas.fa-star-half-alt:before, .fa.fa-star-half:before { content: "⭐" !important; font-family: system-ui !important; }
        .fas.fa-camera:before, .fa.fa-camera:before { content: "📷" !important; font-family: system-ui !important; }
        .fas.fa-map-marker-alt:before, .fa.fa-map-marker:before { content: "📍" !important; font-family: system-ui !important; }
        .fas.fa-directions:before, .fa.fa-directions:before { content: "🧭" !important; font-family: system-ui !important; }
        .fas.fa-clock:before, .fa.fa-clock:before { content: "🕐" !important; font-family: system-ui !important; }
        .fas.fa-phone:before, .fa.fa-phone:before { content: "📞" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .far:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        <!-- Header -->
        <div class="bg-white shadow-sm sticky top-0 z-40">
            <div class="px-6 py-3">
            <div class="flex items-center justify-between">
                <div class="flex items-center space-x-3">
                    <a href="/wisata" class="p-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors">
                        <i class="fas fa-arrow-left text-gray-600"></i>
                    </a>
                    <div>
                        <h1 class="text-lg font-bold text-gray-800">Detail Wisata</h1>
                        <p class="text-sm text-gray-500">Informasi lengkap destinasi</p>
                    </div>
                </div>
                <div class="flex space-x-2">
                    <button class="p-2 rounded-full bg-gray-100 hover:bg-gray-200 transition-colors">
                        <i class="fas fa-share-alt text-gray-600"></i>
                    </button>
                    <button class="p-2 rounded-full bg-red-50 hover:bg-red-100 transition-colors">
                        <i class="far fa-heart text-red-500"></i>
                    </button>
                </div>
            </div>
            </div>
        </div>
        <!-- Image Gallery -->
        <div class="image-gallery">
            <div class="relative">
                <img id="mainImage" src="{{image_url}}" alt="{{nama_destinasi}}" class="w-full h-80 object-cover">
                <div class="absolute top-4 left-4">
                    <span class="bg-green-500 text-white px-3 py-1 rounded-full text-sm font-medium">
                        <i class="fas fa-star mr-1"></i>{{kategori}}
                    </span>
                </div>
                <div class="absolute top-4 right-4">
                    <span class="bg-black/50 text-white px-2 py-1 rounded-lg text-sm">
                        <i class="fas fa-camera mr-1"></i>1/5
                    </span>
                </div>
            </div>
            <div class="gallery-nav">
                <div class="gallery-dot active" onclick="changeImage(0)"></div>
                <div class="gallery-dot" onclick="changeImage(1)"></div>
                <div class="gallery-dot" onclick="changeImage(2)"></div>
                <div class="gallery-dot" onclick="changeImage(3)"></div>
                <div class="gallery-dot" onclick="changeImage(4)"></div>
            </div>
        </div>

        <!-- Destination Info -->
        <div class="px-6">
            <div class="mobile-card">
                <h1 class="text-2xl font-bold text-gray-800 mb-2">{{nama_destinasi}}</h1>
                <p class="text-gray-600 mb-4">{{deskripsi_singkat}}</p>
                
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center">
                        <div class="rating-stars mr-2">
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star"></i>
                            <i class="fas fa-star-half-alt"></i>
                        </div>
                        <span class="text-gray-700 font-medium">{{rating}}</span>
                        <span class="text-gray-500 ml-1">({{total_review}} review)</span>
                    </div>
                    <div class="text-right">
                        <div class="text-lg font-bold text-blue-600">{{harga_tiket}}</div>
                        <div class="text-sm text-gray-500">Per orang</div>
                    </div>
                </div>

                <!-- Location Info -->
                <div class="info-item">
                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center mr-3">
                        <i class="fas fa-map-marker-alt text-blue-600"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-medium text-gray-800">Lokasi</h4>
                        <p class="text-sm text-gray-600">{{alamat_lengkap}}</p>
                        <p class="text-xs text-blue-600 mt-1">{{jarak}} dari pusat desa</p>
                    </div>
                    <button class="p-2 rounded-full bg-blue-50 hover:bg-blue-100 transition-colors">
                        <i class="fas fa-directions text-blue-600"></i>
                    </button>
                </div>

                <!-- Operating Hours -->
                <div class="info-item">
                    <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center mr-3">
                        <i class="fas fa-clock text-green-600"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-medium text-gray-800">Jam Operasional</h4>
                        <p class="text-sm text-gray-600">{{jam_buka}} - {{jam_tutup}}</p>
                        <p class="text-xs text-green-600 mt-1">Buka hari ini</p>
                    </div>
                </div>

                <!-- Contact Info -->
                <div class="info-item">
                    <div class="w-10 h-10 bg-purple-100 rounded-full flex items-center justify-center mr-3">
                        <i class="fas fa-phone text-purple-600"></i>
                    </div>
                    <div class="flex-1">
                        <h4 class="font-medium text-gray-800">Kontak</h4>
                        <p class="text-sm text-gray-600">{{no_telepon}}</p>
                    </div>
                    <button class="p-2 rounded-full bg-green-50 hover:bg-green-100 transition-colors" 
                            onclick="window.open('https://wa.me/{{whatsapp_number}}?text=Halo, saya ingin tanya tentang {{nama_destinasi}}')">
                        <i class="fab fa-whatsapp text-green-600"></i>
                    </button>
                </div>
            </div>

            <!-- Amenities -->
            <div class="mobile-card">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Fasilitas</h3>
                <div class="flex flex-wrap">
                    <span class="amenity-tag"><i class="fas fa-parking mr-1"></i>Parkir</span>
                    <span class="amenity-tag"><i class="fas fa-restroom mr-1"></i>Toilet</span>
                    <span class="amenity-tag"><i class="fas fa-utensils mr-1"></i>Kantin</span>
                    <span class="amenity-tag"><i class="fas fa-mosque mr-1"></i>Mushola</span>
                    <span class="amenity-tag"><i class="fas fa-camera mr-1"></i>Photo Spot</span>
                    <span class="amenity-tag"><i class="fas fa-hiking mr-1"></i>Trekking</span>
                    <span class="amenity-tag"><i class="fas fa-swimming-pool mr-1"></i>Kolam</span>
                    <span class="amenity-tag"><i class="fas fa-wifi mr-1"></i>WiFi</span>
                </div>
            </div>

            <!-- Description -->
            <div class="mobile-card">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Deskripsi</h3>
                <div class="text-gray-600 leading-relaxed">
                    <p class="mb-4">{{deskripsi_lengkap}}</p>
                    
                    <h4 class="font-semibold text-gray-800 mb-2">Yang Bisa Anda Lakukan:</h4>
                    <ul class="list-disc list-inside space-y-1 mb-4">
                        <li>Menikmati pemandangan alam yang indah</li>
                        <li>Berfoto di berbagai spot menarik</li>
                        <li>Trekking ringan di sekitar area</li>
                        <li>Berenang di kolam alami (jika tersedia)</li>
                        <li>Menikmati kuliner lokal di sekitar area</li>
                    </ul>
                    
                    <h4 class="font-semibold text-gray-800 mb-2">Tips Berkunjung:</h4>
                    <ul class="list-disc list-inside space-y-1">
                        <li>Datang pagi hari untuk menghindari keramaian</li>
                        <li>Bawa kamera untuk mengabadikan momen</li>
                        <li>Gunakan alas kaki yang nyaman</li>
                        <li>Jaga kebersihan lingkungan</li>
                    </ul>
                </div>
            </div>

            <!-- Weather Info -->
            <div class="mobile-card">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Info Cuaca</h3>
                <div class="bg-blue-50 rounded-xl p-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center">
                            <i class="fas fa-sun text-yellow-500 text-2xl mr-3"></i>
                            <div>
                                <div class="font-semibold text-gray-800">Cerah</div>
                                <div class="text-sm text-gray-600">Cocok untuk berkunjung</div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-2xl font-bold text-gray-800">28°C</div>
                            <div class="text-sm text-gray-600">Kelembaban 65%</div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Reviews -->
            <div class="mobile-card">
                <div class="flex items-center justify-between mb-4">
                    <h3 class="text-lg font-bold text-gray-800">Review Pengunjung</h3>
                    <button class="text-blue-600 text-sm font-medium">Lihat Semua</button>
                </div>
                
                <!-- Review Summary -->
                <div class="bg-gray-50 rounded-xl p-4 mb-4">
                    <div class="flex items-center justify-between">
                        <div class="text-center">
                            <div class="text-3xl font-bold text-gray-800">{{rating}}</div>
                            <div class="rating-stars text-sm">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star-half-alt"></i>
                            </div>
                            <div class="text-sm text-gray-600">{{total_review}} review</div>
                        </div>
                        <div class="flex-1 ml-6">
                            <div class="flex items-center mb-1">
                                <span class="text-sm w-8">5★</span>
                                <div class="flex-1 bg-gray-200 rounded-full h-2 mx-2">
                                    <div class="bg-yellow-400 h-2 rounded-full" style="width: 70%"></div>
                                </div>
                                <span class="text-sm text-gray-600">70%</span>
                            </div>
                            <div class="flex items-center mb-1">
                                <span class="text-sm w-8">4★</span>
                                <div class="flex-1 bg-gray-200 rounded-full h-2 mx-2">
                                    <div class="bg-yellow-400 h-2 rounded-full" style="width: 20%"></div>
                                </div>
                                <span class="text-sm text-gray-600">20%</span>
                            </div>
                            <div class="flex items-center mb-1">
                                <span class="text-sm w-8">3★</span>
                                <div class="flex-1 bg-gray-200 rounded-full h-2 mx-2">
                                    <div class="bg-yellow-400 h-2 rounded-full" style="width: 8%"></div>
                                </div>
                                <span class="text-sm text-gray-600">8%</span>
                            </div>
                            <div class="flex items-center mb-1">
                                <span class="text-sm w-8">2★</span>
                                <div class="flex-1 bg-gray-200 rounded-full h-2 mx-2">
                                    <div class="bg-yellow-400 h-2 rounded-full" style="width: 2%"></div>
                                </div>
                                <span class="text-sm text-gray-600">2%</span>
                            </div>
                            <div class="flex items-center">
                                <span class="text-sm w-8">1★</span>
                                <div class="flex-1 bg-gray-200 rounded-full h-2 mx-2">
                                    <div class="bg-yellow-400 h-2 rounded-full" style="width: 0%"></div>
                                </div>
                                <span class="text-sm text-gray-600">0%</span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Individual Reviews -->
                <div class="review-card">
                    <div class="flex items-start mb-2">
                        <img src="https://ui-avatars.com/api/?name=Budi+Santoso&size=40&background=667eea&color=fff" 
                             alt="User" class="w-10 h-10 rounded-full mr-3">
                        <div class="flex-1">
                            <div class="flex items-center justify-between mb-1">
                                <h4 class="font-medium text-gray-800 text-sm">Budi Santoso</h4>
                                <span class="text-xs text-gray-500">2 hari lalu</span>
                            </div>
                            <div class="rating-stars text-xs mb-2">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                            <p class="text-sm text-gray-600">Tempat yang sangat indah! Pemandangannya luar biasa dan fasilitasnya lengkap. Sangat recommended untuk liburan keluarga.</p>
                        </div>
                    </div>
                </div>

                <div class="review-card">
                    <div class="flex items-start mb-2">
                        <img src="https://ui-avatars.com/api/?name=Sari+Dewi&size=40&background=f093fb&color=fff" 
                             alt="User" class="w-10 h-10 rounded-full mr-3">
                        <div class="flex-1">
                            <div class="flex items-center justify-between mb-1">
                                <h4 class="font-medium text-gray-800 text-sm">Sari Dewi</h4>
                                <span class="text-xs text-gray-500">1 minggu lalu</span>
                            </div>
                            <div class="rating-stars text-xs mb-2">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                            <p class="text-sm text-gray-600">Spot foto yang keren banget! Air terjunnya jernih dan sejuk. Cuma akses jalannya agak susah, tapi worth it sih.</p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Similar Destinations -->
            <div class="mobile-card">
                <h3 class="text-lg font-bold text-gray-800 mb-4">Destinasi Serupa</h3>
                <div class="space-y-3">
                    <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                        <img src="https://images.unsplash.com/photo-1500382017468-9049fed747ef?w=60&h=60&fit=crop" 
                             alt="Destinasi" class="w-15 h-15 rounded-xl object-cover">
                        <div class="flex-1">
                            <h4 class="font-medium text-gray-800 text-sm">Hutan Bambu Hijau</h4>
                            <p class="text-xs text-gray-600">8 km dari sini</p>
                            <div class="rating-stars text-xs">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="far fa-star"></i>
                            </div>
                        </div>
                        <button class="text-blue-600 text-sm font-medium">Lihat</button>
                    </div>
                    
                    <div class="flex items-center space-x-3 p-3 bg-gray-50 rounded-xl">
                        <img src="https://images.unsplash.com/photo-1469474968028-56623f02e42e?w=60&h=60&fit=crop" 
                             alt="Destinasi" class="w-15 h-15 rounded-xl object-cover">
                        <div class="flex-1">
                            <h4 class="font-medium text-gray-800 text-sm">Bukit Sunrise</h4>
                            <p class="text-xs text-gray-600">12 km dari sini</p>
                            <div class="rating-stars text-xs">
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                                <i class="fas fa-star"></i>
                            </div>
                        </div>
                        <button class="text-blue-600 text-sm font-medium">Lihat</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sticky Bottom Action -->
        <div class="px-6 py-4 bg-white border-t border-gray-200">
            <div class="flex space-x-3">
                <button onclick="beliTiket()" class="flex-1 bg-orange-600 text-white py-3 rounded-xl font-medium hover:bg-orange-700 transition-colors">
                    <i class="fas fa-ticket-alt mr-2"></i>Beli Tiket
                </button>
                <button class="flex-1 bg-blue-600 text-white py-3 rounded-xl font-medium hover:bg-blue-700 transition-colors">
                    <i class="fas fa-route mr-2"></i>Petunjuk Arah
                </button>
                <button class="flex-1 bg-green-600 text-white py-3 rounded-xl font-medium hover:bg-green-700 transition-colors"
                        onclick="window.open('https://wa.me/{{whatsapp_number}}?text=Halo, saya ingin berkunjung ke {{nama_destinasi}}. Bisa minta infonya?')">
                    <i class="fab fa-whatsapp mr-2"></i>Hubungi Guide
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <!-- Modal Pembelian Tiket -->
    <div id="modalTiket" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-end justify-center min-h-screen">
            <div class="bg-white rounded-t-2xl w-full max-w-md max-h-[90vh] overflow-y-auto">
                <!-- Header Modal -->
                <div class="flex items-center justify-between p-4 border-b">
                    <h3 class="text-lg font-bold text-gray-800">Pesan Tiket Wisata</h3>
                    <button onclick="tutupModal()" class="p-2 rounded-full hover:bg-gray-100">
                        <i class="fas fa-times text-gray-600"></i>
                    </button>
                </div>

                <!-- Form Pembelian -->
                <div class="p-4">
                    <!-- Info Destinasi -->
                    <div class="bg-blue-50 rounded-xl p-4 mb-4">
                        <h4 class="font-semibold text-blue-800 mb-2">{{nama_destinasi}}</h4>
                        <div class="text-sm text-blue-700">
                            <div class="flex justify-between mb-1">
                                <span>Harga Tiket:</span>
                                <span class="font-medium">{{harga_tiket}}</span>
                            </div>
                            <div class="flex justify-between">
                                <span>Status:</span>
                                <span class="text-green-600 font-medium">Tersedia</span>
                            </div>
                        </div>
                    </div>

                    <!-- Form Data -->
                    <form id="formTiket" class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                            <input type="text" id="nama" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Masukkan nama lengkap" required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                            <input type="email" id="email" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="email@example.com" required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">No. WhatsApp</label>
                            <input type="tel" id="no_hp" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="08123456789" required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal Kunjungan</label>
                            <input type="date" id="tanggal_kunjungan" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Jumlah Tiket</label>
                            <div class="flex items-center space-x-3">
                                <button type="button" onclick="kurangiTiket()" class="w-10 h-10 bg-gray-200 rounded-lg flex items-center justify-center hover:bg-gray-300">
                                    <i class="fas fa-minus text-gray-600"></i>
                                </button>
                                <input type="number" id="jumlah_tiket" value="1" min="1" max="10" class="w-20 text-center py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" onchange="hitungTotal()">
                                <button type="button" onclick="tambahTiket()" class="w-10 h-10 bg-gray-200 rounded-lg flex items-center justify-center hover:bg-gray-300">
                                    <i class="fas fa-plus text-gray-600"></i>
                                </button>
                            </div>
                        </div>

                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Catatan (Opsional)</label>
                            <textarea id="catatan" rows="3" class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent" placeholder="Permintaan khusus atau catatan..."></textarea>
                        </div>

                        <!-- Summary -->
                        <div class="bg-gray-50 rounded-xl p-4">
                            <h4 class="font-semibold text-gray-800 mb-3">Ringkasan Pembelian</h4>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span>Harga per tiket:</span>
                                    <span id="harga-per-tiket">Rp 25,000</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Jumlah tiket:</span>
                                    <span id="summary-jumlah">1</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Biaya admin:</span>
                                    <span id="biaya-admin">Rp 2,500</span>
                                </div>
                                <hr class="my-2">
                                <div class="flex justify-between font-semibold text-lg">
                                    <span>Total:</span>
                                    <span id="total-bayar" class="text-blue-600">Rp 27,500</span>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Method -->
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-3">Metode Pembayaran</label>
                            <div id="payment-methods-container" class="space-y-2">
                                <div class="text-center py-4">
                                    <div class="animate-spin rounded-full h-6 w-6 border-b-2 border-orange-600 mx-auto"></div>
                                    <p class="text-sm text-gray-500 mt-2">Memuat metode pembayaran...</p>
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <button type="submit" class="w-full bg-orange-600 text-white py-3 rounded-xl font-medium hover:bg-orange-700 transition-colors">
                            <i class="fas fa-credit-card mr-2"></i>Pesan Tiket Sekarang
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Image gallery functionality
        const images = [
            '{{image_url}}',
            'https://images.unsplash.com/photo-1506905925346-21bda4d32df4?w=400&h=300&fit=crop',
            'https://images.unsplash.com/photo-1500382017468-9049fed747ef?w=400&h=300&fit=crop',
            'https://images.unsplash.com/photo-1469474968028-56623f02e42e?w=400&h=300&fit=crop',
            'https://images.unsplash.com/photo-1548013146-72479768bada?w=400&h=300&fit=crop'
        ];

        function changeImage(index) {
            document.getElementById('mainImage').src = images[index];
            
            // Update active dot
            document.querySelectorAll('.gallery-dot').forEach((dot, i) => {
                if (i === index) {
                    dot.classList.add('active');
                } else {
                    dot.classList.remove('active');
                }
            });
            
            // Update counter
            document.querySelector('.absolute.top-4.right-4 span').innerHTML = 
                `<i class="fas fa-camera mr-1"></i>${index + 1}/5`;
        }

        // Heart/favorite functionality
        document.querySelectorAll('.fa-heart').forEach(heart => {
            heart.addEventListener('click', function() {
                if (this.classList.contains('far')) {
                    this.classList.remove('far');
                    this.classList.add('fas');
                    this.style.color = '#ef4444';
                } else {
                    this.classList.remove('fas');
                    this.classList.add('far');
                    this.style.color = '#ef4444';
                }
            });
        });

        // Share functionality
        document.querySelector('.fa-share-alt').addEventListener('click', function() {
            if (navigator.share) {
                navigator.share({
                    title: '{{nama_destinasi}} - Wisata Desa',
                    text: 'Lihat destinasi wisata menarik ini!',
                    url: window.location.href
                });
            } else {
                // Fallback to copy link
                navigator.clipboard.writeText(window.location.href);
                alert('Link berhasil disalin!');
            }
        });

        // Auto-slide gallery
        let currentImageIndex = 0;
        setInterval(() => {
            currentImageIndex = (currentImageIndex + 1) % images.length;
            changeImage(currentImageIndex);
        }, 5000);

        // Ticket booking functionality
        let hargaPerTiket = 25000;
        let biayaAdmin = 2500;

        function beliTiket() {
            document.getElementById('modalTiket').classList.remove('hidden');
            document.body.style.overflow = 'hidden';
            
            // Set minimum date to today
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('tanggal_kunjungan').setAttribute('min', today);
            
            // Load payment methods
            loadPaymentMethods();
            
            hitungTotal();
        }

        async function loadPaymentMethods() {
            try {
                const response = await fetch('/api/payment-methods/tourism');
                const result = await response.json();
                
                if (result.success) {
                    renderPaymentMethods(result.data);
                } else {
                    showPaymentMethodsError('Gagal memuat metode pembayaran');
                }
            } catch (error) {
                console.error('Error loading payment methods:', error);
                showPaymentMethodsError('Terjadi kesalahan saat memuat metode pembayaran');
            }
        }

        function renderPaymentMethods(methods) {
            const container = document.getElementById('payment-methods-container');
            
            // Group methods by group
            const groupedMethods = {};
            methods.forEach(method => {
                if (!groupedMethods[method.group]) {
                    groupedMethods[method.group] = [];
                }
                groupedMethods[method.group].push(method);
            });
            
            let html = '';
            let isFirst = true;
            
            Object.keys(groupedMethods).forEach(groupName => {
                html += `<div class="mb-4">`;
                html += `<h5 class="text-sm font-medium text-gray-700 mb-2">${groupName}</h5>`;
                html += `<div class="space-y-2">`;
                
                groupedMethods[groupName].forEach(method => {
                    const feeText = method.fee > 0 ? 
                        `Biaya: Rp ${method.fee.toLocaleString('id-ID')}` :
                        (method.fee_percentage > 0 ? `Biaya: ${method.fee_percentage}%` : 'Tanpa biaya');
                    
                    html += `
                        <label class="flex items-center p-3 border border-gray-300 rounded-lg cursor-pointer hover:bg-gray-50">
                            <input type="radio" name="metode_pembayaran" value="${method.code}" class="mr-3" ${isFirst ? 'checked' : ''}>
                            <div class="flex items-center">
                                <div class="w-8 h-8 bg-gray-100 rounded-lg flex items-center justify-center mr-3">
                                    <i class="fas fa-credit-card text-gray-500"></i>
                                </div>
                                <div>
                                    <div class="font-medium">${method.name}</div>
                                    <div class="text-sm text-gray-500">${feeText}</div>
                                </div>
                            </div>
                        </label>
                    `;
                    isFirst = false;
                });
                
                html += `</div></div>`;
            });
            
            container.innerHTML = html;
        }

        function showPaymentMethodsError(message) {
            const container = document.getElementById('payment-methods-container');
            container.innerHTML = `
                <div class="text-center py-4">
                    <p class="text-sm text-red-500">${message}</p>
                    <button onclick="loadPaymentMethods()" class="text-orange-600 text-sm mt-2">Coba Lagi</button>
                </div>
            `;
        }

        function tutupModal() {
            document.getElementById('modalTiket').classList.add('hidden');
            document.body.style.overflow = 'auto';
        }

        function tambahTiket() {
            const input = document.getElementById('jumlah_tiket');
            const currentValue = parseInt(input.value);
            if (currentValue < 10) {
                input.value = currentValue + 1;
                hitungTotal();
            }
        }

        function kurangiTiket() {
            const input = document.getElementById('jumlah_tiket');
            const currentValue = parseInt(input.value);
            if (currentValue > 1) {
                input.value = currentValue - 1;
                hitungTotal();
            }
        }

        function hitungTotal() {
            const jumlah = parseInt(document.getElementById('jumlah_tiket').value) || 1;
            const subtotal = hargaPerTiket * jumlah;
            const total = subtotal + biayaAdmin;

            document.getElementById('summary-jumlah').textContent = jumlah;
            document.getElementById('total-bayar').textContent = 'Rp ' + total.toLocaleString('id-ID');
        }

        // Handle form submission
        document.getElementById('formTiket').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const formData = {
                destinasi_wisata: '{{nama_destinasi}}',
                nama_pengunjung: document.getElementById('nama').value,
                email: document.getElementById('email').value,
                no_hp: document.getElementById('no_hp').value,
                tanggal_kunjungan: document.getElementById('tanggal_kunjungan').value,
                jumlah_tiket: parseInt(document.getElementById('jumlah_tiket').value),
                catatan: document.getElementById('catatan').value,
                metode_pembayaran: document.querySelector('input[name="metode_pembayaran"]:checked').value,
                harga_per_tiket: hargaPerTiket,
                total_harga: (hargaPerTiket * parseInt(document.getElementById('jumlah_tiket').value)) + biayaAdmin
            };

            try {
                // Show loading
                const submitBtn = document.querySelector('#formTiket button[type="submit"]');
                const originalText = submitBtn.innerHTML;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i>Memproses...';
                submitBtn.disabled = true;

                // Submit to backend (replace with actual endpoint)
                const response = await fetch('/api/tiket-wisata', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify(formData)
                });

                if (response.ok) {
                    const result = await response.json();
                    
                    if (result.success) {
                        // Show success message
                        alert('Tiket berhasil dipesan! Kode booking: ' + result.data.kode_booking);
                        
                        // Redirect based on payment method
                        if (formData.metode_pembayaran === 'cash') {
                            alert('Silakan bayar di tempat saat berkunjung. Tunjukkan kode booking kepada petugas.');
                            window.location.href = result.data.redirect_url;
                        } else {
                            // Redirect to payment page
                            window.location.href = result.data.redirect_url;
                        }
                        
                        tutupModal();
                    } else {
                        throw new Error(result.message || 'Gagal memesan tiket');
                    }
                } else {
                    const errorData = await response.json();
                    throw new Error(errorData.message || 'Gagal memesan tiket');
                }
            } catch (error) {
                console.error('Error:', error);
                alert('Terjadi kesalahan saat memesan tiket. Silakan coba lagi.');
            } finally {
                // Restore button
                const submitBtn = document.querySelector('#formTiket button[type="submit"]');
                submitBtn.innerHTML = originalText;
                submitBtn.disabled = false;
            }
        });

        // Close modal when clicking outside
        document.getElementById('modalTiket').addEventListener('click', function(e) {
            if (e.target === this) {
                tutupModal();
            }
        });
    </script>
</body>
</html> 