<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pengaduan - Sistem Informasi Desa</title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#EF4444">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#fef2f2',
                            500: '#ef4444',
                            600: '#dc2626',
                            700: '#b91c1c'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            padding: 1.5rem;
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
            border: 1px solid #f3f4f6;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #ef4444 0%, #dc2626 100%);
        }
        
        .form-input {
            padding: 0.75rem;
            border: 2px solid #e5e7eb;
            border-radius: 0.5rem;
            transition: all 0.3s;
            font-size: 1rem;
        }
        
        .form-input:focus {
            outline: none;
            border-color: #ef4444;
            box-shadow: 0 0 0 3px rgba(239, 68, 68, 0.1);
        }
        
        .form-input.error {
            border-color: #ef4444;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header -->
        <div class="gradient-bg text-white px-6 py-6 relative overflow-hidden">
            <!-- Background Pattern -->
            <div class="absolute inset-0 opacity-10">
                <div class="absolute top-0 left-0 w-40 h-40 bg-white rounded-full -translate-x-20 -translate-y-20"></div>
                <div class="absolute bottom-0 right-0 w-32 h-32 bg-white rounded-full translate-x-16 translate-y-16"></div>
            </div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-4">
                    <button onclick="goBack()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                        <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M12.707 5.293a1 1 0 010 1.414L9.414 10l3.293 3.293a1 1 0 01-1.414 1.414l-4-4a1 1 0 010-1.414l4-4a1 1 0 011.414 0z"/>
                        </svg>
                    </button>
                    
                    <div class="text-center">
                        <h1 class="text-lg font-bold">Pengaduan</h1>
                        <p class="text-white/80 text-sm">Sampaikan keluhan Anda</p>
                    </div>
                    
                    <div class="w-10 h-10"></div> <!-- Spacer -->
                </div>
            </div>
        </div>

        <!-- Form Content -->
        <div class="px-6 py-6">
            <!-- Success Message -->
            <div id="success-message" class="mobile-card bg-green-50 border-green-200 text-green-800 mb-6 hidden">
                <div class="flex items-center space-x-3">
                    <svg class="w-6 h-6 text-green-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"/>
                    </svg>
                    <div>
                        <p class="font-semibold">Berhasil!</p>
                        <p class="text-sm">Pengaduan berhasil dikirim</p>
                    </div>
                </div>
            </div>

            <!-- Error Message -->
            <div id="error-message" class="mobile-card bg-red-50 border-red-200 text-red-800 mb-6 hidden">
                <div class="flex items-center space-x-3">
                    <svg class="w-6 h-6 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"/>
                    </svg>
                    <div>
                        <p class="font-semibold">Terjadi Kesalahan!</p>
                        <p class="text-sm" id="error-text">Silakan periksa kembali data yang diinput</p>
                    </div>
                </div>
            </div>

            <!-- Instructions Card -->
            <div class="mobile-card mb-6">
                <h3 class="font-semibold text-gray-800 mb-3 flex items-center">
                    <svg class="w-5 h-5 text-red-600 mr-2" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"/>
                    </svg>
                    Panduan Pengaduan
                </h3>
                <ul class="text-sm text-gray-600 space-y-1">
                    <li>• Sampaikan keluhan dengan jelas dan sopan</li>
                    <li>• Sertakan bukti jika ada (foto/dokumen)</li>
                    <li>• Pengaduan akan ditindaklanjuti dalam 3x24 jam</li>
                    <li>• Anda akan mendapat nomor tiket pengaduan</li>
                </ul>
            </div>

            <!-- Form -->
            <form id="form-pengaduan" class="space-y-4">
                <!-- Nama -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Nama Lengkap <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           id="nama" 
                           name="nama" 
                           class="form-input w-full" 
                           placeholder="Masukkan nama lengkap"
                           required>
                    <div id="nama-error" class="text-red-500 text-xs mt-1 hidden">Nama wajib diisi</div>
                </div>

                <!-- Email -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Email <span class="text-gray-500">(Opsional)</span>
                    </label>
                    <input type="email" 
                           id="email" 
                           name="email" 
                           class="form-input w-full" 
                           placeholder="contoh@email.com">
                    <div id="email-error" class="text-red-500 text-xs mt-1 hidden">Format email tidak valid</div>
                </div>

                <!-- No HP -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Nomor HP <span class="text-gray-500">(Opsional)</span>
                    </label>
                    <input type="tel" 
                           id="no_hp" 
                           name="no_hp" 
                           class="form-input w-full" 
                           placeholder="08123456789">
                    <div id="hp-error" class="text-red-500 text-xs mt-1 hidden">Format nomor HP tidak valid</div>
                </div>

                <!-- Kategori -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Kategori Pengaduan <span class="text-red-500">*</span>
                    </label>
                    <select id="kategori" name="kategori" class="form-input w-full" required>
                        <option value="">Pilih Kategori</option>
                        <option value="Infrastruktur">Infrastruktur</option>
                        <option value="Pelayanan Publik">Pelayanan Publik</option>
                        <option value="Kebersihan">Kebersihan</option>
                        <option value="Keamanan">Keamanan</option>
                        <option value="Ekonomi">Ekonomi</option>
                        <option value="Pendidikan">Pendidikan</option>
                        <option value="Kesehatan">Kesehatan</option>
                        <option value="Sosial">Sosial</option>
                        <option value="Lainnya">Lainnya</option>
                    </select>
                    <div id="kategori-error" class="text-red-500 text-xs mt-1 hidden">Kategori wajib dipilih</div>
                </div>

                <!-- Judul -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Judul Pengaduan <span class="text-red-500">*</span>
                    </label>
                    <input type="text" 
                           id="judul" 
                           name="judul" 
                           class="form-input w-full" 
                           placeholder="Ringkasan singkat pengaduan"
                           required>
                    <div id="judul-error" class="text-red-500 text-xs mt-1 hidden">Judul wajib diisi</div>
                </div>

                <!-- Isi Pengaduan -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Detail Pengaduan <span class="text-red-500">*</span>
                    </label>
                    <textarea id="isi_pengaduan" 
                              name="isi_pengaduan" 
                              class="form-input w-full" 
                              rows="4"
                              placeholder="Jelaskan pengaduan secara detail..."
                              required></textarea>
                    <div id="isi-error" class="text-red-500 text-xs mt-1 hidden">Detail pengaduan wajib diisi</div>
                </div>

                <!-- Upload Lampiran -->
                <div>
                    <label class="block text-sm font-semibold text-gray-800 mb-2">
                        Lampiran Bukti <span class="text-gray-500">(Opsional)</span>
                    </label>
                    <div class="border-2 border-dashed border-gray-300 rounded-lg p-4 text-center">
                        <input type="file" 
                               id="lampiran" 
                               name="lampiran" 
                               class="hidden"
                               accept=".pdf,.jpg,.jpeg,.png">
                        <button type="button" 
                                onclick="document.getElementById('lampiran').click()"
                                class="text-red-600 font-medium hover:text-red-700">
                            <svg class="w-6 h-6 mx-auto mb-2" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M3 17a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zM6.293 6.707a1 1 0 010-1.414l3-3a1 1 0 011.414 0l3 3a1 1 0 01-1.414 1.414L11 5.414V13a1 1 0 11-2 0V5.414L7.707 6.707a1 1 0 01-1.414 0z"/>
                            </svg>
                            Pilih foto atau dokumen
                        </button>
                        <p class="text-xs text-gray-500 mt-1">PDF, JPG, PNG - Maksimal 5MB</p>
                    </div>
                    <div id="file-name" class="text-sm text-gray-600 mt-2 hidden"></div>
                </div>

                <!-- Submit Button -->
                <div class="pt-4">
                    <button type="submit" 
                            id="submit-btn"
                            class="w-full bg-red-600 text-white py-3 px-4 rounded-lg font-semibold hover:bg-red-700 transition-colors disabled:bg-gray-400 disabled:cursor-not-allowed">
                        <span id="submit-text">Kirim Pengaduan</span>
                        <span id="loading-text" class="hidden">Mengirim...</span>
                    </button>
                </div>
            </form>
        </div>

        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-200 px-6 py-4 z-50 shadow-lg">
            <div class="flex justify-around">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h2a1 1 0 001-1v-2a1 1 0 011-1h2a1 1 0 011 1v2a1 1 0 001 1h2a1 1 0 001-1v-6.586l.293.293a1 1 0 001.414-1.414l-7-7z"/>
                    </svg>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M2 5a2 2 0 012-2h8a2 2 0 012 2v10a2 2 0 002 2H4a2 2 0 01-2-2V5zm3 1h6v4H5V6zm6 6H5v2h6v-2z"/>
                        <path d="M15 7h1a2 2 0 012 2v5.5a1.5 1.5 0 01-3 0V7z"/>
                    </svg>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M4 3a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V5a2 2 0 00-2-2H4zm12 12H4l4-8 3 6 2-4 3 6z"/>
                    </svg>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M3 1a1 1 0 000 2h1.22l.305 1.222a.997.997 0 00.01.042l1.358 5.43-.893.892C3.74 11.846 4.632 14 6.414 14H15a1 1 0 000-2H6.414l1-1H14a1 1 0 00.894-.553l3-6A1 1 0 0017 3H6.28l-.31-1.243A1 1 0 005 1H3zM16 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM6.5 18a1.5 1.5 0 100-3 1.5 1.5 0 000 3z"/>
                    </svg>
                    <span class="text-xs">Umkm</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1 text-gray-400 hover:text-blue-600 transition-colors">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M3 3a1 1 0 011 1v12a1 1 0 11-2 0V4a1 1 0 011-1zm7.707 3.293a1 1 0 010 1.414L9.414 9H17a1 1 0 110 2H9.414l1.293 1.293a1 1 0 01-1.414 1.414l-3-3a1 1 0 010-1.414l3-3a1 1 0 011.414 0z"/>
                    </svg>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>

        <!-- Spacer for bottom navigation -->
        <div class="h-20"></div>
    </div>

    <!-- JavaScript -->
    <script>
        function goBack() {
            window.history.back();
        }

        // File upload handler
        document.getElementById('lampiran').addEventListener('change', function(e) {
            const file = e.target.files[0];
            const fileNameDiv = document.getElementById('file-name');
            
            if (file) {
                fileNameDiv.textContent = `File dipilih: ${file.name}`;
                fileNameDiv.classList.remove('hidden');
            } else {
                fileNameDiv.classList.add('hidden');
            }
        });

        // Form validation and submission
        document.getElementById('form-pengaduan').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Clear previous errors
            document.querySelectorAll('.text-red-500').forEach(el => el.classList.add('hidden'));
            document.querySelectorAll('.form-input').forEach(el => el.classList.remove('error'));
            
            let isValid = true;
            
            // Validate required fields
            const requiredFields = ['nama', 'kategori', 'judul', 'isi_pengaduan'];
            requiredFields.forEach(field => {
                const element = document.getElementById(field);
                if (!element.value.trim()) {
                    document.getElementById(field.replace('_', '-') + '-error').classList.remove('hidden');
                    element.classList.add('error');
                    isValid = false;
                }
            });
            
            // Validate email if filled
            const email = document.getElementById('email').value;
            if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
                document.getElementById('email-error').classList.remove('hidden');
                document.getElementById('email').classList.add('error');
                isValid = false;
            }
            
            // Validate phone if filled
            const hp = document.getElementById('no_hp').value;
            if (hp && !/^[0-9+\-\s]+$/.test(hp)) {
                document.getElementById('hp-error').classList.remove('hidden');
                document.getElementById('no_hp').classList.add('error');
                isValid = false;
            }
            
            if (isValid) {
                // Show loading
                const submitBtn = document.getElementById('submit-btn');
                const submitText = document.getElementById('submit-text');
                const loadingText = document.getElementById('loading-text');
                
                submitBtn.disabled = true;
                submitText.classList.add('hidden');
                loadingText.classList.remove('hidden');
                
                // Prepare form data
                const formData = new FormData();
                formData.append('nama', document.getElementById('nama').value);
                formData.append('email', document.getElementById('email').value);
                formData.append('no_hp', document.getElementById('no_hp').value);
                formData.append('kategori', document.getElementById('kategori').value);
                formData.append('judul', document.getElementById('judul').value);
                formData.append('isi_pengaduan', document.getElementById('isi_pengaduan').value);
                
                const fileInput = document.getElementById('lampiran');
                if (fileInput.files[0]) {
                    formData.append('lampiran', fileInput.files[0]);
                }
                
                // Submit to backend
                fetch('/pengaduan', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '',
                        'Accept': 'application/json',
                        'X-Requested-With': 'XMLHttpRequest'
                    },
                    body: formData
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        document.getElementById('success-message').classList.remove('hidden');
                        document.getElementById('form-pengaduan').reset();
                        document.getElementById('file-name').classList.add('hidden');
                        
                        // Scroll to top
                        window.scrollTo(0, 0);
                        
                        // Redirect after 3 seconds
                        setTimeout(() => {
                            window.location.href = '/';
                        }, 3000);
                    } else {
                        throw new Error(data.message || 'Terjadi kesalahan');
                    }
                })
                .catch(error => {
                    document.getElementById('error-text').textContent = error.message;
                    document.getElementById('error-message').classList.remove('hidden');
                    window.scrollTo(0, 0);
                })
                .finally(() => {
                    // Hide loading
                    submitBtn.disabled = false;
                    submitText.classList.remove('hidden');
                    loadingText.classList.add('hidden');
                });
            }
        });

        // Auto-format phone input
        document.getElementById('no_hp').addEventListener('input', function(e) {
            this.value = this.value.replace(/[^0-9+\-\s]/g, '');
        });
        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }
    </script>
</body>
</html> 
