<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= ucfirst($productType) ?> - PPOB</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <meta name="csrf-token" content="<?= csrf_token() ?>">
    <style>
        .mobile-card {
            background: white;
            border-radius: 16px;
            padding: 16px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border: 1px solid #f1f5f9;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .product-item {
            transition: all 0.3s ease;
            cursor: pointer;
        }
        
        .product-item:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        
        .product-item.selected {
            border-color: #3b82f6;
            background-color: #eff6ff;
        }
        
        .loading {
            display: none;
        }
        
        .loading.active {
            display: block;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(59, 130, 246, 0.4);
        }
        
        .btn-primary:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }
    </style>
</head>
<body class="bg-gray-50">
    <!-- Mobile Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen">
        
        <!-- Header -->
        <div class="gradient-bg text-white p-6">
            <div class="flex items-center mb-4">
                <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center mr-4">
                    <svg class="w-5 h-5 text-white" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M9.707 16.707a1 1 0 01-1.414 0l-6-6a1 1 0 010-1.414l6-6a1 1 0 011.414 1.414L5.414 9H17a1 1 0 110 2H5.414l4.293 4.293a1 1 0 010 1.414z"/>
                    </svg>
                </button>
                <div>
                    <h1 class="text-xl font-bold"><?= $productInfo['name'] ?></h1>
                    <p class="text-white/80 text-sm"><?= $productInfo['description'] ?? 'Pilih produk dan nominal' ?></p>
                </div>
            </div>
        </div>

        <!-- Form Container -->
        <div class="p-6 space-y-6">
            
            <!-- Provider Selection (for products that have providers) -->
            <?php if (isset($productInfo['providers'])): ?>
            <div class="mobile-card">
                <h3 class="font-semibold text-gray-800 mb-3">Pilih Provider</h3>
                <div class="grid grid-cols-2 gap-2">
                    <?php foreach ($productInfo['providers'] as $code => $name): ?>
                    <button type="button" 
                            onclick="selectProvider('<?= $code ?>')" 
                            class="provider-btn p-3 border border-gray-200 rounded-lg text-sm font-medium hover:bg-blue-50 hover:border-blue-300 transition-colors"
                            data-provider="<?= $code ?>">
                        <?= $name ?>
                    </button>
                    <?php endforeach; ?>
                </div>
            </div>
            <?php endif; ?>

            <!-- Phone/Account Number Input -->
            <div class="mobile-card">
                <h3 class="font-semibold text-gray-800 mb-3">
                    <?php if (in_array($productType, ['pulsa', 'paket_data'])): ?>
                        Nomor Handphone
                    <?php elseif ($productType == 'pln'): ?>
                        ID Pelanggan PLN
                    <?php elseif ($productType == 'pbb'): ?>
                        NOP (Nomor Objek Pajak)
                    <?php else: ?>
                        Nomor Pelanggan
                    <?php endif; ?>
                </h3>
                <div class="relative">
                    <input type="text" 
                           id="targetNumber" 
                           class="w-full p-4 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent"
                           placeholder="<?php if (in_array($productType, ['pulsa', 'paket_data'])): ?>Contoh: 08123456789<?php elseif ($productType == 'pln'): ?>Contoh: 123456789012<?php elseif ($productType == 'pbb'): ?>Contoh: 32.74.XXX.XXX.XXX-XXXX.X<?php else: ?>Masukkan nomor pelanggan<?php endif; ?>"
                           maxlength="<?= in_array($productType, ['pulsa', 'paket_data']) ? '15' : '20' ?>">
                    <button type="button" 
                            onclick="showContactPicker()" 
                            class="absolute right-3 top-1/2 transform -translate-y-1/2 text-blue-600 hover:text-blue-800"
                            <?= in_array($productType, ['pulsa', 'paket_data']) ? '' : 'style="display:none"' ?>>
                        <i class="fas fa-address-book"></i>
                    </button>
                </div>
            </div>

            <!-- Product Selection -->
            <div class="mobile-card">
                <h3 class="font-semibold text-gray-800 mb-3">Pilih Nominal</h3>
                
                <!-- Loading State -->
                <div id="loadingProducts" class="loading text-center py-8">
                    <div class="animate-spin rounded-full h-8 w-8 border-b-2 border-blue-600 mx-auto mb-2"></div>
                    <p class="text-gray-500 text-sm">Memuat produk...</p>
                </div>

                <!-- Products List -->
                <div id="productsList" class="space-y-2">
                    <!-- Products will be loaded here -->
                </div>
            </div>

            <!-- Customer Info -->
            <div class="mobile-card">
                <h3 class="font-semibold text-gray-800 mb-3">Informasi Pembeli</h3>
                <div class="space-y-3">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                        <input type="text" 
                               id="customerName" 
                               class="w-full p-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                               placeholder="Masukkan nama lengkap"
                               required>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Email</label>
                        <input type="email" 
                               id="customerEmail" 
                               class="w-full p-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500"
                               placeholder="contoh@email.com"
                               required>
                    </div>
                </div>
            </div>

            <!-- Transaction Summary -->
            <div id="transactionSummary" class="mobile-card bg-blue-50 border-blue-200" style="display:none;">
                <h3 class="font-semibold text-gray-800 mb-3">Ringkasan Transaksi</h3>
                <div class="space-y-2 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-600">Produk:</span>
                        <span id="summaryProduct" class="font-medium"></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Nomor:</span>
                        <span id="summaryNumber" class="font-medium"></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Harga:</span>
                        <span id="summaryAmount" class="font-medium"></span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-600">Biaya Admin:</span>
                        <span id="summaryAdminFee" class="font-medium"></span>
                    </div>
                    <hr class="my-2">
                    <div class="flex justify-between text-lg font-bold">
                        <span>Total:</span>
                        <span id="summaryTotal" class="text-blue-600"></span>
                    </div>
                </div>
            </div>

            <!-- Process Button -->
            <button type="button" 
                    id="processBtn" 
                    onclick="processTransaction()" 
                    class="w-full btn-primary text-white py-4 rounded-lg font-semibold text-lg disabled:opacity-50"
                    disabled>
                <span id="btnText">Pilih Produk</span>
                <div id="btnLoading" class="loading">
                    <i class="fas fa-spinner fa-spin mr-2"></i>
                    Memproses...
                </div>
            </button>

        </div>

    </div>

    <script>
        let selectedProvider = null;
        let selectedProduct = null;
        let products = [];
        
        // Initialize page
        document.addEventListener('DOMContentLoaded', function() {
            const targetNumber = document.getElementById('targetNumber');
            const customerName = document.getElementById('customerName');
            const customerEmail = document.getElementById('customerEmail');
            
                         // Load user data if authenticated
             <?php if (isset($user) && $user): ?>
             customerName.value = '<?= $user->name ?? '' ?>';
             customerEmail.value = '<?= $user->email ?? '' ?>';
             <?php endif; ?>
            
            // Auto-load products for non-provider products
            <?php if (!isset($productInfo['providers'])): ?>
            loadProducts();
            <?php endif; ?>
            
            // Add input listeners
            targetNumber.addEventListener('input', updateUI);
            customerName.addEventListener('input', updateUI);
            customerEmail.addEventListener('input', updateUI);
        });

        function selectProvider(providerCode) {
            selectedProvider = providerCode;
            
            // Update UI
            document.querySelectorAll('.provider-btn').forEach(btn => {
                btn.classList.remove('selected', 'bg-blue-50', 'border-blue-300');
            });
            
            document.querySelector(`[data-provider="${providerCode}"]`).classList.add('selected', 'bg-blue-50', 'border-blue-300');
            
            // Load products for selected provider
            loadProducts();
        }

        function loadProducts() {
            const loadingEl = document.getElementById('loadingProducts');
            const productsEl = document.getElementById('productsList');
            
            loadingEl.classList.add('active');
            productsEl.innerHTML = '';
            
            // Build URL
            let url = `/ppob/api/products/<?= $productType ?>`;
            if (selectedProvider) {
                url += `?provider=${selectedProvider}`;
            }
            
            fetch(url, {
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                loadingEl.classList.remove('active');
                
                if (data.success) {
                    products = data.data;
                    renderProducts(products);
                } else {
                    productsEl.innerHTML = `
                        <div class="text-center py-4 text-gray-500">
                            <i class="fas fa-exclamation-triangle text-2xl mb-2"></i>
                            <p>${data.message || 'Gagal memuat produk'}</p>
                        </div>
                    `;
                }
            })
            .catch(error => {
                loadingEl.classList.remove('active');
                productsEl.innerHTML = `
                    <div class="text-center py-4 text-red-500">
                        <i class="fas fa-times-circle text-2xl mb-2"></i>
                        <p>Error: ${error.message}</p>
                    </div>
                `;
            });
        }

        function renderProducts(products) {
            const productsEl = document.getElementById('productsList');
            
            if (products.length === 0) {
                productsEl.innerHTML = `
                    <div class="text-center py-4 text-gray-500">
                        <i class="fas fa-inbox text-2xl mb-2"></i>
                        <p>Tidak ada produk tersedia</p>
                    </div>
                `;
                return;
            }
            
            productsEl.innerHTML = products.map(product => `
                <div class="product-item border border-gray-200 rounded-lg p-3 hover:border-blue-300" 
                     onclick="selectProduct(${JSON.stringify(product).replace(/"/g, '&quot;')})">
                    <div class="flex justify-between items-center">
                        <div>
                            <h4 class="font-medium text-gray-800">${product.description}</h4>
                            <p class="text-sm text-gray-500">Rp ${formatNumber(product.amount)}</p>
                        </div>
                        <div class="text-right">
                            <p class="font-semibold text-blue-600">Rp ${formatNumber(product.price)}</p>
                            <p class="text-xs text-gray-500">+ admin</p>
                        </div>
                    </div>
                </div>
            `).join('');
        }

        function selectProduct(product) {
            selectedProduct = product;
            
            // Update UI
            document.querySelectorAll('.product-item').forEach(item => {
                item.classList.remove('selected');
            });
            
            event.currentTarget.classList.add('selected');
            
            updateUI();
        }

        function updateUI() {
            const targetNumber = document.getElementById('targetNumber').value;
            const customerName = document.getElementById('customerName').value;
            const customerEmail = document.getElementById('customerEmail').value;
            const processBtn = document.getElementById('processBtn');
            const btnText = document.getElementById('btnText');
            const summary = document.getElementById('transactionSummary');
            
            // Check if all required fields are filled
            const isValid = targetNumber && customerName && customerEmail && selectedProduct;
            
            if (isValid) {
                // Show summary
                const adminFee = Math.max(1000, selectedProduct.price * 0.02);
                const total = selectedProduct.price + adminFee;
                
                document.getElementById('summaryProduct').textContent = selectedProduct.description;
                document.getElementById('summaryNumber').textContent = targetNumber;
                document.getElementById('summaryAmount').textContent = 'Rp ' + formatNumber(selectedProduct.price);
                document.getElementById('summaryAdminFee').textContent = 'Rp ' + formatNumber(adminFee);
                document.getElementById('summaryTotal').textContent = 'Rp ' + formatNumber(total);
                
                summary.style.display = 'block';
                processBtn.disabled = false;
                btnText.textContent = 'Bayar Sekarang';
            } else {
                summary.style.display = 'none';
                processBtn.disabled = true;
                btnText.textContent = 'Lengkapi Data';
            }
        }

        function processTransaction() {
            const targetNumber = document.getElementById('targetNumber').value;
            const customerName = document.getElementById('customerName').value;
            const customerEmail = document.getElementById('customerEmail').value;
            
            if (!selectedProduct) {
                alert('Pilih produk terlebih dahulu');
                return;
            }
            
            // Show loading
            const btnText = document.getElementById('btnText');
            const btnLoading = document.getElementById('btnLoading');
            const processBtn = document.getElementById('processBtn');
            
            btnText.style.display = 'none';
            btnLoading.classList.add('active');
            processBtn.disabled = true;
            
            // Prepare data
            const data = {
                product_type: '<?= $productType ?>',
                provider: selectedProvider,
                target_number: targetNumber,
                amount: selectedProduct.amount,
                price: selectedProduct.price,
                description: selectedProduct.description,
                customer_name: customerName,
                customer_email: customerEmail
            };
            
            // Submit transaction
            fetch('/ppob/process', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify(data)
            })
            .then(response => response.json())
            .then(result => {
                if (result.success) {
                    // Redirect to payment
                    if (result.data.payment_url) {
                        window.location.href = result.data.payment_url;
                    } else {
                        alert('Transaksi berhasil dibuat');
                        window.location.href = '/ppob';
                    }
                } else {
                    alert(result.message || 'Gagal memproses transaksi');
                    
                    // Reset loading
                    btnText.style.display = 'block';
                    btnLoading.classList.remove('active');
                    processBtn.disabled = false;
                }
            })
            .catch(error => {
                alert('Error: ' + error.message);
                
                // Reset loading
                btnText.style.display = 'block';
                btnLoading.classList.remove('active');
                processBtn.disabled = false;
            });
        }

        function formatNumber(num) {
            return new Intl.NumberFormat('id-ID').format(num);
        }

        function showContactPicker() {
            // Simple contact picker simulation
            const contacts = [
                '08123456789',
                '08234567890',
                '08345678901'
            ];
            
            const contact = prompt('Pilih nomor atau ketik nomor baru:\n' + contacts.join('\n'));
            if (contact) {
                document.getElementById('targetNumber').value = contact;
                updateUI();
            }
        }
    </script>
</body>
</html> 