<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Produk UMKM - Sistem Informasi Desa</title>
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#8B5CF6">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    <link rel="manifest" href="/manifest.json">
    <meta name="csrf-token" content="<?php echo csrf_token(); ?>">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- FontAwesome - Optimized loading -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer"></noscript>
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eff6ff',
                            500: '#3b82f6',
                            600: '#2563eb',
                            700: '#1d4ed8'
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        /* Optimized font loading */
        @font-face {
            font-family: 'Inter';
            font-display: swap;
            src: url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        }
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 0.75rem;
            padding: 0.75rem;
            box-shadow: 0 6px 12px -2px rgba(0, 0, 0, 0.08), 0 2px 4px -1px rgba(0, 0, 0, 0.04);
            border: 1px solid #f3f4f6;
        }
        
        .product-card {
            background: white;
            border-radius: 0.75rem;
            overflow: hidden;
            box-shadow: 0 3px 5px -1px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
        }
        
        .product-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.12);
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, #8b5cf6 0%, #7c3aed 100%);
        }
        
        .floating-action {
            position: fixed;
            bottom: 100px;
            right: 20px;
            z-index: 50;
        }
        
        /* FontAwesome fallback with !important for navigation */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fas.fa-search:before, .fa.fa-search:before { content: "🔍" !important; font-family: system-ui !important; }
        .fas.fa-filter:before, .fa.fa-filter:before { content: "🔽" !important; font-family: system-ui !important; }
        .fas.fa-shopping-cart:before, .fa.fa-shopping-cart:before { content: "🛒" !important; font-family: system-ui !important; }
        .fas.fa-star:before, .fa.fa-star:before { content: "⭐" !important; font-family: system-ui !important; }
        .far.fa-star:before, .fa.fa-star-o:before { content: "☆" !important; font-family: system-ui !important; }
        .fas.fa-plus:before, .fa.fa-plus:before { content: "➕" !important; font-family: system-ui !important; }
        .fas.fa-minus:before, .fa.fa-minus:before { content: "➖" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header/Status Bar -->
        <div class="gradient-bg text-white px-6 py-8 relative overflow-hidden">
             <!-- Background Pattern -->
           <div class="absolute inset-0 bg-cover bg-top bg-no-repeat opacity-60" style="background-image: url('/images/bg-pettren.png');"></div>
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-3">
                        <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md hover:bg-white/30 transition-colors">
                            <span class="text-lg">⬅️</span>
                        </button>
                        <div>
                            <h1 class="text-lg font-bold">Produk UMKM</h1>
                            <p class="text-white/80 text-xs">Dukung produk lokal</p>
                        </div>
                    </div>
                    
                    <button onclick="openCart()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md hover:bg-white/30 transition-colors relative">
                        <span class="text-lg">🛒</span>
                        <span class="absolute -top-1 -right-1 bg-red-500 text-white text-xs rounded-full w-5 h-5 flex items-center justify-center" id="cartCount">0</span>
                    </button>
                </div>
                
                <!-- Service Info -->
                <div class="text-center">
                    <h2 class="text-base font-semibold mb-2">E-Commerce Desa</h2>
                    <p class="text-white/90 text-xs">Marketplace produk UMKM lokal</p>
                </div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="px-4 -mt-6 relative z-20">
            <div class="grid grid-cols-3 gap-2 mb-4">
                <div class="mobile-card text-center">
                    <div class="w-8 h-8 bg-gradient-to-br from-blue-100 to-blue-200 rounded-lg flex items-center justify-center mx-auto mb-2 shadow-sm">
                        <span class="text-sm">🛍️</span>
                    </div>
                    <div class="text-xs font-bold text-gray-800">{{total_produk}}</div>
                    <div class="text-xs text-gray-500">Produk</div>
                </div>
                
                <div class="mobile-card text-center">
                    <div class="w-8 h-8 bg-gradient-to-br from-green-100 to-green-200 rounded-lg flex items-center justify-center mx-auto mb-2 shadow-sm">
                        <span class="text-sm">🏪</span>
                    </div>
                    <div class="text-xs font-bold text-gray-800">{{total_umkm}}</div>
                    <div class="text-xs text-gray-500">UMKM</div>
                </div>
                
                <div class="mobile-card text-center">
                    <div class="w-8 h-8 bg-gradient-to-br from-purple-100 to-purple-200 rounded-lg flex items-center justify-center mx-auto mb-2 shadow-sm">
                        <span class="text-sm">🏷️</span>
                    </div>
                    <div class="text-xs font-bold text-gray-800">{{total_kategori}}</div>
                    <div class="text-xs text-gray-500">Kategori</div>
                </div>
            </div>
        </div>

        <!-- Search & Filter -->
        <div class="px-4 mb-4">
            <div class="flex space-x-2 mb-3">
                <div class="flex-1">
                    <div class="relative">
                        <input type="text" id="searchInput" placeholder="Cari produk..." 
                               class="w-full pl-10 pr-4 py-3 border border-gray-200 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent text-sm">
                        <i class="fas fa-search text-gray-400 absolute left-3 top-1/2 transform -translate-y-1/2"></i>
                    </div>
                </div>
                <button onclick="toggleFilter()" class="px-4 py-3 bg-gray-100 rounded-xl">
                    <i class="fas fa-filter text-gray-600"></i>
                </button>
            </div>

            <!-- Filter Categories -->
            <div id="filterCategories" class="hidden">
                <div class="flex flex-wrap gap-2 mb-4">
                    {{filter_categories_buttons}}
                </div>
            </div>
        </div>

        <!-- Featured Products -->
        <div class="px-4 mb-4">
            <div class="flex items-center justify-between mb-3">
                <h3 class="text-sm font-semibold text-gray-800">Produk Unggulan</h3>
                <button onclick="showAllFeatured()" class="text-xs text-blue-600 font-medium hover:text-blue-700">Lihat Semua</button>
            </div>
            <div class="flex space-x-2 overflow-x-auto pb-2">
                {{featured_products_content}}
            </div>
        </div>

        <!-- All Products -->
        <div class="px-4 pb-24">
            <div class="flex items-center justify-between mb-3">
                <h3 class="text-sm font-semibold text-gray-800">Semua Produk</h3>
                <select id="sortSelect" class="text-xs border border-gray-200 rounded-lg px-2 py-1.5" onchange="sortProducts()">
                    <option value="terbaru">Terbaru</option>
                    <option value="harga_terendah">Harga Terendah</option>
                    <option value="harga_tertinggi">Harga Tertinggi</option>
                    <option value="rating_tertinggi">Rating Tertinggi</option>
                    <option value="terlaris">Paling Laris</option>
                </select>
            </div>
            
            <div class="grid grid-cols-2 gap-3" id="productsGrid">
                {{products_grid_content}}
            </div>

            <!-- Pagination -->
            <div class="text-center mt-4" id="paginationContainer">
                {{pagination_content}}
            </div>
        </div>



        <!-- Bottom Navigation -->
        <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
            <div class="flex justify-around items-center">
                <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-home text-lg"></i>
                    </div>
                    <span class="text-xs">Beranda</span>
                </button>
                
                <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-newspaper text-lg"></i>
                    </div>
                    <span class="text-xs">Berita</span>
                </button>
                
                <button onclick="navigateToService('wisata')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-map-marked-alt text-lg"></i>
                    </div>
                    <span class="text-xs">Wisata</span>
                </button>
                
                <button class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                    <div class="bg-blue-50 p-2 rounded-xl">
                        <i class="fas fa-store text-lg"></i>
                    </div>
                    <span class="text-xs font-semibold">UMKM</span>
                </button>
                
                <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                    <div class="p-2 rounded-xl hover:bg-blue-50">
                        <i class="fas fa-user-shield text-lg"></i>
                    </div>
                    <span class="text-xs">Portal</span>
                </button>
            </div>
        </div>
    </div>

    <!-- Cart Coming Soon Modal -->
    <div id="cartModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="bg-white rounded-xl w-full max-w-sm p-6 text-center">
                <!-- Icon -->
                <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span class="text-3xl">🛒</span>
                </div>
                
                <!-- Title -->
                <h3 class="text-lg font-semibold text-gray-800 mb-2">Segera Hadir!</h3>
                
                <!-- Message -->
                <p class="text-sm text-gray-600 mb-6">Fitur keranjang belanja akan segera hadir!</p>
                
                <!-- Close Button -->
                <button onclick="closeCartModal()" class="w-full py-3 bg-blue-600 text-white rounded-lg font-medium text-sm hover:bg-blue-700 transition-colors">
                    Mengerti
                </button>
            </div>
        </div>
    </div>

    <!-- Quick Checkout Modal -->
    <div id="quickCheckoutModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="bg-white rounded-xl w-full max-w-sm max-h-screen overflow-y-auto">
                <!-- Modal Header -->
                <div class="flex items-center justify-between p-3 border-b">
                    <h3 class="text-base font-semibold text-gray-800">Beli Cepat</h3>
                    <button onclick="closeQuickCheckout()" class="text-gray-400 hover:text-gray-600">
                        <span class="text-sm">❌</span>
                    </button>
                </div>
                
                <!-- Product Summary -->
                <div class="p-3 border-b">
                    <h4 class="text-sm font-medium text-gray-800" id="quick-product-name">Produk</h4>
                    <p class="text-xs text-gray-600">Qty: 1</p>
                    <p class="text-xs font-semibold text-green-600" id="quick-product-price">Rp 0</p>
                </div>
                
                <!-- Customer Info -->
                <div class="p-3 border-b">
                    <div class="space-y-2">
                        <input type="text" id="quick-customer-name" placeholder="Nama lengkap" class="w-full p-2 border border-gray-300 rounded-lg text-xs">
                        <input type="tel" id="quick-customer-phone" placeholder="No. WhatsApp" class="w-full p-2 border border-gray-300 rounded-lg text-xs">
                    </div>
                </div>
                
                <!-- Payment Methods -->
                <div class="p-3 border-b">
                    <h4 class="text-sm font-medium text-gray-800 mb-2">Metode Pembayaran</h4>
                    <div id="quick-payment-methods" class="space-y-2">
                        <div class="text-center py-2">
                            <div class="animate-spin rounded-full h-3 w-3 border-b-2 border-blue-600 mx-auto"></div>
                            <p class="text-xs text-gray-500 mt-1">Memuat...</p>
                        </div>
                    </div>
                </div>
                
                <!-- Total -->
                <div class="p-3 border-b">
                    <div class="flex justify-between items-center">
                        <span class="text-sm font-medium text-gray-800">Total:</span>
                        <span class="text-sm font-bold text-green-600" id="quick-total">Rp 0</span>
                    </div>
                </div>
                
                <!-- Action Buttons -->
                <div class="p-3">
                    <div class="flex space-x-2">
                        <button onclick="closeQuickCheckout()" class="flex-1 py-2 px-3 border border-gray-300 rounded-lg text-gray-700 font-medium text-xs">
                            Batal
                        </button>
                        <button onclick="processQuickCheckout()" class="flex-1 py-2 px-3 bg-blue-600 text-white rounded-lg font-medium text-xs">
                            Pesan
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- JavaScript -->
    <script>
        // Navigation functions
        function goHome() {
            window.location.href = '/';
        }
        
        function goToWisata() {
            window.location.href = '/wisata';
        }
        
        function goToProfile() {
            window.location.href = '/profile';
        }


        
        function toggleFilter() {
            const filterCategories = document.getElementById('filterCategories');
            filterCategories.classList.toggle('hidden');
        }
        
        // Product functions
        function beliProduk(slug) {
            window.location.href = '/produk/' + slug;
        }

        function quickCheckout(produkId, nama, harga) {
            // Set product data for quick checkout
            currentProduct = {
                id: produkId,
                name: nama,
                price: harga
            };
            
            // Update modal content
            document.getElementById('quick-product-name').textContent = nama;
            document.getElementById('quick-product-price').textContent = `Rp ${harga.toLocaleString('id-ID')}`;
            document.getElementById('quick-total').textContent = `Rp ${harga.toLocaleString('id-ID')}`;
            
            // Show modal
            document.getElementById('quickCheckoutModal').classList.remove('hidden');
            
            // Load payment methods
            loadQuickPaymentMethods();
        }

        function closeQuickCheckout() {
            document.getElementById('quickCheckoutModal').classList.add('hidden');
        }

        async function loadQuickPaymentMethods() {
            try {
                const response = await fetch('/api/payment-methods/umkm');
                const result = await response.json();
                
                if (result.success) {
                    renderQuickPaymentMethods(result.data);
                } else {
                    showQuickPaymentError('Gagal memuat metode pembayaran');
                }
            } catch (error) {
                console.error('Error loading payment methods:', error);
                showQuickPaymentError('Terjadi kesalahan saat memuat metode pembayaran');
            }
        }

        function renderQuickPaymentMethods(methods) {
            const container = document.getElementById('quick-payment-methods');
            
            let html = '';
            let isFirst = true;
            
            methods.forEach(method => {
                const feeText = method.fee > 0 ? 
                    `+Rp ${method.fee.toLocaleString('id-ID')}` :
                    (method.fee_percentage > 0 ? `+${method.fee_percentage}%` : '');
                
                html += `
                    <label class="flex items-center p-2 border border-gray-200 rounded-lg cursor-pointer hover:bg-gray-50">
                        <input type="radio" name="quick_payment_method" value="${method.code}" class="mr-2" ${isFirst ? 'checked' : ''}>
                        <div class="flex-1">
                            <span class="text-sm font-medium text-gray-800">${method.name}</span>
                            ${feeText ? `<span class="text-xs text-gray-500 ml-1">${feeText}</span>` : ''}
                        </div>
                    </label>
                `;
                isFirst = false;
            });
            
            container.innerHTML = html;
        }

        function showQuickPaymentError(message) {
            const container = document.getElementById('quick-payment-methods');
            container.innerHTML = `
                <div class="text-center py-2">
                    <p class="text-xs text-red-500">${message}</p>
                    <button onclick="loadQuickPaymentMethods()" class="text-blue-600 text-xs mt-1">Coba Lagi</button>
                </div>
            `;
        }

        async function processQuickCheckout() {
            const customerName = document.getElementById('quick-customer-name').value.trim();
            const customerPhone = document.getElementById('quick-customer-phone').value.trim();
            const paymentMethod = document.querySelector('input[name="quick_payment_method"]:checked');
            
            if (!customerName || !customerPhone) {
                alert('Mohon lengkapi nama dan nomor WhatsApp');
                return;
            }
            
            if (!paymentMethod) {
                alert('Mohon pilih metode pembayaran');
                return;
            }
            
            try {
                // Add to cart
                const cartResponse = await fetch('/checkout/add-to-cart', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        produk_id: currentProduct.id,
                        quantity: 1
                    })
                });
                
                const cartResult = await cartResponse.json();
                
                if (!cartResult.success) {
                    alert(cartResult.message || 'Gagal menambahkan ke keranjang');
                    return;
                }
                
                // Process checkout
                const checkoutResponse = await fetch('/checkout/process', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        customer_name: customerName,
                        customer_phone: customerPhone,
                        customer_address: 'Quick checkout',
                        payment_method: paymentMethod.value
                    })
                });
                
                const checkoutResult = await checkoutResponse.json();
                
                if (checkoutResult.success) {
                    alert('Pesanan berhasil dibuat!');
                    closeQuickCheckout();
                    if (checkoutResult.redirect_url) {
                        window.location.href = checkoutResult.redirect_url;
                    }
                } else {
                    alert(checkoutResult.message || 'Gagal memproses pesanan');
                }
                
            } catch (error) {
                console.error('Error processing quick checkout:', error);
                alert('Terjadi kesalahan saat memproses pesanan');
            }
        }

        let currentProduct = null;
        
        function showAllFeatured() {
            const url = new URL(window.location);
            url.searchParams.delete('page');
            url.searchParams.set('featured', '1');
            window.location.href = url.toString();
        }
        
        function sortProducts() {
            const sortValue = document.getElementById('sortSelect').value;
            const url = new URL(window.location);
            url.searchParams.set('sort', sortValue);
            url.searchParams.delete('page');
            window.location.href = url.toString();
        }
        
        function searchProducts() {
            const searchValue = document.getElementById('searchInput').value;
            const url = new URL(window.location);
            if (searchValue.trim()) {
                url.searchParams.set('search', searchValue);
            } else {
                url.searchParams.delete('search');
            }
            url.searchParams.delete('page');
            window.location.href = url.toString();
        }
        
        function filterByCategory(kategori) {
            const url = new URL(window.location);
            if (kategori === 'semua') {
                url.searchParams.delete('kategori');
            } else {
                url.searchParams.set('kategori', kategori);
            }
            url.searchParams.delete('page');
            window.location.href = url.toString();
        }
        
        function loadPage(page) {
            const url = new URL(window.location);
            url.searchParams.set('page', page);
            window.location.href = url.toString();
        }
        
        function openCart() {
            document.getElementById('cartModal').classList.remove('hidden');
        }

        function closeCartModal() {
            document.getElementById('cartModal').classList.add('hidden');
        }
        
        // Optimized page initialization
        document.addEventListener('DOMContentLoaded', function() {
            // Use requestIdleCallback for non-critical tasks
            if ('requestIdleCallback' in window) {
                requestIdleCallback(initializePage);
            } else {
                setTimeout(initializePage, 0);
            }
        });
        
        function initializePage() {
            const searchInput = document.getElementById('searchInput');
            if (searchInput) {
                searchInput.addEventListener('keypress', function(e) {
                    if (e.key === 'Enter') {
                        searchProducts();
                    }
                });
            }
            
            // Check FontAwesome loading
            checkFontAwesome();
            
            console.log('Produk UMKM page loaded - Database synchronized');
        }
        
        // Optimized FontAwesome loading check
        function checkFontAwesome() {
            // Use requestIdleCallback for better performance
            if ('requestIdleCallback' in window) {
                requestIdleCallback(checkIcons);
            } else {
                setTimeout(checkIcons, 100);
            }
        }
        
        function checkIcons() {
            const testIcon = document.createElement('i');
            testIcon.className = 'fas fa-home';
            testIcon.style.visibility = 'hidden';
            testIcon.style.position = 'absolute';
            document.body.appendChild(testIcon);
            
            const computedStyle = window.getComputedStyle(testIcon, ':before');
            const content = computedStyle.getPropertyValue('content');
            
            if (content && content !== 'none' && content !== '""') {
                console.log('✅ FontAwesome loaded successfully on UMKM page');
            } else {
                console.warn('⚠️ FontAwesome loading delayed, using fallback');
                loadFontAwesomeFallback();
            }
            
            document.body.removeChild(testIcon);
        }
        
        // Load FontAwesome fallback
        function loadFontAwesomeFallback() {
            const link = document.createElement('link');
            link.rel = 'stylesheet';
            link.href = 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css';
            link.onerror = function() {
                console.error('❌ All FontAwesome sources failed, showing text fallback');
                showTextFallback();
            };
            document.head.appendChild(link);
        }
        
        // Show text fallback for icons
        function showTextFallback() {
            const icons = document.querySelectorAll('.fas, .fab, .fa');
            icons.forEach(icon => {
                const className = icon.className;
                let text = '●';
                
                if (className.includes('fa-home')) text = '🏠';
                else if (className.includes('fa-newspaper')) text = '📰';
                else if (className.includes('fa-map-marked-alt')) text = '🗺️';
                else if (className.includes('fa-store')) text = '🏪';
                else if (className.includes('fa-user-shield')) text = '🛡️';
                else if (className.includes('fa-search')) text = '🔍';
                else if (className.includes('fa-filter')) text = '🔽';
                
                icon.innerHTML = text;
                icon.style.fontFamily = 'inherit';
                icon.style.fontSize = '16px';
            });
        }
        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            
            switch(serviceType) {
                case '/':
                case 'home':
                case 'beranda':
                    window.location.href = '/';
                    break;
                case 'berita':
                    window.location.href = '/berita';
                    break;
                case 'wisata':
                    window.location.href = '/wisata';
                    break;
                case 'umkm':
                    window.location.href = '/produk-umkm';
                    break;
                case 'layanan-mandiri':
                    window.location.href = '/layanan-mandiri';
                    break;
                case 'peta':
                    window.location.href = '/peta';
                    break;
                default:
                    console.log('Unknown service type:', serviceType);
                    window.location.href = '/';
            }
        }
    </script>
</body>
</html> 