<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wisata Desa - Portal Desa Digital</title>
    <meta name="csrf-token" content="<?php echo csrf_token(); ?>">
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#F59E0B">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    <meta name="apple-mobile-web-app-title" content="Sistem Desa">
    <link rel="manifest" href="/manifest.json">
    
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="/favicon.ico">
    
    <!-- DNS Prefetch for External Resources -->
    <link rel="dns-prefetch" href="//cdn.tailwindcss.com">
    <link rel="dns-prefetch" href="//cdnjs.cloudflare.com">
    <link rel="dns-prefetch" href="//fonts.googleapis.com">
    <link rel="dns-prefetch" href="//use.fontawesome.com">
    
    <!-- Preload Critical Resources for LCP -->
    <link rel="preload" as="image" href="/images/bg-pettren.png" fetchpriority="high">
    <link rel="preload" as="style" href="https://cdn.tailwindcss.com" crossorigin>
    
    <!-- Optimize FontAwesome loading -->
    <link rel="preload" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" as="style" onload="this.onload=null;this.rel='stylesheet'">
    <noscript><link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css"></noscript>
    
    <!-- CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'inter': ['Inter', 'system-ui', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#fffbeb',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309'
                        }
                    }
                }
            }
        }
    </script>
    
    <!-- FontAwesome - Optimized loading with fallback -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <style>
        /* Critical CSS for LCP improvement */
        .gradient-bg {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
        }
        
        /* Optimize background image rendering */
        .bg-pattern-optimized {
            background-image: url('/images/bg-pettren.png');
            background-size: cover;
            background-position: top;
            background-repeat: no-repeat;
            opacity: 0.6;
            will-change: transform;
            transform: translateZ(0);
            /* Optimize for performance */
            image-rendering: -webkit-optimize-contrast;
            image-rendering: crisp-edges;
        }
        
        /* Optimized font loading */
        @font-face {
            font-family: 'Inter';
            font-display: swap;
            src: url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
        }
        
        body {
            font-family: 'Inter', system-ui, sans-serif;
        }
        
        .mobile-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 0.75rem;
            padding: 0.75rem;
            box-shadow: 0 6px 12px -2px rgba(0, 0, 0, 0.08), 0 2px 4px -1px rgba(0, 0, 0, 0.04);
            border: 1px solid #f3f4f6;
        }
        

        
        .destination-card {
            background: white;
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 4px 20px rgba(0,0,0,0.12);
            transition: all 0.3s ease;
            border: 1px solid #f0f0f0;
        }
        
        .destination-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 30px rgba(0,0,0,0.15);
        }
        
        .stat-card {
            background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);
            border-radius: 12px;
            padding: 12px;
            color: white;
            text-align: center;
        }
        
        .search-container {
            background: white;
            border-radius: 10px;
            padding: 8px;
            box-shadow: 0 2px 6px rgba(0,0,0,0.05);
            margin-bottom: 12px;
        }
        
        .filter-button {
            background: #f8f9ff;
            border: 1px solid #e5e7eb;
            border-radius: 6px;
            padding: 4px 8px;
            margin: 1px;
            font-size: 11px;
            font-weight: 500;
            color: #374151;
            transition: all 0.3s ease;
        }
        
        .filter-button.active {
            background: #f59e0b;
            border-color: #f59e0b;
            color: white;
        }
        
        .rating-stars {
            color: #fbbf24;
        }
        
        /* FontAwesome fallback with !important for navigation */
        .fas.fa-home:before, .fa.fa-home:before { content: "🏠" !important; font-family: system-ui !important; }
        .fas.fa-newspaper:before, .fa.fa-newspaper:before { content: "📰" !important; font-family: system-ui !important; }
        .fas.fa-map-marked-alt:before, .fa.fa-map-marked-alt:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-store:before, .fa.fa-store:before { content: "🏪" !important; font-family: system-ui !important; }
        .fas.fa-user-shield:before, .fa.fa-user-shield:before { content: "🛡️" !important; font-family: system-ui !important; }
        .fas.fa-search:before, .fa.fa-search:before { content: "🔍" !important; font-family: system-ui !important; }
        .fas.fa-heart:before, .fa.fa-heart:before { content: "❤️" !important; font-family: system-ui !important; }
        .far.fa-heart:before, .fa.fa-heart-o:before { content: "🤍" !important; font-family: system-ui !important; }
        .fas.fa-star:before, .fa.fa-star:before { content: "⭐" !important; font-family: system-ui !important; }
        .far.fa-star:before, .fa.fa-star-o:before { content: "☆" !important; font-family: system-ui !important; }
        .fas.fa-map:before, .fa.fa-map:before { content: "🗺️" !important; font-family: system-ui !important; }
        .fas.fa-calendar:before, .fa.fa-calendar:before { content: "📅" !important; font-family: system-ui !important; }
        .fas.fa-ticket-alt:before, .fa.fa-ticket:before { content: "🎫" !important; font-family: system-ui !important; }
        
        /* Force emoji display for all FontAwesome icons */
        .fas:before, .fab:before, .far:before, .fa:before {
            font-weight: normal !important;
            font-style: normal !important;
            text-rendering: auto !important;
            -webkit-font-smoothing: antialiased !important;
        }
    </style>
</head>
<body class="bg-gray-50 min-h-screen">
    <!-- Mobile App Container -->
    <div class="max-w-md mx-auto bg-white min-h-screen shadow-xl">
        
        <!-- Header/Status Bar -->
        <div class="gradient-bg text-white px-6 py-8 relative overflow-hidden">
           <!-- Background Pattern - Optimized for LCP -->
           <div class="absolute inset-0 bg-pattern-optimized"></div>
            
            
            <!-- Header Content -->
            <div class="relative z-10">
                <div class="flex items-center justify-between mb-6">
                    <div class="flex items-center space-x-3">
                        <button onclick="history.back()" class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                            <span class="text-lg">⬅️</span>
                        </button>
                        <div>
                            <h1 class="text-xl font-bold">Wisata Desa</h1>
                            <p class="text-white/80 text-sm">Destinasi wisata lokal</p>
                        </div>
                    </div>
                    
                    <div class="w-10 h-10 bg-white/20 rounded-full flex items-center justify-center backdrop-blur-md">
                        <span class="text-lg">🖼️</span>
                    </div>
                </div>
                
                <!-- Service Info -->
                <div class="text-center">
                    <h2 class="text-lg font-semibold mb-2">Portal Wisata Desa</h2>
                    <p class="text-white/90 text-sm">Jelajahi keindahan wisata lokal</p>
                </div>
            </div>
        </div>

        <!-- Content Area -->
        <div class="px-4 -mt-6 relative z-20">

        <!-- Statistik -->
        <div class="grid grid-cols-3 gap-2 mb-4">
            <div class="mobile-card text-center">
                <div class="w-8 h-8 rounded-lg flex items-center justify-center mx-auto mb-2 shadow-sm" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                    <span class="text-lg">📍</span>
                </div>
                <div class="text-sm font-bold text-gray-800">{{total_destinasi}}</div>
                <div class="text-xs text-gray-500">Destinasi</div>
            </div>
            
            <div class="mobile-card text-center">
                <div class="w-8 h-8 rounded-lg flex items-center justify-center mx-auto mb-2 shadow-sm" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                    <span class="text-lg">🏷️</span>
                </div>
                <div class="text-sm font-bold text-gray-800">{{total_kategori}}</div>
                <div class="text-xs text-gray-500">Kategori</div>
            </div>
            
            <div class="mobile-card text-center">
                <div class="w-8 h-8 rounded-lg flex items-center justify-center mx-auto mb-2 shadow-sm" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                    <span class="text-lg">👥</span>
                </div>
                <div class="text-sm font-bold text-gray-800">{{total_pengunjung}}</div>
                <div class="text-xs text-gray-500">Pengunjung</div>
            </div>
        </div>
        </div>

        <!-- Filter and Content Area -->
        <div class="px-4">
        
        <!-- Active Filter Status -->
        <div id="filterStatus" class="mb-4" style="display: none;">
            <div class="bg-blue-50 border border-blue-200 rounded-xl p-3">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <i class="fas fa-star text-blue-600 mr-2"></i>
                        <span class="text-blue-800 font-medium text-sm">Menampilkan Destinasi Unggulan</span>
                    </div>
                    <button onclick="clearFeaturedFilter()" class="text-blue-600 hover:text-blue-700 text-sm">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Search & Filter -->
        <div class="search-container">
            <div class="relative mb-3">
                <input type="text" id="searchInput" 
                       placeholder="Cari destinasi wisata..." 
                       class="w-full pl-8 pr-3 py-2 text-sm border border-gray-200 rounded-lg focus:ring-2 focus:ring-blue-500 focus:border-transparent">
                <i class="fas fa-search absolute left-2.5 top-1/2 transform -translate-y-1/2 text-gray-400 text-sm"></i>
            </div>
            
            <div class="filter-categories">
                <h3 class="text-xs font-semibold text-gray-700 mb-2">Kategori Wisata</h3>
                <div class="flex flex-wrap">
                    <button class="filter-button active" data-category="all">Semua</button>
                    <button class="filter-button" data-category="alam">Alam</button>
                    <button class="filter-button" data-category="budaya">Budaya</button>
                    <button class="filter-button" data-category="kuliner">Kuliner</button>
                    <button class="filter-button" data-category="sejarah">Sejarah</button>
                    <button class="filter-button" data-category="religi">Religi</button>
                </div>
            </div>
        </div>

        <!-- Destinasi Unggulan -->
        <div class="mb-3">
            <div class="flex items-center justify-between mb-2">
                <h2 class="text-sm font-bold text-gray-800">Destinasi Unggulan</h2>
                <button onclick="showAllFeatured()" class="text-xs text-blue-600 font-medium hover:text-blue-700">Lihat Semua</button>
            </div>
            
            <div class="horizontal-scroll pb-3" style="overflow-x: auto;">
                <div class="flex space-x-3" style="width: max-content;">
                    {{featured_destinations_content}}
                    <!-- Additional featured destinations will be populated here -->
                </div>
            </div>
        </div>

        <!-- Semua Destinasi -->
        <div class="pb-20">
            <h2 class="text-sm font-bold text-gray-800 mb-2">Semua Destinasi</h2>
            
            <div id="destinationGrid" class="space-y-4">
                {{destinations_grid_content}}
                <!-- Additional destinations will be populated here -->
            </div>
            
            <!-- Pagination -->
            {{pagination_content}}
        </div>
        </div>
    </div>

    <!-- Quick Booking Modal -->
    <div id="quickBookingModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
        <div class="flex items-center justify-center min-h-screen p-4">
            <div class="bg-white rounded-xl w-full max-w-sm max-h-screen overflow-y-auto">
                <!-- Modal Header -->
                <div class="flex items-center justify-between p-4 border-b">
                    <h3 class="text-lg font-semibold text-gray-800">Booking Cepat</h3>
                    <button onclick="closeQuickBooking()" class="text-gray-400 hover:text-gray-600">
                        <span class="text-xl">❌</span>
                    </button>
                </div>
                
                <!-- Destination Summary -->
                <div class="p-4 border-b">
                    <h4 class="font-medium text-gray-800" id="quick-destination-name">Destinasi</h4>
                    <p class="text-sm text-gray-600">Qty: 1 tiket</p>
                    <p class="text-sm font-semibold text-orange-600" id="quick-destination-price">Rp 0</p>
                </div>
                
                <!-- Customer Info -->
                <div class="p-4 border-b">
                    <div class="space-y-3">
                        <input type="text" id="quick-visitor-name" placeholder="Nama lengkap" class="w-full p-2 border border-gray-300 rounded-lg text-sm">
                        <input type="email" id="quick-visitor-email" placeholder="Email" class="w-full p-2 border border-gray-300 rounded-lg text-sm">
                        <input type="tel" id="quick-visitor-phone" placeholder="No. WhatsApp" class="w-full p-2 border border-gray-300 rounded-lg text-sm">
                        <input type="date" id="quick-visit-date" class="w-full p-2 border border-gray-300 rounded-lg text-sm">
                    </div>
                </div>
                
                <!-- Payment Methods -->
                <div class="p-4 border-b">
                    <h4 class="font-medium text-gray-800 mb-3">Metode Pembayaran</h4>
                    <div id="quick-tourism-payment-methods" class="space-y-2">
                        <div class="text-center py-2">
                            <div class="animate-spin rounded-full h-4 w-4 border-b-2 border-orange-600 mx-auto"></div>
                            <p class="text-xs text-gray-500 mt-1">Memuat...</p>
                        </div>
                    </div>
                </div>
                
                <!-- Total -->
                <div class="p-4 border-b">
                    <div class="flex justify-between items-center">
                        <span class="font-medium text-gray-800">Total:</span>
                        <span class="text-lg font-bold text-orange-600" id="quick-booking-total">Rp 0</span>
                    </div>
                </div>
                
                <!-- Action Buttons -->
                <div class="p-4">
                    <div class="flex space-x-3">
                        <button onclick="closeQuickBooking()" class="flex-1 py-2 px-4 border border-gray-300 rounded-lg text-gray-700 font-medium text-sm">
                            Batal
                        </button>
                        <button onclick="processQuickBooking()" class="flex-1 py-2 px-4 bg-orange-600 text-white rounded-lg font-medium text-sm">
                            Booking
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bottom Navigation -->
    <div class="fixed bottom-0 left-1/2 transform -translate-x-1/2 w-full max-w-md bg-white border-t border-gray-100 px-4 py-3 z-50 shadow-lg backdrop-blur-sm bg-white/95">
        <div class="flex justify-around items-center">
            <button onclick="navigateToService('/')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-home text-lg"></i>
                </div>
                <span class="text-xs">Beranda</span>
            </button>
            
            <button onclick="navigateToService('berita')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-newspaper text-lg"></i>
                </div>
                <span class="text-xs">Berita</span>
            </button>
            
            <button class="flex flex-col items-center space-y-1.5 text-blue-600 transition-all duration-200">
                <div class="bg-blue-50 p-2 rounded-xl">
                    <i class="fas fa-map-marked-alt text-lg"></i>
                </div>
                <span class="text-xs font-semibold">Wisata</span>
            </button>
            
            <button onclick="navigateToService('umkm')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-store text-lg"></i>
                </div>
                <span class="text-xs">UMKM</span>
            </button>
            
            <button onclick="navigateToService('layanan-mandiri')" class="flex flex-col items-center space-y-1.5 text-gray-500 hover:text-blue-600 transition-all duration-200">
                <div class="p-2 rounded-xl hover:bg-blue-50">
                    <i class="fas fa-user-shield text-lg"></i>
                </div>
                <span class="text-xs">Portal</span>
            </button>
        </div>
    </div>

    <script>
        // Search functionality
        document.getElementById('searchInput').addEventListener('input', function() {
            const searchTerm = this.value.toLowerCase();
            const destinations = document.querySelectorAll('.destination-item');
            
            destinations.forEach(destination => {
                const title = destination.querySelector('h3').textContent.toLowerCase();
                const description = destination.querySelector('p').textContent.toLowerCase();
                
                if (title.includes(searchTerm) || description.includes(searchTerm)) {
                    destination.style.display = 'block';
                } else {
                    destination.style.display = 'none';
                }
            });
        });

        // Filter functionality
        document.querySelectorAll('.filter-button').forEach(button => {
            button.addEventListener('click', function() {
                // Update active state
                document.querySelectorAll('.filter-button').forEach(btn => btn.classList.remove('active'));
                this.classList.add('active');
                
                const category = this.dataset.category;
                const destinations = document.querySelectorAll('.destination-item');
                
                destinations.forEach(destination => {
                    if (category === 'all' || destination.dataset.category === category) {
                        destination.style.display = 'block';
                    } else {
                        destination.style.display = 'none';
                    }
                });
            });
        });

        // Heart/favorite functionality
        document.querySelectorAll('.fa-heart').forEach(heart => {
            heart.addEventListener('click', function() {
                if (this.classList.contains('far')) {
                    this.classList.remove('far');
                    this.classList.add('fas');
                    this.style.color = '#ef4444';
                } else {
                    this.classList.remove('fas');
                    this.classList.add('far');
                    this.style.color = '#f87171';
                }
            });
        });

        // Pagination functionality
        function loadPage(page) {
            const url = new URL(window.location);
            url.searchParams.set('page', page);
            window.location.href = url.toString();
        }

        // Show all featured destinations
        function showAllFeatured() {
            // Filter to show only featured destinations
            const url = new URL(window.location);
            url.searchParams.delete('page'); // Reset to first page
            url.searchParams.set('featured', '1'); // Add featured filter
            window.location.href = url.toString();
        }

        // Clear featured filter
        function clearFeaturedFilter() {
            const url = new URL(window.location);
            url.searchParams.delete('featured');
            url.searchParams.delete('page'); // Reset to first page
            window.location.href = url.toString();
        }

        // Check if featured filter is active on page load
        document.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            if (urlParams.get('featured') === '1') {
                document.getElementById('filterStatus').style.display = 'block';
            }
            
            // Set minimum date to today for quick booking
            const today = new Date().toISOString().split('T')[0];
            document.getElementById('quick-visit-date').setAttribute('min', today);
            
            // Check FontAwesome loading
            checkFontAwesome();
        });
        
        // Optimized FontAwesome loading check
        function checkFontAwesome() {
            // Use requestIdleCallback for better performance
            if ('requestIdleCallback' in window) {
                requestIdleCallback(checkIcons);
            } else {
                setTimeout(checkIcons, 100);
            }
        }
        
        function checkIcons() {
            const testIcon = document.createElement('i');
            testIcon.className = 'fas fa-home';
            testIcon.style.visibility = 'hidden';
            testIcon.style.position = 'absolute';
            document.body.appendChild(testIcon);
            
            const computedStyle = window.getComputedStyle(testIcon, ':before');
            const content = computedStyle.getPropertyValue('content');
            
            if (content && content !== 'none' && content !== '""') {
                console.log('✅ FontAwesome loaded successfully on wisata page');
            } else {
                console.warn('⚠️ FontAwesome loading delayed, using fallback');
                loadFontAwesomeFallback();
            }
            
            document.body.removeChild(testIcon);
        }
        
        // Load FontAwesome fallback
        function loadFontAwesomeFallback() {
            const link = document.createElement('link');
            link.rel = 'stylesheet';
            link.href = 'https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css';
            link.onerror = function() {
                console.error('❌ All FontAwesome sources failed, showing text fallback');
                showTextFallback();
            };
            document.head.appendChild(link);
        }
        
        // Show text fallback for icons
        function showTextFallback() {
            const icons = document.querySelectorAll('.fas, .fab, .fa');
            icons.forEach(icon => {
                const className = icon.className;
                let text = '●';
                
                if (className.includes('fa-home')) text = '🏠';
                else if (className.includes('fa-newspaper')) text = '📰';
                else if (className.includes('fa-map-marked-alt')) text = '🗺️';
                else if (className.includes('fa-store')) text = '🏪';
                else if (className.includes('fa-user-shield')) text = '🛡️';
                else if (className.includes('fa-search')) text = '🔍';
                else if (className.includes('fa-heart')) text = '❤️';
                
                icon.innerHTML = text;
                icon.style.fontFamily = 'inherit';
                icon.style.fontSize = '16px';
            });
        }

        // Quick Booking Functions
        let currentDestination = null;

        function quickBooking(slug, nama, harga) {
            currentDestination = {
                slug: slug,
                name: nama,
                price: harga
            };
            
            // Update modal content
            document.getElementById('quick-destination-name').textContent = nama;
            document.getElementById('quick-destination-price').textContent = `Rp ${harga.toLocaleString('id-ID')}`;
            document.getElementById('quick-booking-total').textContent = `Rp ${harga.toLocaleString('id-ID')}`;
            
            // Show modal
            document.getElementById('quickBookingModal').classList.remove('hidden');
            
            // Load payment methods
            loadTourismPaymentMethods();
        }

        function closeQuickBooking() {
            document.getElementById('quickBookingModal').classList.add('hidden');
        }

        async function loadTourismPaymentMethods() {
            try {
                const response = await fetch('/api/payment-methods/tourism');
                const result = await response.json();
                
                if (result.success) {
                    renderTourismPaymentMethods(result.data);
                } else {
                    showTourismPaymentError('Gagal memuat metode pembayaran');
                }
            } catch (error) {
                console.error('Error loading payment methods:', error);
                showTourismPaymentError('Terjadi kesalahan saat memuat metode pembayaran');
            }
        }

        function renderTourismPaymentMethods(methods) {
            const container = document.getElementById('quick-tourism-payment-methods');
            
            let html = '';
            let isFirst = true;
            
            methods.forEach(method => {
                const feeText = method.fee > 0 ? 
                    `+Rp ${method.fee.toLocaleString('id-ID')}` :
                    (method.fee_percentage > 0 ? `+${method.fee_percentage}%` : '');
                
                html += `
                    <label class="flex items-center p-2 border border-gray-200 rounded-lg cursor-pointer hover:bg-gray-50">
                        <input type="radio" name="quick_tourism_payment" value="${method.code}" class="mr-2" ${isFirst ? 'checked' : ''}>
                        <div class="flex-1">
                            <span class="text-sm font-medium text-gray-800">${method.name}</span>
                            ${feeText ? `<span class="text-xs text-gray-500 ml-1">${feeText}</span>` : ''}
                        </div>
                    </label>
                `;
                isFirst = false;
            });
            
            container.innerHTML = html;
        }

        function showTourismPaymentError(message) {
            const container = document.getElementById('quick-tourism-payment-methods');
            container.innerHTML = `
                <div class="text-center py-2">
                    <p class="text-xs text-red-500">${message}</p>
                    <button onclick="loadTourismPaymentMethods()" class="text-orange-600 text-xs mt-1">Coba Lagi</button>
                </div>
            `;
        }

        async function processQuickBooking() {
            const visitorName = document.getElementById('quick-visitor-name').value.trim();
            const visitorEmail = document.getElementById('quick-visitor-email').value.trim();
            const visitorPhone = document.getElementById('quick-visitor-phone').value.trim();
            const visitDate = document.getElementById('quick-visit-date').value;
            const paymentMethod = document.querySelector('input[name="quick_tourism_payment"]:checked');
            
            if (!visitorName || !visitorEmail || !visitorPhone || !visitDate) {
                alert('Mohon lengkapi semua informasi pengunjung');
                return;
            }
            
            if (!paymentMethod) {
                alert('Mohon pilih metode pembayaran');
                return;
            }
            
            try {
                const response = await fetch('/api/tiket-wisata', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || ''
                    },
                    body: JSON.stringify({
                        destinasi_wisata: currentDestination.name,
                        nama_pengunjung: visitorName,
                        email: visitorEmail,
                        no_hp: visitorPhone,
                        tanggal_kunjungan: visitDate,
                        jumlah_tiket: 1,
                        catatan: 'Quick booking',
                        metode_pembayaran: paymentMethod.value,
                        harga_per_tiket: currentDestination.price,
                        total_harga: currentDestination.price
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('Tiket berhasil dipesan! Kode booking: ' + result.data.kode_booking);
                    closeQuickBooking();
                    if (result.data.redirect_url) {
                        window.location.href = result.data.redirect_url;
                    }
                } else {
                    alert(result.message || 'Gagal memesan tiket');
                }
                
            } catch (error) {
                console.error('Error processing quick booking:', error);
                alert('Terjadi kesalahan saat memesan tiket');
            }
        }

        // Smooth scroll for horizontal scroll
        document.querySelectorAll('.horizontal-scroll').forEach(container => {
            let isDown = false;
            let startX;
            let scrollLeft;

            container.addEventListener('mousedown', (e) => {
                isDown = true;
                startX = e.pageX - container.offsetLeft;
                scrollLeft = container.scrollLeft;
            });

            container.addEventListener('mouseleave', () => {
                isDown = false;
            });

            container.addEventListener('mouseup', () => {
                isDown = false;
            });

            container.addEventListener('mousemove', (e) => {
                if (!isDown) return;
                e.preventDefault();
                const x = e.pageX - container.offsetLeft;
                const walk = (x - startX) * 2;
                container.scrollLeft = scrollLeft - walk;
            });
        });

        // Navigation function
        function navigateToService(serviceType) {
            console.log('Navigating to:', serviceType);
            console.log('Function called successfully');
            
            try {
                switch(serviceType) {
                    case '/':
                    case 'home':
                    case 'beranda':
                        console.log('Redirecting to home');
                        window.location.href = '/';
                        break;
                    case 'berita':
                        console.log('Redirecting to berita');
                        window.location.href = '/berita';
                        break;
                    case 'wisata':
                        console.log('Already on wisata page');
                        window.location.href = '/wisata';
                        break;
                    case 'umkm':
                        console.log('Redirecting to produk-umkm');
                        window.location.href = '/produk-umkm';
                        break;
                    case 'layanan-mandiri':
                        console.log('Redirecting to layanan-mandiri');
                        window.location.href = '/layanan-mandiri';
                        break;
                    case 'peta':
                        console.log('Redirecting to peta');
                        window.location.href = '/peta';
                        break;
                    default:
                        console.log('Unknown service type:', serviceType);
                        window.location.href = '/';
                }
            } catch (error) {
                console.error('Navigation error:', error);
                alert('Navigation error: ' + error.message);
            }
        }

        // Test function to verify navigation works
        function testNavigation() {
            console.log('Testing navigation function...');
            console.log('Available functions:', typeof navigateToService);
            
            // Test if buttons exist
            const buttons = document.querySelectorAll('button[onclick*="navigateToService"]');
            console.log('Found navigation buttons:', buttons.length);
            
            buttons.forEach((button, index) => {
                console.log(`Button ${index + 1}:`, button.onclick);
            });
        }

        // Optimized page initialization
        document.addEventListener('DOMContentLoaded', function() {
            // Use requestIdleCallback for non-critical tasks
            if ('requestIdleCallback' in window) {
                requestIdleCallback(initializePage);
            } else {
                setTimeout(initializePage, 0);
            }
        });
        
        function initializePage() {
            console.log('DOM loaded, running navigation test...');
            testNavigation();
            
            // Add backup event listeners for navigation buttons
            const navButtons = [
                { selector: 'button[onclick*="navigateToService(\'/\')"]', service: '/' },
                { selector: 'button[onclick*="navigateToService(\'berita\')"]', service: 'berita' },
                { selector: 'button[onclick*="navigateToService(\'umkm\')"]', service: 'umkm' },
                { selector: 'button[onclick*="navigateToService(\'layanan-mandiri\')"]', service: 'layanan-mandiri' }
            ];
            
            navButtons.forEach(button => {
                const element = document.querySelector(button.selector);
                if (element) {
                    element.addEventListener('click', function(e) {
                        console.log('Event listener triggered for:', button.service);
                        navigateToService(button.service);
                    });
                }
            });
        }
    </script>
</body>
</html> 