<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PendudukController;
use App\Http\Controllers\PelayananSuratController;
use App\Http\Controllers\PengaduanController;
use App\Http\Controllers\BantuanController;
use App\Http\Controllers\BeritaController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\KeluargaController;
use App\Http\Controllers\Admin\SettingController;
use App\Http\Controllers\Admin\RoleController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\CaptchaController;
use App\Http\Controllers\PohonKeluargaController;
use App\Http\Controllers\PetaController;
use App\Http\Controllers\ApbdesController;
use App\Http\Controllers\KegiatanPembangunanController;
use App\Http\Controllers\StrukturOrganisasiController;
use App\Http\Controllers\WilayahAdministratifController;
use App\Http\Controllers\Admin\UmkmController;
use App\Http\Controllers\Admin\ProdukUmkmController;
use App\Http\Controllers\Admin\ObjekWisataController;
use App\Http\Controllers\Admin\TiketWisataController;
use App\Http\Controllers\Admin\TransaksiController;
use App\Http\Controllers\Admin\MarketplaceController;
use App\Http\Controllers\TemplateSuratController;
use App\Http\Controllers\Admin\PbbController;
use App\Http\Controllers\PollingController;
use App\Http\Controllers\PerangkatDesaController;
use App\Http\Controllers\AgendaDesaController;
use App\Http\Controllers\InventarisDesaController;
use App\Http\Controllers\ArsipSuratKeluarController;
use App\Http\Controllers\Api\AuthController as ApiAuthController;
use App\Http\Controllers\MutasiPendudukController;
use App\Http\Controllers\BugController;
use App\Http\Controllers\DemografiController;
use App\Http\Controllers\PpobController;
use App\Services\BugDetectionService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Public Website Routes
Route::get('/', [App\Http\Controllers\PublicController::class, 'index'])->name('public.index');
Route::get('/bootstrap', [App\Http\Controllers\PublicController::class, 'publicBootstrap'])->name('public.bootstrap');
Route::get('/tentang', [App\Http\Controllers\PublicController::class, 'tentang'])->name('public.tentang');
Route::get('/layanan', [App\Http\Controllers\PublicController::class, 'layanan'])->name('public.layanan');
Route::get('/kontak', [App\Http\Controllers\PublicController::class, 'kontak'])->name('public.kontak');

// Public Services
Route::get('/ajukan-surat', [App\Http\Controllers\PublicController::class, 'ajukanSurat'])->name('public.ajukan-surat');
Route::get('/api/check-nik/{nik}', [App\Http\Controllers\PublicController::class, 'checkNik'])->name('api.check-nik');
Route::post('/ajukan-surat', [App\Http\Controllers\PublicController::class, 'storeSurat'])->name('public.surat.store');
Route::get('/surat-success', [App\Http\Controllers\PublicController::class, 'suratSuccess'])->name('public.surat.success');

Route::get('/pengaduan', [App\Http\Controllers\PublicController::class, 'pengaduanForm'])->name('public.pengaduan');
Route::post('/pengaduan', [App\Http\Controllers\PublicController::class, 'storePengaduan'])->name('public.pengaduan.store');
Route::get('/pengaduan-success', [App\Http\Controllers\PublicController::class, 'pengaduanSuccess'])->name('public.pengaduan.success');

Route::get('/cek-layanan', [App\Http\Controllers\PublicController::class, 'cekLayanan'])->name('public.cek-layanan');
Route::post('/cek-layanan', [App\Http\Controllers\PublicController::class, 'cekStatusLayanan'])->name('public.cek-layanan.check');

Route::get('/info-bantuan', [App\Http\Controllers\PublicController::class, 'infoBantuan'])->name('public.info-bantuan');

// Registrasi Penduduk with rate limiting
Route::get('/registrasi-penduduk', [App\Http\Controllers\PublicController::class, 'registrasiPenduduk'])->name('public.registrasi-penduduk');
Route::post('/registrasi-penduduk', [App\Http\Controllers\PublicController::class, 'storeRegistrasiPenduduk'])->name('public.registrasi-penduduk.store')->middleware(['throttle:10,1', 'web']); // 10 registrations per minute

// CSRF Token route
Route::get('/csrf-token', function() {
    return response()->json([
        'token' => csrf_token()
    ]);
});

// Test CSRF route
Route::post('/test-csrf', function(Request $request) {
    return response()->json([
        'success' => true,
        'message' => 'CSRF token is valid',
        'received_token' => $request->header('X-CSRF-TOKEN'),
        'form_token' => $request->input('_token')
    ]);
});

// Refresh session route
Route::get('/refresh-session', function() {
    request()->session()->regenerate();
    return response()->json([
        'success' => true,
        'message' => 'Session refreshed',
        'csrf_token' => csrf_token(),
        'session_id' => request()->session()->getId()
    ]);
});

// Admin session refresh route
Route::middleware(['auth', 'admin'])->group(function () {
    Route::get('/admin/refresh-session', function() {
        request()->session()->regenerate();
        return response()->json([
            'success' => true,
            'message' => 'Admin session refreshed',
            'csrf_token' => csrf_token(),
            'session_id' => request()->session()->getId(),
            'user_id' => \Illuminate\Support\Facades\Auth::check() ? \Illuminate\Support\Facades\Auth::id() : null
        ]);
    })->name('admin.refresh-session');
    
    // Route untuk handle form submission yang gagal karena CSRF
    Route::post('/admin/retry-form', function(\Illuminate\Http\Request $request) {
        try {
            // Get the original form data
            $formData = $request->input('form_data', []);
            $originalUrl = $request->input('original_url');
            
            if (!$originalUrl) {
                return response()->json([
                    'success' => false,
                    'message' => 'Original URL tidak ditemukan'
                ], 400);
            }
            
            // Regenerate session
            $request->session()->regenerate();
            
            return response()->json([
                'success' => true,
                'message' => 'Session refreshed, silakan coba submit form lagi',
                'csrf_token' => csrf_token(),
                'form_data' => $formData,
                'original_url' => $originalUrl
            ]);
            
        } catch (\Exception $e) {
            \Illuminate\Support\Facades\Log::error('Error in retry form route', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return response()->json([
                'success' => false,
                'message' => 'Terjadi kesalahan saat memproses request'
            ], 500);
        }
    })->name('admin.retry-form');
});

// Test route untuk debugging
Route::get('/test-registrasi', function() {
    return response()->json([
        'success' => true,
        'message' => 'Test route berfungsi'
    ]);
});

// Test CSRF route
Route::get('/test-csrf', function() {
    return response()->json([
        'success' => true,
        'csrf_token' => csrf_token(),
        'message' => 'CSRF token berhasil diambil'
    ]);
});

Route::post('/test-csrf', function() {
    return response()->json([
        'success' => true,
        'message' => 'CSRF token valid'
    ]);
});

// Test registrasi penduduk
Route::post('/test-registrasi-penduduk', function(Request $request) {
    try {
        // Log the request
        Log::info('Test registrasi penduduk', [
            'data' => $request->all(),
            'files' => $request->allFiles()
        ]);
        
        // Validate
        $validated = $request->validate([
            'nik' => 'required|string|size:16',
            'nama' => 'required|string|max:255',
            'alamat' => 'required|string',
            'tempat_lahir' => 'required|string',
            'tanggal_lahir' => 'required|date',
            'jenis_kelamin' => 'required|in:L,P',
            'status_perkawinan' => 'required|in:Belum Kawin,Kawin,Cerai Hidup,Cerai Mati',
            'agama' => 'required|string',
            'kewarganegaraan' => 'required|in:WNI,WNA',
        ]);
        
        // Check if NIK already exists
        $existingPenduduk = \App\Models\Penduduk::where('nik', $request->nik)->first();
        if ($existingPenduduk) {
            return response()->json([
                'success' => false,
                'message' => 'NIK sudah terdaftar'
            ], 422);
        }
        
        // Map status_perkawinan to status_kawin
        $validated['status_kawin'] = $validated['status_perkawinan'];
        unset($validated['status_perkawinan']);
        
        // Create penduduk
        $penduduk = \App\Models\Penduduk::create($validated);
        
        return response()->json([
            'success' => true,
            'message' => 'Test registrasi berhasil',
            'data' => $penduduk
        ]);
        
    } catch (\Exception $e) {
        Log::error('Test registrasi error', [
            'message' => $e->getMessage(),
            'trace' => $e->getTraceAsString()
        ]);
        
        return response()->json([
            'success' => false,
            'message' => 'Error: ' . $e->getMessage()
        ], 500);
    }
});

// Test database connection
Route::get('/test-db', function() {
    try {
        $count = \App\Models\Penduduk::count();
        return response()->json([
            'success' => true,
            'message' => 'Database connection OK',
            'penduduk_count' => $count
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'success' => false,
            'message' => 'Database error: ' . $e->getMessage()
        ], 500);
    }
});

// Test form submission
Route::post('/test-form', function(Request $request) {
    Log::info('Test form submission received', [
        'method' => $request->method(),
        'url' => $request->url(),
        'headers' => $request->headers->all(),
        'data' => $request->all(),
        'files' => $request->allFiles(),
        'is_ajax' => $request->ajax(),
        'wants_json' => $request->wantsJson()
    ]);
    
    return response()->json([
        'success' => true,
        'message' => 'Form submission test successful',
        'received_data' => $request->all()
    ]);
});

// Test route without CSRF - DISABLED FOR SECURITY
// Route::post('/test-no-csrf', function(Request $request) {
//     Log::info('Test no CSRF route received', [
//         'method' => $request->method(),
//         'data' => $request->all()
//     ]);
//     
//     return response()->json([
//         'success' => true,
//         'message' => 'No CSRF test successful',
//         'received_data' => $request->all()
//     ]);
// })->middleware('web')->withoutMiddleware(\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class);

// Debug CSRF route
Route::post('/debug-csrf', function(Request $request) {
    Log::info('Debug CSRF route received', [
        'method' => $request->method(),
        'headers' => $request->headers->all(),
        'data' => $request->all(),
        'csrf_token' => $request->header('X-CSRF-TOKEN'),
        'session_id' => $request->session()->getId()
    ]);
    
    return response()->json([
        'success' => true,
        'message' => 'CSRF debug successful',
        'csrf_token_received' => $request->header('X-CSRF-TOKEN'),
        'session_id' => $request->session()->getId()
    ]);
});

// Test registrasi without CSRF - DISABLED FOR SECURITY
// Route::post('/test-registrasi-no-csrf', function(Request $request) {
//     try {
//         Log::info('Test registrasi without CSRF received', [
//             'method' => $request->method(),
//             'data' => $request->all(),
//             'files' => $request->allFiles()
//         ]);
//         
//         // Validate
//         $validated = $request->validate([
//             'nik' => 'required|string|size:16',
//             'nama' => 'required|string|max:255',
//             'alamat' => 'required|string',
//             'tempat_lahir' => 'required|string',
//             'tanggal_lahir' => 'required|date',
//             'jenis_kelamin' => 'required|in:L,P',
//             'status_perkawinan' => 'required|in:Belum Kawin,Kawin,Cerai Hidup,Cerai Mati',
//             'agama' => 'required|string',
//             'kewarganegaraan' => 'required|in:WNI,WNA',
//         ]);
//         
//         // Check if NIK already exists
//         $existingPenduduk = \App\Models\Penduduk::where('nik', $request->nik)->first();
//         if ($existingPenduduk) {
//             return response()->json([
//                 'success' => false,
//                 'message' => 'NIK sudah terdaftar'
//             ], 422);
//         }
//         
//         // Map status_perkawinan to status_kawin
//         $validated['status_kawin'] = $validated['status_perkawinan'];
//         unset($validated['status_perkawinan']);
//         
//         // Create penduduk
//         $penduduk = \App\Models\Penduduk::create($validated);
//         
//         Log::info('Test registrasi without CSRF successful', [
//             'nik' => $penduduk->nik,
//             'nama' => $penduduk->nama
//         ]);
//         
//         return response()->json([
//             'success' => true,
//             'message' => 'Test registrasi without CSRF berhasil',
//             'data' => $penduduk
//         ]);
//         
//     } catch (\Exception $e) {
//         Log::error('Test registrasi without CSRF error', [
//             'message' => $e->getMessage(),
//             'trace' => $e->getTraceAsString()
//         ]);
//         
//         return response()->json([
//             'success' => false,
//             'message' => 'Error: ' . $e->getMessage()
//         ], 500);
//     }
// })->withoutMiddleware(\Illuminate\Foundation\Http\Middleware\VerifyCsrfToken::class);

// Layanan Mandiri
Route::get('/layanan-mandiri', function () {
    return view('frontend.layanan-mandiri');
})->name('public.layanan-mandiri');

// Dashboard Warga (after login)
Route::get('/dashboard-warga', function () {
    return view('frontend.dashboard-warga');
})->name('public.dashboard-warga');

// Dashboard Personal (warga data pribadi & riwayat layanan)
Route::get('/dashboard-personal', function () {
    return view('frontend.dashboard-personal');
})->name('public.dashboard-personal');

// Public UMKM & Products
Route::get('/produk-umkm', [App\Http\Controllers\PublicController::class, 'produkUmkm'])->name('public.produk-umkm');
Route::get('/produk/{slug}', [App\Http\Controllers\PublicController::class, 'detailProduk'])->name('public.detail-produk');

// Public Tourism & Destinations
Route::get('/wisata', [App\Http\Controllers\PublicController::class, 'wisata'])->name('public.wisata');
Route::get('/wisata/{slug}', [App\Http\Controllers\PublicController::class, 'detailWisata'])->name('public.detail-wisata');

// Tourism Ticket Booking
Route::post('/api/tiket-wisata', [App\Http\Controllers\PublicController::class, 'beliTiketWisata'])->name('api.beli-tiket');
Route::get('/pembayaran-tiket/{kode_booking}', [App\Http\Controllers\PublicController::class, 'pembayaranTiket'])->name('public.pembayaran-tiket');
Route::get('/tiket-saya/{kode_booking}', [App\Http\Controllers\PublicController::class, 'tiketSaya'])->name('public.tiket-saya');

// Checkout and Payment Routes
Route::get('/checkout', [App\Http\Controllers\CheckoutController::class, 'index'])->name('checkout.index');
Route::post('/checkout/process', [App\Http\Controllers\CheckoutController::class, 'process'])->name('checkout.process');
Route::post('/checkout/add-to-cart', [App\Http\Controllers\CheckoutController::class, 'addToCart'])->name('checkout.add-to-cart');
Route::get('/checkout/payment/{orderId}', [App\Http\Controllers\CheckoutController::class, 'payment'])->name('checkout.payment');
Route::get('/checkout/success', [App\Http\Controllers\CheckoutController::class, 'success'])->name('checkout.success');

// Tripay Callback Route (no middleware needed for callback)
Route::post('/tripay/callback', [App\Http\Controllers\TripayController::class, 'callback'])->name('tripay.callback');

// Payment Methods API
Route::get('/api/payment-methods/{type}', [App\Http\Controllers\PublicController::class, 'getPaymentMethods'])->name('api.payment-methods');

// Public News and Map
Route::get('/berita', [BeritaController::class, 'publicIndex'])->name('public.berita.index');
Route::get('/berita/{slug}', [BeritaController::class, 'publicShow'])->name('public.berita.show');
Route::get('/peta', [App\Http\Controllers\PublicController::class, 'peta'])->name('public.peta');

// Public Demographics
Route::get('/demografi', [DemografiController::class, 'index'])->name('public.demografi');
Route::get('/api/demografi-data', [DemografiController::class, 'apiData'])->name('api.demografi-data');

// PPOB Routes
Route::prefix('ppob')->name('ppob.')->group(function () {
    Route::get('/', [App\Http\Controllers\PpobController::class, 'index'])->name('index');
    Route::get('/product/{type}', [App\Http\Controllers\PpobController::class, 'product'])->name('product');
    Route::get('/denominations/{productType}', [App\Http\Controllers\PpobController::class, 'getDenominations'])->name('denominations');
    Route::post('/process', [App\Http\Controllers\PpobController::class, 'processTransaction'])->name('process');
    Route::get('/status/{orderId}', [App\Http\Controllers\PpobController::class, 'checkStatus'])->name('status');
    Route::get('/history', [App\Http\Controllers\PpobController::class, 'history'])->name('history');
    Route::get('/detail/{orderId}', [App\Http\Controllers\PpobController::class, 'detail'])->name('detail');
    
    // Payment callbacks
    Route::get('/payment/return', [App\Http\Controllers\PpobController::class, 'paymentReturn'])->name('payment.return');
    Route::post('/payment/callback', [App\Http\Controllers\PpobController::class, 'paymentCallback'])->name('payment.callback');
});

// Public Template Downloads
Route::get('/template/penduduk', [PendudukController::class, 'downloadTemplate'])->name('template.penduduk');

// Authentication Routes
Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login'])->middleware('throttle:5,1'); // 5 attempts per minute
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// CAPTCHA Routes - Direct Implementation
Route::get('/captcha', function() {
    try {
        $builder = new \Gregwar\Captcha\CaptchaBuilder();
        $builder->build();
        
        // Store CAPTCHA phrase in session
        session(['captcha_phrase' => $builder->getPhrase()]);
        
        return response($builder->get(), 200, [
            'Content-Type' => 'image/jpeg',
            'Cache-Control' => 'no-cache, no-store, must-revalidate',
            'Pragma' => 'no-cache',
            'Expires' => '0'
        ]);
    } catch (\Exception $e) {
        Log::error('CAPTCHA Error: ' . $e->getMessage());
        return response('Error generating CAPTCHA', 500);
    }
})->name('captcha');

Route::get('/captcha/portal', function() {
    try {
        $builder = new \Gregwar\Captcha\CaptchaBuilder();
        $builder->build();
        
        // Store CAPTCHA phrase in session
        session(['captcha_phrase' => $builder->getPhrase()]);
        
        return response($builder->get(), 200, [
            'Content-Type' => 'image/jpeg',
            'Cache-Control' => 'no-cache, no-store, must-revalidate',
            'Pragma' => 'no-cache',
            'Expires' => '0'
        ]);
    } catch (\Exception $e) {
        Log::error('Portal CAPTCHA Error: ' . $e->getMessage());
        return response('Error generating CAPTCHA', 500);
    }
})->name('captcha.portal');



// Registration (only for first time setup)
Route::get('/register', [AuthController::class, 'showRegistrationForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

// Profile Routes
Route::middleware('auth')->group(function () {
    Route::get('/profile', [AuthController::class, 'showProfile'])->name('profile');
    Route::put('/profile', [AuthController::class, 'updateProfile'])->name('profile.update');
});

// Admin root route (redirect ke login atau dashboard)
Route::get('/admin', function () {
    if (\Illuminate\Support\Facades\Auth::check()) {
        return redirect()->route('admin.dashboard');
    }
    return redirect()->route('login');
})->name('admin.home');

// Admin root route dengan trailing slash
Route::get('/admin/', function () {
    if (\Illuminate\Support\Facades\Auth::check()) {
        return redirect()->route('admin.dashboard');
    }
    return redirect()->route('login');
});

// Admin routes
Route::middleware(['auth', 'admin', 'admin.session'])->prefix('admin')->name('admin.')->group(function () {
    
    // Dashboard
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/dashboard/stats', [DashboardController::class, 'stats'])->name('dashboard.stats');
    
    // Data Penduduk - Routes spesifik harus sebelum resource routes
    Route::get('penduduk-test', [PendudukController::class, 'indexTest'])->name('penduduk.test');
    Route::post('penduduk/import', [PendudukController::class, 'import'])->name('penduduk.import');
    Route::get('penduduk/template', [PendudukController::class, 'downloadTemplate'])->name('penduduk.template');
            Route::get('penduduk/export', [PendudukController::class, 'export'])->name('penduduk.export');
    Route::post('penduduk/reverse-geocode', [PendudukController::class, 'reverseGeocode'])->name('penduduk.reverse-geocode');
    Route::get('peta-rumah', [PendudukController::class, 'petaRumah'])->name('penduduk.map');
    
    // Resource route untuk penduduk (harus setelah routes spesifik)
    Route::resource('penduduk', PendudukController::class);
    Route::get('penduduk/{penduduk}/map', [PendudukController::class, 'showMap'])->name('penduduk.detail-map');
    
    // Upload Image untuk Editor
    Route::post('/upload/image', [App\Http\Controllers\Admin\UploadController::class, 'uploadImage'])->name('upload.image');
    Route::get('/upload/images', [App\Http\Controllers\Admin\UploadController::class, 'getImages'])->name('upload.images');
    Route::delete('/upload/image', [App\Http\Controllers\Admin\UploadController::class, 'deleteImage'])->name('upload.image.delete');
    
    // Data Keluarga
    Route::resource('keluarga', KeluargaController::class);
    Route::get('keluarga/export/{format}', [KeluargaController::class, 'export'])->name('keluarga.export');
    Route::post('keluarga/import', [KeluargaController::class, 'import'])->name('keluarga.import');
    Route::get('keluarga/template', [KeluargaController::class, 'downloadTemplate'])->name('keluarga.template');
    Route::post('keluarga/{keluarga}/anggota', [KeluargaController::class, 'addAnggota'])->name('keluarga.anggota.add');
    Route::delete('keluarga/{keluarga}/anggota/{anggota}', [KeluargaController::class, 'removeAnggota'])->name('keluarga.anggota.remove');
    Route::put('keluarga/{keluarga}/anggota/{anggota}/hubungan', [KeluargaController::class, 'updateHubungan'])->name('keluarga.anggota.update-hubungan');
    Route::post('keluarga/reverse-geocode', [KeluargaController::class, 'reverseGeocode'])->name('keluarga.reverse-geocode');
    
    // Pohon Keluarga Multigenerasi
    Route::prefix('pohon-keluarga')->name('pohon-keluarga.')->group(function () {
        Route::get('/', [PohonKeluargaController::class, 'index'])->name('index');
        Route::get('/statistik', [PohonKeluargaController::class, 'statistik'])->name('statistik');
        Route::get('/search', [PohonKeluargaController::class, 'search'])->name('search');
        Route::get('/{nik}', [PohonKeluargaController::class, 'show'])->name('show');
        Route::get('/{nik}/edit', [PohonKeluargaController::class, 'edit'])->name('edit');
        Route::put('/{nik}', [PohonKeluargaController::class, 'update'])->name('update');
        Route::get('/{nik}/visualisasi', [PohonKeluargaController::class, 'visualisasi'])->name('visualisasi');
        Route::get('/{nik}/api-tree-data', [PohonKeluargaController::class, 'apiTreeData'])->name('api-tree-data');
    });
    
    // Mutasi Penduduk (Riwayat Lahir, Meninggal, Pindah)
    Route::resource('mutasi-penduduk', MutasiPendudukController::class);
    Route::get('mutasi-penduduk/statistik', [MutasiPendudukController::class, 'statistik'])->name('mutasi-penduduk.statistik');
    Route::get('mutasi-penduduk/api/data', [MutasiPendudukController::class, 'apiData'])->name('mutasi-penduduk.api.data');
    Route::get('mutasi-penduduk/api/statistik', [MutasiPendudukController::class, 'apiStatistik'])->name('mutasi-penduduk.api.statistik');
    
    // Pelayanan Surat
    Route::resource('pelayanan-surat', PelayananSuratController::class);
    Route::post('pelayanan-surat/{pelayananSurat}/assign-template', [PelayananSuratController::class, 'assignTemplate'])->name('pelayanan-surat.assign-template');
    Route::post('pelayanan-surat/{pelayananSurat}/generate', [PelayananSuratController::class, 'generateSurat'])->name('pelayanan-surat.generate');
    Route::post('pelayanan-surat/{pelayananSurat}/upload-pdf', [PelayananSuratController::class, 'uploadPdf'])->name('pelayanan-surat.upload-pdf');
    Route::get('pelayanan-surat/{pelayananSurat}/download', [PelayananSuratController::class, 'downloadPdf'])->name('pelayanan-surat.download');
    Route::post('pelayanan-surat/{pelayananSurat}/status', [PelayananSuratController::class, 'updateStatus'])->name('pelayanan-surat.update-status');
    Route::post('pelayanan-surat/{pelayananSurat}/send-wa', [PelayananSuratController::class, 'sendWhatsApp'])->name('pelayanan-surat.send-wa');
    
    // Pengaduan
    Route::resource('pengaduan', PengaduanController::class);
    Route::put('pengaduan/{pengaduan}/tanggapi', [PengaduanController::class, 'tanggapi'])->name('pengaduan.tanggapi');
    
    // Bantuan Sosial
    Route::resource('bantuan', BantuanController::class);
    Route::put('bantuan/{bantuan}/distribusi', [BantuanController::class, 'distribusi'])->name('bantuan.distribusi');
    Route::get('bantuan/import/form', [BantuanController::class, 'importForm'])->name('bantuan.import.form');
    Route::post('bantuan/import', [BantuanController::class, 'import'])->name('bantuan.import');
    Route::get('bantuan/laporan', [BantuanController::class, 'laporan'])->name('bantuan.laporan');
    
    // Berita
    Route::resource('berita', BeritaController::class)->parameters(['berita' => 'berita']);
    Route::post('berita/auto-save', [BeritaController::class, 'autoSave'])->name('berita.auto-save');
    Route::post('berita/{berita}/publish', [BeritaController::class, 'publish'])->name('berita.publish');
    Route::post('berita/{berita}/unpublish', [BeritaController::class, 'unpublish'])->name('berita.unpublish');
    Route::post('berita/{berita}/increment-views', [BeritaController::class, 'incrementViews'])->name('berita.increment-views');
    
    // Berita Comments
    Route::get('berita/{berita}/comments', [BeritaController::class, 'showComments'])->name('berita.comments');
    Route::post('berita/{berita}/comments/{comment}/approve', [BeritaController::class, 'approveComment'])->name('berita.comments.approve');
    Route::post('berita/{berita}/comments/{comment}/reject', [BeritaController::class, 'rejectComment'])->name('berita.comments.reject');
    Route::delete('berita/{berita}/comments/{comment}', [BeritaController::class, 'deleteComment'])->name('berita.comments.delete');
    
    // Peta Rumah
    Route::prefix('peta')->name('peta.')->group(function () {
        Route::get('/', [PetaController::class, 'index'])->name('index');
        Route::get('/{nik}', [PetaController::class, 'show'])->name('show');
    });
    
    // Laporan
    Route::prefix('laporan')->name('laporan.')->group(function () {
        Route::get('penduduk', [DashboardController::class, 'laporanPenduduk'])->name('penduduk');
        Route::get('pelayanan', [DashboardController::class, 'laporanPelayanan'])->name('pelayanan');
        Route::get('bantuan', [DashboardController::class, 'laporanBantuan'])->name('bantuan');
    });
    
    // Notifikasi WhatsApp
    Route::get('notifikasi/wa', [DashboardController::class, 'notifikasiWa'])->name('notifikasi.wa');
    Route::get('notifikasi-wa', [DashboardController::class, 'notifikasiWa'])->name('notifikasi-wa');


    
    // API routes for AJAX notifications
    Route::prefix('api')->name('api.')->group(function () {
        Route::get('notifications/whatsapp', [DashboardController::class, 'apiGetNotifications'])->name('notifications.whatsapp');
        Route::get('notifications/check-new', [DashboardController::class, 'apiCheckNewNotifications'])->name('notifications.check-new');
        Route::post('notifications/{id}/read', [DashboardController::class, 'apiMarkAsRead'])->name('notifications.read');
        Route::post('notifications/{id}/resend', [DashboardController::class, 'apiResendMessage'])->name('notifications.resend');
        Route::post('notifications/{id}/broadcast', [DashboardController::class, 'apiBroadcastMessage'])->name('notifications.broadcast');
        Route::post('notifications/send-custom', [DashboardController::class, 'apiSendCustomMessage'])->name('notifications.send-custom');
    });
    
    // Pengaturan Desa
    Route::prefix('pengaturan')->name('pengaturan.')->group(function () {
        Route::get('/', [SettingController::class, 'index'])->name('index');
        Route::put('/', [SettingController::class, 'update'])->name('update');
        Route::post('/upload-logo', [SettingController::class, 'uploadLogo'])->name('upload-logo');
        Route::delete('/delete-logo', [SettingController::class, 'deleteLogo'])->name('delete-logo');
        Route::post('/test-tripay', [SettingController::class, 'testTripay'])->name('test-tripay');
        Route::post('/test-ottopay', [SettingController::class, 'testOttopay'])->name('test-ottopay');
    });
    
    // Role Management
    Route::resource('roles', RoleController::class);
    Route::put('roles/{role}/toggle-status', [RoleController::class, 'toggleStatus'])->name('roles.toggle-status');
    
    // User Management  
    Route::resource('users', UserController::class);
    Route::put('users/{user}/toggle-status', [UserController::class, 'toggleStatus'])->name('users.toggle-status');
    Route::put('users/{user}/reset-password', [UserController::class, 'resetPassword'])->name('users.reset-password');
    
    // APBDes (Keuangan Desa)
    Route::prefix('apbdes')->name('apbdes.')->group(function () {
        Route::get('rencana', [ApbdesController::class, 'indexRencana'])->name('rencana.index');
        Route::post('rencana', [ApbdesController::class, 'storeRencana'])->name('rencana.store');
        Route::get('rencana/{id}', [ApbdesController::class, 'showRencana'])->name('rencana.show');
        Route::put('rencana/{id}', [ApbdesController::class, 'updateRencana'])->name('rencana.update');
        Route::delete('rencana/{id}', [ApbdesController::class, 'destroyRencana'])->name('rencana.destroy');
        
        Route::get('realisasi', [ApbdesController::class, 'indexRealisasi'])->name('realisasi.index');
        Route::post('realisasi', [ApbdesController::class, 'storeRealisasi'])->name('realisasi.store');
        Route::put('realisasi/{id}/verify', [ApbdesController::class, 'verifyRealisasi'])->name('realisasi.verify');
        Route::delete('realisasi/{id}', [ApbdesController::class, 'destroyRealisasi'])->name('realisasi.destroy');
        
        Route::get('laporan', [ApbdesController::class, 'laporanAnggaran'])->name('laporan');
    });
    
    // Kegiatan Pembangunan
    Route::resource('kegiatan-pembangunan', KegiatanPembangunanController::class);
    Route::put('kegiatan-pembangunan/{id}/progres', [KegiatanPembangunanController::class, 'updateProgres'])->name('kegiatan-pembangunan.progres');
    Route::get('kegiatan-pembangunan-statistik', [KegiatanPembangunanController::class, 'statistik'])->name('kegiatan-pembangunan.statistik');
    
    // Struktur Organisasi
    Route::resource('struktur-organisasi', StrukturOrganisasiController::class);
    Route::get('struktur-organisasi/kategori/{kategori}', [StrukturOrganisasiController::class, 'byKategori'])->name('struktur-organisasi.kategori');
    Route::get('perangkat-desa', [StrukturOrganisasiController::class, 'perangkatDesa'])->name('struktur-organisasi.perangkat-desa');
    Route::put('struktur-organisasi/{id}/nonaktifkan', [StrukturOrganisasiController::class, 'nonaktifkan'])->name('struktur-organisasi.nonaktifkan');
    Route::put('struktur-organisasi/{id}/aktifkan', [StrukturOrganisasiController::class, 'aktifkan'])->name('struktur-organisasi.aktifkan');
    Route::get('struktur-organisasi-statistik', [StrukturOrganisasiController::class, 'statistik'])->name('struktur-organisasi.statistik');
    
    // Wilayah Administratif
    Route::resource('wilayah-administratif', WilayahAdministratifController::class);
    Route::get('wilayah-administratif/jenis/{jenis}', [WilayahAdministratifController::class, 'byJenis'])->name('wilayah-administratif.jenis');
    Route::get('wilayah-tree', [WilayahAdministratifController::class, 'treeStructure'])->name('wilayah-administratif.tree');
    Route::get('wilayah-statistik', [WilayahAdministratifController::class, 'statistik'])->name('wilayah-administratif.statistik');
    Route::put('wilayah-administratif/{id}/update-statistik', [WilayahAdministratifController::class, 'updateStatistik'])->name('wilayah-administratif.update-statistik');
    Route::post('wilayah-administratif/sync', [WilayahAdministratifController::class, 'sync'])->name('wilayah-administratif.sync');
    Route::get('dusun-rw-rt', [WilayahAdministratifController::class, 'dusunWithRwRt'])->name('wilayah-administratif.dusun-rw-rt');
    
    // UMKM & Ekonomi Desa
    Route::resource('umkm', UmkmController::class);
    Route::put('umkm/{umkm}/verify', [UmkmController::class, 'verify'])->name('umkm.verify');
    Route::put('umkm/{umkm}/toggle-marketplace', [UmkmController::class, 'toggleMarketplace'])->name('umkm.toggle-marketplace');
    Route::get('umkm-statistik', [UmkmController::class, 'statistik'])->name('umkm.statistik');
    Route::get('umkm-laporan', [UmkmController::class, 'laporan'])->name('umkm.laporan');
    
    // UMKM Images - Special routes for shared hosting compatibility
    Route::get('umkm/logo/{filename}', function($filename) {
        $path = storage_path('app/public/umkm/logo/' . $filename);
        if (file_exists($path)) {
            return response()->file($path);
        }
        return response()->file(public_path('images/default-umkm-logo.png'));
    })->name('umkm.logo');
    
    Route::get('umkm/galeri/{filename}', function($filename) {
        $path = storage_path('app/public/umkm/galeri/' . $filename);
        if (file_exists($path)) {
            return response()->file($path);
        }
        return response()->file(public_path('images/default-umkm-logo.png'));
    })->name('umkm.gallery');
    
    Route::resource('produk-umkm', ProdukUmkmController::class);
    Route::put('produk-umkm/{produk}/toggle-status', [ProdukUmkmController::class, 'toggleStatus'])->name('produk-umkm.toggle-status');
    Route::put('produk-umkm/{produk}/toggle-featured', [ProdukUmkmController::class, 'toggleFeatured'])->name('produk-umkm.toggle-featured');
    
    Route::get('marketplace', [MarketplaceController::class, 'index'])->name('marketplace.index');
    Route::get('marketplace/kategori/{kategori}', [MarketplaceController::class, 'kategori'])->name('marketplace.kategori');
    Route::get('marketplace/produk/{slug}', [MarketplaceController::class, 'show'])->name('marketplace.show');
    Route::get('marketplace/settings', [MarketplaceController::class, 'pengaturan'])->name('marketplace.settings');
    Route::put('marketplace/settings', [MarketplaceController::class, 'updatePengaturan'])->name('marketplace.settings.update');
    Route::get('marketplace/export', [MarketplaceController::class, 'exportLaporan'])->name('marketplace.export');
    
    // Pariwisata Desa
    Route::resource('objek-wisata', ObjekWisataController::class)->parameters(['objek-wisata' => 'objek_wisata']);
    Route::put('objek-wisata/{objek_wisata}/toggle-status', [ObjekWisataController::class, 'toggleStatus'])->name('objek-wisata.toggle-status');
    Route::put('objek-wisata/{objek_wisata}/toggle-featured', [ObjekWisataController::class, 'toggleFeatured'])->name('objek-wisata.toggle-featured');
    Route::get('objek-wisata-statistik', [ObjekWisataController::class, 'statistik'])->name('objek-wisata.statistik');
    
    Route::resource('tiket-wisata', TiketWisataController::class);
    Route::put('tiket-wisata/{tiket}/verify', [TiketWisataController::class, 'verify'])->name('tiket-wisata.verify');
    Route::post('tiket-wisata/{tiket}/check-in', [TiketWisataController::class, 'checkIn'])->name('tiket-wisata.check-in');
    Route::post('tiket-wisata/{tiket}/check-out', [TiketWisataController::class, 'checkOut'])->name('tiket-wisata.check-out');
    Route::get('tiket-wisata/{tiket}/qr-code', [TiketWisataController::class, 'generateQrCode'])->name('tiket-wisata.qr-code');
    
    Route::get('wisata/statistik', [ObjekWisataController::class, 'statistikKunjungan'])->name('wisata.statistik');
    Route::get('wisata/laporan', [ObjekWisataController::class, 'laporanWisata'])->name('wisata.laporan');
    
    // Transaksi & Pembayaran (Tripay Integration)
    Route::resource('transaksi', TransaksiController::class);
    Route::get('transaksi/pending', [TransaksiController::class, 'pending'])->name('transaksi.pending');
    Route::get('transaksi/success', [TransaksiController::class, 'success'])->name('transaksi.success');
    Route::get('transaksi/laporan', [TransaksiController::class, 'laporan'])->name('transaksi.laporan');
    Route::get('transaksi/export', [TransaksiController::class, 'export'])->name('transaksi.export');
    Route::get('transaksi/sync', [TransaksiController::class, 'sync'])->name('transaksi.sync');
    Route::post('transaksi/{transaksi}/refund', [TransaksiController::class, 'refund'])->name('transaksi.refund');
    Route::put('transaksi/{transaksi}/verify', [TransaksiController::class, 'verify'])->name('transaksi.verify');
    
    // Template Surat Routes
    Route::resource('template-surat', TemplateSuratController::class);
    Route::post('template-surat/{templateSurat}/preview', [TemplateSuratController::class, 'preview'])->name('template-surat.preview');
    Route::post('template-surat/{templateSurat}/duplicate', [TemplateSuratController::class, 'duplicate'])->name('template-surat.duplicate');
    Route::post('template-surat/bulk-activate', [TemplateSuratController::class, 'bulkActivate'])->name('template-surat.bulk-activate');
    Route::post('template-surat/bulk-deactivate', [TemplateSuratController::class, 'bulkDeactivate'])->name('template-surat.bulk-deactivate');
    
    // PBB (Pajak Bumi dan Bangunan) Routes
    Route::resource('pbb', PbbController::class);
    Route::get('pbb/{pbb}/sppt', [PbbController::class, 'cetakSppt'])->name('pbb.sppt');
    Route::post('pbb/{pbb}/bayar', [PbbController::class, 'prosesBayar'])->name('pbb.bayar');
    Route::get('pbb/tagihan/bulk-generate/{tahun}', [PbbController::class, 'bulkGenerateTagihan'])->name('pbb.bulk-generate');
    Route::get('pbb/laporan/tunggakan', [PbbController::class, 'laporanTunggakan'])->name('pbb.laporan-tunggakan');
    Route::get('pbb/statistik', [PbbController::class, 'statistik'])->name('pbb.statistik');
    
    // Polling/Voting Routes
    Route::resource('polling', PollingController::class);
    Route::post('polling/{polling}/activate', [PollingController::class, 'activate'])->name('polling.activate');
    Route::post('polling/{polling}/deactivate', [PollingController::class, 'deactivate'])->name('polling.deactivate');
    Route::get('polling/{polling}/hasil', [PollingController::class, 'hasil'])->name('polling.hasil');
    Route::get('polling/{polling}/export', [PollingController::class, 'exportHasil'])->name('polling.export');
    Route::get('polling/{polling}/reset', [PollingController::class, 'resetVotes'])->name('polling.reset');
    
    // Perangkat Desa Routes
    Route::resource('perangkat-desa', PerangkatDesaController::class);
    Route::get('perangkat-desa/{perangkatDesa}/cetak-sk', [PerangkatDesaController::class, 'cetakSk'])->name('perangkat-desa.cetak-sk');
    Route::post('perangkat-desa/{perangkatDesa}/activate', [PerangkatDesaController::class, 'activate'])->name('perangkat-desa.activate');
    Route::post('perangkat-desa/{perangkatDesa}/deactivate', [PerangkatDesaController::class, 'deactivate'])->name('perangkat-desa.deactivate');
    Route::post('perangkat-desa/{perangkatDesa}/update-status', [PerangkatDesaController::class, 'updateStatus'])->name('perangkat-desa.update-status');
    Route::get('perangkat-desa/struktur/organisasi', [PerangkatDesaController::class, 'strukturOrganisasi'])->name('perangkat-desa.struktur');
    Route::post('perangkat-desa/struktur/update', [PerangkatDesaController::class, 'updateStruktur'])->name('perangkat-desa.update-struktur');
    
    // Agenda Desa Routes
    Route::resource('agenda-desa', AgendaDesaController::class);
    Route::get('agenda-desa/calendar/view', [AgendaDesaController::class, 'calendar'])->name('agenda-desa.calendar');
    Route::get('agenda-desa/calendar/events', [AgendaDesaController::class, 'getEvents'])->name('agenda-desa.events');
    Route::post('agenda-desa/{agendaDesa}/reminder', [AgendaDesaController::class, 'setReminder'])->name('agenda-desa.reminder');
    Route::post('agenda-desa/{agendaDesa}/complete', [AgendaDesaController::class, 'markComplete'])->name('agenda-desa.complete');
    Route::get('agenda-desa/upcoming/all', [AgendaDesaController::class, 'upcomingEvents'])->name('agenda-desa.upcoming');
    
    // Inventaris Desa Routes
    Route::resource('inventaris-desa', InventarisDesaController::class);
    Route::get('inventaris-desa/{inventarisDesa}/qr-code', [InventarisDesaController::class, 'qrCode'])->name('inventaris-desa.qr-code');
    Route::post('inventaris-desa/scan-qr', [InventarisDesaController::class, 'scanQr'])->name('inventaris-desa.scan-qr');
    Route::post('inventaris-desa/{inventarisDesa}/maintenance', [InventarisDesaController::class, 'maintenance'])->name('inventaris-desa.maintenance');
    Route::post('inventaris-desa/{inventarisDesa}/update-nilai', [InventarisDesaController::class, 'updateNilai'])->name('inventaris-desa.update-nilai');
    Route::get('inventaris-desa/statistik/view', [InventarisDesaController::class, 'statistik'])->name('inventaris-desa.statistik');
    Route::post('inventaris-desa/bulk-update-kondisi', [InventarisDesaController::class, 'bulkUpdateKondisi'])->name('inventaris-desa.bulk-update-kondisi');
    Route::get('inventaris-desa/export/{format}', [InventarisDesaController::class, 'export'])->name('inventaris-desa.export');
    
    // Arsip Surat Keluar Routes
    Route::resource('arsip-surat-keluar', ArsipSuratKeluarController::class);
    Route::get('arsip-surat-keluar/{arsipSuratKeluar}/download', [ArsipSuratKeluarController::class, 'download'])->name('arsip-surat-keluar.download');
    Route::get('arsip-surat-keluar/statistik/view', [ArsipSuratKeluarController::class, 'statistik'])->name('arsip-surat-keluar.statistik');
    Route::get('arsip-surat-keluar/register/cetak', [ArsipSuratKeluarController::class, 'cetakRegister'])->name('arsip-surat-keluar.register');
    
    // Enhanced PelayananSurat Routes (existing with additions)
    Route::get('surat/{pelayananSurat}/template-preview', [PelayananSuratController::class, 'templatePreview'])->name('surat.template-preview');
    Route::post('surat/{pelayananSurat}/generate-qr', [PelayananSuratController::class, 'generateQr'])->name('surat.generate-qr');
    Route::post('surat/{pelayananSurat}/tanda-tangan', [PelayananSuratController::class, 'tandaTangan'])->name('surat.tanda-tangan');
    Route::get('surat/{pelayananSurat}/arsip', [PelayananSuratController::class, 'arsipkan'])->name('surat.arsip');
    Route::post('surat/verify-qr', [PelayananSuratController::class, 'verifyQr'])->name('surat.verify-qr');
    
    // Bug Detection & Monitoring Routes
    Route::prefix('bugs')->name('bugs.')->group(function () {
        Route::get('/', [BugController::class, 'index'])->name('index');
        Route::get('/dashboard', [BugController::class, 'dashboard'])->name('dashboard');
        Route::get('/create', [BugController::class, 'create'])->name('create');
        Route::post('/', [BugController::class, 'store'])->name('store');
        Route::get('/{bug}', [BugController::class, 'show'])->name('show');
        Route::put('/{bug}', [BugController::class, 'update'])->name('update');
        Route::delete('/{bug}', [BugController::class, 'destroy'])->name('destroy');
        Route::post('/bulk-resolve', [BugController::class, 'bulkResolve'])->name('bulk-resolve');
        Route::get('/export/csv', [BugController::class, 'export'])->name('export');
        Route::get('/statistics', [BugController::class, 'statistics'])->name('statistics');
        Route::get('/health-check', function() {
            return response()->json(\App\Services\BugDetectionService::healthCheck());
        })->name('health-check');
    });

    // PPOB Management Routes
    Route::prefix('ppob')->name('ppob.')->group(function () {
        Route::get('/', [\App\Http\Controllers\Admin\PpobController::class, 'index'])->name('index');
        Route::get('/settings', [\App\Http\Controllers\Admin\PpobController::class, 'settings'])->name('settings');
        Route::post('/settings', [\App\Http\Controllers\Admin\PpobController::class, 'updateSettings'])->name('settings.update');
        Route::get('/transaction/{id}', [\App\Http\Controllers\Admin\PpobController::class, 'showTransaction'])->name('transaction.show');
        Route::post('/transaction/{id}/retry', [\App\Http\Controllers\Admin\PpobController::class, 'retryTransaction'])->name('transaction.retry');
        Route::get('/export', [\App\Http\Controllers\Admin\PpobController::class, 'exportTransactions'])->name('export');
    });
    
    // Password Management Routes
    Route::post('penduduk/{penduduk}/generate-password', [PendudukController::class, 'generatePassword'])->name('penduduk.generate-password');
    Route::post('penduduk/{penduduk}/reset-password', [PendudukController::class, 'resetPassword'])->name('penduduk.reset-password');
    Route::post('penduduk/{penduduk}/set-password', [PendudukController::class, 'setPassword'])->name('penduduk.set-password');
    Route::post('penduduk/{penduduk}/force-password-change', [PendudukController::class, 'forcePasswordChange'])->name('penduduk.force-password-change');
    
    // Bulk Password Generation Routes
    Route::post('penduduk/bulk-password-preview', [PendudukController::class, 'bulkPasswordPreview'])->name('penduduk.bulk-password-preview');
    Route::post('penduduk/bulk-password-generate', [PendudukController::class, 'bulkPasswordGenerate'])->name('penduduk.bulk-password-generate');
});

// Public routes untuk polling dan verifikasi
Route::get('polling/{polling}/vote', [PollingController::class, 'showVoteForm'])->name('polling.vote');
Route::post('polling/{polling}/vote', [PollingController::class, 'submitVote'])->name('polling.submit-vote');
Route::get('polling/{polling}/results', [PollingController::class, 'publicResults'])->name('polling.public-results');

// Public route untuk verifikasi surat
Route::get('surat/verify/{qr_code}', [PelayananSuratController::class, 'publicVerifyQr'])->name('surat.public-verify');

// API Routes untuk mobile dan external integration  
Route::prefix('api/v1')->name('api.')->group(function () {
    
    // Auth routes untuk API
    Route::post('login', [ApiAuthController::class, 'login'])->name('login');
    Route::post('logout', [ApiAuthController::class, 'logout'])->middleware('auth:sanctum')->name('logout');
    
    Route::middleware('auth:sanctum')->group(function () {
        
        // Penduduk API
        Route::apiResource('penduduk', PendudukController::class);
        Route::get('penduduk/{penduduk}/mutasi', [PendudukController::class, 'getMutasi'])->name('penduduk.mutasi');
        Route::post('penduduk/{penduduk}/mutasi', [PendudukController::class, 'createMutasi'])->name('penduduk.create-mutasi');
        
        // Pelayanan Surat API
        Route::apiResource('surat', PelayananSuratController::class);
        Route::get('surat/{surat}/status', [PelayananSuratController::class, 'getStatus'])->name('surat.status');
        Route::post('surat/{surat}/upload-persyaratan', [PelayananSuratController::class, 'uploadPersyaratan'])->name('surat.upload-persyaratan');
        
        // Template Surat API
        Route::get('template-surat', [TemplateSuratController::class, 'apiIndex'])->name('template-surat.index');
        Route::get('template-surat/{templateSurat}', [TemplateSuratController::class, 'apiShow'])->name('template-surat.show');
        
        // PBB API
        Route::get('pbb', [PbbController::class, 'apiIndex'])->name('pbb.index');
        Route::get('pbb/{pbb}', [PbbController::class, 'apiShow'])->name('pbb.show');
        Route::get('pbb/{pbb}/tagihan', [PbbController::class, 'getTagihan'])->name('pbb.tagihan');
        
        // Polling API
        Route::get('polling', [PollingController::class, 'apiIndex'])->name('polling.index');
        Route::get('polling/{polling}', [PollingController::class, 'apiShow'])->name('polling.show');
        Route::post('polling/{polling}/vote', [PollingController::class, 'apiVote'])->name('polling.vote');
        
        // Agenda Desa API
        Route::get('agenda', [AgendaDesaController::class, 'apiIndex'])->name('agenda.index');
        Route::get('agenda/{agendaDesa}', [AgendaDesaController::class, 'apiShow'])->name('agenda.show');
        Route::get('agenda/upcoming/{days?}', [AgendaDesaController::class, 'apiUpcoming'])->name('agenda.upcoming');
        
        // Inventaris API
        Route::get('inventaris', [InventarisDesaController::class, 'apiIndex'])->name('inventaris.index');
        Route::get('inventaris/{inventarisDesa}', [InventarisDesaController::class, 'apiShow'])->name('inventaris.show');
        Route::post('inventaris/scan-qr', [InventarisDesaController::class, 'apiScanQr'])->name('inventaris.scan-qr');
        
        // Perangkat Desa API
        Route::get('perangkat', [PerangkatDesaController::class, 'apiIndex'])->name('perangkat.index');
        Route::get('perangkat/struktur', [PerangkatDesaController::class, 'apiStruktur'])->name('perangkat.struktur');
        
        // Statistics API
        Route::get('statistics/dashboard', [DashboardController::class, 'apiStatistics'])->name('statistics.dashboard');
        Route::get('statistics/penduduk', [PendudukController::class, 'apiStatistics'])->name('statistics.penduduk');
        Route::get('statistics/surat', [PelayananSuratController::class, 'apiStatistics'])->name('statistics.surat');
        Route::get('statistics/pbb', [PbbController::class, 'apiStatistics'])->name('statistics.pbb');
        
    });
});

// Alias untuk frontend modern (tanpa root conflict)
Route::get('/frontend', function () {
    return view('frontend.index');
});

Route::get('/modern', function () {
    return view('frontend.index');
});

// API Routes untuk data dinamis
Route::prefix('api')->group(function () {
    
    // Debug route for template-surat
    Route::get('test-templates', function () {
        try {
            $templates = \App\Models\TemplateSurat::all(['id', 'nama_template', 'jenis_surat', 'aktif']);
            return response()->json([
                'success' => true,
                'count' => $templates->count(),
                'data' => $templates
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ], 500);
        }
    });
    
    // Template Surat API (public, no auth required)
    Route::get('template-surat', [TemplateSuratController::class, 'apiIndex']);
    Route::get('template-surat/{templateSurat}', [TemplateSuratController::class, 'apiShow']);
    
    Route::get('/stats', function () {
        $stats = [
            'total_penduduk' => \App\Models\Penduduk::count(),
            'total_keluarga' => \App\Models\Penduduk::distinct('no_kk')->count('no_kk'),
            'total_surat' => \App\Models\PelayananSurat::count(),
            'total_pengaduan' => \App\Models\Pengaduan::count(),
            'surat_pending' => \App\Models\PelayananSurat::where('status', 'Menunggu')->count(),
            'pengaduan_baru' => \App\Models\Pengaduan::where('status', 'Baru')->count()
        ];
        
        return response()->json([
            'success' => true,
            'data' => [
                'total_penduduk' => number_format($stats['total_penduduk']),
                'total_keluarga' => number_format($stats['total_keluarga']),
                'total_surat' => number_format($stats['total_surat']),
                'total_pengaduan' => number_format($stats['total_pengaduan']),
                'surat_pending' => number_format($stats['surat_pending']),
                'pengaduan_baru' => number_format($stats['pengaduan_baru'])
            ]
        ]);
    });
    
    Route::post('/submit-service', function () {
        return response()->json([
            'success' => true,
            'message' => 'Pengajuan berhasil dikirim'
        ]);
    });
});

// Portal Warga Routes - with proper CSRF handling
Route::group(['middleware' => ['web']], function () {
    Route::get('portal/dashboard', [\App\Http\Controllers\Api\PortalWargaController::class, 'dashboardWeb'])->name('portal.dashboard');
    Route::get('dashboard-warga', function() {
        return view('frontend.dashboard-warga');
    })->name('dashboard.warga');
    Route::get('profil-warga', function() {
        return view('frontend.profil-warga');
    })->name('profil.warga');
    Route::get('surat-online', function() {
        return view('frontend.surat-online');
    })->name('surat.online');
    Route::post('portal/set-session', [\App\Http\Controllers\Api\PortalWargaController::class, 'setSession'])->name('portal.set-session');
    Route::post('portal/logout', [\App\Http\Controllers\Api\PortalWargaController::class, 'logoutWeb'])->name('portal.logout');
    
    // Test route for debugging
    Route::post('portal/test', function(\Illuminate\Http\Request $request) {
        try {
            return response()->json([
                'success' => true,
                'message' => 'CSRF and routing working',
                'session_id' => $request->session()->getId(),
                'csrf_token' => csrf_token(),
                'request_token' => $request->header('X-CSRF-TOKEN'),
                'timestamp' => now(),
                'method' => $request->method(),
                'url' => $request->url()
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ], 500);
        }
    })->name('portal.test');
});

// Debug routes (hanya untuk development)
if (app()->environment('local')) {
    Route::get('/debug/import-test', function() {
        $filePath = public_path('test_import.csv');
        
        if (!file_exists($filePath)) {
            return response()->json(['error' => 'File test tidak ditemukan']);
        }
        
        try {
            $controller = new \App\Http\Controllers\PendudukController();
            $reflection = new \ReflectionClass($controller);
            $method = $reflection->getMethod('readExcelFile');
            $method->setAccessible(true);
            
            $data = $method->invoke($controller, $filePath);
            
            return response()->json([
                'success' => true,
                'rows' => count($data),
                'sample_data' => array_slice($data, 0, 2),
                'headers' => !empty($data) ? array_keys($data[0]) : []
            ]);
            
        } catch (\Exception $e) {
            return response()->json([
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
        }
    });
    
    Route::get('/debug/session', function() {
        return response()->json([
            'session_data' => session()->all(),
            'flash_data' => [
                'success' => session('success'),
                'error' => session('error'),
                'import_errors' => session('import_errors')
            ]
        ]);
    });


}

// Public surat validation routes
Route::get('/validasi-surat/{encoded}', [\App\Http\Controllers\PublicController::class, 'validateSurat'])->name('validasi-surat');
Route::post('/validasi-qr', [\App\Http\Controllers\PublicController::class, 'validateQrCode'])->name('validasi-qr');

// API Routes for Wilayah Administratif
Route::prefix('api/wilayah')->group(function () {
    Route::get('/dusun', function () {
        try {
            $dusunList = \App\Models\WilayahAdministratif::where('jenis_wilayah', 'dusun')
                ->where('status', 'aktif')
                ->orderBy('urutan_tampil', 'asc')
                ->get(['id', 'nama_wilayah']);
                
            return response()->json([
                'success' => true,
                'data' => $dusunList
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Gagal memuat data dusun',
                'error' => $e->getMessage()
            ], 500);
        }
    });
    
    Route::get('/rw/{dusunId}', function ($dusunId) {
        try {
            $rwList = \App\Models\WilayahAdministratif::where('jenis_wilayah', 'rw')
                ->where('status', 'aktif')
                ->where('parent_id', $dusunId)
                ->orderBy('urutan_tampil', 'asc')
                ->get(['id', 'nama_wilayah']);
                
            return response()->json([
                'success' => true,
                'data' => $rwList
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Gagal memuat data RW',
                'error' => $e->getMessage()
            ], 500);
        }
    });
    
    Route::get('/rt/{rwId}', function ($rwId) {
        try {
            $rtList = \App\Models\WilayahAdministratif::where('jenis_wilayah', 'rt')
                ->where('status', 'aktif')
                ->where('parent_id', $rwId)
                ->orderBy('urutan_tampil', 'asc')
                ->get(['id', 'nama_wilayah']);
                
            return response()->json([
                'success' => true,
                'data' => $rtList
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Gagal memuat data RT',
                'error' => $e->getMessage()
            ], 500);
        }
    });
});
