<?php $__env->startSection('title', 'Detail Berita - ' . $berita->judul); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.berita.index')); ?>">Berita</a></li>
    <li class="breadcrumb-item active"><?php echo e(Str::limit($berita->judul, 30)); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <div>
        <h2 class="mb-2">
            <i class="fas fa-newspaper me-2 text-warning"></i>
            Detail Berita
        </h2>
        <p class="text-muted mb-0">Lihat dan kelola detail berita</p>
    </div>
    <div>
        <a href="<?php echo e(route('admin.berita.index')); ?>" class="btn btn-outline-secondary me-2">
            <i class="fas fa-arrow-left me-2"></i>
            Kembali
        </a>
        <?php if($berita->status === 'Terbit'): ?>
        <a href="<?php echo e(route('public.berita.show', $berita->slug)); ?>" target="_blank" class="btn btn-outline-info me-2">
            <i class="fas fa-external-link-alt me-2"></i>
            Lihat Live
        </a>
        <?php endif; ?>
        <a href="<?php echo e(route('admin.berita.edit', $berita->id)); ?>" class="btn btn-outline-warning me-2">
            <i class="fas fa-edit me-2"></i>
            Edit
        </a>
        <a href="<?php echo e(route('admin.berita.comments', $berita->id)); ?>" class="btn btn-outline-info me-2">
            <i class="fas fa-comments me-2"></i>
            Komentar
            <?php if($berita->comments_count > 0): ?>
                <span class="badge bg-danger ms-1"><?php echo e($berita->comments_count); ?></span>
            <?php endif; ?>
        </a>
        <div class="btn-group">
            <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                <i class="fas fa-share me-2"></i>
                Bagikan
            </button>
            <ul class="dropdown-menu">
                <li><a class="dropdown-item" href="#" onclick="shareToWhatsApp()">
                    <i class="fab fa-whatsapp me-2"></i>WhatsApp
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="shareToFacebook()">
                    <i class="fab fa-facebook me-2"></i>Facebook
                </a></li>
                <li><a class="dropdown-item" href="#" onclick="copyLink()">
                    <i class="fas fa-link me-2"></i>Copy Link
                </a></li>
                <li><hr class="dropdown-divider"></li>
                <li><a class="dropdown-item" href="#" onclick="downloadPDF()">
                    <i class="fas fa-file-pdf me-2"></i>Download PDF
                </a></li>
            </ul>
        </div>
    </div>
</div>

<!-- Status Alert -->
<?php if($berita->status === 'Draft'): ?>
<div class="alert alert-warning d-flex align-items-center mb-4">
    <i class="fas fa-edit me-2"></i>
    <div>
        <strong>Status Draft</strong><br>
        Berita ini masih dalam status draft dan belum dipublikasikan
    </div>
</div>
<?php elseif($berita->status === 'Dijadwalkan'): ?>
<div class="alert alert-info d-flex align-items-center mb-4">
    <i class="fas fa-clock me-2"></i>
    <div>
        <strong>Dijadwalkan</strong><br>
        Berita ini akan dipublikasikan pada <?php echo e($berita->tanggal_publish->format('d F Y, H:i')); ?> WIB
    </div>
</div>
<?php endif; ?>

<div class="row">
    <!-- Main Content -->
    <div class="col-lg-8">
        <!-- Article Content -->
        <div class="card">
            <div class="card-body">
                <!-- Header -->
                <div class="article-header mb-4">
                    <div class="d-flex align-items-center mb-3">
                        <span class="badge bg-<?php echo e($berita->kategori_color); ?> me-2">
                            <?php echo e(ucfirst($berita->kategori)); ?>

                        </span>
                        <?php if($berita->prioritas !== 'normal'): ?>
                        <span class="badge bg-<?php echo e($berita->prioritas === 'penting' ? 'warning' : 'danger'); ?>">
                            <?php echo e(ucfirst($berita->prioritas)); ?>

                        </span>
                        <?php endif; ?>
                        <span class="ms-auto text-muted small">
                            <i class="fas fa-calendar me-1"></i>
                            <?php echo e($berita->created_at->format('d F Y, H:i')); ?> WIB
                        </span>
                    </div>
                    
                    <h1 class="article-title mb-3"><?php echo e($berita->judul); ?></h1>
                    
                    <div class="article-meta d-flex align-items-center justify-content-between mb-4">
                        <div class="author-info d-flex align-items-center">
                            <div class="avatar bg-primary text-white rounded-circle me-3" style="width: 40px; height: 40px;">
                                <i class="fas fa-user"></i>
                            </div>
                            <div>
                                <div class="fw-medium"><?php echo e($berita->user->name ?? 'Admin Desa'); ?></div>
                                <small class="text-muted">Penulis</small>
                            </div>
                        </div>
                        
                        <div class="article-stats d-flex align-items-center gap-3">
                            <div class="stat-item text-center">
                                <div class="fw-bold"><?php echo e(number_format($berita->views ?? 0)); ?></div>
                                <small class="text-muted">Views</small>
                            </div>
                            <div class="stat-item text-center">
                                <div class="fw-bold"><?php echo e(number_format($berita->likes_count ?? 0)); ?></div>
                                <small class="text-muted">Likes</small>
                            </div>
                            <div class="stat-item text-center">
                                <div class="fw-bold"><?php echo e(number_format($berita->shares_count ?? 0)); ?></div>
                                <small class="text-muted">Shares</small>
                            </div>
                            <div class="stat-item text-center">
                                <div class="fw-bold"><?php echo e(number_format($berita->comments_count ?? 0)); ?></div>
                                <small class="text-muted">Komentar</small>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Featured Image -->
                    <?php if($berita->gambar): ?>
                    <div class="featured-image mb-4">
                        <img src="<?php echo e(asset('storage/' . $berita->gambar)); ?>" 
                             class="img-fluid rounded" 
                             alt="<?php echo e($berita->alt_text ?? $berita->judul); ?>"
                             style="width: 100%; max-height: 400px; object-fit: cover;">
                        <?php if($berita->alt_text): ?>
                        <figcaption class="text-muted small mt-2"><?php echo e($berita->alt_text); ?></figcaption>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Ringkasan -->
                    <?php if($berita->ringkasan): ?>
                    <div class="article-summary p-3 bg-light rounded mb-4">
                        <h6 class="mb-2">
                            <i class="fas fa-quote-left me-2"></i>
                            Ringkasan
                        </h6>
                        <p class="mb-0 lead"><?php echo e($berita->ringkasan); ?></p>
                    </div>
                    <?php endif; ?>
                </div>
                
                <!-- Content -->
                <div class="article-content">
                    <?php echo $berita->konten; ?>

                </div>
                
                <!-- Tags -->
                <?php if($berita->tags): ?>
                <div class="article-tags mt-4 pt-4 border-top">
                    <h6 class="mb-3">
                        <i class="fas fa-tags me-2"></i>
                        Tags
                    </h6>
                    <div class="d-flex flex-wrap gap-2">
                        <?php $__currentLoopData = explode(',', $berita->tags); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge bg-secondary"><?php echo e(trim($tag)); ?></span>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endif; ?>
                
                <!-- Social Actions -->
                <div class="social-actions mt-4 pt-4 border-top">
                    <div class="d-flex align-items-center justify-content-between">
                        <div class="like-share-buttons">
                            <button type="button" class="btn btn-outline-danger" onclick="toggleLike()">
                                <i class="fas fa-heart me-2" id="likeIcon"></i>
                                <span id="likeCount"><?php echo e($berita->likes ?? 0); ?></span> Suka
                            </button>
                            <button type="button" class="btn btn-outline-primary" onclick="shareArticle()">
                                <i class="fas fa-share me-2"></i>
                                <span id="shareCount"><?php echo e($berita->shares ?? 0); ?></span> Bagikan
                            </button>
                        </div>
                        
                        <div class="admin-actions">
                            <?php if($berita->status === 'Terbit'): ?>
                            <button type="button" class="btn btn-outline-success btn-sm" onclick="broadcastWhatsApp()">
                                <i class="fab fa-whatsapp me-1"></i>
                                Broadcast WA
                            </button>
                            <?php endif; ?>
                            <button type="button" class="btn btn-outline-info btn-sm" onclick="viewAnalytics()">
                                <i class="fas fa-chart-line me-1"></i>
                                Analytics
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Comments Section (Admin View) -->
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-comments me-2"></i>
                    Komentar & Tanggapan
                </h5>
            </div>
            <div class="card-body">
                <?php if(isset($comments) && $comments->count() > 0): ?>
                <div class="comments-list">
                    <?php $__currentLoopData = $comments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="comment-item border-bottom pb-3 mb-3">
                        <div class="d-flex">
                            <div class="avatar bg-info text-white rounded-circle me-3" style="width: 40px; height: 40px;">
                                <i class="fas fa-user"></i>
                            </div>
                            <div class="flex-grow-1">
                                <div class="d-flex justify-content-between align-items-start">
                                    <div>
                                        <h6 class="mb-1"><?php echo e($comment->nama ?? 'Anonim'); ?></h6>
                                        <small class="text-muted"><?php echo e($comment->created_at->format('d M Y, H:i')); ?></small>
                                    </div>
                                    <div class="btn-group btn-group-sm">
                                        <button type="button" class="btn btn-outline-success" onclick="approveComment(<?php echo e($comment->id); ?>)">
                                            <i class="fas fa-check"></i>
                                        </button>
                                        <button type="button" class="btn btn-outline-danger" onclick="deleteComment(<?php echo e($comment->id); ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                <p class="mb-2"><?php echo e($comment->komentar); ?></p>
                                <?php if($comment->status === 'pending'): ?>
                                <span class="badge bg-warning">Menunggu Moderasi</span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php else: ?>
                <div class="text-center py-5">
                    <i class="fas fa-comments fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Belum ada komentar</h5>
                    <p class="text-muted">Komentar dari pembaca akan muncul di sini</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Sidebar -->
    <div class="col-lg-4">
        <!-- Article Info -->
        <div class="card">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-info-circle me-2"></i>
                    Informasi Artikel
                </h6>
            </div>
            <div class="card-body">
                <table class="table table-sm table-borderless">
                    <tr>
                        <td>Status</td>
                        <td>:</td>
                        <td>
                            <span class="badge bg-<?php echo e($berita->status_color); ?>">
                                <?php echo e(ucfirst($berita->status)); ?>

                            </span>
                        </td>
                    </tr>
                    <tr>
                        <td>Kategori</td>
                        <td>:</td>
                        <td><?php echo e(ucfirst($berita->kategori)); ?></td>
                    </tr>
                    <tr>
                        <td>Prioritas</td>
                        <td>:</td>
                        <td><?php echo e(ucfirst($berita->prioritas ?? 'Normal')); ?></td>
                    </tr>
                    <tr>
                        <td>Dibuat</td>
                        <td>:</td>
                        <td><?php echo e($berita->created_at->format('d/m/Y H:i')); ?></td>
                    </tr>
                    <?php if($berita->updated_at != $berita->created_at): ?>
                    <tr>
                        <td>Diupdate</td>
                        <td>:</td>
                        <td><?php echo e($berita->updated_at->format('d/m/Y H:i')); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if($berita->tanggal_publish): ?>
                    <tr>
                        <td>Dipublikasi</td>
                        <td>:</td>
                        <td><?php echo e($berita->tanggal_publish->format('d/m/Y H:i')); ?></td>
                    </tr>
                    <?php endif; ?>
                    <tr>
                        <td>URL</td>
                        <td>:</td>
                        <td>
                            <code><?php echo e($berita->slug); ?></code>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
        
        <!-- Statistics -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-chart-bar me-2"></i>
                    Statistik
                </h6>
            </div>
            <div class="card-body">
                <div class="stats-overview">
                    <div class="row text-center">
                        <div class="col-4">
                            <div class="stat-card p-3 bg-primary bg-opacity-10 rounded">
                                <h4 class="mb-1 text-primary"><?php echo e($berita->views ?? 0); ?></h4>
                                <small class="text-muted">Total Views</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="stat-card p-3 bg-success bg-opacity-10 rounded">
                                <h4 class="mb-1 text-success"><?php echo e($berita->likes ?? 0); ?></h4>
                                <small class="text-muted">Total Likes</small>
                            </div>
                        </div>
                        <div class="col-4">
                            <div class="stat-card p-3 bg-info bg-opacity-10 rounded">
                                <h4 class="mb-1 text-info"><?php echo e($berita->shares ?? 0); ?></h4>
                                <small class="text-muted">Total Shares</small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- SEO Score -->
                <div class="seo-score mt-4">
                    <h6 class="mb-3">SEO Score</h6>
                    <div class="progress mb-2">
                        <div class="progress-bar bg-<?php echo e($seo_score >= 80 ? 'success' : ($seo_score >= 60 ? 'warning' : 'danger')); ?>" 
                             style="width: <?php echo e($seo_score ?? 0); ?>%"></div>
                    </div>
                    <small class="text-muted"><?php echo e($seo_score ?? 0); ?>/100 - 
                        <?php if(($seo_score ?? 0) >= 80): ?> Sangat Baik
                        <?php elseif(($seo_score ?? 0) >= 60): ?> Baik
                        <?php else: ?> Perlu Diperbaiki
                        <?php endif; ?>
                    </small>
                </div>
                
                <!-- Reading Time -->
                <div class="reading-time mt-3">
                    <h6 class="mb-2">Estimasi Baca</h6>
                    <p class="text-muted mb-0">
                        <i class="fas fa-clock me-1"></i>
                        <?php echo e($reading_time ?? 5); ?> menit
                    </p>
                </div>
                
                <!-- Word Count -->
                <div class="word-count mt-3">
                    <h6 class="mb-2">Jumlah Kata</h6>
                    <p class="text-muted mb-0">
                        <i class="fas fa-file-text me-1"></i>
                        <?php echo e($word_count ?? str_word_count(strip_tags($berita->konten))); ?> kata
                    </p>
                </div>
            </div>
        </div>
        
        <!-- Related Articles -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-newspaper me-2"></i>
                    Artikel Terkait
                </h6>
            </div>
            <div class="card-body">
                <?php if(isset($related_articles) && $related_articles->count() > 0): ?>
                <?php $__currentLoopData = $related_articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="related-item d-flex mb-3">
                    <?php if($related->gambar): ?>
                    <img src="<?php echo e(asset('storage/' . $related->gambar)); ?>" 
                         class="rounded me-3" 
                         style="width: 60px; height: 60px; object-fit: cover;"
                         alt="<?php echo e($related->judul); ?>">
                    <?php else: ?>
                    <div class="bg-light rounded me-3 d-flex align-items-center justify-content-center" 
                         style="width: 60px; height: 60px;">
                        <i class="fas fa-image text-muted"></i>
                    </div>
                    <?php endif; ?>
                    <div class="flex-grow-1">
                        <h6 class="mb-1">
                            <a href="<?php echo e(route('admin.berita.show', $related->id)); ?>" 
                               class="text-decoration-none">
                                <?php echo e(Str::limit($related->judul, 60)); ?>

                            </a>
                        </h6>
                        <small class="text-muted">
                            <?php echo e($related->created_at->format('d M Y')); ?> • <?php echo e($related->views ?? 0); ?> views
                        </small>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <div class="text-center py-3">
                    <i class="fas fa-newspaper fa-2x text-muted mb-2"></i>
                    <p class="text-muted mb-0">Tidak ada artikel terkait</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Recent Activities -->
        <div class="card mt-4">
            <div class="card-header">
                <h6 class="card-title mb-0">
                    <i class="fas fa-history me-2"></i>
                    Aktivitas Terbaru
                </h6>
            </div>
            <div class="card-body">
                <?php if(isset($recent_activities) && count($recent_activities) > 0): ?>
                <div class="activity-list">
                    <?php $__currentLoopData = $recent_activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="activity-item d-flex mb-3">
                        <div class="activity-icon bg-<?php echo e($activity['color']); ?> text-white rounded-circle me-3" 
                             style="width: 30px; height: 30px; display: flex; align-items: center; justify-content: center;">
                            <i class="fas fa-<?php echo e($activity['icon']); ?> fa-sm"></i>
                        </div>
                        <div class="flex-grow-1">
                            <p class="mb-1 small"><?php echo e($activity['message']); ?></p>
                            <small class="text-muted"><?php echo e($activity['time']); ?></small>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <?php else: ?>
                <div class="text-center py-3">
                    <i class="fas fa-history fa-2x text-muted mb-2"></i>
                    <p class="text-muted mb-0">Tidak ada aktivitas</p>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.article-title {
    font-size: 2.2rem;
    font-weight: 700;
    line-height: 1.3;
    color: #2c3e50;
}

.article-content {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #2c3e50;
}

.article-content h1,
.article-content h2,
.article-content h3,
.article-content h4,
.article-content h5,
.article-content h6 {
    margin-top: 2rem;
    margin-bottom: 1rem;
    color: #2c3e50;
}

.article-content p {
    margin-bottom: 1.5rem;
}

.article-content img {
    max-width: 100%;
    height: auto;
    border-radius: 8px;
    margin: 1.5rem 0;
}

.article-content blockquote {
    border-left: 4px solid #007bff;
    padding-left: 1rem;
    margin: 1.5rem 0;
    font-style: italic;
    color: #6c757d;
}

.article-content ul,
.article-content ol {
    margin-bottom: 1.5rem;
    padding-left: 2rem;
}

.article-content li {
    margin-bottom: 0.5rem;
}

.stat-card {
    transition: all 0.3s ease;
}

.stat-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
}

.activity-icon {
    flex-shrink: 0;
}

.related-item:hover {
    background-color: #f8f9fa;
    border-radius: 8px;
    padding: 8px;
    margin: -8px;
}

.badge {
    font-size: 0.75rem;
}

@media (max-width: 768px) {
    .article-title {
        font-size: 1.8rem;
    }
    
    .article-meta {
        flex-direction: column;
        align-items: flex-start !important;
        gap: 1rem;
    }
    
    .article-stats {
        width: 100%;
        justify-content: space-around !important;
    }
}
</style>

<script>
function shareToWhatsApp() {
    const url = '<?php echo e(route("public.berita.show", $berita->slug)); ?>';
    const text = '<?php echo e($berita->judul); ?>';
    window.open(`https://wa.me/?text=${encodeURIComponent(text + ' - ' + url)}`, '_blank');
}

function shareToFacebook() {
    const url = '<?php echo e(route("public.berita.show", $berita->slug)); ?>';
    window.open(`https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`, '_blank');
}

function copyLink() {
    const url = '<?php echo e(route("public.berita.show", $berita->slug)); ?>';
    navigator.clipboard.writeText(url).then(() => {
        alert('Link berhasil disalin!');
    });
}

function downloadPDF() {
    // Implementasi download PDF
    alert('Fitur download PDF sedang dalam pengembangan');
}

function toggleLike() {
    // Implementasi like/unlike
    const likeCount = document.getElementById('likeCount');
    const currentCount = parseInt(likeCount.textContent);
    likeCount.textContent = currentCount + 1;
}

function shareArticle() {
    // Implementasi share counter
    const shareCount = document.getElementById('shareCount');
    const currentCount = parseInt(shareCount.textContent);
    shareCount.textContent = currentCount + 1;
}

function broadcastWhatsApp() {
    if (confirm('Kirim broadcast WhatsApp ke semua warga?')) {
        // Implementasi broadcast WhatsApp
        alert('Broadcast WhatsApp sedang dikirim...');
    }
}

function viewAnalytics() {
    // Implementasi view analytics
    alert('Fitur analytics sedang dalam pengembangan');
}

function approveComment(commentId) {
    if (confirm('Setujui komentar ini?')) {
        // Implementasi approve comment
        alert('Komentar disetujui');
    }
}

function deleteComment(commentId) {
    if (confirm('Hapus komentar ini?')) {
        // Implementasi delete comment
        alert('Komentar dihapus');
    }
}
</script>
<?php $__env->stopSection(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/admin/berita/show.blade.php ENDPATH**/ ?>