<?php $__env->startSection('title', 'Tambah Berita'); ?>

<?php $__env->startSection('head'); ?>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.berita.index')); ?>">Berita</a></li>
    <li class="breadcrumb-item active">Tambah Berita</li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <!-- Header Section -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
    <div>
                    <h2 class="mb-1">
                        <i class="fas fa-plus-circle text-primary me-2"></i>
            Tambah Berita Baru
        </h2>
                    <p class="text-muted mb-0">Buat artikel berita atau informasi untuk warga desa</p>
    </div>
                <div class="d-flex gap-2">
                    <a href="<?php echo e(route('admin.berita.index')); ?>" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i>
            Kembali
        </a>
        <button type="button" class="btn btn-outline-info" onclick="previewBerita()">
                        <i class="fas fa-eye me-1"></i>
            Preview
        </button>
                </div>
            </div>
    </div>
</div>

    <!-- Main Form -->
    <form id="beritaForm" action="<?php echo e(route('admin.berita.store')); ?>" method="POST" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <div class="row">
        <!-- Main Content -->
            <div class="col-xl-8 col-lg-7">
                <!-- Basic Information -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                    <h5 class="card-title mb-0">
                            <i class="fas fa-edit text-primary me-2"></i>
                            Informasi Dasar
                    </h5>
                </div>
                <div class="card-body">
                    <!-- Judul -->
                    <div class="mb-4">
                            <label class="form-label fw-semibold">
                                Judul Berita <span class="text-danger">*</span>
                            </label>
                            <input type="text" 
                                   class="form-control form-control-lg <?php $__errorArgs = ['judul'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="judul" 
                                   id="judulInput"
                                   value="<?php echo e(old('judul')); ?>"
                                   placeholder="Masukkan judul berita yang menarik..."
                                   maxlength="100"
                                   required>
                        <div class="form-text">
                                <small class="text-muted">
                            <span id="judulCount">0</span>/100 karakter
                                </small>
                        </div>
                            <?php $__errorArgs = ['judul'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <!-- Slug -->
                    <div class="mb-4">
                            <label class="form-label fw-semibold">URL Slug</label>
                        <div class="input-group">
                                <span class="input-group-text bg-light">
                                    <i class="fas fa-link text-muted me-1"></i>
                                    <?php echo e(url('/berita/')); ?>/
                                </span>
                                <input type="text" 
                                       class="form-control <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                       name="slug" 
                                       id="slugInput"
                                       value="<?php echo e(old('slug')); ?>"
                                   placeholder="url-berita-otomatis">
                        </div>
                            <div class="form-text">
                                <small class="text-muted">URL akan dibuat otomatis dari judul</small>
                            </div>
                            <?php $__errorArgs = ['slug'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <!-- Ringkasan -->
                    <div class="mb-4">
                            <label class="form-label fw-semibold">
                                Ringkasan <span class="text-danger">*</span>
                            </label>
                            <textarea class="form-control <?php $__errorArgs = ['ringkasan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      name="ringkasan" 
                                      id="ringkasanInput"
                                      rows="3" 
                                      maxlength="200"
                                      placeholder="Tulis ringkasan singkat berita untuk preview..."
                                      required><?php echo e(old('ringkasan')); ?></textarea>
                        <div class="form-text">
                                <small class="text-muted">
                            <span id="ringkasanCount">0</span>/200 karakter
                                </small>
                            </div>
                            <?php $__errorArgs = ['ringkasan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        </div>
                    </div>
                    
                <!-- Content Editor -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h5 class="card-title mb-0">
                            <i class="fas fa-file-alt text-primary me-2"></i>
                            Konten Berita
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">
                                Isi Berita <span class="text-danger">*</span>
                            </label>
                            
                            <!-- Rich Text Editor Container -->
                            <div class="editor-container">
                                <div id="uploadStatus" class="alert alert-info small py-2 mb-2" style="display: none;">
                                    <i class="fas fa-info-circle me-1"></i>
                                    <span id="uploadMessage">Upload gambar...</span>
                            </div>
                                <div id="editor-wrapper">
                                    <textarea class="form-control <?php $__errorArgs = ['konten'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                              name="konten" 
                                              id="kontenEditor"
                                              placeholder="Tulis konten berita lengkap di sini..."
                                              rows="10"><?php echo e(old('konten')); ?></textarea>
                                </div>
                        </div>
                        
                            <?php $__errorArgs = ['konten'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Editor Info -->
                        <div class="d-flex justify-content-between align-items-center mt-2">
                                <small class="text-muted">
                                <i class="fas fa-magic me-1"></i>
                                CKEditor 5 - Editor canggih dengan fitur lengkap
                                </small>
                            <div class="editor-status">
                                <small class="text-success">
                                    <i class="fas fa-check-circle me-1"></i>
                                    <span id="editorStatus">Siap digunakan</span>
                                </small>
                            </div>
                        </div>

                        <!-- Quick Templates -->
                        <div class="mt-3">
                            <div class="d-flex flex-wrap gap-2">
                                <button type="button" class="btn btn-sm btn-outline-primary" onclick="insertPredefinedContent('announcement')">
                                    <i class="fas fa-bullhorn me-1"></i>
                                    Pengumuman
                                    </button>
                                <button type="button" class="btn btn-sm btn-outline-success" onclick="insertPredefinedContent('agenda')">
                                    <i class="fas fa-calendar me-1"></i>
                                    Agenda
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-info" onclick="insertPredefinedContent('contact')">
                                    <i class="fas fa-phone me-1"></i>
                                    Kontak
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="insertPredefinedContent('signature')">
                                    <i class="fas fa-signature me-1"></i>
                                    Tanda Tangan
                                </button>
                                <button type="button" class="btn btn-sm btn-outline-warning" onclick="insertPredefinedContent('table')">
                                    <i class="fas fa-table me-1"></i>
                                    Tabel
                                    </button>
                            </div>
                        </div>
                        
                        <!-- Quick Tips -->
                        <div class="mt-3">
                            <div class="alert alert-info alert-dismissible fade show" role="alert">
                                <i class="fas fa-lightbulb me-2"></i>
                                <strong>Tips Editor:</strong>
                                <ul class="mb-0 mt-2">
                                    <li>Gunakan <kbd>Ctrl+B</kbd> untuk bold, <kbd>Ctrl+I</kbd> untuk italic</li>
                                    <li>Drag & drop gambar langsung ke editor</li>
                                    <li>Copy-paste dari Word akan mempertahankan formatting</li>
                                    <li>Gunakan toolbar untuk akses cepat semua fitur</li>
                                </ul>
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    </div>
                    
                        <!-- Fallback for CKEditor Loading Error -->
                        <div id="editorFallback" class="mt-3" style="display: none;">
                            <div class="alert alert-warning" role="alert">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <strong>Editor Sederhana:</strong> CKEditor tidak dapat dimuat. Menggunakan editor teks sederhana.
                                <br><small>Anda masih dapat menggunakan HTML tags untuk formatting.</small>
                            </div>
                    </div>
                </div>
            </div>
            
            <!-- SEO Settings -->
                <div class="card shadow-sm">
                    <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                            <i class="fas fa-search text-success me-2"></i>
                        Pengaturan SEO
                    </h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                            <label class="form-label fw-semibold">Meta Description</label>
                            <textarea class="form-control <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                      name="meta_description" 
                                      id="metaInput"
                                      rows="2" 
                                      maxlength="160"
                                      placeholder="Deskripsi singkat untuk search engine..."><?php echo e(old('meta_description')); ?></textarea>
                        <div class="form-text">
                                <small class="text-muted">
                            <span id="metaCount">0</span>/160 karakter (optimal: 150-160)
                                </small>
                        </div>
                            <?php $__errorArgs = ['meta_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <div class="mb-3">
                            <label class="form-label fw-semibold">Keywords SEO</label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['keywords'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="keywords"
                                   value="<?php echo e(old('keywords')); ?>"
                                   placeholder="berita desa, informasi, pengumuman">
                            <div class="form-text">
                                <small class="text-muted">Pisahkan dengan koma untuk multiple keywords</small>
                            </div>
                            <?php $__errorArgs = ['keywords'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Sidebar -->
            <div class="col-xl-4 col-lg-5">
                <!-- Publikasi -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                            <i class="fas fa-paper-plane text-warning me-2"></i>
                        Pengaturan Publikasi
                    </h6>
                </div>
                <div class="card-body">
                    <!-- Status -->
                    <div class="mb-3">
                            <label class="form-label fw-semibold">
                                Status <span class="text-danger">*</span>
                            </label>
                            <select class="form-select <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="status" 
                                    id="statusSelect"
                                    required>
                                <option value="draft" <?php echo e(old('status') == 'draft' ? 'selected' : ''); ?>>
                                    📝 Draft
                                </option>
                                <option value="published" <?php echo e(old('status') == 'published' ? 'selected' : ''); ?>>
                                    ✅ Terbitkan Sekarang
                                </option>
                                <option value="scheduled" <?php echo e(old('status') == 'scheduled' ? 'selected' : ''); ?>>
                                    ⏰ Jadwalkan
                                </option>
                        </select>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <!-- Tanggal Publish -->
                    <div class="mb-3" id="publishDateSection" style="display: none;">
                            <label class="form-label fw-semibold">Tanggal & Waktu Terbit</label>
                            <input type="datetime-local" 
                                   class="form-control <?php $__errorArgs = ['tanggal_publish'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="tanggal_publish"
                                   value="<?php echo e(old('tanggal_publish')); ?>">
                            <?php $__errorArgs = ['tanggal_publish'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                    <!-- Kategori -->
                    <div class="mb-3">
                            <label class="form-label fw-semibold">
                                Kategori <span class="text-danger">*</span>
                            </label>
                            <select class="form-select <?php $__errorArgs = ['kategori'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="kategori" 
                                    required>
                            <option value="">Pilih Kategori</option>
                                <option value="pengumuman" <?php echo e(old('kategori') == 'pengumuman' ? 'selected' : ''); ?>>
                                    📢 Pengumuman
                                </option>
                                <option value="kegiatan" <?php echo e(old('kategori') == 'kegiatan' ? 'selected' : ''); ?>>
                                    🎯 Kegiatan Desa
                                </option>
                                <option value="pembangunan" <?php echo e(old('kategori') == 'pembangunan' ? 'selected' : ''); ?>>
                                    🏗️ Pembangunan
                                </option>
                                <option value="kesehatan" <?php echo e(old('kategori') == 'kesehatan' ? 'selected' : ''); ?>>
                                    🏥 Kesehatan
                                </option>
                                <option value="pendidikan" <?php echo e(old('kategori') == 'pendidikan' ? 'selected' : ''); ?>>
                                    📚 Pendidikan
                                </option>
                                <option value="ekonomi" <?php echo e(old('kategori') == 'ekonomi' ? 'selected' : ''); ?>>
                                    💰 Ekonomi
                                </option>
                                <option value="lingkungan" <?php echo e(old('kategori') == 'lingkungan' ? 'selected' : ''); ?>>
                                    🌿 Lingkungan
                                </option>
                                <option value="sosial" <?php echo e(old('kategori') == 'sosial' ? 'selected' : ''); ?>>
                                    👥 Sosial
                                </option>
                                <option value="budaya" <?php echo e(old('kategori') == 'budaya' ? 'selected' : ''); ?>>
                                    🎭 Budaya
                                </option>
                                <option value="lainnya" <?php echo e(old('kategori') == 'lainnya' ? 'selected' : ''); ?>>
                                    📋 Lainnya
                                </option>
                        </select>
                            <?php $__errorArgs = ['kategori'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                        <!-- Priority -->
                    <div class="mb-3">
                            <label class="form-label fw-semibold">Prioritas</label>
                            <select class="form-select <?php $__errorArgs = ['prioritas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                    name="prioritas">
                                <option value="normal" <?php echo e(old('prioritas') == 'normal' ? 'selected' : ''); ?>>
                                    📄 Normal
                                </option>
                                <option value="penting" <?php echo e(old('prioritas') == 'penting' ? 'selected' : ''); ?>>
                                    ⭐ Penting
                                </option>
                                <option value="urgent" <?php echo e(old('prioritas') == 'urgent' ? 'selected' : ''); ?>>
                                    🚨 Mendesak
                                </option>
                        </select>
                            <?php $__errorArgs = ['prioritas'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    </div>
                    </div>
                    
                <!-- Featured Image -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                        <h6 class="card-title mb-0">
                            <i class="fas fa-image text-info me-2"></i>
                            Gambar Utama
                            </h6>
                            </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Upload Gambar</label>
                            <input type="file" 
                                   class="form-control <?php $__errorArgs = ['gambar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="gambar" 
                                   id="gambarInput"
                                   accept="image/*">
                            <div class="form-text">
                                <small class="text-muted">
                                    Format: JPG, PNG, WEBP. Maksimal 2MB. Ukuran optimal: 1200x630px
                                </small>
                            </div>
                            <?php $__errorArgs = ['gambar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- Image Preview -->
                        <div id="imagePreview" class="text-center" style="display: none;">
                            <img id="previewImg" src="" alt="Preview" class="img-fluid rounded border" style="max-height: 200px;">
                            <div class="mt-2">
                                <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeImage()">
                                    <i class="fas fa-trash me-1"></i>
                                    Hapus Gambar
                                </button>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-semibold">Alt Text Gambar</label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['alt_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="alt_text"
                                   value="<?php echo e(old('alt_text')); ?>"
                                   placeholder="Deskripsi gambar untuk SEO">
                            <?php $__errorArgs = ['alt_text'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                </div>
            </div>
            
                <!-- Additional Settings -->
                <div class="card shadow-sm mb-4">
                    <div class="card-header bg-white border-bottom">
                    <h6 class="card-title mb-0">
                            <i class="fas fa-cogs text-secondary me-2"></i>
                            Pengaturan Tambahan
                    </h6>
                </div>
                <div class="card-body">
                        <!-- Tags -->
                        <div class="mb-3">
                            <label class="form-label fw-semibold">Tags</label>
                            <input type="text" 
                                   class="form-control <?php $__errorArgs = ['tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   name="tags"
                                   value="<?php echo e(old('tags')); ?>"
                                   placeholder="kesehatan, lingkungan, pembangunan">
                            <div class="form-text">
                                <small class="text-muted">Pisahkan dengan koma untuk multiple tags</small>
                        </div>
                            <?php $__errorArgs = ['tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    
                        <!-- Allow Comments -->
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="allow_comments" 
                                       id="allowComments"
                                       value="1"
                                       <?php echo e(old('allow_comments') ? 'checked' : ''); ?>>
                                <label class="form-check-label fw-semibold" for="allowComments">
                                    Izinkan Komentar
                                </label>
                            </div>
                    </div>
                    
                        <!-- Featured Post -->
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="is_featured" 
                                       id="isFeatured"
                                       value="1"
                                       <?php echo e(old('is_featured') ? 'checked' : ''); ?>>
                                <label class="form-check-label fw-semibold" for="isFeatured">
                                    Berita Unggulan
                                </label>
                            </div>
                            <div class="form-text">
                                <small class="text-muted">Berita akan ditampilkan di halaman utama</small>
                            </div>
                        </div>

                        <!-- WhatsApp Broadcast -->
                        <div class="mb-3">
                            <div class="form-check form-switch">
                                <input class="form-check-input" 
                                       type="checkbox" 
                                       name="send_wa_broadcast" 
                                       id="sendWaBroadcast"
                                       value="1"
                                       <?php echo e(old('send_wa_broadcast') ? 'checked' : ''); ?>>
                                <label class="form-check-label fw-semibold" for="sendWaBroadcast">
                                    <i class="fab fa-whatsapp text-success me-1"></i>
                                    Kirim via WhatsApp
                                </label>
                            </div>
                            <div class="form-text">
                                <small class="text-muted">Broadcast berita ke warga via WhatsApp</small>
                            </div>
                    </div>
                </div>
            </div>
            
            <!-- Action Buttons -->
                <div class="card shadow-sm">
                <div class="card-body">
                    <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-lg">
                            <i class="fas fa-save me-2"></i>
                                Simpan Berita
                        </button>
                            <button type="button" class="btn btn-outline-info" onclick="previewBerita()">
                                <i class="fas fa-eye me-2"></i>
                                Preview Berita
                        </button>
                            <a href="<?php echo e(route('admin.berita.index')); ?>" class="btn btn-outline-secondary">
                                <i class="fas fa-times me-2"></i>
                                Batal
                            </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
</div>

<!-- Preview Modal -->
<div class="modal fade" id="previewModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="fas fa-eye me-2"></i>
                    Preview Berita
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="previewContent">
                    <!-- Preview content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .card {
        border: none;
        box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
        transition: all 0.15s ease-in-out;
    }
    
    .card:hover {
        box-shadow: 0 0.5rem 1rem rgba(0, 0, 0, 0.15);
    }
    
    .form-label.fw-semibold {
        color: #495057;
        font-weight: 600;
    }
    
    .form-control:focus,
    .form-select:focus {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }
    
    .btn-group-sm > .btn {
        padding: 0.25rem 0.5rem;
        font-size: 0.875rem;
    }
    
    #imagePreview img {
        border: 2px dashed #dee2e6;
        padding: 10px;
    }
    
    .form-check-input:checked {
        background-color: #0d6efd;
        border-color: #0d6efd;
    }
    
    .text-danger {
        color: #dc3545 !important;
    }
    
    .badge {
        font-size: 0.75em;
    }
    
    .card-header {
        background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    }
    
    .btn-lg {
        padding: 0.75rem 1.5rem;
        font-size: 1.125rem;
    }
    
    .invalid-feedback {
        display: block;
    }
    
    .form-text small {
        font-size: 0.8em;
    }
    
    .input-group-text {
        border-right: none;
    }
    
    .input-group .form-control {
        border-left: none;
    }
    
    .input-group:focus-within .input-group-text {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }

    /* CKEditor 5 Custom Styles */
    .editor-container {
        border-radius: 0.375rem;
        overflow: hidden;
    }
    
    .ck-editor__editable {
        min-height: 400px;
        border: 1px solid #ced4da !important;
        border-radius: 0 0 0.375rem 0.375rem !important;
    }
    
    .ck-toolbar {
        border: 1px solid #ced4da !important;
        border-bottom: none !important;
        border-radius: 0.375rem 0.375rem 0 0 !important;
        background: #f8f9fa !important;
    }
    
    .ck-toolbar .ck-toolbar__separator {
        background: #dee2e6 !important;
    }
    
    .ck-button:not(.ck-disabled):hover,
    .ck-button:not(.ck-disabled):focus {
        background: #e9ecef !important;
    }
    
    .ck-button.ck-on {
        background: #0d6efd !important;
        color: white !important;
    }
    
    /* Focus state */
    .ck-focused {
        border-color: #80bdff !important;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25) !important;
    }
    
    /* Loading state */
    .editor-loading {
        display: flex;
        align-items: center;
        justify-content: center;
        min-height: 400px;
        background: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 0.375rem;
    }
    
    .editor-loading .spinner-border {
        width: 3rem;
        height: 3rem;
    }
    
    /* Alert styling */
    .alert-info {
        background-color: #e7f3ff;
        border-color: #b3d7ff;
        color: #0c5460;
    }
    
    .alert-info .alert-link {
        color: #0a4249;
    }
    
    kbd {
        background-color: #212529;
        color: #fff;
        border-radius: 0.25rem;
        padding: 0.125rem 0.25rem;
        font-size: 0.75em;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/ckeditor-image-styles.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<!-- CKEditor 5 CDN -->
<script src="https://cdn.ckeditor.com/ckeditor5/40.2.0/classic/ckeditor.js"></script>

<script>
// Initialize CKEditor 5
let editorInstance = null;
let ckeditorLoaded = false;

// Custom Upload Adapter untuk CKEditor
class UploadAdapter {
    constructor(loader) {
        this.loader = loader;
    }

    upload() {
        return this.loader.file
            .then(file => new Promise((resolve, reject) => {
                this._showUploadStatus('Mengupload gambar...', 'info');
                this._initRequest();
                this._initListeners(resolve, reject, file);
                this._sendRequest(file);
            }));
    }

    abort() {
        if (this.xhr) {
            this.xhr.abort();
        }
    }

    _initRequest() {
        const xhr = this.xhr = new XMLHttpRequest();
        xhr.open('POST', '<?php echo e(route("admin.upload.image")); ?>', true);
        xhr.setRequestHeader('X-CSRF-TOKEN', document.querySelector('meta[name="csrf-token"]').getAttribute('content'));
        xhr.setRequestHeader('Accept', 'application/json');
        xhr.responseType = 'json';
    }

    _initListeners(resolve, reject, file) {
        const xhr = this.xhr;
        const loader = this.loader;
        const genericErrorText = 'Tidak dapat upload file.';

        xhr.addEventListener('error', () => {
            // Fallback to Base64 if server upload fails
            console.log('Server upload failed, using Base64 fallback');
            this._showUploadStatus('Server upload gagal, menggunakan Base64...', 'warning');
            this._convertToBase64(file, resolve, reject);
        });

        xhr.addEventListener('abort', () => reject());

        xhr.addEventListener('load', () => {
            const response = xhr.response;

            if (!response || xhr.status !== 200) {
                console.error('Upload failed:', xhr.status, response);
                this._showUploadStatus(`Upload gagal (${xhr.status}). Menggunakan Base64...`, 'warning');
                this._convertToBase64(file, resolve, reject);
                return;
            }

            if (response.error || !response.uploaded) {
                console.error('Server returned error:', response.error);
                this._showUploadStatus('Server error. Menggunakan Base64...', 'warning');
                this._convertToBase64(file, resolve, reject);
                return;
            }

            if (response.url) {
                this._showUploadStatus('Gambar berhasil diupload ke server!', 'success');
                setTimeout(() => this._hideUploadStatus(), 2000);
                resolve({
                    default: response.url
                });
            } else {
                console.error('No URL in response:', response);
                this._showUploadStatus('Response tidak valid, menggunakan Base64...', 'warning');
                this._convertToBase64(file, resolve, reject);
            }
        });

        if (xhr.upload) {
            xhr.upload.addEventListener('progress', evt => {
                if (evt.lengthComputable) {
                    loader.uploadTotal = evt.total;
                    loader.uploaded = evt.loaded;
                }
            });
        }
    }

    _sendRequest(file) {
        const data = new FormData();
        data.append('upload', file);
        this.xhr.send(data);
    }

    _convertToBase64(file, resolve, reject) {
        const reader = new FileReader();
        reader.onload = () => {
            this._showUploadStatus('Gambar disimpan sebagai Base64!', 'success');
            setTimeout(() => this._hideUploadStatus(), 2000);
            resolve({
                default: reader.result
            });
        };
        reader.onerror = () => {
            this._showUploadStatus('Gagal membaca file!', 'danger');
            setTimeout(() => this._hideUploadStatus(), 3000);
            reject('Tidak dapat membaca file.');
        };
        reader.readAsDataURL(file);
    }

    _showUploadStatus(message, type) {
        const statusDiv = document.getElementById('uploadStatus');
        const messageSpan = document.getElementById('uploadMessage');
        
        if (statusDiv && messageSpan) {
            statusDiv.className = `alert alert-${type} small py-2 mb-2`;
            messageSpan.textContent = message;
            statusDiv.style.display = 'block';
        }
    }

    _hideUploadStatus() {
        const statusDiv = document.getElementById('uploadStatus');
        if (statusDiv) {
            statusDiv.style.display = 'none';
        }
    }
}

function initCKEditor() {
    // Check if CKEditor is loaded
    if (typeof ClassicEditor === 'undefined') {
        console.log('CKEditor belum dimuat, menunggu...');
        
        // Retry with timeout
        if (!window.ckeditorRetryCount) {
            window.ckeditorRetryCount = 0;
        }
        window.ckeditorRetryCount++;
        
        if (window.ckeditorRetryCount < 50) { // Max 5 seconds
            setTimeout(initCKEditor, 100);
            return;
        } else {
            // Fallback to simple textarea
            console.error('CKEditor gagal dimuat setelah 5 detik, menggunakan editor sederhana');
            showEditorFallback();
            return;
        }
    }
    
    // Show loading state
    const statusElement = document.getElementById('editorStatus');
    if (statusElement) {
        statusElement.innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Memuat editor...';
    }
    
    // Hide textarea and show CKEditor
    const textarea = document.querySelector('#kontenEditor');
    if (textarea) {
        textarea.style.display = 'none';
    }
    
    ClassicEditor
        .create(document.querySelector('#kontenEditor'), {
            toolbar: {
                items: [
                    'undo', 'redo',
                    '|', 'heading',
                    '|', 'bold', 'italic', 'underline',
                    '|', 'link', 'uploadImage', 'insertImage', 'blockQuote',
                    '|', 'bulletedList', 'numberedList', 'outdent', 'indent',
                    '|', 'insertTable'
                ],
                shouldNotGroupWhenFull: true
            },
                            image: {
                    toolbar: [
                        'imageTextAlternative', 
                        'imageStyle:inline', 
                        'imageStyle:block', 
                        'imageStyle:side',
                        '|',
                        'resizeImage:25',
                        'resizeImage:50',
                        'resizeImage:75',
                        'resizeImage:original',
                        '|',
                        'resizeImage:300',
                        'resizeImage:500',
                        'resizeImage:800',
                        'resizeImage:1200'
                    ],
                    resizeOptions: [
                        {
                            name: 'resizeImage:original',
                            label: 'Ukuran Asli',
                            value: null
                        },
                        {
                            name: 'resizeImage:25',
                            label: '25% (Kecil)',
                            value: '25'
                        },
                        {
                            name: 'resizeImage:50',
                            label: '50% (Sedang)',
                            value: '50'
                        },
                        {
                            name: 'resizeImage:75',
                            label: '75% (Besar)',
                            value: '75'
                        },
                        {
                            name: 'resizeImage:300',
                            label: '300px (Thumbnail)',
                            value: '300'
                        },
                        {
                            name: 'resizeImage:500',
                            label: '500px (Medium)',
                            value: '500'
                        },
                        {
                            name: 'resizeImage:800',
                            label: '800px (Large)',
                            value: '800'
                        },
                        {
                            name: 'resizeImage:1200',
                            label: '1200px (Extra Large)',
                            value: '1200'
                        }
                    ],
                    resizeUnit: 'px',
                    styles: [
                        'full',
                        'side',
                        'alignLeft',
                        'alignCenter',
                        'alignRight'
                    ]
                },
            table: {
                contentToolbar: ['tableColumn', 'tableRow', 'mergeTableCells']
            },
            heading: {
                options: [
                    { model: 'paragraph', title: 'Paragraph', class: 'ck-heading_paragraph' },
                    { model: 'heading1', view: 'h1', title: 'Heading 1', class: 'ck-heading_heading1' },
                    { model: 'heading2', view: 'h2', title: 'Heading 2', class: 'ck-heading_heading2' },
                    { model: 'heading3', view: 'h3', title: 'Heading 3', class: 'ck-heading_heading3' }
                ]
            },
            placeholder: 'Tulis konten berita lengkap di sini...'
        })
        .then(editor => {
            editorInstance = editor;
            ckeditorLoaded = true;
            
            const statusElement = document.getElementById('editorStatus');
            if (statusElement) {
                statusElement.innerHTML = '<i class="fas fa-check-circle me-1"></i>Siap digunakan';
            }
            
            console.log('CKEditor 5 initialized successfully');
            
            // Update word count on content change
            editor.model.document.on('change:data', () => {
                updateWordCount();
                clearValidationErrors(); // Clear errors when user types in editor
            });
            
            // Set initial content if exists
            const initialContent = document.querySelector('#kontenEditor').value;
            if (initialContent) {
                editor.setData(initialContent);
            }
            
            // Setup custom upload adapter
            editor.plugins.get('FileRepository').createUploadAdapter = (loader) => {
                return new UploadAdapter(loader);
            };
            
            // Add image resize styles to editor
            const style = document.createElement('style');
            style.innerHTML = `
                .ck-content .image {
                    max-width: 100%;
                    height: auto;
                    position: relative;
                }
                .ck-content .image.image_resized {
                    max-width: none;
                }
                .ck-content .image img {
                    border-radius: 4px;
                    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
                }
                .ck-content .image-style-side {
                    float: right;
                    margin: 0 0 1em 1.5em;
                    max-width: 50%;
                }
                .ck-content .image-style-align-left {
                    float: left;
                    margin: 0 1.5em 1em 0;
                }
                .ck-content .image-style-align-center {
                    margin: 1em auto;
                    display: block;
                    text-align: center;
                }
                .ck-content .image-style-align-right {
                    float: right;
                    margin: 0 0 1em 1.5em;
                }
                .ck-content .image-style-full {
                    width: 100%;
                    margin: 1em 0;
                }
                
                /* Image size indicators */
                .ck-content .image::after {
                    content: attr(data-size);
                    position: absolute;
                    top: 5px;
                    right: 5px;
                    background: rgba(0,0,0,0.7);
                    color: white;
                    padding: 2px 6px;
                    border-radius: 3px;
                    font-size: 11px;
                    font-family: Arial, sans-serif;
                    opacity: 0;
                    transition: opacity 0.3s;
                    pointer-events: none;
                }
                .ck-content .image:hover::after {
                    opacity: 1;
                }
                
                /* Responsive images */
                @media (max-width: 768px) {
                    .ck-content .image-style-side,
                    .ck-content .image-style-align-left,
                    .ck-content .image-style-align-right {
                        float: none;
                        margin: 1em auto;
                        display: block;
                        max-width: 100%;
                    }
                }
            `;
            if (!document.getElementById('ckeditor-image-styles')) {
                style.id = 'ckeditor-image-styles';
                document.head.appendChild(style);
            }
            
            // Add image size tracking
            editor.model.document.on('change:data', () => {
                setTimeout(() => {
                    const images = editor.editing.view.document.getRoot().getChildren();
                    // Update image size indicators
                    updateImageSizeIndicators();
                }, 100);
            });
        })
        .catch(error => {
            console.error('CKEditor initialization failed:', error);
            showEditorFallback();
        });
}

function showEditorFallback() {
    // Show textarea again
    const textarea = document.querySelector('#kontenEditor');
    if (textarea) {
        textarea.style.display = 'block';
        textarea.rows = 15;
    }
    
    // Update status
    const statusElement = document.getElementById('editorStatus');
    if (statusElement) {
        statusElement.innerHTML = '<i class="fas fa-exclamation-triangle text-warning me-1"></i>Editor sederhana';
    }
    
    // Show fallback alert
    const fallbackDiv = document.getElementById('editorFallback');
    if (fallbackDiv) {
        fallbackDiv.style.display = 'block';
    }
    
    console.log('Fallback to simple textarea editor');
}

// Show validation errors with better UX
function showValidationErrors(errors) {
    // Remove existing error highlights
    document.querySelectorAll('.is-invalid').forEach(el => {
        el.classList.remove('is-invalid');
    });
    
    // Create or update error alert
    let errorAlert = document.getElementById('validationErrorAlert');
    if (!errorAlert) {
        errorAlert = document.createElement('div');
        errorAlert.id = 'validationErrorAlert';
        errorAlert.className = 'alert alert-danger alert-dismissible fade show mb-3';
        
        const form = document.getElementById('beritaForm');
        if (form) {
            form.insertBefore(errorAlert, form.firstChild);
        }
    }
    
    const errorList = errors.map(error => `<li>${error}</li>`).join('');
    errorAlert.innerHTML = `
        <i class="fas fa-exclamation-circle me-2"></i>
        <strong>Mohon perbaiki kesalahan berikut:</strong>
        <ul class="mb-0 mt-2">${errorList}</ul>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;
    
    // Highlight invalid fields
    errors.forEach(error => {
        if (error.includes('Judul')) {
            document.getElementById('judulInput')?.classList.add('is-invalid');
        }
        if (error.includes('Ringkasan')) {
            document.getElementById('ringkasanInput')?.classList.add('is-invalid');
        }
        if (error.includes('Konten')) {
            // For CKEditor, highlight the editor container
            if (editorInstance && ckeditorLoaded) {
                const editorElement = document.querySelector('.ck-editor');
                if (editorElement) {
                    editorElement.style.borderColor = '#dc3545';
                    editorElement.style.boxShadow = '0 0 0 0.2rem rgba(220, 53, 69, 0.25)';
                }
            } else {
                document.getElementById('kontenEditor')?.classList.add('is-invalid');
            }
        }
        if (error.includes('Kategori')) {
            document.querySelector('select[name="kategori"]')?.classList.add('is-invalid');
        }
    });
    
    // Scroll to error alert
    errorAlert.scrollIntoView({ behavior: 'smooth', block: 'center' });
    
    // Auto-hide after 10 seconds
    setTimeout(() => {
        if (errorAlert && errorAlert.parentNode) {
            errorAlert.style.opacity = '0';
            setTimeout(() => {
                if (errorAlert && errorAlert.parentNode) {
                    errorAlert.remove();
                }
            }, 300);
        }
    }, 10000);
}

// Clear validation errors when user starts typing
function clearValidationErrors() {
    const errorAlert = document.getElementById('validationErrorAlert');
    if (errorAlert) {
        errorAlert.remove();
    }
    
    // Remove error highlights
    document.querySelectorAll('.is-invalid').forEach(el => {
        el.classList.remove('is-invalid');
    });
    
    // Clear CKEditor error styling
    const editorElement = document.querySelector('.ck-editor');
    if (editorElement) {
        editorElement.style.borderColor = '';
        editorElement.style.boxShadow = '';
    }
}

// Update word count
function updateWordCount() {
    if (editorInstance && ckeditorLoaded) {
        try {
            const data = editorInstance.getData();
            const textContent = data.replace(/<[^>]*>/g, ''); // Remove HTML tags
            const wordCount = textContent.trim() ? textContent.trim().split(/\s+/).length : 0;
            const charCount = textContent.length;
            
            // Update status if needed
            const statusElement = document.getElementById('editorStatus');
            if (wordCount > 0 && statusElement) {
                statusElement.innerHTML = 
                    `<i class="fas fa-edit me-1"></i>${wordCount} kata, ${charCount} karakter`;
            }
        } catch (error) {
            console.log('Word count update error:', error);
        }
    }
}

// Get editor content
function getEditorContent() {
    if (editorInstance && ckeditorLoaded) {
        return editorInstance.getData();
    }
    return document.getElementById('kontenEditor').value;
}

// Set editor content
function setEditorContent(content) {
    if (editorInstance && ckeditorLoaded) {
        editorInstance.setData(content);
        } else {
        document.getElementById('kontenEditor').value = content;
    }
}

document.addEventListener('DOMContentLoaded', function() {
    // Initialize CKEditor with delay to ensure DOM is ready
    setTimeout(function() {
        initCKEditor();
    }, 100);
    
    // Character counters
    const judulInput = document.getElementById('judulInput');
    const ringkasanInput = document.getElementById('ringkasanInput');
    const metaInput = document.getElementById('metaInput');
    const gambarInput = document.getElementById('gambarInput');
    const statusSelect = document.getElementById('statusSelect');
    
    // Update character counts
    function updateCharCount(input, countElement) {
        if (input && countElement) {
            const count = input.value.length;
            countElement.textContent = count;
            
            // Color coding
            const maxLength = input.getAttribute('maxlength');
            if (maxLength) {
                const percentage = (count / maxLength) * 100;
                if (percentage >= 90) {
                    countElement.className = 'text-danger fw-bold';
                } else if (percentage >= 75) {
                    countElement.className = 'text-warning fw-bold';
            } else {
                    countElement.className = 'text-muted';
                }
            }
        }
    }
    
    // Initialize character counters
    if (judulInput) {
        updateCharCount(judulInput, document.getElementById('judulCount'));
        judulInput.addEventListener('input', function() {
            updateCharCount(this, document.getElementById('judulCount'));
            updateSlug(this.value);
            clearValidationErrors(); // Clear errors when user types
        });
    }
    
    if (ringkasanInput) {
        updateCharCount(ringkasanInput, document.getElementById('ringkasanCount'));
        ringkasanInput.addEventListener('input', function() {
            updateCharCount(this, document.getElementById('ringkasanCount'));
            clearValidationErrors(); // Clear errors when user types
        });
    }
    
    if (metaInput) {
        updateCharCount(metaInput, document.getElementById('metaCount'));
        metaInput.addEventListener('input', function() {
            updateCharCount(this, document.getElementById('metaCount'));
        });
    }
    
    // Auto-generate slug
function updateSlug(title) {
        if (!title) return;
        
        const slug = title
            .toLowerCase()
        .replace(/[^a-z0-9\s-]/g, '')
        .replace(/\s+/g, '-')
        .replace(/-+/g, '-')
        .trim('-');
    
        const slugInput = document.getElementById('slugInput');
        if (slugInput && !slugInput.value) {
            slugInput.value = slug;
        }
    }
    
    // Status change handler
    if (statusSelect) {
        statusSelect.addEventListener('change', function() {
            const publishDateSection = document.getElementById('publishDateSection');
            if (this.value === 'scheduled') {
                publishDateSection.style.display = 'block';
                publishDateSection.querySelector('input').required = true;
    } else {
                publishDateSection.style.display = 'none';
                publishDateSection.querySelector('input').required = false;
            }
            clearValidationErrors(); // Clear errors when user changes status
        });
        
        // Trigger on page load
        statusSelect.dispatchEvent(new Event('change'));
    }
    
    // Add change listener to kategori select
    const kategoriSelect = document.querySelector('select[name="kategori"]');
    if (kategoriSelect) {
        kategoriSelect.addEventListener('change', function() {
            clearValidationErrors(); // Clear errors when user selects category
        });
    }
    
    // Image preview
    if (gambarInput) {
        gambarInput.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
        // Validate file size (2MB)
        if (file.size > 2 * 1024 * 1024) {
                    alert('Ukuran file terlalu besar. Maksimal 2MB.');
                    this.value = '';
                    return;
                }
                
                // Validate file type
                if (!file.type.match('image.*')) {
                    alert('File harus berupa gambar.');
                    this.value = '';
            return;
        }
        
        const reader = new FileReader();
        reader.onload = function(e) {
                    const preview = document.getElementById('imagePreview');
                    const img = document.getElementById('previewImg');
                    img.src = e.target.result;
                    preview.style.display = 'block';
        };
        reader.readAsDataURL(file);
    }
        });
    }
    
    // Custom form validation
    const form = document.getElementById('beritaForm');
    if (form) {
        // Remove default HTML5 validation to prevent focus issues
        form.setAttribute('novalidate', 'true');
        
        form.addEventListener('submit', function(e) {
            e.preventDefault(); // Always prevent default first
            
            const judul = judulInput?.value.trim();
            const ringkasan = ringkasanInput?.value.trim();
            
            // Get content from CKEditor
            let konten = '';
            if (editorInstance && ckeditorLoaded) {
                konten = editorInstance.getData().trim();
                // Update the textarea value for server validation
                document.getElementById('kontenEditor').value = konten;
    } else {
                konten = document.getElementById('kontenEditor')?.value.trim();
            }
            
            const kategori = document.querySelector('select[name="kategori"]')?.value;
            
            // Custom validation with better UX
            let errors = [];
            
            if (!judul) {
                errors.push('Judul berita harus diisi');
                judulInput?.focus();
            }
            if (!ringkasan) {
                errors.push('Ringkasan berita harus diisi');
                if (errors.length === 1) ringkasanInput?.focus();
            }
            if (!konten) {
                errors.push('Konten berita harus diisi');
                if (errors.length === 1) {
                    if (editorInstance && ckeditorLoaded) {
                        editorInstance.editing.view.focus();
        } else {
                        document.getElementById('kontenEditor')?.focus();
                    }
                }
            }
            if (!kategori) {
                errors.push('Kategori harus dipilih');
                if (errors.length === 1) document.querySelector('select[name="kategori"]')?.focus();
            }
            
            if (errors.length > 0) {
                // Show validation errors with better UX
                showValidationErrors(errors);
                return false;
            }
            
            // Check minimum content length (strip HTML tags for accurate count)
            const textContent = konten.replace(/<[^>]*>/g, '').trim();
            if (textContent.length < 50) {
                alert('Konten berita minimal 50 karakter (tanpa HTML).');
                if (editorInstance && ckeditorLoaded) {
                    editorInstance.editing.view.focus();
            } else {
                    document.getElementById('kontenEditor')?.focus();
                }
                return false;
            }
            
            // Show loading state
            const submitBtn = this.querySelector('button[type="submit"]');
            if (submitBtn) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i>Menyimpan...';
            }
            
            // Submit form programmatically
            this.submit();
        });
    }
});

// Enhanced text formatting functions for CKEditor
function insertTextFormat(format) {
    if (editorInstance && ckeditorLoaded) {
        switch(format) {
            case 'bold':
                editorInstance.execute('bold');
                break;
            case 'italic':
                editorInstance.execute('italic');
                break;
            case 'underline':
                editorInstance.execute('underline');
                break;
            case 'h1':
                editorInstance.execute('heading', { value: 'heading1' });
                break;
            case 'h2':
                editorInstance.execute('heading', { value: 'heading2' });
                break;
            case 'h3':
                editorInstance.execute('heading', { value: 'heading3' });
                break;
            case 'quote':
                editorInstance.execute('blockQuote');
                break;
            case 'link':
                const url = prompt('Masukkan URL:');
                if (url) {
                    editorInstance.execute('link', url);
                }
                break;
        }
        editorInstance.editing.view.focus();
    }
}

// Insert predefined content
function insertPredefinedContent(type) {
    if (!editorInstance || !ckeditorLoaded) return;
    
    let content = '';
    
    switch(type) {
        case 'signature':
            content = `
                <hr>
                <p><strong>Pemerintah Desa [Nama Desa]</strong><br>
                Kepala Desa<br><br>
                <strong>[Nama Kepala Desa]</strong></p>
            `;
            break;
        case 'contact':
            content = `
                <div style="background: #f8f9fa; padding: 15px; border-radius: 5px; margin: 10px 0;">
                    <h4>📞 Kontak Informasi</h4>
                    <p><strong>Telepon:</strong> [Nomor Telepon]<br>
                    <strong>Email:</strong> [Email Desa]<br>
                    <strong>Alamat:</strong> [Alamat Lengkap]</p>
                </div>
            `;
            break;
        case 'table':
            editorInstance.execute('insertTable', { rows: 3, columns: 3 });
            return;
        case 'announcement':
            content = `
                <div style="background: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; border-radius: 5px; margin: 10px 0;">
                    <h3 style="color: #856404; margin-top: 0;">📢 PENGUMUMAN PENTING</h3>
                    <p>Isi pengumuman di sini...</p>
                    <p><strong>Tanggal:</strong> [Tanggal]</p>
                    <p><strong>Tempat:</strong> [Lokasi]</p>
                </div>
            `;
            break;
        case 'agenda':
            content = `
                <div style="background: #d4edda; border: 1px solid #c3e6cb; padding: 15px; border-radius: 5px; margin: 10px 0;">
                    <h3 style="color: #155724; margin-top: 0;">📅 AGENDA KEGIATAN</h3>
                    <table style="width: 100%; border-collapse: collapse;">
                        <tr>
                            <td style="border: 1px solid #ddd; padding: 8px; background: #f8f9fa;"><strong>Kegiatan</strong></td>
                            <td style="border: 1px solid #ddd; padding: 8px;">[Nama Kegiatan]</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #ddd; padding: 8px; background: #f8f9fa;"><strong>Tanggal</strong></td>
                            <td style="border: 1px solid #ddd; padding: 8px;">[Tanggal & Waktu]</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #ddd; padding: 8px; background: #f8f9fa;"><strong>Tempat</strong></td>
                            <td style="border: 1px solid #ddd; padding: 8px;">[Lokasi]</td>
                        </tr>
                        <tr>
                            <td style="border: 1px solid #ddd; padding: 8px; background: #f8f9fa;"><strong>Peserta</strong></td>
                            <td style="border: 1px solid #ddd; padding: 8px;">[Target Peserta]</td>
                        </tr>
                    </table>
                </div>
            `;
            break;
    }
    
    if (content) {
        const viewFragment = editorInstance.data.processor.toView(content);
        const modelFragment = editorInstance.data.toModel(viewFragment);
        editorInstance.model.insertContent(modelFragment);
        editorInstance.editing.view.focus();
    }
}

// Remove image function
function removeImage() {
    const gambarInput = document.getElementById('gambarInput');
    const preview = document.getElementById('imagePreview');
    
    if (gambarInput) gambarInput.value = '';
    if (preview) preview.style.display = 'none';
}

// Preview function
function previewBerita() {
    const judul = document.getElementById('judulInput')?.value || 'Judul Berita';
    const ringkasan = document.getElementById('ringkasanInput')?.value || 'Ringkasan berita...';
    
    // Get content from CKEditor
    let konten = 'Konten berita...';
    if (editorInstance && ckeditorLoaded) {
        konten = editorInstance.getData() || 'Konten berita...';
    } else {
        konten = document.getElementById('kontenEditor')?.value || 'Konten berita...';
    }
    
    const kategori = document.querySelector('select[name="kategori"]')?.selectedOptions[0]?.text || 'Kategori';
    
    const previewContent = `
        <article class="preview-article">
            <div class="mb-3">
                <span class="badge bg-primary">${kategori}</span>
                <small class="text-muted ms-2">${new Date().toLocaleDateString('id-ID')}</small>
            </div>
            <h1 class="mb-3">${judul}</h1>
            <p class="lead text-muted mb-4">${ringkasan}</p>
            <div class="content">
                ${konten}
            </div>
        </article>
    `;
    
    document.getElementById('previewContent').innerHTML = previewContent;
    
    const modal = new bootstrap.Modal(document.getElementById('previewModal'));
    modal.show();
}

// Save draft function
function saveDraft() {
    if (!editorInstance || !ckeditorLoaded) return;
    
    const formData = new FormData(document.getElementById('beritaForm'));
    formData.set('status', 'draft');
    formData.set('konten', editorInstance.getData());
    
    // Show saving indicator
    const originalStatus = document.getElementById('editorStatus').innerHTML;
    document.getElementById('editorStatus').innerHTML = '<i class="fas fa-spinner fa-spin me-1"></i>Menyimpan draft...';
    
    // Simulate save (you can implement actual AJAX save here)
    setTimeout(() => {
        document.getElementById('editorStatus').innerHTML = '<i class="fas fa-save me-1"></i>Draft tersimpan';
        setTimeout(() => {
            document.getElementById('editorStatus').innerHTML = originalStatus;
        }, 2000);
    }, 1000);
}

// Auto-save draft (optional)
let autoSaveTimer;
function autoSaveDraft() {
    clearTimeout(autoSaveTimer);
    autoSaveTimer = setTimeout(() => {
        const formData = new FormData(document.getElementById('beritaForm'));
        formData.set('status', 'draft');
        
        // You can implement auto-save functionality here
        console.log('Auto-saving draft...');
    }, 30000); // Auto-save every 30 seconds
}

// Initialize auto-save on input
document.querySelectorAll('input, textarea, select').forEach(element => {
    element.addEventListener('input', autoSaveDraft);
});

// Update image size indicators
function updateImageSizeIndicators() {
    if (!editorInstance) return;
    
    const editorElement = document.querySelector('.ck-editor__editable');
    if (!editorElement) return;
    
    const images = editorElement.querySelectorAll('img');
    images.forEach(img => {
        const imageContainer = img.closest('.image');
        if (imageContainer) {
            const naturalWidth = img.naturalWidth;
            const naturalHeight = img.naturalHeight;
            const displayWidth = img.offsetWidth;
            const displayHeight = img.offsetHeight;
            
            let sizeText = '';
            if (naturalWidth && naturalHeight && displayWidth && displayHeight) {
                const scale = Math.round((displayWidth / naturalWidth) * 100);
                sizeText = `${displayWidth}×${displayHeight}px (${scale}%)`;
                
                // Add size info to image container
                imageContainer.setAttribute('data-size', sizeText);
                imageContainer.setAttribute('title', `Ukuran: ${sizeText} | Asli: ${naturalWidth}×${naturalHeight}px`);
            }
        }
    });
}

// Image load event listener
document.addEventListener('DOMContentLoaded', function() {
    // Listen for image loads in CKEditor
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'childList') {
                mutation.addedNodes.forEach(function(node) {
                    if (node.nodeType === Node.ELEMENT_NODE) {
                        const images = node.querySelectorAll ? node.querySelectorAll('img') : [];
                        images.forEach(function(img) {
                            img.addEventListener('load', updateImageSizeIndicators);
                        });
                        
                        if (node.tagName === 'IMG') {
                            node.addEventListener('load', updateImageSizeIndicators);
                        }
                    }
                });
            }
        });
    });
    
    // Start observing
    setTimeout(() => {
        const editorElement = document.querySelector('.ck-editor__editable');
        if (editorElement) {
            observer.observe(editorElement, {
                childList: true,
                subtree: true
            });
        }
    }, 1000);
});
</script>
<?php $__env->stopPush(); ?> 
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/admin/berita/create.blade.php ENDPATH**/ ?>