

<?php $__env->startSection('title', 'Detail Objek Wisata'); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Detail Objek Wisata</h1>
                <div>
                    <a href="<?php echo e(route('admin.objek-wisata.edit', $objekWisata->id)); ?>" class="btn btn-warning btn-sm">
                        <i class="fas fa-edit"></i> Edit
                    </a>
                    <a href="<?php echo e(route('admin.objek-wisata.index')); ?>" class="btn btn-secondary btn-sm">
                        <i class="fas fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Informasi Dasar</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Nama:</strong> <?php echo e($objekWisata->nama_wisata); ?></p>
                            <p><strong>Kategori:</strong> <span class="badge badge-info"><?php echo e(ucfirst(str_replace('_', ' ', $objekWisata->kategori_wisata))); ?></span></p>
                            <p><strong>Status:</strong> 
                                <?php if($objekWisata->status === 'aktif'): ?>
                                    <span class="badge badge-success">Aktif</span>
                                <?php else: ?>
                                    <span class="badge badge-secondary">Non-aktif</span>
                                <?php endif; ?>
                            </p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Harga Tiket Dewasa:</strong> Rp <?php echo e(number_format($objekWisata->harga_tiket_dewasa ?? 0)); ?></p>
                            <p><strong>Harga Tiket Anak:</strong> Rp <?php echo e(number_format($objekWisata->harga_tiket_anak ?? 0)); ?></p>
                            <p><strong>Total Pengunjung:</strong> <?php echo e(number_format($objekWisata->total_pengunjung ?? 0)); ?></p>
                            <p><strong>Rating:</strong> 
                                <?php if($objekWisata->rating_rata_rata ?? 0 > 0): ?>
                                    <?php echo e(number_format($objekWisata->rating_rata_rata, 1)); ?>/5 (<?php echo e($objekWisata->jumlah_review ?? 0); ?> review)
                                <?php else: ?>
                                    Belum ada rating
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                    
                    <div class="row mt-3">
                        <div class="col-12">
                            <p><strong>Deskripsi:</strong></p>
                            <p><?php echo e($objekWisata->deskripsi ?? 'Tidak ada deskripsi'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Lokasi</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Alamat:</strong> <?php echo e($objekWisata->alamat ?? '-'); ?></p>
                            <p><strong>Desa:</strong> <?php echo e($objekWisata->desa ?? '-'); ?></p>
                            <p><strong>Kecamatan:</strong> <?php echo e($objekWisata->kecamatan ?? '-'); ?></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Latitude:</strong> <?php echo e($objekWisata->latitude ?? '-'); ?></p>
                            <p><strong>Longitude:</strong> <?php echo e($objekWisata->longitude ?? '-'); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informasi Kontak & Operasional -->
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Kontak & Operasional</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Jam Operasional:</strong> 
                                <?php if($objekWisata->jam_operasional): ?>
                                    <?php if(is_array($objekWisata->jam_operasional)): ?>
                                        <?php echo e(implode(', ', $objekWisata->jam_operasional)); ?>

                                    <?php else: ?>
                                        <?php echo e($objekWisata->jam_operasional); ?>

                                    <?php endif; ?>
                                <?php else: ?>
                                    24 Jam
                                <?php endif; ?>
                            </p>
                            <p><strong>Nama Pengelola:</strong> <?php echo e($objekWisata->nama_pengelola ?? '-'); ?></p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Telepon:</strong> <?php echo e($objekWisata->telepon ?? '-'); ?></p>
                            <p><strong>Email:</strong> <?php echo e($objekWisata->email ?? '-'); ?></p>
                            <p><strong>Website:</strong> 
                                <?php if($objekWisata->website): ?>
                                    <a href="<?php echo e($objekWisata->website); ?>" target="_blank"><?php echo e($objekWisata->website); ?></a>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-lg-4">
            <?php if($objekWisata->foto_utama && is_string($objekWisata->foto_utama)): ?>
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Foto Utama</h6>
                </div>
                <div class="card-body">
                    <img src="<?php echo e($objekWisata->foto_utama_url); ?>" 
                         alt="<?php echo e($objekWisata->nama_wisata); ?>" 
                         class="img-fluid rounded"
                         onerror="this.style.display='none';">
                </div>
            </div>
            <?php endif; ?>

            <!-- Galeri Foto -->
            <?php if($objekWisata->galeri_foto && count($objekWisata->galeri_foto) > 0): ?>
            <div class="card shadow mb-4">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Galeri Foto</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php
                            $galeri = is_array($objekWisata->galeri_foto) ? $objekWisata->galeri_foto : json_decode($objekWisata->galeri_foto, true);
                        ?>
                        <?php if($galeri && count($galeri) > 0): ?>
                            <?php $__currentLoopData = $galeri; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $foto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($foto && is_string($foto)): ?>
                                <div class="col-6 mb-3">
                                    <img src="<?php echo e(\App\Helpers\SharedHostingHelper::getFileUrl('wisata/galeri/' . $foto, 'images/default-tourism.png')); ?>" 
                                         alt="Gallery" 
                                         class="img-fluid rounded"
                                         style="width: 100%; height: 120px; object-fit: cover;"
                                         onerror="this.style.display='none';">
                                </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="card shadow">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">Aksi</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?php echo e(route('admin.objek-wisata.edit', $objekWisata->id)); ?>" class="btn btn-warning btn-sm">
                            <i class="fas fa-edit"></i> Edit
                        </a>
                        <a href="<?php echo e(route('admin.tiket-wisata.index')); ?>?objek_wisata_id=<?php echo e($objekWisata->id); ?>" 
                           class="btn btn-info btn-sm">
                            <i class="fas fa-ticket-alt"></i> Lihat Booking
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?> 

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/admin/objek-wisata/show.blade.php ENDPATH**/ ?>