<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <title>Login - Aplikasi Desa</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Custom Styles -->
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .login-container {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            overflow: hidden;
            max-width: 900px;
            width: 100%;
        }

        .login-left {
            background: linear-gradient(135deg, rgba(102, 126, 234, 0.9) 0%, rgba(118, 75, 162, 0.9) 100%);
            color: white;
            padding: 60px 40px;
            text-align: center;
            position: relative;
        }

        .login-left::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.1'%3E%3Ccircle cx='30' cy='30' r='4'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E") repeat;
            opacity: 0.3;
        }

        .login-left-content {
            position: relative;
            z-index: 2;
        }

        .login-form {
            padding: 60px 40px;
        }

        .form-control {
            border: 2px solid #e9ecef;
            border-radius: 10px;
            padding: 15px 20px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #f8f9fa;
        }

        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.25);
            background: white;
        }

        .input-group-text {
            border: 2px solid #e9ecef;
            border-radius: 10px 0 0 10px;
            background: #f8f9fa;
            border-right: none;
            color: #6c757d;
            width: 50px;
            justify-content: center;
        }

        .input-group .form-control {
            border-left: none;
            border-radius: 0 10px 10px 0;
        }

        .input-group:focus-within .input-group-text {
            border-color: #667eea;
            background: white;
            color: #667eea;
        }

        .input-group:focus-within .form-control {
            border-color: #667eea;
        }

        .btn-login {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            padding: 15px 30px;
            font-size: 16px;
            font-weight: 600;
            color: white;
            transition: all 0.3s ease;
            width: 100%;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(102, 126, 234, 0.3);
            color: white;
        }

        .logo-icon {
            width: 80px;
            height: 80px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            font-size: 36px;
        }

        .feature-list {
            text-align: left;
            margin-top: 40px;
        }

        .feature-item {
            display: flex;
            align-items: center;
            margin-bottom: 15px;
        }

        .feature-item i {
            width: 25px;
            margin-right: 15px;
        }

        .alert {
            border-radius: 10px;
            border: none;
            padding: 15px 20px;
        }

        .alert-danger {
            background: linear-gradient(135deg, rgba(220, 53, 69, 0.1) 0%, rgba(220, 53, 69, 0.05) 100%);
            color: #dc3545;
            border-left: 4px solid #dc3545;
        }

        .form-check-input:checked {
            background-color: #667eea;
            border-color: #667eea;
        }

        .form-check-input:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.25rem rgba(102, 126, 234, 0.25);
        }

        .forgot-password {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .forgot-password:hover {
            color: #764ba2;
            text-decoration: underline;
        }

        @media (max-width: 768px) {
            .login-left {
                display: none;
            }
            
            .login-form {
                padding: 40px 30px;
            }
            
            .login-container {
                margin: 20px;
                border-radius: 15px;
            }
        }

        .loading-spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 2px solid #ffffff40;
            border-top: 2px solid #ffffff;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-right: 10px;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .pulse {
            animation: pulse 2s infinite;
        }

        @keyframes pulse {
            0% { transform: scale(1); }
            50% { transform: scale(1.05); }
            100% { transform: scale(1); }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-12">
                <div class="login-container row g-0 mx-auto">
                    <!-- Left Side - Information -->
                    <div class="col-lg-6 login-left">
                        <div class="login-left-content">
                            <div class="logo-icon pulse">
                                <i class="fas fa-landmark"></i>
                            </div>
                            
                            <h2 class="mb-3">Aplikasi Desa</h2>
                            <p class="mb-4">
                                Sistem Informasi Manajemen Desa yang komprehensif untuk pengelolaan 
                                data penduduk, pelayanan surat, dan administrasi desa yang modern.
                            </p>
                            
                            <div class="feature-list">
                                <div class="feature-item">
                                    <i class="fas fa-users"></i>
                                    <span>Manajemen Data Penduduk</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-file-alt"></i>
                                    <span>Pelayanan Surat Online</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-comment-dots"></i>
                                    <span>Sistem Pengaduan</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-hand-holding-heart"></i>
                                    <span>Manajemen Bantuan Sosial</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-newspaper"></i>
                                    <span>Portal Berita Desa</span>
                                </div>
                                <div class="feature-item">
                                    <i class="fas fa-map"></i>
                                    <span>Peta Interaktif</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Right Side - Login Form -->
                    <div class="col-lg-6">
                        <div class="login-form">
                            <div class="text-center mb-4 d-lg-none">
                                <div class="logo-icon mx-auto mb-3" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white;">
                                    <i class="fas fa-landmark"></i>
                                </div>
                                <h3>Aplikasi Desa</h3>
                            </div>
                            
                            <h3 class="mb-2 d-none d-lg-block">Selamat Datang!</h3>
                            <p class="text-muted mb-4 d-none d-lg-block">
                                Silakan masuk ke akun Anda untuk mengakses sistem
                            </p>
                            
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger" role="alert">
                                    <i class="fas fa-exclamation-triangle me-2"></i>
                                    <ul class="mb-0">
                                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li><?php echo e($error); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            
                            <?php if(session('status')): ?>
                                <div class="alert alert-success" role="alert">
                                    <i class="fas fa-check-circle me-2"></i>
                                    <?php echo e(session('status')); ?>

                                </div>
                            <?php endif; ?>
                            
                            <form method="POST" action="<?php echo e(route('login')); ?>" id="loginForm">
                                <?php echo csrf_field(); ?>
                                
                                <!-- Email Field -->
                                <div class="mb-4">
                                    <label for="email" class="form-label fw-semibold">Email</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fas fa-envelope"></i>
                                        </span>
                                        <input type="email" 
                                               class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="email" 
                                               name="email" 
                                               value="<?php echo e(old('email')); ?>" 
                                               required 
                                               autocomplete="email" 
                                               autofocus
                                               placeholder="Masukkan email Anda">
                                    </div>
                                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback d-block">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <!-- Password Field -->
                                <div class="mb-4">
                                    <label for="password" class="form-label fw-semibold">Password</label>
                                    <div class="input-group">
                                        <span class="input-group-text">
                                            <i class="fas fa-lock"></i>
                                        </span>
                                        <input type="password" 
                                               class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               id="password" 
                                               name="password" 
                                               required 
                                               autocomplete="current-password"
                                               placeholder="Masukkan password Anda">
                                        <span class="input-group-text" 
                                              style="cursor: pointer; border-radius: 0 10px 10px 0;" 
                                              onclick="togglePassword()">
                                            <i class="fas fa-eye" id="toggleIcon"></i>
                                        </span>
                                    </div>
                                    <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                        <div class="invalid-feedback d-block">
                                            <?php echo e($message); ?>

                                        </div>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                                
                                <!-- CAPTCHA Field -->
                                <div class="mb-4">
                                    <label for="captcha" class="form-label fw-semibold">Kode Keamanan (CAPTCHA)</label>
                                    <div class="row">
                                        <div class="col-7">
                                            <div class="input-group">
                                                <span class="input-group-text">
                                                    <i class="fas fa-shield-alt"></i>
                                                </span>
                                                <input type="text" 
                                                       class="form-control <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                       id="captcha" 
                                                       name="captcha" 
                                                       required 
                                                       autocomplete="off"
                                                       placeholder="Masukkan kode di samping">
                                            </div>
                                            <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <div class="invalid-feedback d-block">
                                                    <?php echo e($message); ?>

                                                </div>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                        <div class="col-5">
                                            <div class="captcha-container" style="position: relative;">
                                                <img src="/captcha" 
                                                     alt="CAPTCHA" 
                                                     id="captcha-image"
                                                     style="width: 100%; height: 45px; border-radius: 8px; border: 1px solid #ddd; cursor: pointer;"
                                                     onclick="refreshCaptcha()"
                                                     title="Klik untuk refresh CAPTCHA">
                                                <div style="position: absolute; top: -8px; right: -8px;">
                                                    <button type="button" 
                                                            class="btn btn-sm btn-outline-secondary rounded-circle" 
                                                            onclick="refreshCaptcha()"
                                                            title="Refresh CAPTCHA"
                                                            style="width: 25px; height: 25px; padding: 0;">
                                                        <i class="fas fa-refresh" style="font-size: 10px;"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Remember Me & Forgot Password -->
                                <div class="d-flex justify-content-between align-items-center mb-4">
                                    <div class="form-check">
                                        <input class="form-check-input" 
                                               type="checkbox" 
                                               name="remember" 
                                               id="remember" 
                                               <?php echo e(old('remember') ? 'checked' : ''); ?>>
                                        <label class="form-check-label" for="remember">
                                            Ingat saya
                                        </label>
                                    </div>
                                    
                                    <?php if(Route::has('password.request')): ?>
                                        <a class="forgot-password" href="<?php echo e(route('password.request')); ?>">
                                            Lupa password?
                                        </a>
                                    <?php endif; ?>
                                </div>
                                
                                <!-- Login Button -->
                                <button type="submit" class="btn btn-login" id="loginBtn">
                                    <div class="loading-spinner" id="loadingSpinner"></div>
                                    <span id="loginText">
                                        <i class="fas fa-sign-in-alt me-2"></i>
                                        Masuk
                                    </span>
                                </button>
                            </form>
                            
                            <!-- Footer -->
                            <div class="text-center mt-4 pt-4 border-top">
                                <small class="text-muted">
                                    © <?php echo e(date('Y')); ?> Aplikasi Desa. Semua hak cipta dilindungi.
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Toggle password visibility
        function togglePassword() {
            const passwordInput = document.getElementById('password');
            const toggleIcon = document.getElementById('toggleIcon');
            
            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                toggleIcon.className = 'fas fa-eye-slash';
            } else {
                passwordInput.type = 'password';
                toggleIcon.className = 'fas fa-eye';
            }
        }
        
        // Refresh CAPTCHA
        function refreshCaptcha() {
            const captchaImg = document.getElementById('captcha-image');
            const captchaInput = document.getElementById('captcha');
            
            // Add timestamp to prevent caching
            captchaImg.src = '/captcha?' + Math.random();
            
            // Clear captcha input
            captchaInput.value = '';
            captchaInput.focus();
        }
        
        // Handle form submission with loading state
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const loginBtn = document.getElementById('loginBtn');
            const loadingSpinner = document.getElementById('loadingSpinner');
            const loginText = document.getElementById('loginText');
            
            // Show loading state
            loginBtn.disabled = true;
            loadingSpinner.style.display = 'inline-block';
            loginText.innerHTML = 'Memproses...';
            
            // Add some delay to show the loading effect
            setTimeout(() => {
                // Form will submit naturally after this timeout
            }, 500);
        });
        
        // Auto-focus email field if empty
        document.addEventListener('DOMContentLoaded', function() {
            const emailInput = document.getElementById('email');
            if (!emailInput.value) {
                emailInput.focus();
            }
        });
        
        // Add smooth transitions to form controls
        document.querySelectorAll('.form-control').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'scale(1.02)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'scale(1)';
            });
        });
        
        // Enhanced form validation
        document.getElementById('email').addEventListener('input', function() {
            const email = this.value;
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            
            if (email && !emailRegex.test(email)) {
                this.classList.add('is-invalid');
            } else {
                this.classList.remove('is-invalid');
            }
        });
        
        document.getElementById('password').addEventListener('input', function() {
            const password = this.value;
            
            if (password && password.length < 6) {
                this.classList.add('is-invalid');
            } else {
                this.classList.remove('is-invalid');
            }
        });
        
        // Keyboard shortcuts
        document.addEventListener('keydown', function(e) {
            // Alt + E to focus email
            if (e.altKey && e.key === 'e') {
                e.preventDefault();
                document.getElementById('email').focus();
            }
            
            // Alt + P to focus password
            if (e.altKey && e.key === 'p') {
                e.preventDefault();
                document.getElementById('password').focus();
            }
            
            // Ctrl + Enter to submit form
            if (e.ctrlKey && e.key === 'Enter') {
                e.preventDefault();
                document.getElementById('loginForm').submit();
            }
        });
    </script>
</body>
</html> 
<?php /**PATH /home/copg1493/public_html/susukannet.id/resources/views/auth/login.blade.php ENDPATH**/ ?>