<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Testing login after password fix...\n";

try {
    // Get a penduduk with fixed password
    $penduduk = \App\Models\Penduduk::whereNotNull('password')->first();
    
    if (!$penduduk) {
        echo "No penduduk with password found\n";
        exit(1);
    }
    
    echo "Testing with NIK: " . $penduduk->nik . "\n";
    echo "Name: " . $penduduk->nama . "\n";
    
    // Test password methods
    echo "\nTesting password methods:\n";
    
    $hasPassword = $penduduk->hasPassword();
    echo "  hasPassword(): " . ($hasPassword ? "Yes" : "No") . "\n";
    
    $mustChange = $penduduk->mustChangePassword();
    echo "  mustChangePassword(): " . ($mustChange ? "Yes" : "No") . "\n";
    
    // Test with default password (last 6 digits of NIK)
    $defaultPassword = substr($penduduk->nik, -6);
    echo "  Testing with default password: " . $defaultPassword . "\n";
    
    $checkPassword = $penduduk->checkPassword($defaultPassword);
    echo "  checkPassword(): " . ($checkPassword ? "Valid" : "Invalid") . "\n";
    
    // Test API endpoint
    echo "\nTesting API endpoint...\n";
    
    $request = \Illuminate\Http\Request::create('/api/v1/portal/login', 'POST');
    $request->headers->set('Content-Type', 'application/json');
    $request->headers->set('Accept', 'application/json');
    
    $request->initialize(
        [], [], [], [], [], [],
        json_encode([
            'nik' => $penduduk->nik,
            'password' => $defaultPassword
        ])
    );
    
    $response = $app->handle($request);
    echo "  API Response Status: " . $response->getStatusCode() . "\n";
    
    if ($response->getStatusCode() === 200) {
        $responseData = json_decode($response->getContent(), true);
        echo "  API Response Success: " . ($responseData['success'] ? "Yes" : "No") . "\n";
        if ($responseData['success']) {
            echo "  Login successful! Token generated.\n";
        } else {
            echo "  Login failed: " . ($responseData['message'] ?? 'Unknown error') . "\n";
        }
    } else {
        echo "  API Error: " . $response->getContent() . "\n";
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
}
