<?php

echo "=== TESTING URL ACCESS ===\n\n";

// Test URLs
$testUrls = [
    'https://susukannet.id/storage/umkm/logo/sample-logo.png',
    'https://susukannet.id/storage/umkm/galeri/sample-gallery1.png',
    'https://susukannet.id/images/default-umkm-logo.png',
    'https://susukannet.id/images/default-tourism.png'
];

foreach ($testUrls as $url) {
    echo "Testing: " . $url . "\n";
    
    // Test with get_headers
    $headers = @get_headers($url);
    if ($headers) {
        $status = $headers[0];
        echo "  Status: " . $status . "\n";
        
        if (strpos($status, '200') !== false) {
            echo "  ✓ URL accessible\n";
        } else {
            echo "  ✗ URL not accessible\n";
        }
    } else {
        echo "  ✗ Failed to get headers\n";
    }
    
    // Test with file_get_contents
    $context = stream_context_create([
        'http' => [
            'method' => 'HEAD',
            'timeout' => 10
        ]
    ]);
    
    $result = @file_get_contents($url, false, $context);
    if ($result !== false) {
        echo "  ✓ File content accessible\n";
    } else {
        echo "  ✗ File content not accessible\n";
    }
    
    echo "\n";
}

// Test local file access
echo "Testing local file access...\n";
$localFiles = [
    'public/storage/umkm/logo/sample-logo.png',
    'public/storage/umkm/galeri/sample-gallery1.png',
    'public/images/default-umkm-logo.png',
    'public/images/default-tourism.png'
];

foreach ($localFiles as $file) {
    echo "Local file: " . $file . "\n";
    if (file_exists($file)) {
        echo "  ✓ File exists\n";
        echo "  Size: " . filesize($file) . " bytes\n";
    } else {
        echo "  ✗ File not found\n";
    }
    echo "\n";
}

echo "=== TEST COMPLETED ===\n";
