<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Berita;
use Illuminate\Http\Request;

class BeritaController extends Controller
{
    /**
     * Display a listing of news articles
     */
    public function index(Request $request)
    {
        try {
            $query = Berita::where('status', 'Terbit');

            // Filter by category
            if ($request->has('kategori') && $request->kategori) {
                $query->where('kategori', $request->kategori);
            }

            // Search functionality
            if ($request->has('search') && $request->search) {
                $query->where(function($q) use ($request) {
                    $q->where('judul', 'like', '%' . $request->search . '%')
                      ->orWhere('konten', 'like', '%' . $request->search . '%');
                });
            }

            $page = $request->get('page', 1);
            $limit = $request->get('limit', 10);

            $berita = $query->orderBy('created_at', 'desc')
                          ->paginate($limit, ['*'], 'page', $page);

            return response()->json([
                'success' => true,
                'data' => $berita->items(),
                'meta' => [
                    'current_page' => $berita->currentPage(),
                    'last_page' => $berita->lastPage(),
                    'per_page' => $berita->perPage(),
                    'total' => $berita->total(),
                ],
                'message' => 'Data berita berhasil diambil'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Gagal mengambil data berita',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Display the specified news article
     */
    public function show($id)
    {
        try {
            $berita = Berita::where('status', 'Terbit')->findOrFail($id);

            // Increment view count
            $berita->increment('views');

            return response()->json([
                'success' => true,
                'data' => $berita,
                'message' => 'Detail berita berhasil diambil'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Berita tidak ditemukan',
                'error' => $e->getMessage()
            ], 404);
        }
    }
}
