<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Penduduk;
use App\Models\Keluarga;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DemografiController extends Controller
{
    public function index()
    {
        // Statistik dasar
        $totalPenduduk = Penduduk::count();
        $totalKeluarga = Keluarga::count();
        
        // Statistik jenis kelamin
        $jenisKelamin = Penduduk::select('jenis_kelamin', DB::raw('count(*) as total'))
            ->groupBy('jenis_kelamin')
            ->get()
            ->pluck('total', 'jenis_kelamin');
        
        $lakiLaki = $jenisKelamin['L'] ?? 0;
        $perempuan = $jenisKelamin['P'] ?? 0;
        
        // Statistik usia
        $today = Carbon::today();
        $anak = Penduduk::whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) < 18')->count();
        $dewasa = Penduduk::whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) BETWEEN 18 AND 59')->count();
        $lansia = Penduduk::whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) >= 60')->count();
        
        // Statistik pendidikan
        $pendidikan = Penduduk::select('pendidikan', DB::raw('count(*) as total'))
            ->whereNotNull('pendidikan')
            ->groupBy('pendidikan')
            ->get()
            ->pluck('total', 'pendidikan')
            ->toArray();
        
        // Statistik pekerjaan
        $pekerjaan = Penduduk::select('pekerjaan', DB::raw('count(*) as total'))
            ->whereNotNull('pekerjaan')
            ->groupBy('pekerjaan')
            ->get()
            ->pluck('total', 'pekerjaan');
        
        // Kategorisasi pekerjaan
        $bekerja = 0;
        $mencariKerja = 0;
        $pelajar = 0;
        $lainnya = 0;
        
        foreach ($pekerjaan as $job => $total) {
            $jobLower = strtolower($job);
            if (in_array($jobLower, ['tidak bekerja', 'pengangguran', 'mencari kerja'])) {
                $mencariKerja += $total;
            } elseif (in_array($jobLower, ['pelajar', 'siswa', 'mahasiswa'])) {
                $pelajar += $total;
            } elseif (in_array($jobLower, ['ibu rumah tangga', 'pensiunan', 'balita'])) {
                $lainnya += $total;
            } else {
                $bekerja += $total;
            }
        }
        
        $data = [
            'totalPenduduk' => $totalPenduduk,
            'totalKeluarga' => $totalKeluarga,
            'lakiLaki' => $lakiLaki,
            'perempuan' => $perempuan,
            'anak' => $anak,
            'dewasa' => $dewasa,
            'lansia' => $lansia,
            'pendidikan' => $pendidikan,
            'bekerja' => $bekerja,
            'mencariKerja' => $mencariKerja,
            'pelajar' => $pelajar,
            'lainnya' => $lainnya
        ];
        
        return view('frontend.demografi', compact('data'));
    }
    
    public function apiData()
    {
        // API endpoint untuk data chart
        $totalPenduduk = Penduduk::count();
        $totalKeluarga = Keluarga::count();
        
        // Statistik jenis kelamin
        $jenisKelamin = Penduduk::select('jenis_kelamin', DB::raw('count(*) as total'))
            ->groupBy('jenis_kelamin')
            ->get()
            ->pluck('total', 'jenis_kelamin');
        
        $lakiLaki = $jenisKelamin['L'] ?? 0;
        $perempuan = $jenisKelamin['P'] ?? 0;
        
        // Statistik usia
        $anak = Penduduk::whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) < 18')->count();
        $dewasa = Penduduk::whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) BETWEEN 18 AND 59')->count();
        $lansia = Penduduk::whereRaw('TIMESTAMPDIFF(YEAR, tanggal_lahir, CURDATE()) >= 60')->count();
        
        // Statistik pekerjaan
        $pekerjaan = Penduduk::select('pekerjaan', DB::raw('count(*) as total'))
            ->whereNotNull('pekerjaan')
            ->groupBy('pekerjaan')
            ->get()
            ->pluck('total', 'pekerjaan');
        
        // Kategorisasi pekerjaan
        $bekerja = 0;
        $mencariKerja = 0;
        $pelajar = 0;
        $lainnya = 0;
        
        foreach ($pekerjaan as $job => $total) {
            $jobLower = strtolower($job);
            if (in_array($jobLower, ['tidak bekerja', 'pengangguran', 'mencari kerja'])) {
                $mencariKerja += $total;
            } elseif (in_array($jobLower, ['pelajar', 'siswa', 'mahasiswa'])) {
                $pelajar += $total;
            } elseif (in_array($jobLower, ['ibu rumah tangga', 'pensiunan', 'balita'])) {
                $lainnya += $total;
            } else {
                $bekerja += $total;
            }
        }
        
        return response()->json([
            'totalPenduduk' => $totalPenduduk,
            'totalKeluarga' => $totalKeluarga,
            'jenisKelamin' => [
                'lakiLaki' => $lakiLaki,
                'perempuan' => $perempuan
            ],
            'usia' => [
                'anak' => $anak,
                'dewasa' => $dewasa,
                'lansia' => $lansia
            ],
            'pekerjaan' => [
                'bekerja' => $bekerja,
                'mencariKerja' => $mencariKerja,
                'pelajar' => $pelajar,
                'lainnya' => $lainnya
            ]
        ]);
    }
} 