<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

try {
    $result = DB::select("SHOW COLUMNS FROM objek_wisata LIKE 'kategori_wisata'");
    echo "Database ENUM values: " . $result[0]->Type . PHP_EOL;
    
    // Parse enum values
    preg_match_all("/'([^']+)'/", $result[0]->Type, $matches);
    $enumValues = $matches[1];
    
    echo "Parsed enum values: " . implode(', ', $enumValues) . PHP_EOL;
    
    // Controller values
    $controller = new App\Http\Controllers\Admin\ObjekWisataController();
    $reflection = new ReflectionClass($controller);
    $method = $reflection->getMethod('getKategoriList');
    $method->setAccessible(true);
    $kategoriList = $method->invoke($controller);
    $controllerKeys = array_keys($kategoriList);
    
    echo "Controller keys: " . implode(', ', $controllerKeys) . PHP_EOL;
    
    // Check if they match
    $missingInController = array_diff($enumValues, $controllerKeys);
    $missingInEnum = array_diff($controllerKeys, $enumValues);
    
    if (empty($missingInController) && empty($missingInEnum)) {
        echo "✅ Controller and Database ENUM values are perfectly synchronized!" . PHP_EOL;
    } else {
        if (!empty($missingInController)) {
            echo "❌ Missing in Controller: " . implode(', ', $missingInController) . PHP_EOL;
        }
        if (!empty($missingInEnum)) {
            echo "❌ Missing in Database ENUM: " . implode(', ', $missingInEnum) . PHP_EOL;
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . PHP_EOL;
}
