<?php

require 'vendor/autoload.php';

$app = require 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "Checking password hashing in database...\n";

try {
    $penduduk = \App\Models\Penduduk::first();
    
    if (!$penduduk) {
        echo "No penduduk data found\n";
        exit(1);
    }
    
    echo "NIK: " . $penduduk->nik . "\n";
    echo "Name: " . $penduduk->nama . "\n";
    echo "Password field: " . ($penduduk->password ? "Set" : "Not set") . "\n";
    
    if ($penduduk->password) {
        echo "Password length: " . strlen($penduduk->password) . "\n";
        echo "Password starts with \$2y\$: " . (str_starts_with($penduduk->password, '$2y$') ? "Yes" : "No") . "\n";
        echo "Password starts with \$2a\$: " . (str_starts_with($penduduk->password, '$2a$') ? "Yes" : "No") . "\n";
        echo "Password starts with \$2b\$: " . (str_starts_with($penduduk->password, '$2b$') ? "Yes" : "No") . "\n";
        echo "First 20 chars: " . substr($penduduk->password, 0, 20) . "...\n";
        
        // Test with default password (last 6 digits of NIK)
        $defaultPassword = substr($penduduk->nik, -6);
        echo "\nTesting with default password: " . $defaultPassword . "\n";
        
        try {
            $isValid = \Illuminate\Support\Facades\Hash::check($defaultPassword, $penduduk->password);
            echo "Hash::check result: " . ($isValid ? "Valid" : "Invalid") . "\n";
        } catch (Exception $e) {
            echo "Hash::check ERROR: " . $e->getMessage() . "\n";
        }
        
        // Try to rehash the password
        echo "\nAttempting to fix password hash...\n";
        try {
            $penduduk->setPassword($defaultPassword);
            echo "Password rehashed successfully\n";
            
            // Test again
            $isValid = \Illuminate\Support\Facades\Hash::check($defaultPassword, $penduduk->password);
            echo "New Hash::check result: " . ($isValid ? "Valid" : "Invalid") . "\n";
            
        } catch (Exception $e) {
            echo "Rehash ERROR: " . $e->getMessage() . "\n";
        }
    }
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . ":" . $e->getLine() . "\n";
}
