<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pengaduan', function (Blueprint $table) {
            $table->id();
            $table->string('nik', 16);
            $table->string('judul');
            $table->text('isi_pengaduan');
            $table->enum('kategori', [
                'Infrastruktur',
                'Kebersihan',
                'Keamanan',
                'Pelayanan',
                'Sosial',
                'Ekonomi',
                'Lingkungan',
                'Lainnya'
            ]);
            $table->string('gambar')->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            $table->enum('status', ['Baru', 'Diproses', 'Ditanggapi', 'Selesai'])->default('Baru');
            $table->text('tanggapan')->nullable();
            $table->timestamp('tanggal_tanggapan')->nullable();
            $table->timestamps();
            
            $table->foreign('nik')->references('nik')->on('penduduk');
            $table->index(['status', 'kategori']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pengaduan');
    }
}; 
