<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('arsip_surat_keluar', function (Blueprint $table) {
            $table->id();
            $table->string('nomor_surat')->unique();
            $table->enum('jenis_surat', [
                'SK', 'Surat Keputusan',
                'Undangan', 'Surat Undangan',
                'Edaran', 'Surat Edaran',
                'Pemberitahuan', 'Surat Pemberitahuan',
                'Tugas', 'Surat Tugas',
                'Rekomendasi', 'Surat Rekomendasi',
                'Lainnya'
            ]);
            $table->string('perihal');
            $table->text('tujuan'); // Bisa multiple, dalam format JSON
            $table->date('tanggal_surat');
            $table->longText('isi_surat');
            $table->string('penandatangan_nama');
            $table->string('penandatangan_jabatan');
            $table->string('penandatangan_nip')->nullable();
            $table->string('file_surat')->nullable(); // PDF file
            $table->string('lampiran')->nullable(); // File lampiran
            $table->enum('klasifikasi', ['Biasa', 'Penting', 'Rahasia'])->default('Biasa');
            $table->enum('status', ['Draft', 'Dikirim', 'Arsip'])->default('Draft');
            $table->date('tanggal_kirim')->nullable();
            $table->text('keterangan')->nullable();
            $table->integer('created_by'); // User ID yang membuat
            $table->timestamps();
            
            $table->index(['jenis_surat', 'status']);
            $table->index('tanggal_surat');
            $table->index('nomor_surat');
            $table->index('klasifikasi');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('arsip_surat_keluar');
    }
}; 