<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tagihan_pbb', function (Blueprint $table) {
            $table->id();
            $table->foreignId('pbb_id')->constrained('pbb')->onDelete('cascade');
            $table->string('nop', 18);
            $table->year('tahun_pajak');
            $table->decimal('nilai_pajak', 15, 2);
            $table->decimal('denda', 15, 2)->default(0);
            $table->decimal('total_tagihan', 15, 2);
            
            // Status pembayaran
            $table->enum('status_bayar', ['Belum Lunas', 'Lunas', 'Dicicil'])->default('Belum Lunas');
            $table->date('jatuh_tempo');
            $table->date('tanggal_bayar')->nullable();
            $table->decimal('jumlah_bayar', 15, 2)->default(0);
            $table->decimal('sisa_tagihan', 15, 2)->default(0);
            
            // Metode pembayaran
            $table->enum('metode_bayar', ['Tunai', 'Transfer', 'E-Wallet', 'QRIS', 'Lainnya'])->nullable();
            $table->string('referensi_bayar')->nullable(); // Nomor referensi pembayaran
            $table->string('bukti_bayar')->nullable(); // File bukti bayar
            
            // Kwitansi
            $table->string('nomor_kwitansi')->nullable();
            $table->string('file_kwitansi')->nullable(); // PDF kwitansi
            
            $table->text('keterangan')->nullable();
            $table->timestamps();
            
            $table->unique(['pbb_id', 'tahun_pajak']);
            $table->index('nop');
            $table->index(['tahun_pajak', 'status_bayar']);
            $table->index('jatuh_tempo');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tagihan_pbb');
    }
}; 