<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Tabel polling/voting
        Schema::create('polling', function (Blueprint $table) {
            $table->id();
            $table->string('judul');
            $table->text('deskripsi');
            $table->enum('jenis', ['Musyawarah', 'Usulan Pembangunan', 'Kegiatan Desa', 'Lainnya']);
            $table->datetime('mulai_voting');
            $table->datetime('selesai_voting');
            $table->boolean('multi_pilihan')->default(false); // Bisa pilih lebih dari 1
            $table->boolean('anonim')->default(true); // Voting anonim atau tidak
            $table->enum('target_voter', ['Semua Warga', 'RT Tertentu', 'RW Tertentu', 'Dusun Tertentu', 'Kelompok Usia'])->default('Semua Warga');
            $table->json('filter_voter')->nullable(); // Filter voter dalam format JSON
            $table->enum('status', ['Draft', 'Aktif', 'Selesai', 'Ditutup'])->default('Draft');
            $table->integer('total_voter')->default(0);
            $table->integer('total_suara')->default(0);
            $table->string('banner')->nullable(); // Gambar banner
            $table->text('hasil_keputusan')->nullable(); // Hasil dan keputusan
            $table->integer('created_by'); // User ID yang membuat
            $table->timestamps();
            
            $table->index(['status', 'mulai_voting']);
            $table->index('jenis');
        });

        // Tabel opsi polling
        Schema::create('polling_opsi', function (Blueprint $table) {
            $table->id();
            $table->foreignId('polling_id')->constrained('polling')->onDelete('cascade');
            $table->string('judul_opsi');
            $table->text('deskripsi_opsi')->nullable();
            $table->string('gambar')->nullable();
            $table->decimal('estimasi_biaya', 15, 2)->nullable(); // Untuk usulan pembangunan
            $table->integer('urutan')->default(0);
            $table->integer('jumlah_suara')->default(0);
            $table->timestamps();
            
            $table->index('polling_id');
        });

        // Tabel vote warga
        Schema::create('polling_vote', function (Blueprint $table) {
            $table->id();
            $table->foreignId('polling_id')->constrained('polling')->onDelete('cascade');
            $table->foreignId('opsi_id')->constrained('polling_opsi')->onDelete('cascade');
            $table->string('nik', 16)->nullable(); // Null jika anonim
            $table->string('nama_voter')->nullable(); // Null jika anonim
            $table->string('ip_address');
            $table->text('alasan')->nullable(); // Alasan memilih
            $table->timestamps();
            
            $table->index(['polling_id', 'nik']);
            $table->index('opsi_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('polling_vote');
        Schema::dropIfExists('polling_opsi');
        Schema::dropIfExists('polling');
    }
}; 