<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('agenda_desa', function (Blueprint $table) {
            $table->id();
            $table->string('judul');
            $table->text('deskripsi')->nullable();
            $table->enum('jenis_kegiatan', [
                'Rapat Desa',
                'Musyawarah',
                'Posyandu', 
                'Penyuluhan',
                'Gotong Royong',
                'Pelatihan',
                'Sosialisasi',
                'Kerja Bakti',
                'Kegiatan Keagamaan',
                'Kegiatan Budaya',
                'Kegiatan Olahraga',
                'Lainnya'
            ]);
            $table->datetime('tanggal_mulai');
            $table->datetime('tanggal_selesai');
            $table->string('tempat');
            $table->text('alamat_lengkap')->nullable();
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            
            // Penyelenggara
            $table->string('penyelenggara'); // Pemerintah Desa, RT, RW, dll
            $table->string('penanggung_jawab');
            $table->string('kontak_person')->nullable();
            
            // Target peserta
            $table->enum('target_peserta', ['Semua Warga', 'RT Tertentu', 'RW Tertentu', 'Dusun Tertentu', 'Kelompok Usia', 'Kelompok Tertentu'])->default('Semua Warga');
            $table->json('filter_peserta')->nullable(); // Filter peserta dalam JSON
            $table->integer('kapasitas')->nullable(); // Maksimal peserta
            $table->boolean('perlu_daftar')->default(false); // Butuh pendaftaran
            
            // Status dan publikasi
            $table->enum('status', ['Draft', 'Terjadwal', 'Berlangsung', 'Selesai', 'Dibatalkan'])->default('Draft');
            $table->boolean('tampil_public')->default(true);
            $table->string('banner')->nullable(); // Gambar banner
            
            // Reminder
            $table->boolean('kirim_reminder')->default(true);
            $table->json('waktu_reminder')->nullable(); // Kapan kirim reminder (1 hari, 1 jam sebelum, dll)
            
            // Catatan hasil
            $table->text('hasil_kegiatan')->nullable();
            $table->string('dokumentasi')->nullable(); // File/folder foto
            $table->integer('jumlah_peserta')->nullable(); // Jumlah peserta aktual
            
            $table->integer('created_by'); // User ID yang membuat
            $table->timestamps();
            
            $table->index(['tanggal_mulai', 'status']);
            $table->index('jenis_kegiatan');
            $table->index('tampil_public');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('agenda_desa');
    }
}; 