<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventaris_desa', function (Blueprint $table) {
            $table->id();
            $table->string('kode_inventaris')->unique(); // Kode unik aset
            $table->string('nama_barang');
            $table->enum('kategori', [
                'Tanah',
                'Bangunan',
                'Kendaraan',
                'Elektronik',
                'Furniture',
                'Alat Tulis Kantor',
                'Alat Kesehatan',
                'Alat Pertanian',
                'Alat Olahraga',
                'Buku dan Perpustakaan',
                'Lainnya'
            ]);
            $table->text('deskripsi')->nullable();
            $table->string('merk_tipe')->nullable();
            $table->year('tahun_perolehan')->nullable();
            
            // Nilai dan finansial
            $table->decimal('harga_perolehan', 15, 2)->default(0);
            $table->decimal('nilai_sekarang', 15, 2)->default(0);
            $table->enum('sumber_dana', ['APBDes', 'Bantuan Pemerintah', 'Swadaya', 'Hibah', 'Lainnya'])->nullable();
            
            // Kondisi dan status
            $table->enum('kondisi', ['Baik', 'Rusak Ringan', 'Rusak Berat', 'Tidak Dapat Digunakan'])->default('Baik');
            $table->enum('status_pemakaian', ['Digunakan', 'Tidak Digunakan', 'Dipinjamkan', 'Dalam Perbaikan', 'Hilang'])->default('Digunakan');
            
            // Lokasi dan penanggung jawab
            $table->string('lokasi_penyimpanan');
            $table->text('alamat_detail')->nullable();
            $table->string('penanggung_jawab'); // Nama PJ
            $table->string('jabatan_pj')->nullable(); // Jabatan penanggung jawab
            
            // Koordinat untuk aset tetap
            $table->decimal('latitude', 10, 8)->nullable();
            $table->decimal('longitude', 11, 8)->nullable();
            
            // Spesifikasi teknis (untuk barang elektronik/kendaraan)
            $table->json('spesifikasi')->nullable(); // JSON untuk detail spesifikasi
            
            // Maintenance dan perawatan
            $table->date('terakhir_maintenance')->nullable();
            $table->date('jadwal_maintenance_berikutnya')->nullable();
            $table->decimal('biaya_maintenance_per_tahun', 12, 2)->default(0);
            
            // Dokumentasi
            $table->string('foto_barang')->nullable();
            $table->string('dokumen_pendukung')->nullable(); // Faktur, BPKB, dll
            
            // QR Code untuk tracking
            $table->string('qr_code')->nullable();
            
            $table->text('keterangan')->nullable();
            $table->integer('created_by'); // User ID yang input
            $table->timestamps();
            
            $table->index(['kategori', 'kondisi']);
            $table->index('status_pemakaian');
            $table->index('lokasi_penyimpanan');
            $table->index('kode_inventaris');
        });
    }

    /**
     * Reverse the migrations.
     */
     public function down(): void
    {
        Schema::dropIfExists('inventaris_desa');
    }
}; 