<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('audit_log', function (Blueprint $table) {
            $table->id();
            
            // User information
            $table->integer('user_id')->nullable(); // Null jika guest/system
            $table->string('user_name')->nullable();
            $table->string('user_role')->nullable();
            
            // Action details
            $table->enum('action_type', [
                'CREATE', 'UPDATE', 'DELETE', 'VIEW', 'LOGIN', 'LOGOUT', 
                'EXPORT', 'IMPORT', 'PRINT', 'SEND_NOTIFICATION', 'APPROVE', 
                'REJECT', 'ARCHIVE', 'RESTORE', 'BACKUP', 'DOWNLOAD'
            ]);
            $table->string('module'); // Penduduk, Surat, Pengaduan, dll
            $table->string('table_name')->nullable(); // Nama tabel yang diubah
            $table->string('record_id')->nullable(); // ID record yang diubah
            
            // Description and context
            $table->text('description'); // Deskripsi kegiatan
            $table->json('old_values')->nullable(); // Nilai lama (sebelum update)
            $table->json('new_values')->nullable(); // Nilai baru (setelah update)
            $table->json('metadata')->nullable(); // Data tambahan
            
            // Request information
            $table->string('ip_address');
            $table->string('user_agent')->nullable();
            $table->string('url')->nullable();
            $table->string('method', 10)->nullable(); // GET, POST, PUT, DELETE
            
            // Status and result
            $table->enum('status', ['SUCCESS', 'FAILED', 'WARNING'])->default('SUCCESS');
            $table->text('error_message')->nullable(); // Jika ada error
            
            // Tags for easier filtering
            $table->json('tags')->nullable(); // [critical, data_change, security, etc]
            
            $table->timestamp('created_at')->useCurrent(); // Waktu kejadian
            
            // Indexes for performance
            $table->index(['user_id', 'created_at']);
            $table->index(['action_type', 'created_at']);
            $table->index(['module', 'created_at']);
            $table->index(['table_name', 'record_id']);
            $table->index('status');
            $table->index('ip_address');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('audit_log');
    }
}; 